<?php

$tj_service_list = !empty($settings['tj_service_list']) ? $settings['tj_service_list'] : [];

$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

$wrappClass = "h5-service-wrap";
if (!empty($tjAnimation)) {
  $wrappClass .= " wow $tjAnimationName";
  $this->add_render_attribute('tj_wrap_arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj_wrap_arg', 'class', $wrappClass);


?>

<div <?php echo $this->get_render_attribute_string('tj_wrap_arg'); ?>>
  <?php foreach ($tj_service_list as $service):

    $active = !empty($service['tj_active']) ? "active" : "";
    $serviceIcon = !empty($service['tj_service_icon']) ? $service['tj_service_icon'] : "";
    $serviceTitle = !empty($service['tj_service_title']) ? $service['tj_service_title'] : "";
    $serviceDesc = !empty($service['tj_service_desc']) ? $service['tj_service_desc'] : "";
    $serviceBtn = !empty($service['tj_service_btn']) ? $service['tj_service_btn'] : "";

    $icon = !empty($service['service_icon_btn']) ? $service['service_icon_btn'] : '';

    $link = !empty($service['tj_service_link']['url']) ? $service['tj_service_link']['url'] : '';
    $target = !empty($service['tj_service_link']['is_external']) ? '_blank' : '';
    $rel = !empty($service['tj_service_link']['nofollow']) ? 'nofollow' : '';

  ?>
    <div class="service-style-5 <?php echo esc_attr($active); ?>">
      <div class="h5-service-content">
        <?php if (!empty($serviceTitle)): ?>
          <div class="h5-title-area">
            <h4 class="title"><?php echo tj_kses($serviceTitle); ?></h4>
          </div>
        <?php endif; ?>
        <?php if (!empty($serviceIcon['value'])) : ?>
          <div class="service-icon">
            <span><?php tj_render_icon($service, 'service_icon', 'tj_service_icon') ?></span>
          </div>
        <?php endif; ?>
        <div class="h5-service-content-inner">
          <?php if (!empty($serviceTitle)): ?>
            <h4 class="title">
              <?php
              if (!empty($link)) :
                $href = 'href="' . esc_attr($link) . '"';
                $target = !empty($target) ? 'target="' . esc_attr($target) . '"' : '';
                $rel = !empty($rel) ? 'rel="' . esc_attr($rel) . '"' : '';
              ?>
                <a <?php echo $href; ?> <?php echo $target; ?> <?php echo $rel; ?>>
                  <?php echo tj_kses($serviceTitle); ?>
                </a>
              <?php else: ?>
                <?php echo tj_kses($serviceTitle); ?>
              <?php endif; ?>
            </h4>
          <?php endif; ?>
          <?php if (!empty($serviceDesc)): ?>
            <div class="desc">
              <?php echo tj_kses($serviceDesc); ?>
            </div>
          <?php endif; ?>
        </div>

        <?php if (!empty($serviceBtn)): ?>
          <a href="<?php echo esc_url($link); ?>" class="blog-btn-2">
            <?php if (!empty($icon['value'])) : ?>
              <span class="btn-icon"><?php tj_render_icon($service, 'btn_icon', 'service_icon_btn') ?></span>
            <?php endif; ?>
            <span class="btn-text"><?php echo esc_html($serviceBtn); ?></span>
          </a>
        <?php endif; ?>
        <?php if (!empty($icon['value'])) : ?>
          <a class="blog-btn-2 mobile-show" href="<?php echo esc_url($link); ?>">
            <span class="btn-icon"><?php tj_render_icon($service, 'btn_icon', 'service_icon_btn') ?></i></span>
          </a>
        <?php endif; ?>
      </div>
    </div>
  <?php endforeach; ?>
</div>