<?php

$tj_service_list = !empty($settings['tj_service_list']) ? $settings['tj_service_list'] : [];

$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

$wrappClass = "h7-service-wrapper";
if (!empty($tjAnimation)) {
  $wrappClass .= " wow $tjAnimationName";
  $this->add_render_attribute('tj_wrap_arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj_wrap_arg', 'class', $wrappClass);


?>

<div <?php echo $this->get_render_attribute_string('tj_wrap_arg'); ?>>

  <?php foreach ($tj_service_list as $service):

    $serviceIcon = !empty($service['tj_service_icon']) ? $service['tj_service_icon'] : "";
    $serviceTitle = !empty($service['tj_service_title']) ? $service['tj_service_title'] : "";
    $serviceDesc = !empty($service['tj_service_desc']) ? $service['tj_service_desc'] : "";

    $icon = !empty($service['service_icon_btn']) ? $service['service_icon_btn'] : '';

    $link = !empty($service['tj_service_link']['url']) ? $service['tj_service_link']['url'] : '';
    $target = !empty($service['tj_service_link']['is_external']) ? '_blank' : '';
    $rel = !empty($service['tj_service_link']['nofollow']) ? 'nofollow' : '';

  ?>
    <div class="service-style-3">

      <div class="service-title">
        <?php if (!empty($serviceIcon['value'])) : ?>
          <div class="service-icon">
            <span><?php tj_render_icon($service, 'service_icon', 'tj_service_icon') ?></span>
          </div>
        <?php endif; ?>

        <?php if (!empty($serviceTitle)): ?>
          <h4 class="title">
            <?php
            if (!empty($link)) :
              $href = 'href="' . esc_attr($link) . '"';
              $target = !empty($target) ? 'target="' . esc_attr($target) . '"' : '';
              $rel = !empty($rel) ? 'rel="' . esc_attr($rel) . '"' : '';
            ?>
              <a <?php echo $href; ?> <?php echo $target; ?> <?php echo $rel; ?>>
                <?php echo tj_kses($serviceTitle); ?>
              </a>
            <?php else: ?>
              <?php echo tj_kses($serviceTitle); ?>
            <?php endif; ?>
          </h4>
        <?php endif; ?>

      </div>
      <div class="service-right">
        <?php if (!empty($serviceDesc)): ?>
          <div class="desc">
            <p><?php echo tj_kses($serviceDesc); ?></p>
          </div>
        <?php endif; ?>

        <?php if (!empty($icon['value'])) : ?>
          <div class="service-button">
            <a class="blog-btn-2" href="<?php echo esc_url($link); ?>">
              <?php if (!empty($icon['value'])) : ?>
                <span class="btn-icon"><?php tj_render_icon($service, 'btn_icon', 'service_icon_btn') ?></span>
              <?php endif; ?>
            </a>
          </div>
        <?php endif; ?>
      </div>
    </div>
  <?php endforeach; ?>

</div>