<?php

$tj_service_list = !empty($settings['tj_service_list']) ? $settings['tj_service_list'] : [];

$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

$wrappClass = "h8-services-list";
if (!empty($tjAnimation)) {
  $wrappClass .= " wow $tjAnimationName";
  $this->add_render_attribute('tj_wrap_arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj_wrap_arg', 'class', $wrappClass);
?>

<div <?php $this->print_render_attribute_string('tj_wrap_arg'); ?>>

  <?php foreach ($tj_service_list as $key => $service):
    $serviceIcon = !empty($service['tj_service_icon']) ? $service['tj_service_icon'] : "";
    $serviceTitle = !empty($service['tj_service_title']) ? $service['tj_service_title'] : "";
    $serviceDesc = !empty($service['tj_service_desc']) ? $service['tj_service_desc'] : "";

    $icon = !empty($service['service_icon_btn']) ? $service['service_icon_btn'] : '';

    $link = !empty($service['tj_service_link']['url']) ? $service['tj_service_link']['url'] : '';
    $target = !empty($service['tj_service_link']['is_external']) ? '_blank' : '';
    $rel = !empty($service['tj_service_link']['nofollow']) ? 'nofollow' : '';

  ?>
    <div class="service_item">
      <span class="no"><?php echo str_pad($key + 1, 2, '0', STR_PAD_LEFT) . esc_html("."); ?></span>

      <div class="content">
        <h4 class="title">
          <?php if (!empty($link)) :
            $href = 'href="' . esc_attr($link) . '"';
            $target = !empty($target) ? 'target="' . esc_attr($target) . '"' : '';
            $rel = !empty($rel) ? 'rel="' . esc_attr($rel) . '"' : '';
          ?>
            <a <?php echo $href; ?> <?php echo $target; ?> <?php echo $rel; ?>>
              <?php echo tj_kses($serviceTitle); ?>
            </a>
          <?php else: ?>
            <?php echo tj_kses($serviceTitle); ?>
          <?php endif; ?>
        </h4>
        <?php if (!empty($serviceDesc)): ?>
          <div class="desc">
            <?php echo tj_kses($serviceDesc); ?>
          </div>
        <?php endif; ?>
      </div>

      <?php if (!empty($icon['value'])) : ?>
        <a href="<?php echo esc_url($link); ?>" class="service_btn icon-btn">
          <?php tj_render_icon($service, 'btn_icon', 'service_icon_btn') ?>
        </a>
      <?php endif; ?>
    </div>
  <?php endforeach; ?>

</div>