<?php

$tj_service_list = !empty($settings['tj_service_list']) ? $settings['tj_service_list'] : [];

$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

$wrappClass = "h9-service-wrapper carouselWrap";
if (!empty($tjAnimation)) {
  $wrappClass .= " wow $tjAnimationName";
  $this->add_render_attribute('tj_wrap_arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj_wrap_arg', 'class', $wrappClass);


$loop            = !empty($settings['slide_loop']) ? $settings['slide_loop'] : 'no';
$dot            = !empty($settings['slide_dot']) ? $settings['slide_dot'] : 'no';
$autoplay        = !empty($settings['slide_autoplay']) ? $settings['slide_autoplay'] : 'no';
$autoplayDelay        = !empty($settings['slide_autoplay_Delay']) ? $settings['slide_autoplay_Delay'] : '5000';

$swipeDirction = !empty($settings['gsap_swipe_direction']) ? $settings['gsap_swipe_direction'] : '';

$swipeWrapperClass = '';
if ($swipeDirction === 'right-swipe') {
  $swipeWrapperClass = 'rightSwipeWrap';
} elseif ($swipeDirction === 'left-swipe') {
  $swipeWrapperClass = 'leftSwipeWrap';
}
$is_rtl = is_rtl() ? 'rtl' : 'ltr';

?>

<div <?php echo $this->get_render_attribute_string('tj_wrap_arg'); ?> data-loop="<?php echo $loop; ?>" data-dot="<?php echo $dot; ?>" data-autoplay="<?php echo $autoplay; ?>" data-delay="<?php echo $autoplayDelay; ?>">

  <div dir="<?php echo esc_attr($is_rtl); ?>" class="h9-services-slider swiper swiper-container" id="serviceSlider-<?php echo $this->get_id(); ?>">
    <div class="swiper-wrapper <?php echo esc_attr($swipeWrapperClass); ?>">
      <?php foreach ($tj_service_list as $key => $service):

        $serviceIcon = !empty($service['tj_service_icon']) ? $service['tj_service_icon'] : "";
        $serviceTitle = !empty($service['tj_service_title']) ? $service['tj_service_title'] : "";
        $serviceDesc = !empty($service['tj_service_desc']) ? $service['tj_service_desc'] : "";
        $serviceBtn = !empty($service['tj_service_btn']) ? $service['tj_service_btn'] : "";
        $icon = !empty($service['service_icon_btn']) ? $service['service_icon_btn'] : '';

        $link = !empty($service['tj_service_link']['url']) ? $service['tj_service_link']['url'] : '';
        $target = !empty($service['tj_service_link']['is_external']) ? '_blank' : '';
        $rel = !empty($service['tj_service_link']['nofollow']) ? 'nofollow' : '';

      ?>
        <div class="swiper-slide <?php echo esc_attr($swipeDirction); ?>">
          <div class="h9-services-item">
            <div class="h9-services-item-inner">
              <?php if (!empty($serviceIcon['value'])) : ?>
                <div class="service-icon">
                  <?php tj_render_icon($service, 'service_icon', 'tj_service_icon') ?>
                </div>
              <?php endif; ?>

              <span class="number"><?php echo str_pad($key + 1, 2, '0', STR_PAD_LEFT) . esc_html("."); ?></span>

              <div class="service-content">
                <?php if (!empty($serviceTitle)): ?>
                  <h4 class="title">
                    <?php
                    if (!empty($link)) :
                      $href = 'href="' . esc_attr($link) . '"';
                      $target = !empty($target) ? 'target="' . esc_attr($target) . '"' : '';
                      $rel = !empty($rel) ? 'rel="' . esc_attr($rel) . '"' : '';
                    ?>
                      <a <?php echo $href; ?> <?php echo $target; ?> <?php echo $rel; ?>>
                        <?php echo tj_kses($serviceTitle); ?>
                      </a>
                    <?php else: ?>
                      <?php echo tj_kses($serviceTitle); ?>
                    <?php endif; ?>
                  </h4>
                <?php endif; ?>
                <?php if (!empty($serviceDesc)): ?>
                  <div class="check-list-one">
                    <?php echo tj_kses($serviceDesc); ?>
                  </div>
                <?php endif; ?>
              </div>
            </div>

            <?php if (!empty($serviceBtn)): ?>
              <a href="<?php echo esc_url($link); ?>" class="service-btn">
                <span class=" text-btn">
                  <?php echo esc_html($serviceBtn); ?>
                  <?php if (!empty($icon['value'])) : ?>
                    <?php tj_render_icon($service, 'btn_icon', 'service_icon_btn') ?>
                  <?php endif; ?>
                </span>
              </a>
            <?php endif; ?>
          </div>

        </div>
      <?php endforeach; ?>
    </div>
    <?php if ("yes" == $dot): ?>
      <div class="swiper_pagination"></div>
    <?php endif; ?>
  </div>

</div>