<?php
if (get_query_var('paged')) {
  $paged = get_query_var('paged');
} else if (get_query_var('page')) {
  $paged = get_query_var('page');
} else {
  $paged = 1;
}

$posts_per_page = (!empty($settings['posts_per_page'])) ? $settings['posts_per_page'] : '-1';
$orderby = (!empty($settings['orderby'])) ? $settings['orderby'] : 'post_date';
$order = (!empty($settings['order'])) ? $settings['order'] : 'desc';
$offset_value = (!empty($settings['offset'])) ? $settings['offset'] : '0';

// number
$off = (!empty($offset_value)) ? $offset_value : 0;
$offset = $off + (($paged - 1) * $posts_per_page);

// post Include
$pI_ids = array();
if (!empty($settings['post__in'])) {
  foreach ($settings['post__in'] as $pI_idsn) {
    $pI_ids[] = $pI_idsn;
  }
}

// post exclude
$pE_ids = array();
if (!empty($settings['post__not_in'])) {
  foreach ($settings['post__not_in'] as $pE_idsn) {
    $pE_ids[] = $pE_idsn;
  }
}


$args = array(
  'post_type' => 'services',
  'post_status' => 'publish',
  'posts_per_page' => $posts_per_page,
  'orderby' => $orderby,
  'order' => $order,
  'offset' => $offset,
  'paged' => $paged,
  'post__in' => $pI_ids,
  'post__not_in' => $pE_ids,
);

// The Query
$query = new \WP_Query($args);
$tjQuery         = !empty($settings['tj_query_style']) ? $settings['tj_query_style'] : "";
$tj_service_list  = !empty($settings['tj_service_list']) ? $settings['tj_service_list'] : "";

$tj_show_link   = $settings['tj_show_link'] ?? '';
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $serviceClass = "service-wrapper wow $tjAnimationName";
  $this->add_render_attribute('tj-services-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $serviceClass = "service-wrapper";
}
$this->add_render_attribute('tj-services-arg', 'class', $serviceClass);

?>

<!-- start: Service Area -->
<div class="tj_service">
  <?php if ("2" == $tjQuery): ?>
    <div <?php echo $this->get_render_attribute_string('tj-services-arg'); ?>>
      <?php if ($query->have_posts()) : ?>
        <?php while ($query->have_posts()) : $query->the_post();
          $serviceIconType = function_exists('get_field') ? get_field("service_icon_type", get_the_ID()) : '';
          $serviceIcon = function_exists('get_field') ? get_field("service_icon", get_the_ID()) : '';
          $serviceFontAwesomeIcon = function_exists('get_field') ? get_field("service_fontawesome_icon", get_the_ID()) : '';
          $serviceImageIcon = function_exists('get_field') ? get_field("service_image_icon", get_the_ID()) : '';
          $serviceNumber = function_exists('get_field') ? get_field("service_number", get_the_ID()) : '';
        ?>

          <div class="service-item service-el-item">
            <div class="service-content">
              <?php if (!empty($serviceNumber)) : ?>
                <div class="service-number el-number">
                  <span class="active"><?php echo wp_kses_post($serviceNumber); ?></span>
                </div>
              <?php endif; ?>
              <div class="service-text">

                <div class="service-icons el-icon">
                  <?php if ('image-icon' === $serviceIconType && !empty($serviceImageIcon)) : ?>
                    <img src="<?php echo esc_url($serviceImageIcon['url']); ?>" alt="<?php echo esc_attr($serviceImageIcon['alt']); ?>">
                  <?php
                  elseif ('fontawesome-icon' === $serviceIconType && !empty($serviceFontAwesomeIcon)) :
                    echo tj_kses($serviceFontAwesomeIcon);
                  elseif (!empty($serviceIcon)) : ?>
                    <i class="<?php echo esc_attr($serviceIcon); ?>"></i>
                  <?php endif; ?>
                </div>

                <h3 class="title">
                  <a href="<?php the_permalink(); ?>">
                    <?php echo wp_trim_words(get_the_title(), $settings['tj_post_title_word'], '...'); ?>
                  </a>
                </h3>
                <?php if ("yes" == $settings['tj_post_content']) : ?>
                  <div class="desc">
                    <p>
                      <?php echo wp_trim_words(get_the_excerpt(), $settings['tj_post_content_limit'], '...'); ?>
                    </p>
                  </div>
                <?php endif; ?>
                <?php if ("yes" == $settings['tj_service_btn']) : ?>
                  <a href="<?php the_permalink(); ?>" class="tj-primary-btn service-btn">
                    <span class="btn_inner">
                      <?php if (!empty($settings['tj_service_btn_icon']['value'])): ?>
                        <span class="btn_icon">
                          <span>
                            <?php tj_render_icon($settings, 'btn_icon', 'tj_service_btn_icon') ?>
                            <?php tj_render_icon($settings, 'btn_icon', 'tj_service_btn_icon') ?>
                          </span>
                        </span>
                      <?php endif; ?>
                      <?php if (!empty($settings['tj_service_btn_text'])): ?>
                        <span class="btn_text">
                          <span><?php echo esc_html__($settings['tj_service_btn_text'], 'tjcore'); ?></span>
                        </span>
                      <?php endif; ?>
                    </span>
                  </a>
                <?php endif; ?>
              </div>
            </div>
            <?php if (has_post_thumbnail()): ?>
              <div class="service-images hover:shine">
                <?php if (!empty($tj_show_link)) : ?>
                  <a href="<?php the_permalink(); ?>">
                    <?php the_post_thumbnail('full', ['class' => 'img-responsive']); ?>
                  </a>
                <?php else : ?>
                  <?php the_post_thumbnail('full', ['class' => 'img-responsive']); ?>
                <?php endif; ?>
              </div>
            <?php endif; ?>
          </div>
        <?php endwhile;
        wp_reset_query(); ?>

      <?php else :
        printf("%s", esc_html__("No service available", 'tjcore'));
      endif; ?>
    </div>
  <?php else: ?>
    <div <?php echo $this->get_render_attribute_string('tj-services-arg'); ?>>
      <?php if (!empty($tj_service_list)): ?>
        <?php foreach ($tj_service_list as $service):
          $serviceIcon = !empty($service['tj_service_icon']) ? $service['tj_service_icon'] : "";
          $serviceImage = !empty($service['tj_service_image']) ? $service['tj_service_image'] : "";
          $serviceNumber = !empty($service['tj_service_number']) ? $service['tj_service_number'] : "";
          $serviceNumber2 = !empty($service['tj_service_number2']) ? $service['tj_service_number2'] : "";
          $serviceTitle = !empty($service['tj_service_title']) ? $service['tj_service_title'] : "";
          $serviceDesc = !empty($service['tj_service_desc']) ? $service['tj_service_desc'] : "";
          $tj_btn_text = !empty($service['tj_btn_text']) ? $service['tj_btn_text'] : "";
          $tj_btn_icon = !empty($service['tj_btn_icon']) ? $service['tj_btn_icon'] : "";
          $tj_gsap_stack = !empty($service['tj_gsap_stack']) ? 'service-stack' : '';

          $link = !empty($service['tj_service_link']['url']) ? $service['tj_service_link']['url'] : '';
          $target = !empty($service['tj_service_link']['is_external']) ? '_blank' : '';
          $rel = !empty($service['tj_service_link']['nofollow']) ? 'nofollow' : '';

          $tj_show_link_2   = $service['tj_show_link_2'] ?? '';

        ?>
          <div class="service-item service-el-item <?php echo esc_attr($tj_gsap_stack); ?>">
            <div class="service-content">
              <?php if (!empty($serviceNumber) || !empty($serviceNumber2)): ?>
                <div class="service-number el-number">
                  <?php if (!empty($serviceNumber)): ?>
                    <span class="active"><?php echo esc_html($serviceNumber); ?></span>
                  <?php endif; ?>
                  <?php if (!empty($serviceNumber2)): ?>
                    <span><?php echo esc_html($serviceNumber2); ?></span>
                  <?php endif; ?>
                </div>
              <?php endif; ?>
              <div class="service-text">
                <?php if (!empty($serviceIcon['value'])): ?>
                  <div class="service-icons el-icon">
                    <?php tj_render_icon($service, 'service_icon', 'tj_service_icon'); ?>
                  </div>
                <?php endif; ?>
                <?php if (!empty($serviceTitle)): ?>
                  <h3 class="title">
                    <?php
                    if (!empty($link)) :
                      $href = 'href="' . esc_attr($link) . '"';
                      $target = !empty($target) ? 'target="' . esc_attr($target) . '"' : '';
                      $rel = !empty($rel) ? 'rel="' . esc_attr($rel) . '"' : '';
                    ?>
                      <a <?php echo $href; ?> <?php echo $target; ?> <?php echo $rel; ?>>
                        <?php echo esc_html($serviceTitle); ?>
                      </a>
                    <?php else: ?>
                      <?php echo esc_html($serviceTitle); ?>
                    <?php endif; ?>
                  </h3>
                <?php endif; ?>
                <?php if (!empty($serviceDesc)): ?>
                  <div class="desc">
                    <?php echo tj_kses($serviceDesc); ?>
                  </div>
                <?php endif; ?>
                <?php if (!empty($link)): ?>
                  <a href="<?php echo esc_url($link); ?>" class="tj-primary-btn service-btn">
                    <span class="btn_inner">
                      <?php if (!empty($tj_btn_icon['value'])): ?>
                        <span class="btn_icon">
                          <span>
                            <?php tj_render_icon($service, 'btn_icon', 'tj_btn_icon') ?>
                            <?php tj_render_icon($service, 'btn_icon', 'tj_btn_icon') ?>
                          </span>
                        </span>
                      <?php endif; ?>
                      <?php if (!empty($tj_btn_text)): ?>
                        <span class="btn_text">
                          <span><?php echo esc_html__($tj_btn_text, 'tjcore'); ?></span>
                        </span>
                      <?php endif; ?>
                    </span>
                  </a>
                <?php endif; ?>
              </div>
            </div>
            <?php if (!empty($serviceImage['url'])): ?>
              <div class="service-images hover:shine">
                <?php if (!empty($tj_show_link_2)) : ?>
                  <a href="<?php echo esc_url($link); ?>">
                    <img src="<?php echo esc_url($serviceImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($serviceImage['id'], '_wp_attachment_image_alt', true)); ?>">
                  </a>
                <?php else : ?>
                  <img src="<?php echo esc_url($serviceImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($serviceImage['id'], '_wp_attachment_image_alt', true)); ?>">
                <?php endif; ?>
              </div>
            <?php endif; ?>
          </div>
        <?php endforeach; ?>
      <?php else :
        printf("%s", esc_html__("No services available", 'tjcore'));
      endif; ?>
    </div>
  <?php endif; ?>
</div>
<!-- end: Service Area -->