<?php
if (get_query_var('paged')) {
  $paged = get_query_var('paged');
} else if (get_query_var('page')) {
  $paged = get_query_var('page');
} else {
  $paged = 1;
}

$posts_per_page = (!empty($settings['posts_per_page'])) ? $settings['posts_per_page'] : '-1';
$orderby = (!empty($settings['orderby'])) ? $settings['orderby'] : 'post_date';
$order = (!empty($settings['order'])) ? $settings['order'] : 'desc';
$offset_value = (!empty($settings['offset'])) ? $settings['offset'] : '0';

// number
$off = (!empty($offset_value)) ? $offset_value : 0;
$offset = $off + (($paged - 1) * $posts_per_page);

// post Include
$pI_ids = array();
if (!empty($settings['post__in'])) {
  foreach ($settings['post__in'] as $pI_idsn) {
    $pI_ids[] = $pI_idsn;
  }
}

// post exclude
$pE_ids = array();
if (!empty($settings['post__not_in'])) {
  foreach ($settings['post__not_in'] as $pE_idsn) {
    $pE_ids[] = $pE_idsn;
  }
}


$args = array(
  'post_type' => 'services',
  'post_status' => 'publish',
  'posts_per_page' => $posts_per_page,
  'orderby' => $orderby,
  'order' => $order,
  'offset' => $offset,
  'paged' => $paged,
  'post__in' => $pI_ids,
  'post__not_in' => $pE_ids,
);

// The Query
$query = new \WP_Query($args);

$loop            = !empty($settings['slide_loop']) ? $settings['slide_loop'] : 'no';
$dots            = !empty($settings['slide_dot']) ? $settings['slide_dot'] : 'no';
$autoplay        = !empty($settings['slide_autoplay']) ? $settings['slide_autoplay'] : 'no';
$autoplayDelay        = !empty($settings['slide_autoplay_delay']) ? $settings['slide_autoplay_delay'] : '5000';

$tjQuery         = !empty($settings['tj_query_style']) ? $settings['tj_query_style'] : "";
$tj_service_list  = !empty($settings['tj_service_list']) ? $settings['tj_service_list'] : "";

$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $serviceClass = "h6-services-slider swiper swiper-container wow $tjAnimationName";
  $this->add_render_attribute('tj-services-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $serviceClass = "h6-services-slider swiper swiper-container";
}
$this->add_render_attribute('tj-services-arg', 'class', $serviceClass);
$swipeDirction = !empty($settings['gsap_swipe_direction']) ? $settings['gsap_swipe_direction'] : '';

$swipeWrapperClass = '';
if ($swipeDirction === 'right-swipe') {
  $swipeWrapperClass = 'rightSwipeWrap';
} elseif ($swipeDirction === 'left-swipe') {
  $swipeWrapperClass = 'leftSwipeWrap';
}

$is_rtl = is_rtl() ? 'rtl' : 'ltr';

// Preview values
$preview_xs  = $settings['tj_xs_preview'] ?? '';
$preview_sm  = $settings['tj_sm_preview'] ?? '';
$preview_md  = $settings['tj_md_preview'] ?? '';
$preview_lg  = $settings['tj_lg_preview'] ?? '';
$preview_xl  = $settings['tj_xl_preview'] ?? '';
$preview_xxl = $settings['tj_xxl_preview'] ?? '';

// Space values
$space_xs  = $settings['tj_xs_space'] ?? '';
$space_sm  = $settings['tj_sm_space'] ?? '';
$space_md  = $settings['tj_md_space'] ?? '';
$space_lg  = $settings['tj_lg_space'] ?? '';
$space_xl  = $settings['tj_xl_space'] ?? '';
$space_xxl = $settings['tj_xxl_space'] ?? '';

$data_attrs = [
  'xxl' => $preview_xxl,
  'xl'  => $preview_xl,
  'lg'  => $preview_lg,
  'md'  => $preview_md,
  'sm'  => $preview_sm,
  'xs'  => $preview_xs,

  'space-xxl' => $space_xxl,
  'space-xl'  => $space_xl,
  'space-lg'  => $space_lg,
  'space-md'  => $space_md,
  'space-sm'  => $space_sm,
  'space-xs'  => $space_xs,
];

// Convert to HTML attributes string
$data_attr_str = '';
foreach ($data_attrs as $key => $val) {
  if ($val !== '') {
    $data_attr_str .= ' data-' . esc_attr($key) . '="' . esc_attr($val) . '"';
  }
}

?>

<!-- start: Service Area -->
<div class="tj_service sw-carousel-5 carouselWrap" data-loop="<?php echo $loop; ?>" data-dot="<?php echo $dots; ?>" data-autoplay="<?php echo $autoplay; ?>" data-delay="<?php echo $autoplayDelay; ?>" <?php echo $data_attr_str; ?>>
  <?php if ("2" == $tjQuery): ?>

    <div dir="<?php echo esc_attr($is_rtl); ?>" <?php echo $this->get_render_attribute_string('tj-services-arg'); ?> id="serviceSlider-<?php echo $this->get_id(); ?>">
      <?php if ($query->have_posts()) : ?>
        <div class="swiper-wrapper <?php echo esc_attr($swipeWrapperClass); ?>">
          <?php while ($query->have_posts()) : $query->the_post();
            $serviceIconType = function_exists('get_field') ? get_field("service_icon_type", get_the_ID()) : '';
            $serviceIcon = function_exists('get_field') ? get_field("service_icon", get_the_ID()) : '';
            $serviceFontAwesomeIcon = function_exists('get_field') ? get_field("service_fontawesome_icon", get_the_ID()) : '';
            $serviceImageIcon = function_exists('get_field') ? get_field("service_image_icon", get_the_ID()) : '';
          ?>
            <div class="swiper-slide h6-services-item <?php echo esc_attr($swipeDirction); ?>">

              <div class="h6-services-item-inner service-el-item" data-bg-image="<?php echo get_the_post_thumbnail_url(null, 'full'); ?>">
                <div class="service_shape"></div>

                <div class="service_icon el-icon">
                  <?php if ('image-icon' === $serviceIconType && !empty($serviceImageIcon)) : ?>
                    <img src="<?php echo esc_url($serviceImageIcon['url']); ?>" alt="<?php echo esc_attr($serviceImageIcon['alt']); ?>">
                  <?php
                  elseif ('fontawesome-icon' === $serviceIconType && !empty($serviceFontAwesomeIcon)) :
                    echo tj_kses($serviceFontAwesomeIcon);
                  elseif (!empty($serviceIcon)) : ?>
                    <i class="<?php echo esc_attr($serviceIcon); ?>"></i>
                  <?php endif; ?>
                </div>

                <div class="service_content">
                  <h4 class="title">
                    <a href="<?php the_permalink(); ?>">
                      <?php echo wp_trim_words(get_the_title(), $settings['tj_post_title_word'], '...'); ?>
                    </a>
                  </h4>
                  <?php if ("yes" == $settings['tj_service_btn']) : ?>
                    <a class="icon-btn-2 service_btn" href="<?php the_permalink(); ?>">
                      <?php if (!empty($settings['tj_service_btn_icon']['value'])): ?>
                        <span class="btn-icon"> <?php tj_render_icon($settings, 'btn_icon', 'tj_service_btn_icon') ?></span>
                      <?php endif; ?>
                      <span class="btn-text"><?php echo esc_html__($settings['tj_service_btn_text'], 'tjcore'); ?></span>
                    </a>
                  <?php endif; ?>
                </div>
              </div>

            </div>
          <?php endwhile;
          wp_reset_query(); ?>
        </div>

        <?php if ("yes" == $dots): ?>
          <div class="swiper_pagination"></div>
        <?php endif; ?>

      <?php else :
        printf("%s", esc_html__("No service available", 'tjcore'));
      endif; ?>
    </div>

  <?php else: ?>
    <div dir="<?php echo esc_attr($is_rtl); ?>" <?php echo $this->get_render_attribute_string('tj-services-arg'); ?> id="serviceSlider-<?php echo $this->get_id(); ?>">
      <?php if (!empty($tj_service_list)): ?>
        <div class="swiper-wrapper <?php echo esc_attr($swipeWrapperClass); ?>">
          <?php foreach ($tj_service_list as $service):
            $serviceIcon = !empty($service['tj_service_icon']) ? $service['tj_service_icon'] : "";
            $serviceImage = !empty($service['tj_service_image']) ? $service['tj_service_image'] : "";
            $serviceTitle = !empty($service['tj_service_title']) ? $service['tj_service_title'] : "";
            $serviceDesc = !empty($service['tj_service_desc']) ? $service['tj_service_desc'] : "";
            $tj_btn_text = !empty($service['tj_btn_text']) ? $service['tj_btn_text'] : "";
            $tj_btn_icon = !empty($service['tj_btn_icon']) ? $service['tj_btn_icon'] : "";

            $link = !empty($service['tj_service_link']['url']) ? $service['tj_service_link']['url'] : '';
            $target = !empty($service['tj_service_link']['is_external']) ? '_blank' : '';
            $rel = !empty($service['tj_service_link']['nofollow']) ? 'nofollow' : '';
          ?>

            <div class="swiper-slide h6-services-item <?php echo esc_attr($swipeDirction); ?>">

              <div class="h6-services-item-inner service-el-item" data-bg-image="<?php echo esc_url($serviceImage['url']); ?>">
                <div class="service_shape"></div>

                <?php if (!empty($serviceIcon['value'])): ?>
                  <div class="service_icon el-icon">
                    <?php tj_render_icon($service, 'service_icon', 'tj_service_icon'); ?>
                  </div>
                <?php endif; ?>

                <div class="service_content">
                  <?php if (!empty($serviceTitle)): ?>
                    <h4 class="title">
                      <?php
                      if (!empty($link)) :
                        $href = 'href="' . esc_attr($link) . '"';
                        $target = !empty($target) ? 'target="' . esc_attr($target) . '"' : '';
                        $rel = !empty($rel) ? 'rel="' . esc_attr($rel) . '"' : '';
                      ?>
                        <a <?php echo $href; ?> <?php echo $target; ?> <?php echo $rel; ?>>
                          <?php echo esc_html($serviceTitle); ?>
                        </a>
                      <?php else: ?>
                        <?php echo esc_html($serviceTitle); ?>
                      <?php endif; ?>
                    </h4>
                  <?php endif; ?>
                  <?php if (!empty($tj_btn_icon['value']) || !empty($tj_btn_text)) : ?>
                    <a class="icon-btn-2 service_btn" href="<?php echo esc_url($link); ?>">
                      <?php if (!empty($tj_btn_icon['value'])): ?>
                        <span class="btn-icon"><?php tj_render_icon($service, 'btn_icon', 'tj_btn_icon') ?></span>
                      <?php endif; ?>
                      <span class="btn-text"><?php echo esc_html__($tj_btn_text, 'tjcore'); ?></span>
                    </a>
                  <?php endif; ?>
                </div>
              </div>
            </div>

          <?php endforeach; ?>
        </div>
        <?php if ("yes" == $dots): ?>
          <div class="swiper_pagination"></div>
        <?php endif; ?>
      <?php else :
        printf("%s", esc_html__("No services available", 'tjcore'));
      endif; ?>
    </div>
  <?php endif; ?>
</div>
<!-- end: Service Area -->