<?php
$teamMembers = !empty($settings['team_member_list']) ? $settings['team_member_list'] : "";

$loop            = !empty($settings['slide_loop']) ? $settings['slide_loop'] : 'no';
$dot            = !empty($settings['slide_dot']) ? $settings['slide_dot'] : 'no';
$autoplay        = !empty($settings['slide_autoplay']) ? $settings['slide_autoplay'] : 'no';
$autoplayDelay        = !empty($settings['slide_autoplay_Delay']) ? $settings['slide_autoplay_Delay'] : '5000';
$is_rtl = is_rtl() ? 'rtl' : 'ltr';


// Preview values
$preview_xs  = $settings['tj_xs_preview'] ?? '';
$preview_sm  = $settings['tj_sm_preview'] ?? '';
$preview_md  = $settings['tj_md_preview'] ?? '';
$preview_lg  = $settings['tj_lg_preview'] ?? '';
$preview_xl  = $settings['tj_xl_preview'] ?? '';
$preview_xxl = $settings['tj_xxl_preview'] ?? '';

// Space values
$space_xs  = $settings['tj_xs_space'] ?? '';
$space_sm  = $settings['tj_sm_space'] ?? '';
$space_md  = $settings['tj_md_space'] ?? '';
$space_lg  = $settings['tj_lg_space'] ?? '';
$space_xl  = $settings['tj_xl_space'] ?? '';
$space_xxl = $settings['tj_xxl_space'] ?? '';

$data_attrs = [
  'xxl' => $preview_xxl,
  'xl'  => $preview_xl,
  'lg'  => $preview_lg,
  'md'  => $preview_md,
  'sm'  => $preview_sm,
  'xs'  => $preview_xs,

  'space-xxl' => $space_xxl,
  'space-xl'  => $space_xl,
  'space-lg'  => $space_lg,
  'space-md'  => $space_md,
  'space-sm'  => $space_sm,
  'space-xs'  => $space_xs,
];

// Convert to HTML attributes string
$data_attr_str = '';
foreach ($data_attrs as $key => $val) {
  if ($val !== '') {
    $data_attr_str .= ' data-' . esc_attr($key) . '="' . esc_attr($val) . '"';
  }
}

?>

<?php if (!empty($teamMembers)): ?>
  <div class="carouselWrap sw-carousel-team" data-loop="<?php echo $loop; ?>" data-dot="<?php echo $dot; ?>" data-autoplay="<?php echo $autoplay; ?>" data-delay="<?php echo $autoplayDelay; ?>" <?php echo $data_attr_str; ?>>
    <div dir="<?php echo esc_attr($is_rtl); ?>" class="swiper tj-team-slider" id="teamCarousel-<?php echo $this->get_id(); ?>">
      <div class="swiper-wrapper">
        <?php foreach ($teamMembers as $key => $member) :
          $memberImage = !empty($member['tj_member_image']) ? $member['tj_member_image'] : "";
          $memberName = !empty($member['tj_member_name']) ? $member['tj_member_name'] : "";
          $memberDesignation = !empty($member['tj_member_designation']) ? $member['tj_member_designation'] : "";
          $memberUrl = !empty($member['member_url']) ? $member['member_url'] : "";

          if (! empty($memberUrl['url'])) {
            $this->add_link_attributes('link-' . $key, $memberUrl);
          }

          $showMediaLink = $member['tj_media_link'] ?? "";
          $showNameLink = $member['tj_name_link'] ?? "";
          $showButton = $member['tj_show_button'] ?? "";
          $buttonText = $member['tj_button_text'] ?? "";
          $buttonIcon = $member['tj_btn_icon'] ?? "";

          // socials
          $showMemberSocials = !empty($member['show_member_socials']) ? $member['show_member_socials'] : false;
          $memberWebsite = !empty($member['website_link']) ? $member['website_link'] : "";
          $memberEmail = !empty($member['email_link']) ? $member['email_link'] : "";
          $memberPhone = !empty($member['phone_link']) ? $member['phone_link'] : "";
          $memberFacebook = !empty($member['facebook_link']) ? $member['facebook_link'] : "";
          $memberTwitter = !empty($member['twitter_link']) ? $member['twitter_link'] : "";
          $memberInstagram = !empty($member['instagram_link']) ? $member['instagram_link'] : "";
          $memberLinkedin = !empty($member['linkedin_link']) ? $member['linkedin_link'] : "";
          $memberPinterest = !empty($member['pinterest_link']) ? $member['pinterest_link'] : "";
          $memberYoutube = !empty($member['youtube_link']) ? $member['youtube_link'] : "";
          $memberVimeo = !empty($member['vimeo_link']) ? $member['vimeo_link'] : "";
          $memberGithub = !empty($member['github_link']) ? $member['github_link'] : "";
          $memberFlickr = !empty($member['flickr_link']) ? $member['flickr_link'] : "";
          $memberBehance = !empty($member['behance_link']) ? $member['behance_link'] : "";
          $memberDribbble = !empty($member['dribbble_link']) ? $member['dribbble_link'] : "";


          $tjAnimation      = $member['tj_animation'] ?? '';
          $tjAnimationName  = $member['tj_animation_name'] ?? '';
          $tjAnimationDelay   = $member['tj_animation_delay'] ?? '';

          $team_arg = 'tj-team-arg-' . $key;
          if (!empty($tjAnimation)) {
            $teamClass = "team-item wow $tjAnimationName";
            $this->add_render_attribute($team_arg, 'data-wow-delay', $tjAnimationDelay['size'] . "s");
          } else {
            $teamClass = "team-item";
          }
          $this->add_render_attribute($team_arg, 'class', $teamClass);

        ?>
          <div class="swiper-slide">
            <div <?php echo $this->get_render_attribute_string($team_arg); ?>>

              <?php if (!empty($memberImage['url'])): ?>
                <!-- image -->
                <div class="team-images">
                  <?php if ("yes" == $showMediaLink && !empty($memberUrl['url'])): ?>
                    <a <?php $this->print_render_attribute_string('link-' . $key); ?>>
                      <img src="<?php echo esc_url($memberImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($memberImage['id'], '_wp_attachment_image_alt', true)); ?>">
                    </a>
                  <?php else: ?>
                    <img src="<?php echo esc_url($memberImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($memberImage['id'], '_wp_attachment_image_alt', true)); ?>">
                  <?php endif; ?>
                </div>
              <?php endif; ?>

              <div class="team-content">
                <div class="team-text">

                  <?php if (!empty($memberName)): ?>
                    <!-- name -->
                    <h5 class="title">
                      <?php if ("yes" == $showNameLink && !empty($memberUrl['url'])): ?>
                        <a <?php $this->print_render_attribute_string('link-' . $key); ?>>
                          <?php echo tj_kses($memberName); ?>
                        </a>
                      <?php else: ?>
                        <?php echo tj_kses($memberName); ?>
                      <?php endif; ?>
                    </h5>
                  <?php endif; ?>

                  <?php if (!empty($memberDesignation)): ?>
                    <!-- designation -->
                    <span class="sub-title"><?php echo esc_html__($memberDesignation, 'tjcore'); ?></span>
                  <?php endif; ?>

                  <?php if ("yes" == $showButton && !empty($memberUrl['url'])): ?>
                    <!-- button -->
                    <a class="team_btn text-btn" <?php $this->print_render_attribute_string('link-' . $key); ?>>
                      <?php echo tj_kses($buttonText); ?>
                      <?php \Elementor\Icons_Manager::render_icon($buttonIcon, ['aria-hidden' => 'true']); ?>
                    </a>
                  <?php endif; ?>
                </div>
                <?php if ('yes' === $showMemberSocials): ?>
                  <div class="team-share">
                    <ul>
                      <?php if (!empty($memberWebsite)) : ?>
                        <li>
                          <a href="<?php echo esc_attr($memberWebsite); ?>">
                            <i class="fa-solid fa-globe"></i>
                          </a>
                        </li>
                      <?php endif;

                      if (!empty($memberEmail)) : ?>
                        <li>
                          <a href="<?php echo esc_attr($memberEmail); ?>">
                            <i class="fa-solid fa-envelope"></i>
                          </a>
                        </li>
                      <?php endif;

                      if (!empty($memberPhone)) : ?>
                        <li>
                          <a href="<?php echo esc_attr($memberPhone); ?>">
                            <i class="fa-solid fa-phone"></i>
                          </a>
                        </li>
                      <?php endif;

                      if (!empty($memberFacebook)) : ?>
                        <li>
                          <a href="<?php echo esc_attr($memberFacebook); ?>">
                            <i class="fa-brands fa-facebook-f"></i>
                          </a>
                        </li>
                      <?php endif;

                      if (!empty($memberTwitter)) : ?>
                        <li>
                          <a href="<?php echo esc_attr($memberTwitter); ?>">
                            <i class="fa-brands fa-twitter"></i>
                          </a>
                        </li>
                      <?php endif;

                      if (!empty($memberInstagram)) : ?>
                        <li>
                          <a href="<?php echo esc_attr($memberInstagram); ?>">
                            <i class="fa-brands fa-instagram"></i>
                          </a>
                        </li>
                      <?php endif;

                      if (!empty($memberLinkedin)) : ?>
                        <li>
                          <a href="<?php echo esc_attr($memberLinkedin); ?>">
                            <i class="fa-brands fa-linkedin-in"></i>
                          </a>
                        </li>
                      <?php endif;

                      if (!empty($memberPinterest)) :  ?>
                        <li>
                          <a href="<?php echo esc_attr($memberPinterest); ?>">
                            <i class="fa-brands fa-pinterest"></i>
                          </a>
                        </li>
                      <?php endif;

                      if (!empty($memberYoutube)) : ?>
                        <li>
                          <a href="<?php echo esc_attr($memberYoutube); ?>">
                            <i class="fa-brands fa-youtube"></i>
                          </a>
                        </li>
                      <?php endif;

                      if (!empty($memberVimeo)) : ?>
                        <li>
                          <a href="<?php echo esc_attr($memberVimeo); ?>">
                            <i class="fab fa-vimeo"></i>
                          </a>
                        </li>
                      <?php endif;

                      if (!empty($memberGithub)) : ?>
                        <li>
                          <a href="<?php echo esc_attr($memberGithub); ?>">
                            <i class="fab fa-github"></i>
                          </a>
                        </li>
                      <?php endif;

                      if (!empty($memberFlickr)) : ?>
                        <li>
                          <a href="<?php echo esc_attr($memberFlickr); ?>">
                            <i class="fab fa-flickr"></i>
                          </a>
                        </li>
                      <?php endif;

                      if (!empty($memberBehance)) : ?>
                        <li>
                          <a href="<?php echo esc_attr($memberBehance); ?>">
                            <i class="fab fa-behance"></i>
                          </a>
                        </li>
                      <?php endif;

                      if (!empty($memberDribbble)) : ?>
                        <li>
                          <a href="<?php echo esc_attr($memberDribbble); ?>">
                            <i class="fab fa-dribbble"></i>
                          </a>
                        </li>
                      <?php endif; ?>
                    </ul>
                  </div>
                <?php endif; ?>
              </div>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
      <?php if ("yes" == $dot): ?>
        <div class="swiper_pagination service-pagination"></div>
      <?php endif; ?>
    </div>
  </div>
<?php endif; ?>