<?php
$reviewList = !empty($settings['tj_testi_list']) ? $settings['tj_testi_list'] : [];

$loop           = !empty($settings['slide_loop']) ? $settings['slide_loop'] : 'no';
$dot            = !empty($settings['slide_dot']) ? $settings['slide_dot'] : 'no';
$nav            = !empty($settings['slide_nav']) ? $settings['slide_nav'] : 'no';
$autoplay       = !empty($settings['slide_autoplay']) ? $settings['slide_autoplay'] : 'no';
$autoplayDelay  = !empty($settings['slide_autoplay_Delay']) ? $settings['slide_autoplay_Delay'] : '5000';

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

$testiClass = "h6-testimonial-wrapper sw-testimonial-5 carouselWrap";
if (!empty($tjAnimation)) {
  $testiClass .= " wow $tjAnimationName";
  $this->add_render_attribute('tj-testimonial-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj-testimonial-arg', 'class', $testiClass);

$swipeDirction = !empty($settings['gsap_swipe_direction']) ? $settings['gsap_swipe_direction'] : '';

$swipeWrapperClass = '';
if ($swipeDirction === 'right-swipe') {
  $swipeWrapperClass = 'rightSwipeWrap';
} elseif ($swipeDirction === 'left-swipe') {
  $swipeWrapperClass = 'leftSwipeWrap';
}

$is_rtl = is_rtl() ? 'rtl' : 'ltr';

// Preview values
$preview_xs  = $settings['tj_xs_preview'] ?? '';
$preview_sm  = $settings['tj_sm_preview'] ?? '';
$preview_md  = $settings['tj_md_preview'] ?? '';
$preview_lg  = $settings['tj_lg_preview'] ?? '';
$preview_xl  = $settings['tj_xl_preview'] ?? '';
$preview_xxl = $settings['tj_xxl_preview'] ?? '';

// Space values
$space_xs  = $settings['tj_xs_space'] ?? '';
$space_sm  = $settings['tj_sm_space'] ?? '';
$space_md  = $settings['tj_md_space'] ?? '';
$space_lg  = $settings['tj_lg_space'] ?? '';
$space_xl  = $settings['tj_xl_space'] ?? '';
$space_xxl = $settings['tj_xxl_space'] ?? '';

$data_attrs = [
  'xxl' => $preview_xxl,
  'xl'  => $preview_xl,
  'lg'  => $preview_lg,
  'md'  => $preview_md,
  'sm'  => $preview_sm,
  'xs'  => $preview_xs,

  'space-xxl' => $space_xxl,
  'space-xl'  => $space_xl,
  'space-lg'  => $space_lg,
  'space-md'  => $space_md,
  'space-sm'  => $space_sm,
  'space-xs'  => $space_xs,
];

// Convert to HTML attributes string
$data_attr_str = '';
foreach ($data_attrs as $key => $val) {
  if ($val !== '') {
    $data_attr_str .= ' data-' . esc_attr($key) . '="' . esc_attr($val) . '"';
  }
}

?>

<div <?php echo $this->get_render_attribute_string('tj-testimonial-arg'); ?> data-loop="<?php echo $loop; ?>" data-nav="<?php echo $nav; ?>" data-dot="<?php echo $dot; ?>" data-autoplay="<?php echo $autoplay; ?>" data-delay="<?php echo $autoplayDelay; ?>" <?php echo $data_attr_str; ?>>
  <?php if (!empty($reviewList)): ?>
    <div dir="<?php echo esc_attr($is_rtl); ?>" class="swiper swiper-container h6-testimonial-slider" id="testiCarousel-<?php echo $this->get_id(); ?>">
      <div class="swiper-wrapper <?php echo esc_attr($swipeWrapperClass); ?>">
        <?php foreach ($reviewList as $key => $review):
          $name = $review['tj_testi_name'];
          $designation = $review['tj_testi_designation'];
          $text = $review['tj_testi_text'];
          $authorImage = $review['tj_testi_image'];
        ?>
          <div class="swiper-slide <?php echo esc_attr($swipeDirction); ?>">
            <div class="testimonial-item style-6 tj-el-item">
              <div class="testimonial-content">
                <?php if (!empty($review['tj_testi_rating'])) : ?>
                  <div class="author-rating el-rating">
                    <div class="star-ratings">
                      <div class="fill-ratings" style="width: <?php echo esc_attr($review['tj_testi_rating']['size']);
                                                              echo esc_attr($review['tj_testi_rating']['unit']) ?>">
                        <span><?php esc_html_e('★★★★★', 'tjcore'); ?></span>
                      </div>
                      <div class="empty-ratings">
                        <span><?php esc_html_e('★★★★★', 'tjcore'); ?></span>
                      </div>
                    </div>
                  </div>
                <?php endif; ?>

                <?php if (!empty($text)): ?>
                  <div class="desc">
                    <p><?php echo tj_kses($text); ?></p>
                  </div>
                <?php endif; ?>

              </div>
              <div class="tj-testimonial-author">
                <?php if (!empty($authorImage)): ?>
                  <div class="author-images">
                    <img src="<?php echo esc_url($authorImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($authorImage['id'], '_wp_attachment_image_alt', true)); ?>" />
                  </div>
                <?php endif; ?>

                <div class="author-content">
                  <div class="author-text">
                    <?php if (!empty($name)): ?>
                      <h4 class="author-name el-title"><?php echo esc_html($name); ?></h4>
                    <?php endif; ?>
                    <?php if (!empty($designation)): ?>
                      <span class="sub-title el-stitle"><?php echo esc_html($designation); ?></span>
                    <?php endif; ?>
                  </div>
                </div>
              </div>
            </div>
          </div>
        <?php endforeach; ?>
      </div>

      <?php if ("yes" == $dot): ?>
        <div class="swiper_pagination testimonial-pagination d-md-none"></div>
      <?php endif; ?>
    </div>
  <?php endif; ?>
</div>