<?php
$reviewList = !empty($settings['tj_testi_list']) ? $settings['tj_testi_list'] : [];

$loop           = !empty($settings['slide_loop']) ? $settings['slide_loop'] : 'no';
$dot            = !empty($settings['slide_dot']) ? $settings['slide_dot'] : 'no';
$nav            = !empty($settings['slide_nav']) ? $settings['slide_nav'] : 'no';
$autoplay       = !empty($settings['slide_autoplay']) ? $settings['slide_autoplay'] : 'no';
$autoplayDelay  = !empty($settings['slide_autoplay_Delay']) ? $settings['slide_autoplay_Delay'] : '5000';

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

$testiClass = "h7-testimonial-wrap";
if (!empty($tjAnimation)) {
  $testiClass .= " wow $tjAnimationName";
  $this->add_render_attribute('tj-testimonial-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj-testimonial-arg', 'class', $testiClass);
$is_rtl = is_rtl() ? 'rtl' : 'ltr';
?>


<div <?php echo $this->get_render_attribute_string('tj-testimonial-arg'); ?>>
  <?php if (!empty($reviewList)): ?>
    <?php foreach ($reviewList as $key => $review):
      $name = $review['tj_testi_name'];
      $designation = $review['tj_testi_designation'];
      $text = $review['tj_testi_text'];
      $authorImage = $review['tj_testi_image'];
    ?>
      <div dir="<?php echo esc_attr($is_rtl); ?>" class="testimonial-style-2 h7-testimonial-single tj-el-item <?php echo esc_attr("1" == $key ? "active" : ""); ?>">
        <div class="testimonial-content">

          <?php if (!empty($name)): ?>
            <div class="h7-testimonial-title">
              <h4 class="title el-title"><?php echo esc_html($name); ?> <i class="tji-plus"></i></h4>
            </div>
          <?php endif; ?>

          <div class="testimonial-content-inner">

            <?php if (!empty($settings['tj_quote_icon']['value'])) : ?>
              <div class="testimonial-quote el-icon">
                <?php tj_render_icon($settings, 'quote_icon', 'tj_quote_icon'); ?>
              </div>
            <?php endif; ?>

            <?php if (!empty($text)): ?>
              <div class="desc">
                <p><?php echo tj_kses($text); ?></p>
              </div>
            <?php endif; ?>

            <div class="testimonial-author">

              <?php if (!empty($authorImage)): ?>
                <div class="author-images">
                  <img src="<?php echo esc_url($authorImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($authorImage['id'], '_wp_attachment_image_alt', true)); ?>" />
                </div>
              <?php endif; ?>

              <div class="author-text">
                <?php if (!empty($review['tj_testi_rating'])) : ?>
                  <div class="testimonial-rating el-rating">
                    <div class="star-fill">
                      <div class="star-ratings">
                        <div class="fill-ratings" style="width: <?php echo esc_attr($review['tj_testi_rating']['size']);
                                                                echo esc_attr($review['tj_testi_rating']['unit']) ?>">
                          <span><?php esc_html_e('★★★★★', 'tjcore'); ?></span>
                        </div>
                        <div class="empty-ratings">
                          <span><?php esc_html_e('★★★★★', 'tjcore'); ?></span>
                        </div>
                      </div>
                    </div>
                  </div>
                <?php endif; ?>

                <?php if (!empty($name)): ?>
                  <h4 class="title el-title"><?php echo esc_html($name); ?></h4>
                <?php endif; ?>
                <?php if (!empty($designation)): ?>
                  <span class="designation el-stitle"><?php echo esc_html($designation); ?></span>
                <?php endif; ?>
              </div>

            </div>
          </div>

        </div>
      </div>
    <?php endforeach; ?>
  <?php endif; ?>
</div>