<?php
$reviewList = !empty($settings['tj_testi_list']) ? $settings['tj_testi_list'] : [];

$sliderDirction = $settings['slide_direction'] ?? 'tj-slider-up';

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

$testiClass = "h8-testimonial-wrapper carouselWrap";
if (!empty($tjAnimation)) {
  $testiClass .= " wow $tjAnimationName";
  $this->add_render_attribute('tj-testimonial-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj-testimonial-arg', 'class', $testiClass);
?>

<div <?php echo $this->get_render_attribute_string('tj-testimonial-arg'); ?>>
  <?php if (!empty($reviewList)): ?>
    <div class="swiper swiper-container h8-testimonial-slider <?php echo esc_attr($sliderDirction); ?>" id="testiCarousel-<?php echo $this->get_id(); ?>">
      <div class="swiper-wrapper">
        <?php foreach ($reviewList as $key => $review):
          $name = $review['tj_testi_name'];
          $designation = $review['tj_testi_designation'];
          $text = $review['tj_testi_text'];
          $authorImage = $review['tj_testi_image'];
        ?>
          <div class="swiper-slide">
            <div class="testimonial-item h8-testimonial-item tj-el-item">
              <div class="testimonial-content">
                <?php if (!empty($review['tj_testi_rating'])) : ?>
                  <div class="author-rating el-rating">
                    <div class="star-ratings">
                      <div class="fill-ratings" style="width: <?php echo esc_attr($review['tj_testi_rating']['size']);
                                                              echo esc_attr($review['tj_testi_rating']['unit']) ?>">
                        <span><?php esc_html_e('★★★★★', 'tjcore'); ?></span>
                      </div>
                      <div class="empty-ratings">
                        <span><?php esc_html_e('★★★★★', 'tjcore'); ?></span>
                      </div>
                    </div>
                  </div>
                <?php endif; ?>
                <?php if (!empty($text)): ?>
                  <div class="desc">
                    <p><?php echo tj_kses($text); ?></p>
                  </div>
                <?php endif; ?>
              </div>
              <div class="tj-testimonial-author">
                <?php if (!empty($authorImage)): ?>
                  <div class="author-images">
                    <img src="<?php echo esc_url($authorImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($authorImage['id'], '_wp_attachment_image_alt', true)); ?>" />
                  </div>
                <?php endif; ?>
                <div class="author-content">
                  <div class="author-text">
                    <?php if (!empty($name)): ?>
                      <h4 class="author-name el-title"><?php echo esc_html($name); ?></h4>
                    <?php endif; ?>
                    <?php if (!empty($designation)): ?>
                      <span class="sub-title el-stitle"><?php echo esc_html($designation); ?></span>
                    <?php endif; ?>
                  </div>
                </div>
              </div>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  <?php endif; ?>
</div>