<?php
$reviewList = !empty($settings['tj_testi_list']) ? $settings['tj_testi_list'] : [];

$loop            = !empty($settings['slide_loop']) ? $settings['slide_loop'] : 'no';
$dot            = !empty($settings['slide_dot']) ? $settings['slide_dot'] : 'no';
$nav            = !empty($settings['slide_nav']) ? $settings['slide_nav'] : 'no';
$autoplay        = !empty($settings['slide_autoplay']) ? $settings['slide_autoplay'] : 'no';
$autoplayDelay        = !empty($settings['slide_autoplay_Delay']) ? $settings['slide_autoplay_Delay'] : '5000';

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

$testiClass = "h9-testimonial-wrapper carouselWrap";
if (!empty($tjAnimation)) {
  $testiClass .= " wow $tjAnimationName";
  $this->add_render_attribute('tj-testimonial-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj-testimonial-arg', 'class', $testiClass);
$is_rtl = is_rtl() ? 'rtl' : 'ltr';

?>

<div <?php echo $this->get_render_attribute_string('tj-testimonial-arg'); ?> data-loop="<?php echo $loop; ?>" data-nav="<?php echo $nav; ?>" data-dot="<?php echo $dot; ?>" data-autoplay="<?php echo $autoplay; ?>" data-delay="<?php echo $autoplayDelay; ?>">
  <?php if (!empty($reviewList)): ?>
    <div dir="<?php echo esc_attr($is_rtl); ?>" class="swiper h9-testimonial-slider" id="testiCarousel-<?php echo $this->get_id(); ?>">
      <div class="swiper-wrapper">
        <?php foreach ($reviewList as $key => $review):
          $text = $review['tj_testi_text'];
        ?>
          <div class="swiper-slide">
            <div class="h9-testimonial-item tj-el-item">
              <div class="testimonial-content">
                <?php if (!empty($settings['tj_quote_icon']['value'])) : ?>
                  <div class="testimonial-quote el-icon">
                    <?php tj_render_icon($settings, 'quote_icon', 'tj_quote_icon'); ?>
                  </div>
                <?php endif; ?>
                <?php if (!empty($text)): ?>
                  <div class="desc">
                    <p><?php echo tj_kses($text); ?></p>
                  </div>
                <?php endif; ?>
              </div>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
      <div class="client-thumb-wrap">
        <div class="swiper client-thumb" id="clientThumb-<?php echo $this->get_id(); ?>">
          <div class="swiper-wrapper">
            <?php foreach ($reviewList as $key => $review):
              $name = $review['tj_testi_name'];
              $designation = $review['tj_testi_designation'];
              $authorImage = $review['tj_testi_image'];
            ?>
              <div class="swiper-slide thumb-item">
                <div class="testimonial-author">
                  <?php if (!empty($authorImage)): ?>
                    <div class="author-images">
                      <img src="<?php echo esc_url($authorImage['url']); ?>" alt="<?php echo esc_attr(get_post_meta($authorImage['id'], '_wp_attachment_image_alt', true)); ?>" />
                    </div>
                  <?php endif; ?>
                  <div class="author-text">
                    <?php if (!empty($name)): ?>
                      <h5 class="title el-title"><?php echo esc_html($name); ?></h5>
                    <?php endif; ?>
                    <?php if (!empty($designation)): ?>
                      <span class="designation el-stitle"><?php echo esc_html($designation); ?></span>
                    <?php endif; ?>
                  </div>
                </div>
              </div>
            <?php endforeach; ?>
          </div>
        </div>
      </div>
      <?php if ("yes" == $dot): ?>
        <div class="swiper_pagination"></div>
      <?php endif; ?>
    </div>
    <?php if ("yes" == $nav): ?>
      <div class="swiper_navigations testimonial-navigation">
        <div class="navigation slider-prev"><i class="tji-arrow-left"></i></div>
        <div class="navigation slider-next"><i class="tji-arrow-right"></i></div>
      </div>
    <?php endif; ?>
  <?php endif; ?>
</div>