<?php
$tjCircleIcon = $settings['tj_circle_icon'] ?? "";
$tjCircleVideoLink = $settings['tj_circle_video_link'] ?? "";
$tj_subtitle = $settings['tj_subtitle'] ?? "";
$tj_title = $settings['tj_title'] ?? "";

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

// setting animation
$class = "growth-content mt-0";
if (!empty($tjAnimation)) {
  $class .= " wow $tjAnimationName";
  $this->add_render_attribute('tj_video_args', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj_video_args', 'class', $class);
?>

<section class="tj-growth-section tjParallaxSection">
  <?php if (!empty($settings['tj_image']['url'])): ?>
    <div class="tj-growth-bg tjParallaxImage" data-bg-image="<?php echo esc_url($settings['tj_image']['url']); ?>"></div>
  <?php endif; ?>
  <div class="container">
    <div class="row">
      <div class="col-12">
        <div class="growth-wrap">
          <div <?php echo $this->get_render_attribute_string('tj_video_args'); ?>>
            <?php if (!empty($tj_title)): ?>
              <h2 class="title text-anim"><?php echo wp_kses_post($tj_title); ?></h2>
            <?php endif; ?>
            <?php if (!empty($tjCircleVideoLink)): ?>
              <div class="video-btn-wrap">
                <a class="video-btn video-popup" data-autoplay="true" data-vbtype="video" data-maxwidth="1200px"
                  href="<?php echo esc_url($tjCircleVideoLink); ?>">
                  <?php if (!empty($tjCircleIcon['value'])): ?>
                    <span class="play-btn"><?php tj_render_icon($settings, 'circle_icon', 'tj_circle_icon') ?></span>
                  <?php endif; ?>
                  <?php if (!empty($tj_subtitle)): ?>
                    <span class="video-text"><?php echo esc_html($tj_subtitle); ?></span>
                  <?php endif; ?>
                </a>
              </div>
            <?php endif; ?>
            <?php if (!empty($settings['tj_shape_image']['url'])): ?>
              <div class="icon-shape">
                <img src="<?php echo esc_url($settings['tj_shape_image']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_shape_image']['id'], '_wp_attachment_image_alt', true)); ?>">
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>