<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Image.
 */
class TJ_About_Image extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-about-image';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ About Image', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-image tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'image',
      'media',
      'tj image',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {

    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Image Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // _tj_image_content
    $this->start_controls_section(
      '_tj_image_content',
      [
        'label' => esc_html__('Image', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_image',
      [
        'label'   => esc_html__('Choose Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
      ]
    );

    // title
    $this->add_control(
      'tj_image_title',
      [
        'label'       => esc_html__('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => tj_kses('<span>Reach</span> 20M'),
        'rows'        => '3',
        'condition' => [
          'tj_design_style!' => ['1', '2']
        ]
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    // author
    $this->start_controls_section(
      'tj_about_author_tab',
      [
        'label' => esc_html__('Author Content', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
        'condition'   => [
          'tj_design_style!' => ['2', '3'],
        ],
      ]
    );
    $this->add_control(
      'tj_signature',
      [
        'label'   => esc_html__('Signature Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $this->add_control(
      'tj_name',
      [
        'label'       => esc_html__('Name', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Burdee Nicolas', 'tjcore'),
        'dynamic'     => [
          'active' => true,
        ],
      ]
    );
    $this->add_control(
      'tj_job',
      [
        'label'       => esc_html__('Designation', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Co. Founder', 'tjcore'),
        'dynamic'     => [
          'active' => true,
        ],
      ]
    );
    $this->end_controls_section();

    // counter
    $this->start_controls_section(
      'section_tab_1',
      [
        'label' => esc_html__('Counter', 'tjcore'),
        'condition'   => [
          'tj_design_style' => ['2'],
        ],
      ]
    );
    // title
    $this->add_control(
      'tj_ff_title',
      [
        'label'       => esc_html__('Counter Title', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => tj_kses('Running Project'),
        'rows'        => '3',
      ]
    );
    // number
    $this->add_control(
      'tj_ff_number',
      [
        'label'       => esc_html__('Counter Amount', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'default'     => esc_html__('3.8', 'tjcore'),
      ]
    );
    // prefix
    $this->add_control(
      'tj_ff_prefix',
      [
        'label'       => esc_html__('Number Prefix', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'description' => esc_html__('Insert prefix for fact.', 'tjcore'),
      ]
    );
    // suffix
    $this->add_control(
      'tj_ff_suffix',
      [
        'label'       => esc_html__('Number Suffix', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'description' => esc_html__('Insert suffix for fact.', 'tjcore'),
      ]
    );
    $this->end_controls_section();

    // circle button
    $this->start_controls_section(
      '__tj_circle_button',
      [
        'label' => esc_html__('Circle button', 'tjcore'),
        'condition'   => [
          'tj_design_style!' => ['1', '2'],
        ],
      ]
    );
    $this->add_control(
      'tj_circle_show',
      [
        'label'        => esc_html__('Enable circle button?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '1',
      ]
    );
    $this->add_control(
      'tj_circle_image',
      [
        'label'   => esc_html__('Circle Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition'   => [
          'tj_circle_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_icon_image',
      [
        'label'   => esc_html__('Icon Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition'   => [
          'tj_circle_show' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */


    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Wrapper', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    // section background
    $this->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_background',
        'selector' => '{{WRAPPER}} .tj-wrap',
        'exclude' => ['image', 'video']
      ]
    );
    // section padding
    $this->add_responsive_control(
      'tj_section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    // section margin
    $this->add_responsive_control(
      'tj_section_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
    // counter
    $this->start_controls_section(
      '_counter_name',
      [
        'label' => esc_html__('Counter', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    // counter typography
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_counter_typography',
        'selector' => '{{WRAPPER}} .tj-wrap .number span',
      ]
    );

    // counter color
    $this->add_control(
      'tj_counter_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-wrap .number, .tj-wrap .number span' => 'color: {{VALUE}}',
        ],
      ]
    );

    // counter margin
    $this->add_responsive_control(
      'tj_counter_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-wrap .number' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    // counter padding
    $this->add_responsive_control(
      'tj_counter_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-wrap .number' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      '_label_content',
      [
        'label' => esc_html__('Content', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .tj-wrap .title',
      ]
    );

    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Title Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-wrap .title' => 'color: {{VALUE}} !important',
        ],
      ]
    );

    // Label
    $this->add_control(
      '_label_name',
      [
        'label' => esc_html__('Text', 'tjcore'),
        'type'   => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_label_typography',
        'selector' => '{{WRAPPER}} .tj-wrap .sub-title',
      ]
    );
    $this->add_control(
      'tj_label_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-wrap .sub-title' => 'color: {{VALUE}} !important',
        ],
      ]
    );
    $this->add_control(
      'tj_wrapper_box_background',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .about-images-group-one .about-author' => 'background: {{VALUE}}',
          '{{WRAPPER}} .testimonial-images-2 .testimonial-funfact' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/about-image/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_About_Image());
