<?php

namespace TJCore;

use Elementor\Widget_Base;
use \Elementor\Utils;
use \Elementor\Repeater;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Text_Stroke;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Css_Filter;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for About.
 */
class TJ_About extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-about';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ About', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-ehp-hero tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'image',
      'media',
      'title',
      'tj about',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {

    // tj_section_title
    $this->start_controls_section(
      'tj_section_title',
      [
        'label' => esc_html__('Section Title', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_subtitle',
      [
        'label'       => esc_html__('Subtitle', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Section Subtitle', 'tjcore'),
        'label_block' => true,
      ]
    );

    $this->add_control(
      'tj_subtitle_animation',
      [
        'label'        => esc_html__('Enable Subtitle Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
      ]
    );
    $this->add_control(
      'tj_subtitle_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_subtitle_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_subtitle_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_subtitle_animation' => 'yes',
        ],
      ]
    );

    $this->add_control(
      'tj_title',
      [
        'label'     => esc_html__('Title', 'tjcore'),
        'type'      => Controls_Manager::TEXTAREA,
        'default'   => esc_html__('Section Title', 'tjcore'),
        'rows'      => '3',
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'tj_title_animation',
      [
        'label'        => esc_html__('Enable Title Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
      ]
    );

    $this->add_control(
      'is_content',
      [
        'label'        => esc_html__('Is Section Content?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '1',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_content',
      [
        'label'     => esc_html__('Content', 'tjcore'),
        'type'      => Controls_Manager::WYSIWYG,
        'default'      => tj_kses("Lorem ipsum dolor sit amet consectetur adipisicing elit. Odio ipsam, quis ipsum totam provident quaerat!"),
        'condition' => [
          'is_content' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_content_animation',
      [
        'label'        => esc_html__('Enable Content Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'condition'    => [
          'is_content' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_content_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'is_content'           => 'yes',
          'tj_content_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_content_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'is_content'           => 'yes',
          'tj_content_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_title_tag',
      [
        'label'   => esc_html__('Title HTML Tag', 'tjcore'),
        'type'    => Controls_Manager::CHOOSE,
        'options' => [
          'h1' => [
            'title' => esc_html__('H1', 'tjcore'),
            'icon'  => 'eicon-editor-h1',
          ],
          'h2' => [
            'title' => esc_html__('H2', 'tjcore'),
            'icon'  => 'eicon-editor-h2',
          ],
          'h3' => [
            'title' => esc_html__('H3', 'tjcore'),
            'icon'  => 'eicon-editor-h3',
          ],
          'h4' => [
            'title' => esc_html__('H4', 'tjcore'),
            'icon'  => 'eicon-editor-h4',
          ],
          'h5' => [
            'title' => esc_html__('H5', 'tjcore'),
            'icon'  => 'eicon-editor-h5',
          ],
          'h6' => [
            'title' => esc_html__('H6', 'tjcore'),
            'icon'  => 'eicon-editor-h6',
          ],
        ],
        'default' => 'h2',
        'toggle'  => false,
      ]
    );
    $this->add_responsive_control(
      'tj_alignment',
      [
        'label'        => esc_html__('Alignment', 'tjcore'),
        'type'         => Controls_Manager::CHOOSE,
        'options'      => [
          'start'   => [
            'title' => esc_html__('Left', 'tjcore'),
            'icon'  => 'eicon-text-align-left',
          ],
          'center' => [
            'title' => esc_html__('Center', 'tjcore'),
            'icon'  => 'eicon-text-align-center',
          ],
          'end'  => [
            'title' => esc_html__('Right', 'tjcore'),
            'icon'  => 'eicon-text-align-right',
          ],
        ],
        'default'      => 'start',
        'prefix_class' => 'tj_section_align elementor%s-align-',
        'separator'    => 'before',
      ]
    );
    $this->end_controls_section();

    // _tj_image_content
    $this->start_controls_section(
      '_tj_image_content',
      [
        'label' => esc_html__('Images', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_image',
      [
        'label'   => esc_html__('Choose Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
      ]
    );

    $this->add_control(
      'tj_shape_image',
      [
        'label'   => esc_html__('Shape Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'separator' => 'before',
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
      ]
    );

    $this->add_control(
      'tj_star_show',
      [
        'label' => esc_html__('Enable Star?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => 'yes',
        'separator' => 'before'
      ]
    );

    $this->add_control(
      'tj_img_animation',
      [
        'label' => esc_html__('Enable Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_img_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_img_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_img_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_img_animation' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();

    // lists
    $this->start_controls_section(
      'section_list_tab',
      [
        'label'         => esc_html__('List Items', 'tjcore'),
      ]
    );
    $repeater = new Repeater();
    $repeater->add_control(
      'tj_item_icon',
      [
        'label'         => esc_html__('Icon', 'tjcore'),
        'type'          => Controls_Manager::ICONS,
        'fa4compatibility' => 'tj_icon',
        'default'          => [
          'value' => 'tji-double-check',
          'library' => 'tji',
        ],
      ]
    );
    $repeater->add_control(
      'tj_item_content',
      [
        'label'         => esc_html__('Item Content', 'tjcore'),
        'type'          => Controls_Manager::TEXTAREA,
        'default'       => esc_html__('List Content', 'tjcore'),
        'rows' => 3,
      ]
    );
    $this->add_control(
      'tj_list',
      [
        'label'    => esc_html__('List Items', 'tjcore'),
        'type'     => Controls_Manager::REPEATER,
        'fields'   => $repeater->get_controls(),
        'default'  => [
          [
            'tj_item_content' => tj_kses('Expertise and experience'),
          ],
          [
            'tj_item_content' => tj_kses('Client centric approach'),
          ],
          [
            'tj_item_content' => tj_kses('Commitment excellences'),
          ]
        ],
        'title_field' => '{{{ tj_item_content }}}',
      ]
    );

    $this->end_controls_section();

    // button    
    $this->start_controls_section(
      'tj_hero_btn',
      [
        'label'     => esc_html__('Button', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_button_show',
      [
        'label'        => esc_html__('Show button?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );
    $this->add_control(
      'tj_btn_text',
      [
        'label'     => esc_html__('Text', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__('Read more', 'tjcore'),
        'dynamic'   => [
          'active' => true,
        ],
        'condition' => [
          'tj_button_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_btn_icon',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'default' => [
          'value' => 'tji-arrow-right',
          'library' => 'tji',
        ],
        'skin' => 'inline',
        'label_block' => false
      ]
    );
    $this->add_control(
      'tj_btn_link_type',
      [
        'label'     => esc_html__('Link Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'options'   => [
          '1' => esc_html__('Custom Link', 'tjcore'),
          '2' => esc_html__('Internal Page', 'tjcore'),
        ],
        'default'   => '1',
        'separator' => 'before',
        'condition' => [
          'tj_button_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_btn_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'condition'   => [
          'tj_button_show' => 'yes',
          'tj_btn_link_type' => '1',
        ],
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_btn_page_link',
      [
        'label'       => esc_html__('Select Page', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'tj_button_show' => 'yes',
          'tj_btn_link_type' => '2',
        ],
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'section_tj_counter',
      [
        'label' => esc_html__('Counter', 'tjcore'),
      ]
    );

    // title
    $this->add_control(
      'tj_ff_title',
      [
        'label'       => esc_html__('Counter Title', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => tj_kses('Happy clients all over <br> world now.'),
        'rows'        => '3',
      ]
    );
    // number
    $this->add_control(
      'tj_ff_number',
      [
        'label'       => esc_html__('Counter Amount', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'default'     => esc_html__('200', 'tjcore'),
      ]
    );
    // prefix
    $this->add_control(
      'tj_ff_prefix',
      [
        'label'       => esc_html__('Number Prefix', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'description' => esc_html__('Insert prefix for fact.', 'tjcore'),
      ]
    );
    // suffix
    $this->add_control(
      'tj_ff_suffix',
      [
        'label'       => esc_html__('Number Suffix', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'description' => esc_html__('Insert suffix for fact.', 'tjcore'),
        'default'     => tj_kses('K+'),
      ]
    );

    $this->add_control(
      'tj_cimage',
      [
        'label'   => esc_html__('Choose Image 1', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_cimage2',
      [
        'label'   => esc_html__('Choose Image 2', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'tj_cimage3',
      [
        'label'   => esc_html__('Choose Image 3', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'separator' => 'before',
      ]
    );

    $this->add_control(
      'tj_button_animation',
      [
        'label'        => esc_html__('Enable Wrapper Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_button_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_button_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_button_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_button_animation' => 'yes',
        ],
      ]
    );

    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Section', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .tj-about-section::before',
      ]
    );
    $this->add_responsive_control(
      'tj_section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-about-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_section_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-about-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // subtitle
    $this->start_controls_section(
      '_style_subtitle',
      [
        'label' => esc_html__('Subtitle', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_subtitle_typography',
        'selector' => '{{WRAPPER}} .sec-heading .sub-title',
      ]
    );
    $this->add_control(
      'tj_subtitle_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .sec-heading .sub-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_subtitle_dot_color',
      [
        'label'     => __('Dot Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .sec-heading .sub-title::before, .sec-heading .sub-title::after' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_subtitle_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .sec-heading .sub-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_subtitle_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .sec-heading .sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .sec-heading .sec-title',
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .sec-heading .sec-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .sec-heading .sec-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .sec-heading .sec-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // content
    $this->start_controls_section(
      '_style_content',
      [
        'label'     => esc_html__('Content', 'tjcore'),
        'tab'       => Controls_Manager::TAB_STYLE,
        'condition' => [
          'is_content' => 'yes',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_content_typography',
        'selector' => '{{WRAPPER}} .sec-heading .desc',
      ]
    );
    $this->add_control(
      'tj_content_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .sec-heading .desc' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_content_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .sec-heading .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_content_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .sec-heading .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    //Button
    $this->start_controls_section(
      '_heading_hero_btn_style',
      [
        'label' => __('Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'btn_typography',
        'selector' => '{{WRAPPER}} .tj-primary-btn',
      ]
    );
    $this->start_controls_tabs('btn_style_tabs');
    $this->start_controls_tab(
      'btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn .btn_text' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn .btn_icon' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_bgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn .btn_inner::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_hcolor',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn:hover .btn_text' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_hcolor',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover .btn_icon' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_hbgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover .btn_inner::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_bg_hcolor',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();

    // icon
    $this->start_controls_section(
      'section_style_list',
      [
        'label' => esc_html__('List style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_responsive_control(
      'ficon_font_size',
      [
        'label' => esc_html__('Icon Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .check-list-one ul li i' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $this->add_control(
      'ficon_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .check-list-one ul li i' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_list_typography',
        'selector' => '{{WRAPPER}} .check-list-one ul li',
      ]
    );
    $this->add_control(
      'tj_list_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .check-list-one ul li' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->end_controls_section();

    // subtitle
    $this->start_controls_section(
      '_style_counter',
      [
        'label' => esc_html__('Counter', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_counter_typography',
        'selector' => '{{WRAPPER}} .funfact-item-one .number',
      ]
    );
    $this->add_control(
      'tj_counter_color',
      [
        'label'     => __('Number Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .funfact-item-one .number' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_counter_tcolor',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .funfact-item-one .sub-title' => 'color: {{VALUE}}',
        ],
        'separator' => 'before'
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_counter_text_typography',
        'selector' => '{{WRAPPER}} .funfact-item-one .sub-title',
      ]
    );
    $this->add_control(
      'tj_counter_border_color',
      [
        'label'     => __('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .about-feature-item .feature-box, .about-feature-item' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
    // image
    $this->start_controls_section(
      '_section_style_image',
      [
        'label' => esc_html__('Image', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_responsive_control(
      'tj_image_width',
      [
        'label'      => esc_html__('Box Width', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 2000,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => '%',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .about-bg-images .about-shape-1' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_image_max_width',
      [
        'label'      => esc_html__('Max Width', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 2000,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => '%',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .about-bg-images .about-shape-1' => 'max-width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_image_height',
      [
        'label'      => esc_html__('Height', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 2000,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => '%',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .about-bg-images .about-shape-1' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'tj_image_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .about-bg-images .about-shape-1' => 'background: {{VALUE}}',
        ],
      ]
    );

    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/about/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_About());
