<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Accordion.
 */
class TJ_Accordion extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-accordion';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Accordion', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-accordion tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'accordion',
      'accordions',
      'tj accordion',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Accordion Style', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
          5 => esc_html__('Style 05', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();


    // Accordion items
    $this->start_controls_section(
      'tj_accordion_content',
      [
        'label' => esc_html__('Accordion Content', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $repeater = new Repeater();
    $repeater->add_control(
      'tj_accordion_question',
      [
        'label'       => esc_html__('Question', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'rows' => 2,
      ]
    );
    $repeater->add_control(
      'is_expand',
      [
        'label'             => esc_html__('Is Expand?', 'tjcore'),
        'type'              => Controls_Manager::SWITCHER,
        'label_on'          => esc_html__('Yes', 'tjcore'),
        'label_off'         => esc_html__('No', 'tjcore'),
        'description'       => esc_html__('Do you want to make this item expand?', 'tjcore'),
        'return_value'      => 'yes',
        'default'           => 'no',
      ]
    );
    $repeater->add_control(
      'tj_accordion_answer',
      [
        'label'       => esc_html__('Answer', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
      ]
    );
    $this->add_control(
      'tj_accordion_list',
      [
        'label'       => esc_html__('Accordion - List', 'tjcore'),
        'type'        => Controls_Manager::REPEATER,
        'fields'      => $repeater->get_controls(),
        'default'     => [
          [
            'tj_accordion_question' => esc_html__('How does the Agile Manifesto address planning?', 'tjcore'),
            'tj_accordion_answer'   => esc_html__("Conix excels delivering high-quality construction solutions tailore to meet your unique needs. Innovative to our  residential projects and dynamic to our commercial from innovates delivering construction solutions for builders construction solutions. Conix excel delivering a high-quali construction solution tailoreid to our meets your uniq needs Innovative to residential."),
          ],
          [
            'tj_accordion_question' => esc_html__('How does the Agile Manifesto address planning?', 'tjcore'),
            'tj_accordion_answer'   => esc_html__("Conix excels delivering high-quality construction solutions tailore to meet your unique needs. Innovative to our  residential projects and dynamic to our commercial from innovates delivering construction solutions for builders construction solutions. Conix excel delivering a high-quali construction solution tailoreid to our meets your uniq needs Innovative to residential."),
          ],
          [
            'tj_accordion_question' => esc_html__('How does the Manifesto address planning?', 'tjcore'),
            'tj_accordion_answer'   => esc_html__("Conix excels delivering high-quality construction solutions tailore to meet your unique needs. Innovative to our  residential projects and dynamic to our commercial from innovates delivering construction solutions for builders construction solutions. Conix excel delivering a high-quali construction solution tailoreid to our meets your uniq needs Innovative to residential."),
          ],
          [
            'tj_accordion_question' => esc_html__('How does the Agil address planning?', 'tjcore'),
            'tj_accordion_answer'   => esc_html__("Conix excels delivering high-quality construction solutions tailore to meet your unique needs. Innovative to our  residential projects and dynamic to our commercial from innovates delivering construction solutions for builders construction solutions. Conix excel delivering a high-quali construction solution tailoreid to our meets your uniq needs Innovative to residential."),
          ],
          [
            'tj_accordion_question' => esc_html__('How the Agile Manifesto address planning?', 'tjcore'),
            'tj_accordion_answer'   => esc_html__("Conix excels delivering high-quality construction solutions tailore to meet your unique needs. Innovative to our  residential projects and dynamic to our commercial from innovates delivering construction solutions for builders construction solutions. Conix excel delivering a high-quali construction solution tailoreid to our meets your uniq needs Innovative to residential."),
          ],
          [
            'tj_accordion_question' => esc_html__('How does the Agile Manifesto address planning?', 'tjcore'),
            'tj_accordion_answer'   => esc_html__("Conix excels delivering high-quality construction solutions tailore to meet your unique needs. Innovative to our  residential projects and dynamic to our commercial from innovates delivering construction solutions for builders construction solutions. Conix excel delivering a high-quali construction solution tailoreid to our meets your uniq needs Innovative to residential."),
          ],
        ],
        'title_field' => '{{{ tj_accordion_question }}}',
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Wrapper', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'wrapper_border',
        'selector' => '{{WRAPPER}} .tj-faq-item',
      ]
    );

    $this->add_responsive_control(
      'wrapper_marging',
      [
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'label' => esc_html__('Margin', 'textdomain'),
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors' => [
          '{{WRAPPER}} .tj-faq-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->start_controls_tabs('accordion_item_tabs');
    $this->start_controls_tab(
      'style_item_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_section_background',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-faq-item' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_border_color',
      [
        'label'     => __('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-faq-item' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_item_active_tab',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_section_active_background',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-faq-item.active' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_border_active_color',
      [
        'label'     => __('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-faq-item.active' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->end_controls_section();

    $this->start_controls_section(
      '_style_tj_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .tj-faq-item .accordion-button, {{WRAPPER}} .accordion_title .title, {{WRAPPER}} .h6-insight_accordion .accordion_item .accordion_title .title, {{WRAPPER}} .h6-insight_accordion.h10-about-accordion .accordion_item .accordion_title .subtitle',
      ]
    );
    $this->start_controls_tabs('accordion_title_tabs');
    $this->start_controls_tab(
      'style_title_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-faq-item .accordion-button' => 'color: {{VALUE}}',
          '{{WRAPPER}} .accordion_title .title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .accordion_title .subtitle' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_title_bg_color',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-faq-item button.collapsed' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_title_border_color',
      [
        'label'     => __('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-faq-item button.collapsed' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_title_active_tab',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_title_active_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-faq-item .accordion-button:not(.collapsed)' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-faq-item .accordion-button:not(.collapsed) span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .accordion_title:not(.collapsed) .title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .accordion_title:not(.collapsed) .subtitle' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_title_bg_active_color',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-faq-item.active button' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_title_border_active_color',
      [
        'label'     => __('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-faq-item.active button' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-faq-item .accordion-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .accordion_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before'
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-faq-item .accordion-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .accordion_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .accordion_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // icon
    $this->start_controls_section(
      '_style_tj_icon',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'accordion_icon_size',
      [
        'label' => esc_html__('Icon Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-faq-item .accordion-button:before' => 'font-size: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .accordion_title::before' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->start_controls_tabs('accordion_icon_tabs');
    $this->start_controls_tab(
      'style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'accordion_icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-faq-item .accordion-button:before' => 'color: {{VALUE}}',
          '{{WRAPPER}} .accordion_title::before' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'accordion_icon_border_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-faq-item .accordion-button:before' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .accordion_title::before' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'accordion_style_active_tab',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );
    $this->add_control(
      'accordion_icon_active_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-faq-item .accordion-button:not(.collapsed):before' => 'color: {{VALUE}}',
          '{{WRAPPER}} .accordion_title:not(.collapsed)::before' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'accordion_icon_ac_border_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-faq-item.active .accordion-button:before' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .tj-faq-item.active .accordion_title::before' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();

    // content
    $this->start_controls_section(
      '_style_tj_content',
      [
        'label' => esc_html__('Content', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_content_typography',
        'selector' => '{{WRAPPER}} .accordion-body.faq-text p, {{WRAPPER}} .accordion_desc .accordion-body, {{WRAPPER}} .tj-faq-item .accordion-body p, {{WRAPPER}} .accordion_item .accordion-body',
      ]
    );
    $this->add_control(
      'tj_content_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .accordion-body.faq-text' => 'color: {{VALUE}}',
          '{{WRAPPER}} .accordion-body.faq-text p' => 'color: {{VALUE}}',
          '{{WRAPPER}} .accordion_desc .accordion-body' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-faq-item .accordion-body p' => 'color: {{VALUE}}',
          '{{WRAPPER}} .accordion_item .accordion-body' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_content_border_color',
      [
        'label'     => __('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .accordion-body.faq-text' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .accordion-body.faq-text p' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .accordion_desc .accordion-body' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .tj-faq-item .accordion-body p' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .accordion_item .accordion-body' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_content_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .accordion-body.faq-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .accordion_desc .accordion-body' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-faq-item .accordion-body p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .accordion_item .accordion-body' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_content_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .accordion-body.faq-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .accordion_desc .accordion-body' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-faq-item .accordion-body' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .accordion_item .accordion-body' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/accordion/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Accordion());
