<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Blog Carousel.
 */
class TJ_Blog_Carousel extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-blog-carousel';
  }

  // widget title.
  public function get_title() {
    return __('TJ Blog Carousel', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-carousel tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script', 'swiper'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style', 'swiper'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'blog-post',
      'carousel',
      'tj post',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {
    // layout Panel
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Post Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();


    // Post Query
    $this->start_controls_section(
      'tj_post_query',
      [
        'label' => esc_html__('Post Query', 'tjcore'),
      ]
    );

    $post_type = 'post';
    $taxonomy  = 'category';

    $this->add_control(
      'posts_per_page',
      [
        'label'       => esc_html__('Posts Per Page', 'tjcore'),
        'description' => esc_html__('Leave blank or enter -1 for all.', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '3',
      ]
    );
    $this->add_control(
      'category',
      [
        'label'       => esc_html__('Include Categories', 'tjcore'),
        'description' => esc_html__('Select a category to include or leave blank for all.', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'multiple'    => true,
        'options'     => tj_get_categories($taxonomy),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'exclude_category',
      [
        'label'       => esc_html__('Exclude Categories', 'tjcore'),
        'description' => esc_html__('Select a category to exclude', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'multiple'    => true,
        'options'     => tj_get_categories($taxonomy),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'post__in',
      [
        'label'       => esc_html__('Include Posts', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'options'     => tj_get_all_types_post($post_type),
        'multiple'    => true,
        'label_block' => true,
      ]
    );
    $this->add_control(
      'post__not_in',
      [
        'label'       => esc_html__('Exclude Posts', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'options'     => tj_get_all_types_post($post_type),
        'multiple'    => true,
        'label_block' => true,
      ]
    );
    $this->add_control(
      'offset',
      [
        'label'   => esc_html__('Offset', 'tjcore'),
        'type'    => Controls_Manager::NUMBER,
        'default' => '0',
      ]
    );
    $this->add_control(
      'orderby',
      [
        'label'   => esc_html__('Order By', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => array(
          'ID'            => 'Post ID',
          'author'        => 'Post Author',
          'title'         => 'Title',
          'date'          => 'Date',
          'modified'      => 'Last Modified Date',
          'parent'        => 'Parent Id',
          'rand'          => 'Random',
          'comment_count' => 'Comment Count',
          'menu_order'    => 'Menu Order',
        ),
        'default' => 'date',
      ]
    );
    $this->add_control(
      'order',
      [
        'label'   => esc_html__('Order', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          'asc'  => esc_html__('Ascending', 'tjcore'),
          'desc' => esc_html__('Descending', 'tjcore'),
        ],
        'default' => 'desc',
      ]
    );
    $this->add_control(
      'ignore_sticky_posts',
      [
        'label'        => esc_html__('Ignore Sticky Posts', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );
    $this->add_control(
      'tj_post_title_word',
      [
        'label'       => esc_html__('Title Word Count', 'tjcore'),
        'description' => esc_html__('Set how many word you want to display!', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '6',
      ]
    );
    $this->add_control(
      'tj_post_content',
      [
        'label'        => __('Content', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Show', 'tjcore'),
        'label_off'    => __('Hide', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );
    $this->add_control(
      'tj_post_content_limit',
      [
        'label'       => __('Content Limit', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '18',
        'condition'   => [
          'tj_post_content'  => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_btn',
      [
        'label'   => esc_html__('Button Text', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('Read more', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_post_button_icon',
      [
        'label' => esc_html__('Button Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'fa4compatibility' => 'post_button_icon',
        'default' => [
          'value' => 'tji-arrow-right',
          'library' => 'tji',
        ],
      ]
    );
    $this->end_controls_section();

    // post meta
    $this->start_controls_section(
      'tj_post_meta',
      [
        'label' => esc_html__('Post Meta', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_post_category',
      [
        'label'        => esc_html__('Post Category', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );
    $this->add_control(
      'tj_max_category',
      [
        'label' => esc_html__('Max Categories to Show', 'tjcore'),
        'type' => Controls_Manager::NUMBER,
        'min' => 1,
        'max' => 50,
        'default' => 1,
        'condition' => [
          'tj_post_category' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_post_date',
      [
        'label'        => esc_html__('Post Date', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );
    $this->add_control(
      'tj_post_comment',
      [
        'label'        => esc_html__('Post Comment', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );
    $this->end_controls_section();


    // Slider options
    $this->start_controls_section(
      '_slider_options',
      [
        'label' => esc_html__('Slider Options', 'tjcore'),
      ]
    );
    $slides_to_show = range(1, 10);
    $slides_to_show = array_combine($slides_to_show, $slides_to_show);
    $this->add_responsive_control(
      'slides_to_show',
      [
        'label'       => esc_html__('Slides to Show', 'tjcore'),
        'type'        => Controls_Manager::SELECT,
        'default'     => '3',
        'required'    => true,
        'options'     => [
          'auto' => esc_html__('Auto', 'tjcore'),
        ] + $slides_to_show,
        'render_type' => 'template',
        'selectors'   => [
          '{{WRAPPER}}' => '--slides-to-show: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'autoplay',
      [
        'label'   => esc_html__('Autoplay', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'default' => 'no',
        'options' => [
          'yes' => esc_html__('Yes', 'tjcore'),
          'no'  => esc_html__('No', 'tjcore'),
        ],
      ]
    );
    $this->add_control(
      'autoplay_delay',
      [
        'label'     => esc_html__('Autoplay delay', 'tjcore'),
        'type'      => Controls_Manager::NUMBER,
        'default'   => 3000,
        'condition' => [
          'autoplay' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'autoplay_interaction',
      [
        'label'     => esc_html__('Autoplay Interaction', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => 'true',
        'options'   => [
          'true'  => esc_html__('Yes', 'tjcore'),
          'false' => esc_html__('No', 'tjcore'),
        ],
        'condition' => [
          'autoplay' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'allow_touch_move',
      [
        'label'     => esc_html__('Allow Touch Move', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'separator' => 'before',
        'default'   => 'false',
        'options'   => [
          'true'  => esc_html__('Yes', 'tjcore'),
          'false' => esc_html__('No', 'tjcore'),
        ],
      ]
    );
    $this->add_control(
      'loop',
      [
        'label'   => esc_html__('Loop', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'default' => 'true',
        'options' => [
          'true'  => esc_html__('Yes', 'tjcore'),
          'false' => esc_html__('No', 'tjcore'),
        ],
      ]
    );
    $this->add_control(
      'speed',
      [
        'label'   => esc_html__('Animation Speed', 'tjcore'),
        'type'    => Controls_Manager::NUMBER,
        'default' => 1000,
      ]
    );
    $this->add_control(
      'space_between',
      [
        'label'       => esc_html__('Space Between', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'default'     => 30,
        'render_type' => 'template',
        'selectors'   => [
          '{{WRAPPER}}' => '--space-between: {{VALUE}}px;',
        ],
      ]
    );
    //slider navigation
    $this->add_control(
      'navigation',
      [
        'label'     => esc_html__('Navigation', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'separator' => 'before',
        'default'   => 'both',
        'options'   => [
          'both'   => esc_html__('Arrows and Dots', 'tjcore'),
          'arrows' => esc_html__('Arrows', 'tjcore'),
          'dots'   => esc_html__('Dots', 'tjcore'),
          'none'   => esc_html__('None', 'tjcore'),
        ],
      ]
    );
    $this->add_control(
      'navigation_previous_icon',
      [
        'label'            => esc_html__('Previous Arrow Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'previous_icon',
        'skin'             => 'inline',
        'label_block'      => false,
        'default' => [
          'value' => 'tji-arrow-left',
          'library' => 'tji',
        ],
        'conditions'       => [
          'relation' => 'or',
          'terms'    => [
            [
              'name'     => 'navigation',
              'operator' => '=',
              'value'    => 'both',
            ],
            [
              'name'     => 'navigation',
              'operator' => '=',
              'value'    => 'arrows',
            ],
          ],
        ],
      ]
    );
    $this->add_control(
      'navigation_next_icon',
      [
        'label'            => esc_html__('Next Arrow Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'next_icon',
        'skin'             => 'inline',
        'label_block'      => false,
        'default' => [
          'value' => 'tji-arrow-right',
          'library' => 'tji',
        ],
        'conditions'       => [
          'relation' => 'or',
          'terms'    => [
            [
              'name'     => 'navigation',
              'operator' => '=',
              'value'    => 'both',
            ],
            [
              'name'     => 'navigation',
              'operator' => '=',
              'value'    => 'arrows',
            ],
          ],
        ],
      ]
    );
    $this->add_control(
      'direction',
      [
        'label'     => esc_html__('Direction', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'separator' => 'before',
        'default'   => 'ltr',
        'options'   => [
          'ltr' => esc_html__('Left', 'tjcore'),
          'rtl' => esc_html__('Right', 'tjcore'),
        ],
      ]
    );
    $this->end_controls_section();

    // animation
    $this->start_controls_section(
      '_slider_animation',
      [
        'label' => esc_html__('Animation', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();


    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Blog Item', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .blog-el-item, {{WRAPPER}} .blog-style-3 .blog-content',
      ]
    );
    $this->add_group_control(
      Group_Control_Border::get_type(),
      [
        'name' => 'wrapper_border',
        'selector' => '{{WRAPPER}} .blog-el-item',
      ]
    );
    $this->add_responsive_control(
      'tj_section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .blog-el-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_section_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .blog-el-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // Date
    $this->start_controls_section(
      '_section_style_date',
      [
        'label' => esc_html__('Date', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['2', '4']
        ]
      ]
    );
    $this->add_control(
      'date_option_01',
      [
        'label' => esc_html__('Day', 'tjcore'),
        'type' => Controls_Manager::HEADING,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_date_day_typography',
        'selector' => '{{WRAPPER}} .blog-date .date, {{WRAPPER}} .blog-date .day',
      ]
    );
    $this->add_control(
      'tj_date_day_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-date .date' => 'color: {{VALUE}}',
          '{{WRAPPER}} .blog-date .day' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'date_option_02',
      [
        'label' => esc_html__('Month', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_date_month_typography',
        'selector' => '{{WRAPPER}} .blog-date .month',
      ]
    );
    $this->add_control(
      'tj_date_month_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-date .month' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_meta_date_bg_color',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-date' => 'background-color: {{VALUE}}',
        ],
        'separator' => 'before',
      ]
    );
    $this->add_responsive_control(
      'tj_meta_date_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .blog-date' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // Category
    $this->start_controls_section(
      '_section_style_category',
      [
        'label' => esc_html__('Category', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_category_typography',
        'selector' => '{{WRAPPER}} .blog-el-category',
      ]
    );
    $this->start_controls_tabs('category_style_tabs');
    $this->start_controls_tab(
      'category_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'category_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-el-category' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'category_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-el-category' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'category_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'category_text_hcolor',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-el-category:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'category_bg_hcolor',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-el-category:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'category_border_hover_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-el-category:hover' => 'border-color: {{VALUE}}',
        ],
        'condition' => [
          'category_border_style!' => ['', 'none'],
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_control(
      'category_border_style',
      [
        'label'     => esc_html__('Border Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''       => esc_html__('Default', 'tjcore'),
          'none'   => esc_html__('None', 'tjcore'),
          'solid'  => esc_html__('Solid', 'tjcore'),
          'dashed' => esc_html__('Dashed', 'tjcore'),
          'dotted' => esc_html__('Dotted', 'tjcore'),
          'double' => esc_html__('Double', 'tjcore'),
        ],
        'selectors' => [
          '{{WRAPPER}} .blog-el-category' => 'border-style: {{VALUE}};',
        ],
        'separator' => 'before',
      ]
    );
    $this->add_responsive_control(
      'category_border_width',
      [
        'label'      => esc_html__('Border Width', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .blog-el-category' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition'  => [
          'category_border_style!' => ['', 'none'],
        ],
      ]
    );
    $this->add_control(
      'category_border_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-el-category' => 'border-color: {{VALUE}}',
        ],
        'condition' => [
          'category_border_style!' => ['', 'none'],
        ],
      ]
    );
    $this->add_responsive_control(
      'category_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .blog-el-category' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'category_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .blog-el-category'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->end_controls_section();

    // meta
    $this->start_controls_section(
      '_section_style_comment',
      [
        'label' => esc_html__('Meta', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_comment_typography',
        'selector' => '{{WRAPPER}} .blog-el-comment',
      ]
    );
    $this->add_control(
      'tj_comment_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-el-comment' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_comment_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .blog-el-comment' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_comment_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .blog-el-comment' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .blog-el-item .blog-content .blog-el-title',
      ]
    );
    $this->start_controls_tabs('title_style_tabs');
    $this->start_controls_tab(
      'title_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-el-item .blog-content .blog-el-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'title_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_title_hcolor',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-el-item .blog-content .blog-el-title a:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .blog-el-item .blog-content .blog-el-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before'
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .blog-el-item .blog-content .blog-el-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // content
    $this->start_controls_section(
      '_style_content',
      [
        'label'     => esc_html__('Content', 'tjcore'),
        'tab'       => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_content_typography',
        'selector' => '{{WRAPPER}} .blog-el-item .blog-content .desc',
      ]
    );
    $this->add_control(
      'tj_content_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-el-item .blog-content .desc' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_content_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .blog-el-item .blog-content .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_content_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .blog-el-item .blog-content .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // button
    $this->start_controls_section(
      '_style_button',
      [
        'label'     => esc_html__('Button', 'tjcore'),
        'tab'       => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['4']
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_button_typography',
        'selector' => '{{WRAPPER}} .blog-el-item .text-btn',
      ]
    );
    $this->start_controls_tabs('button_style_tabs');
    $this->start_controls_tab(
      'button_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_button_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-el-item .text-btn' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'button_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_button_hover_color',
      [
        'label'     => __('Text Hover Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-el-item .text-btn:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_button_linecolor',
      [
        'label'     => __('Line Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-el-item .text-btn::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();

    // Icon Button
    $this->start_controls_section(
      '_icon_btn_style',
      [
        'label' => __('Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style' => ['4'],
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'btn_typography',
        'selector' => '{{WRAPPER}} .blog-btn .btn-text',
      ]
    );
    $this->start_controls_tabs('btn_style_tabs');
    $this->start_controls_tab(
      'btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-btn .btn-text' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn-icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-btn .btn-icon i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn-icon_bgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-btn .btn-icon' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_hcolor',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-btn:hover .btn-text' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn-icon_hcolor',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-btn:hover .btn-icon i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn-icon_hbgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-btn:hover .btn-icon' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();

    // navigation
    $this->start_controls_section(
      'section_nav_style',
      [
        'label' => esc_html__('Navigation', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->start_controls_tabs('navs_tabs');
    $this->start_controls_tab(
      'nav_style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj_slider_nav i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'icon_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-next' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .slider-prev' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'icon_border_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-next' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .slider-prev' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'nav_style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'icon_hover_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj_slider_nav:hover i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'icon_bg_hover_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-next:hover' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .slider-prev:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'icon_border_hcolor',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-next:hover' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .slider-prev:hover' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();

    // dots
    $this->start_controls_section(
      'section_dots_style',
      [
        'label' => esc_html__('Dots', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->start_controls_tabs('dots_tabs');
    $this->start_controls_tab(
      '_dots_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'dot_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .swiper-pagination-bullet::after' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'dot_hover_tab',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );
    $this->add_control(
      'dot_bg_hover_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .swiper-pagination-bullet.swiper-pagination-bullet-active::after' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'dot_border_hcolor',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .swiper-pagination-bullet.swiper-pagination-bullet-active::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();


    $this->add_responsive_control(
      'tj_dots_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj_slider_pagination' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before'
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();
    extract($settings);
    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/blog-carousel/style-' . $tj_design_style . '.php';
?>

<?php
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Blog_Carousel());
