<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Latest Posts.
 */
class TJ_Blog_Grid extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-blog-grid';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Blog Grid', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-posts-grid tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'blog-post',
      'posts',
      'tj post',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {

    // Post Query
    $this->start_controls_section(
      'tj_post_query',
      [
        'label' => esc_html__('Post Query', 'tjcore'),
      ]
    );

    $post_type = 'post';
    $taxonomy  = 'category';

    $this->add_control(
      'posts_per_page',
      [
        'label'       => esc_html__('Posts Per Page', 'tjcore'),
        'description' => esc_html__('Leave blank or enter -1 for all.', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '3',
      ]
    );
    $this->add_control(
      'category',
      [
        'label'       => esc_html__('Include Categories', 'tjcore'),
        'description' => esc_html__('Select a category to include or leave blank for all.', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'multiple'    => true,
        'options'     => tj_get_categories($taxonomy),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'exclude_category',
      [
        'label'       => esc_html__('Exclude Categories', 'tjcore'),
        'description' => esc_html__('Select a category to exclude', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'multiple'    => true,
        'options'     => tj_get_categories($taxonomy),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'post__in',
      [
        'label'       => esc_html__('Include Posts', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'options'     => tj_get_all_types_post($post_type),
        'multiple'    => true,
        'label_block' => true,
      ]
    );
    $this->add_control(
      'post__not_in',
      [
        'label'       => esc_html__('Exclude Posts', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'options'     => tj_get_all_types_post($post_type),
        'multiple'    => true,
        'label_block' => true,
      ]
    );
    $this->add_control(
      'offset',
      [
        'label'   => esc_html__('Offset', 'tjcore'),
        'type'    => Controls_Manager::NUMBER,
        'default' => '0',
      ]
    );
    $this->add_control(
      'orderby',
      [
        'label'   => esc_html__('Order By', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => array(
          'ID'            => 'Post ID',
          'author'        => 'Post Author',
          'title'         => 'Title',
          'date'          => 'Date',
          'modified'      => 'Last Modified Date',
          'parent'        => 'Parent Id',
          'rand'          => 'Random',
          'comment_count' => 'Comment Count',
          'menu_order'    => 'Menu Order',
        ),
        'default' => 'date',
      ]
    );
    $this->add_control(
      'order',
      [
        'label'   => esc_html__('Order', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          'asc'  => esc_html__('Ascending', 'tjcore'),
          'desc' => esc_html__('Descending', 'tjcore'),
        ],
        'default' => 'desc',
      ]
    );
    $this->add_control(
      'ignore_sticky_posts',
      [
        'label'        => esc_html__('Ignore Sticky Posts', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );
    $this->add_control(
      'tj_post_title_word',
      [
        'label'       => esc_html__('Title Word Count', 'tjcore'),
        'description' => esc_html__('Set how many word you want to display!', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '6',
      ]
    );
    $this->add_control(
      'tj_post_content',
      [
        'label'        => __('Content', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Show', 'tjcore'),
        'label_off'    => __('Hide', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );
    $this->add_control(
      'tj_post_content_limit',
      [
        'label'       => __('Content Limit', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'label_block' => true,
        'default'     => '18',
        'dynamic'     => [
          'active' => true,
        ],
        'condition'   => [
          'tj_post_content'  => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_btn',
      [
        'label'   => esc_html__('Button Text', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('Read more', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_post_button_icon',
      [
        'label' => esc_html__('Button Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'fa4compatibility' => 'post_button_icon',
        'default' => [
          'value' => 'tji-arrow-right',
          'library' => 'tji',
        ],
      ]
    );
    $this->end_controls_section();

    // post meta
    $this->start_controls_section(
      'tj_post_meta',
      [
        'label' => esc_html__('Post Meta', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_post_category',
      [
        'label'        => esc_html__('Post Category', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );
    $this->add_control(
      'tj_post_date',
      [
        'label'        => esc_html__('Post Date', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );
    $this->add_control(
      'tj_post_comment',
      [
        'label'        => esc_html__('Post Comment', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );
    $this->add_control(
      'tj_pagination',
      [
        'label' => esc_html__('Enable Pagination?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
      ]
    );
    $this->end_controls_section();


    $this->start_controls_section(
      'section_column_settings',
      [
        'label' => esc_html__('Post Column Settings', 'tjcore'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'show_sidebar',
      [
        'label' => __('Show Sidebar', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Yes', 'tjcore'),
        'label_off' => __('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '',
      ]
    );

    $this->add_control(
      'left_sidebar',
      [
        'label' => esc_html__('Sidebar', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          '' => esc_html__('Right Sidebar', 'tjcore'),
          'flex-row-reverse' => esc_html__('Left Sidebar', 'tjcore'),
        ],
        'default' => '',
        'style_transfer' => true,
        'condition' => [
          'show_sidebar' => 'yes',
        ]
      ]
    );

    $this->add_control(
      'desktop_column',
      [
        'label' => esc_html__('Columns for Desktop', 'tjcore'),
        'description' => esc_html__('Screen width equal to or greater than 1200px', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          12 => esc_html__('1 Columns', 'tjcore'),
          6 => esc_html__('2 Columns', 'tjcore'),
          4 => esc_html__('3 Columns', 'tjcore'),
          3 => esc_html__('4 Columns', 'tjcore'),
          2 => esc_html__('6 Columns', 'tjcore'),
        ],
        'separator' => 'before',
        'default' => '6',
        'style_transfer' => true,
      ]
    );

    $this->add_control(
      'laptop_column',
      [
        'label' => esc_html__('Columns for Laptop', 'tjcore'),
        'description' => esc_html__('Screen width equal to or greater than 992px', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          12 => esc_html__('1 Columns', 'tjcore'),
          6 => esc_html__('2 Columns', 'tjcore'),
          4 => esc_html__('3 Columns', 'tjcore'),
          3 => esc_html__('4 Columns', 'tjcore'),
          2 => esc_html__('6 Columns', 'tjcore'),
        ],
        'separator' => 'before',
        'default' => '6',
        'style_transfer' => true,
      ]
    );

    $this->add_control(
      'tablet_column',
      [
        'label' => esc_html__('Columns for Tablet', 'tjcore'),
        'description' => esc_html__('Screen width equal to or greater than 768px', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          12 => esc_html__('1 Columns', 'tjcore'),
          6 => esc_html__('2 Columns', 'tjcore'),
          4 => esc_html__('3 Columns', 'tjcore'),
          3 => esc_html__('4 Columns', 'tjcore'),
          2 => esc_html__('6 Columns', 'tjcore'),
        ],
        'separator' => 'before',
        'default' => '6',
        'style_transfer' => true,
      ]
    );
    $this->add_control(
      'mobile_column',
      [
        'label' => esc_html__('Columns for Mobile', 'tjcore'),
        'description' => esc_html__('Screen width less than 768px', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          12 => esc_html__('1 Columns', 'tjcore'),
          6 => esc_html__('2 Columns', 'tjcore'),
          4 => esc_html__('3 Columns', 'tjcore'),
          3 => esc_html__('4 Columns', 'tjcore'),
          2 => esc_html__('6 Columns', 'tjcore'),
        ],
        'separator' => 'before',
        'default' => '12',
        'style_transfer' => true,
      ]
    );

    $this->add_control(
      'nav_align',
      [
        'label' => esc_html__('Pagination Align', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'justify-content-start' => esc_html__('Left', 'tjcore'),
          'justify-content-center' => esc_html__('Center', 'tjcore'),
          'justify-content-end' => esc_html__('Right', 'tjcore'),
        ],
        'separator' => 'before',
        'default' => '',
        'style_transfer' => true,
      ]
    );

    $this->end_controls_section();


    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Wrapper', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .blog-el-item',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'wrapper_border',
        'selector' => '{{WRAPPER}} .blog-el-item',
      ]
    );
    $this->add_responsive_control(
      'tj_section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .blog-el-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_section_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .blog-el-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // meta
    $this->start_controls_section(
      '_section_style_meta',
      [
        'label' => esc_html__('Meta', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_meta_typography',
        'selector' => '{{WRAPPER}} .blog-el-meta ul li',
      ]
    );
    $this->add_control(
      'tj_meta_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-el-meta ul li' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_meta_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .blog-el-meta ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_meta_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .blog-el-meta ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .blog-el-item .blog-content .blog-el-title',
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-el-item .blog-content .blog-el-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_title_hcolor',
      [
        'label'     => __('Hover Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-el-item .blog-content .blog-el-title:hover a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .blog-el-item .blog-content .blog-el-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .blog-el-item .blog-content .blog-el-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // content
    $this->start_controls_section(
      '_style_content',
      [
        'label'     => esc_html__('Content', 'tjcore'),
        'tab'       => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_content_typography',
        'selector' => '{{WRAPPER}} .blog-el-item .blog-content .desc',
      ]
    );
    $this->add_control(
      'tj_content_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-el-item .blog-content .desc' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_content_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .blog-el-item .blog-content .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_content_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .blog-el-item .blog-content .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // button
    $this->start_controls_section(
      '_style_button',
      [
        'label'     => esc_html__('Button', 'tjcore'),
        'tab'       => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_button_typography',
        'selector' => '{{WRAPPER}} .blog-el-item .text-btn',
      ]
    );
    $this->add_control(
      'tj_button_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-el-item .text-btn' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_button_hover_color',
      [
        'label'     => __('Text Hover Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-el-item .text-btn:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_button_linecolor',
      [
        'label'     => __('Line Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-el-item .text-btn::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();

    // widget 
    $this->start_controls_section(
      '_section_style_widget',
      [
        'label' => esc_html__('Sidebar widget Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_widget_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .tj-sidebar-widget',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'widget_border',
        'selector' => '{{WRAPPER}} .tj-sidebar-widget',
      ]
    );

    $this->add_responsive_control(
      'tj_widget_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sidebar-widget' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'tj_widget_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sidebar-widget' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'tj_widget_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sidebar-widget' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_widgettitle',
      [
        'label' => esc_html__('Widget Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_wtitle_typography',
        'selector' => '{{WRAPPER}} .tj-sidebar-widget-title',
      ]
    );
    $this->add_control(
      'tj_wtitle_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-sidebar-widget-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_wtitle_linecolor',
      [
        'label'     => __('Line Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-sidebar-widget-title::before, .tj-sidebar-widget-title::after' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_wtitle_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sidebar-widget-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before'
      ]
    );
    $this->add_responsive_control(
      'tj_wtitle_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sidebar-widget-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      '_section_style_service_item',
      [
        'label' => esc_html__('Widget Category', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->start_controls_tabs('service_style_tabs');
    $this->start_controls_tab(
      'service_style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_service_background',
        'exclude' => ['image'],
        'selector' => '{{WRAPPER}} .tj_widget_categories ul li a',
      ]
    );
    $this->add_control(
      'tj_service_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj_widget_categories ul li a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'service_style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_service_hover_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .tj_widget_categories ul li a:hover',
      ]
    );
    $this->add_control(
      'tj_service_hover_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj_widget_categories ul li a:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'tj_service_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj_widget_categories ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_service_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj_widget_categories ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // tag
    $this->start_controls_section(
      'style_stext_btn',
      [
        'label' => esc_html__('Tag', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_stext_btn_typography',
        'selector' => '{{WRAPPER}} .tagcloud a',
      ]
    );
    $this->start_controls_tabs('stext_btn_style_tabs');
    $this->start_controls_tab(
      'stext_btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_stext_btn_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tagcloud a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_stext_btn_bgcolor',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tagcloud a' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_stext_btn_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_stext_btn_hcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tagcloud a:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_stext_btn_hbgcolor',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tagcloud a:hover' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_stext_btn_hborder_color',
      [
        'label'     => __('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tagcloud a:hover' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();
    extract($settings);
    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/blog-grid/style-' . $tj_design_style . '.php';
?>

<?php
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Blog_Grid());
