<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) {
  exit;
}

/**
 * Elementor widget for Button.
 */
class Tj_Button extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-button';
  }

  // widget title.
  public function get_title()
  {
    return esc_html__('TJ Button', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-button tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'button',
      'btn',
      'tj button',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {
    $this->start_controls_section(
      '__tj_button',
      [
        'label' => esc_html__('Button', 'tjcore'),
      ]
    );

    $this->add_control(
      'tj_btn_style',
      [
        'label'     => esc_html__('Button Style', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'options'   => [
          '1' => esc_html__('Style 01', 'tjcore'),
          '2' => esc_html__('Style 02', 'tjcore'),
          '3' => esc_html__('Style 03', 'tjcore'),
          '4' => esc_html__('Style 04', 'tjcore'),
          '5' => esc_html__('Style 05', 'tjcore'),
        ],
        'default'   => '1',
        'separator' => 'after',
      ]
    );

    $this->add_control(
      'tj_btn_text',
      [
        'label'   => esc_html__('Text', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('Click here', 'tjcore'),
        'dynamic' => [
          'active' => true,
        ],
        'condition' => [
          'tj_btn_style!' => ['5'],
        ],
      ]
    );
    $this->add_control(
      'tj_btn_link_type',
      [
        'label'     => esc_html__('Link Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'options'   => [
          '1' => esc_html__('Custom Link', 'tjcore'),
          '2' => esc_html__('Internal Page', 'tjcore'),
        ],
        'default'   => '1',
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'tj_btn_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'condition'   => [
          'tj_btn_link_type' => '1',
        ],
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_btn_page_link',
      [
        'label'       => esc_html__('Select Page', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'tj_btn_link_type' => '2',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_align',
      [
        'label'        => esc_html__('Alignment', 'tjcore'),
        'type'         => Controls_Manager::CHOOSE,
        'options'      => [
          'start'   => [
            'title' => esc_html__('Left', 'tjcore'),
            'icon'  => 'eicon-text-align-left',
          ],
          'center' => [
            'title' => esc_html__('Center', 'tjcore'),
            'icon'  => 'eicon-text-align-center',
          ],
          'end'  => [
            'title' => esc_html__('Right', 'tjcore'),
            'icon'  => 'eicon-text-align-right',
          ],
        ],
        'default'      => 'center',
        'prefix_class' => 'tj_el_button elementor%s-align-',
      ]
    );
    $this->add_control(
      'tj_btn_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'btn_icon',
        'default'          => [
          'value'   => 'tji-arrow-right',
          'library' => 'tji',
        ],
        'skin'             => 'inline',
        'label_block'      => false,
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_heading_header_btn',
      [
        'label' => __('Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'btn_typography',
        'selector' => '{{WRAPPER}} .tj-primary-btn, {{WRAPPER}} .icon-btn, .tj_btn_wrapper .text-button .btn_text, {{WRAPPER}} .video-btn-wrap .video-btn .video-text',
      ]
    );
    $this->start_controls_tabs('btn_style_tabs');
    $this->start_controls_tab(
      'btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn .btn_text' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj_btn_wrapper .text-button .btn_text' => 'color: {{VALUE}}',
          '{{WRAPPER}} .video-btn-wrap .video-btn .video-text' => 'color: {{VALUE}}',
          '{{WRAPPER}} .video-btn-wrap .video-btn .video-text:after' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .icon-btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn .btn_icon' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj_btn_wrapper .text-button .btn_icon' => 'color: {{VALUE}}',
          '{{WRAPPER}} .video-btn-wrap .video-btn .play-btn' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_bgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .icon-btn' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn .btn_inner::before' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .tj_btn_wrapper .text-button .btn_icon' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .video-btn-wrap .video-btn .play-btn' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .tj_btn_wrapper .text-button .btn_text' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .video-btn-wrap .video-btn' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_hcolor',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn:hover .btn_text' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj_btn_wrapper .text-button:hover .btn_text' => 'color: {{VALUE}}',
          '{{WRAPPER}} .video-btn-wrap .video-btn:hover .video-text' => 'color: {{VALUE}}',
          '{{WRAPPER}} .video-btn-wrap .video-btn:hover .video-text::after' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_hcolor',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .icon-btn:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn:hover .btn_icon' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj_btn_wrapper .text-button:hover .btn_icon' => 'color: {{VALUE}}',
          '{{WRAPPER}} .video-btn-wrap .video-btn:hover .play-btn' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_hbgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .icon-btn:hover' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn:hover .btn_inner::before' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .tj_btn_wrapper .text-button:hover .btn_icon' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .video-btn-wrap .video-btn:hover .play-btn' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_bg_hcolor',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .tj_btn_wrapper .text-button:hover' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .video-btn-wrap .video-btn:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_border_hover_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj_btn_wrapper .tj-primary-btn:hover' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .tj_btn_wrapper .text-button:hover' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .video-btn-wrap .video-btn:hover' => 'border-color: {{VALUE}}',
        ],
        'condition' => [
          'btn_border_style!' => ['', 'none'],
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_control(
      'btn_border_style',
      [
        'label'     => esc_html__('Border Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''       => esc_html__('Default', 'tjcore'),
          'none'   => esc_html__('None', 'tjcore'),
          'solid'  => esc_html__('Solid', 'tjcore'),
          'dashed' => esc_html__('Dashed', 'tjcore'),
          'dotted' => esc_html__('Dotted', 'tjcore'),
          'double' => esc_html__('Double', 'tjcore'),
        ],
        'selectors' => [
          '{{WRAPPER}} .icon-btn' => 'border-style: {{VALUE}};',
          '{{WRAPPER}} .tj_btn_wrapper .tj-primary-btn' => 'border-style: {{VALUE}};',
          '{{WRAPPER}} .tj_btn_wrapper .text-button' => 'border-style: {{VALUE}};',
          '{{WRAPPER}} .video-btn-wrap .video-btn' => 'border-style: {{VALUE}};',
        ],
        'separator' => 'before',
      ]
    );
    $this->add_responsive_control(
      'btn_border_width',
      [
        'label'      => esc_html__('Border Width', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .icon-btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj_btn_wrapper .tj-primary-btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj_btn_wrapper .text-button' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .video-btn-wrap .video-btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition'  => [
          'btn_border_style!' => ['', 'none'],
        ],
      ]
    );
    $this->add_control(
      'btn_border_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .icon-btn' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .tj_btn_wrapper .tj-primary-btn' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .tj_btn_wrapper .text-button' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .video-btn-wrap .video-btn' => 'border-color: {{VALUE}}',
        ],
        'condition' => [
          'btn_border_style!' => ['', 'none'],
        ],
      ]
    );
    $this->add_responsive_control(
      'btn_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .icon-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj_btn_wrapper .tj-primary-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj_btn_wrapper .text-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .video-btn-wrap .video-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'btn_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj_btn_wrapper .tj-primary-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj_btn_wrapper .text-button'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .video-btn-wrap .video-btn'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .icon-btn'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->add_responsive_control(
      'btn_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj_btn_wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  protected function render()
  {
    $settings = $this->get_settings_for_display();

    $tjBtnText     = $settings['tj_btn_text'];
    $tjBtnLinkType = $settings['tj_btn_link_type'];
    $tjBtnLink     = $settings['tj_btn_link'];
    $tjBtnPageLink = $settings['tj_btn_page_link'];

    // animation
    $tjAnimation      = $settings['tj_animation'] ?? '';
    $tjAnimationName  = $settings['tj_animation_name'] ?? '';
    $tjAnimationDelay = $settings['tj_animation_delay'] ?? '';
    if ("4" == $settings['tj_btn_style']) {
      $buttonClass = "video-btn vbox-item";
    } elseif ("5" == $settings['tj_btn_style']) {
      $buttonClass = "icon-btn h10-footer-cta-btn";
    } elseif ("3" == $settings['tj_btn_style']) {
      $buttonClass = "call-btn-style-2 text-button";
    } elseif ("2" == $settings['tj_btn_style']) {
      $buttonClass =  "tj-primary-btn white-btn";
    } else {
      $buttonClass =  "tj-primary-btn";
    }

    //$buttonClass = ("2" == $settings['tj_btn_style']) ? "tj-primary-btn  white-btn" : "tj-primary-btn";
    if (!empty($tjAnimation)) {
      $buttonClass .= " wow $tjAnimationName";
      $this->add_render_attribute('tj-button-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
    }

    if ('2' == $tjBtnLinkType) {
      $this->add_render_attribute('tj-button-arg', 'href', get_permalink($tjBtnPageLink));
      $this->add_render_attribute('tj-button-arg', 'target', '_self');
    } else {
      if (!empty($tjBtnLink['url'])) {
        $this->add_link_attributes('tj-button-arg', $tjBtnLink);
      }
    }
    $this->add_render_attribute('tj-button-arg', 'class', $buttonClass);

?>
    <div class="tj_btn_wrapper">

      <?php if ("4" == $settings['tj_btn_style']): ?>
        <div class="video-btn-wrap style-2">
          <a <?php echo $this->get_render_attribute_string('tj-button-arg'); ?>>
            <?php if (!empty($settings['tj_btn_icon']['value'])) : ?>
              <span class="play-btn">
                <?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?>
              </span>
            <?php endif; ?>
            <span class="video-text"> <?php echo esc_html__($tjBtnText, 'tjcore'); ?></span>
          </a>
        </div>

      <?php elseif ("5" == $settings['tj_btn_style']): ?>
        <a <?php echo $this->get_render_attribute_string('tj-button-arg'); ?>>
          <?php if (!empty($settings['tj_btn_icon']['value'])) : ?>
            <?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?>
          <?php endif; ?>
        </a>

      <?php elseif ("3" == $settings['tj_btn_style']): ?>
        <a <?php echo $this->get_render_attribute_string('tj-button-arg'); ?>>
          <?php if (!empty($settings['tj_btn_icon']['value'])) : ?>
            <span class="btn_icon">
              <?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?>
            </span>
          <?php endif; ?>
          <span class="btn_text">
            <?php echo esc_html__($tjBtnText, 'tjcore'); ?>
          </span>
        </a>
      <?php elseif ("2" == $settings['tj_btn_style']): ?>
        <a <?php echo $this->get_render_attribute_string('tj-button-arg'); ?>>
          <span class="btn_inner">
            <?php if (!empty($settings['tj_btn_icon']['value'])) : ?>
              <span class="btn_icon">
                <span>
                  <?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?>
                  <?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?>
                </span>
              </span>
            <?php endif; ?>
            <span class="btn_text">
              <span>
                <?php echo esc_html__($tjBtnText, 'tjcore'); ?>
              </span>
            </span>
          </span>
        </a>

      <?php else: ?>

        <a <?php echo $this->get_render_attribute_string('tj-button-arg'); ?>>
          <span class="btn_inner">
            <?php if (!empty($settings['tj_btn_icon']['value'])) : ?>
              <span class="btn_icon">
                <span>
                  <?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?>
                  <?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?>
                </span>
              </span>
            <?php endif; ?>
            <span class="btn_text">
              <span>
                <?php echo esc_html__($tjBtnText, 'tjcore'); ?>
              </span>
            </span>
          </span>
        </a>
      <?php endif; ?>
    </div>

<?php
  }
  protected function content_template() {}
}

$widgets_manager->register(new Tj_Button());
