<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Repeater;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Form.
 */
class TJ_Career_Form extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-career-form';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Career Form', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-form-horizontal tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'form',
      'form',
      'tj contact',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  // Get Contact Form
  public function get_tj_contact_form()
  {
    if (!class_exists('WPCF7')) {
      return;
    }
    $tj_cfa     = array();
    $tj_cf_args = array('posts_per_page' => -1, 'post_type' => 'wpcf7_contact_form');
    $tj_forms   = get_posts($tj_cf_args);
    $tj_cfa     = ['0' => esc_html__('Select Form', 'tjcore')];
    if ($tj_forms) {
      foreach ($tj_forms as $tj_form) {
        $tj_cfa[$tj_form->ID] = $tj_form->post_title;
      }
    } else {
      $tj_cfa[esc_html__('No contact form found', 'tjcore')] = 0;
    }
    return $tj_cfa;
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {

    $this->start_controls_section(
      'tj_career_form',
      [
        'label' => esc_html__('TJ Form', 'tjcore'),
      ]
    );

    $this->add_control(
      'tj_title',
      [
        'label'       => esc_html__('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Apply online', 'tjcore'),
        'label_block' => true,
      ]
    );

    $this->add_control(
      'tj_select_form',
      [
        'label'     => esc_html__('Select Form', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'separator' => 'before',
        'options'   => $this->get_tj_contact_form(),
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Form Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Wrapper Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .tj-sidebar-widget',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'wrapper_border',
        'selector' => '{{WRAPPER}} .tj-sidebar-widget',
      ]
    );

    $this->add_responsive_control(
      'tj_section_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sidebar-widget' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'tj_section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sidebar-widget' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'tj_section_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sidebar-widget' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_title',
      [
        'label' => esc_html__('Widget Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .tj-sidebar-widget-title',
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-sidebar-widget-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_title_linecolor',
      [
        'label'     => __('Line Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-sidebar-widget-title::before, .tj-sidebar-widget-title::after' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sidebar-widget-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before'
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sidebar-widget-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();


    // From Style
    $this->start_controls_section(
      'section_tab_area',
      [
        'label' => esc_html__('Form Field Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'cf_field_typo',
        'label'    => esc_html__('Field Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-form .form-input select, {{WRAPPER}} .tj-form .form-input .nice-select, {{WRAPPER}} .tj-form .form-input input:not([type="submit"]):not([type="radio"]):not([type="checkbox"]), {{WRAPPER}} .tj-form .form-input textarea, {{WRAPPER}} .wpcf7-list-item-label',
      ]
    );
    $this->add_responsive_control(
      'cf_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-form .form-input input:not([type="submit"]):not([type="radio"]):not([type="checkbox"])' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input select'                                                                => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input .nice-select'                                                          => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input textarea'                                                              => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input .wpcf7-list-item-label'                                                => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_placeholder_color',
      [
        'label'     => esc_html__('Placeholder Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-form .form-input textarea::-moz-placeholder'                                            => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input .nice-select::-moz-placeholder'                                        => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input input::-moz-placeholder'                                               => 'color: {{VALUE}}',

          '{{WRAPPER}} .tj-form .form-input textarea::-ms-input-placeholder'                                       => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input .nice-select::-ms-input-placeholder'                                   => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input input::-ms-input-placeholder'                                          => 'color: {{VALUE}}',

          '{{WRAPPER}} .tj-form .form-input textarea::-webkit-input-placeholder'                                   => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input .nice-select::-webkit-input-placeholder'                               => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input input::-webkit-input-placeholder'                                      => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-form .form-input select'                                                                => 'background: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input .nice-select'                                                          => 'background: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input .form-input input:not([type="submit"]):not([type="radio"]):not([type="checkbox"])' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input .form-input textarea'                                                              => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Border::get_type(),
      [
        'name'     => 'cf_borders',
        'label'    => esc_html__('Field Border', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-form .form-input select, {{WRAPPER}} .tj-form .form-input .nice-select, {{WRAPPER}} .tj-form .form-input input:not([type="submit"]):not([type="range"]):not([type="radio"]):not([type="checkbox"]), {{WRAPPER}} .tj-form .form-input textarea',
      ]
    );
    $this->add_control(
      'cf_focus_border_color',
      [
        'label'     => esc_html__('Focus Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-form .form-input select:focus' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input .nice-select:focus' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input input:not([type="submit"]):not([type="range"]):not([type="radio"]):not([type="checkbox"]):focus' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input textarea:focus' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_field_radius',
      [
        'label'      => esc_html__('Field Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-form .form-input select'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input .nice-select' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input input:not([type="submit"]):not([type="radio"]):not([type="checkbox"])' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input textarea' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name'     => 'cf_field_shadow',
        'label'    => esc_html__('Field Shadow', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-form .form-input select, {{WRAPPER}} .tj-form .form-input .nice-select, {{WRAPPER}} .tj-form .form-input input:not([type="submit"]):not([type="radio"]):not([type="checkbox"]), {{WRAPPER}} .tj-form .form-input textarea',
      ]
    );
    $this->add_responsive_control(
      'cf_field_padding',
      [
        'label'      => esc_html__('Field Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-form .form-input select' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input .nice-select' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input input:not([type="submit"]):not([type="radio"]):not([type="checkbox"])' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_field_margin',
      [
        'label'      => esc_html__('Field Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-form .form-input select'   => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input .nice-select' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input input:not([type="submit"]):not([type="radio"]):not([type="checkbox"])' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_filed_height',
      [
        'label'      => esc_html__('Input/Select Height', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 8,
            'max'  => 100,
            'step' => 1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .tj-form .form-input input[type="text"]'   => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input input[type="email"]'  => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input input[type="url"]'    => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input input[type="tel"]'    => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input input[type="number"]' => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input input[type="date"]'   => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input select'               => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input .nice-select'         => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_message_height',
      [
        'label'      => esc_html__('Textarea Height', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 8,
            'max'  => 500,
            'step' => 1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .tj-form .form-input textarea' => 'height: {{SIZE}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->add_responsive_control(
      'text_area_box_radius',
      [
        'label'      => esc_html__('Textarea Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-form .form-input textarea' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'cf_textarea_typo',
        'label'    => esc_html__('Textarea Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-form .form-input textarea',
      ]
    );
    $this->add_responsive_control(
      'cf_message_padding',
      [
        'label'      => esc_html__('Textarea Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-form .form-input textarea' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_message_margin',
      [
        'label'      => esc_html__('Textarea Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-form .form-input textarea' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();


    //Button
    $this->start_controls_section(
      '_heading_hero_btn_style',
      [
        'label' => __('Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'btn_typography',
        'selector' => '{{WRAPPER}} .tj-primary-btn',
      ]
    );
    $this->start_controls_tabs('btn_style_tabs');
    $this->start_controls_tab(
      'btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn .btn_text' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn .btn_icon' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_bgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn .btn_inner::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_hcolor',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn:hover .btn_text' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_hcolor',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover .btn_icon' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_hbgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover .btn_inner::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_bg_hcolor',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();
    extract($settings);

    $tj_title = $settings['tj_title'] ?? "";
    $tjSelectForm   = $settings['tj_select_form'] ?? "";

    // animation
    $tjAnimation   = $settings['tj_animation'] ?? '';
    $tjAnimationName   = $settings['tj_animation_name'] ?? '';
    $tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

    if (!empty($tjAnimation)) {
      $formClass = "tj-sidebar-widget wow $tjAnimationName";
      $this->add_render_attribute('tj-form-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
    } else {
      $formClass = "tj-sidebar-widget";
    }
    $this->add_render_attribute('tj-form-arg', 'class', $formClass);

?>

    <div class="tj-careers-details">
      <div <?php echo $this->get_render_attribute_string('tj-form-arg'); ?>>
        <?php if (!empty($tj_title)): ?>
          <h5 class="tj-sidebar-widget-title"><?php echo esc_html($tj_title); ?></h5>
        <?php endif; ?>

        <div class="tj-careers-form tj-form">
          <?php if (!empty($tjSelectForm)) : ?>
            <?php echo do_shortcode('[contact-form-7  id="' . $tjSelectForm . '"]'); ?>
          <?php
          else :
            printf("%s", esc_html_e("Select Contact Form", 'tjcore'));
          endif; ?>
        </div>
      </div>
    </div>

<?php
  }
}
$widgets_manager->register(new TJ_Career_Form());
