<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Careers.
 */
class TJ_Careers extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-careers';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Careers', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-document-file tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'career',
      'careers',
      'tj careers',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {


    // layout Panel
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Career Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // _tj_icon_box_content
    $this->start_controls_section(
      'tj_careers_content',
      [
        'label' => esc_html__('Content', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_career_icon',
      [
        'label'         => esc_html__('Icon', 'tjcore'),
        'type'          => Controls_Manager::ICONS,
        'fa4compatibility' => 'tj_icon',
        'default'          => [
          'value' => 'tji-strategy',
          'library' => 'tj',
        ],
      ]
    );
    $this->add_control(
      'tj_career_meta',
      [
        'label'       => esc_html__('Meta', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => esc_html__('', 'tjcore'),
        'row'         => '2',
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_career_title',
      [
        'label'       => esc_html__('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Career Title', 'tjcore'),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_career_salary',
      [
        'label'       => esc_html__('Salary', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => esc_html__('', 'tjcore'),
        'row'         => '2',
        'label_block' => true,
        'condition' => [
          'tj_design_style!' => ['2'],
        ],
      ]
    );
    $this->add_control(
      'tj_career_location',
      [
        'label'       => esc_html__('Location', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('London,UK', 'tjcore'),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_career_btn',
      [
        'label'       => esc_html__('Button Text', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Apply now', 'tjcore'),
        'label_block' => true,
        'condition' => [
          'tj_design_style!' => ['2'],
        ],
      ]
    );
    $this->add_control(
      'tj_career_btn_icon',
      [
        'label'         => esc_html__('Icon', 'tjcore'),
        'type'          => Controls_Manager::ICONS,
        'fa4compatibility' => 'btn_icon',
        'default'          => [
          'value' => 'tji-angle-right',
          'library' => 'tj',
        ],
        'condition' => [
          'tj_design_style!' => ['2'],
        ],
      ]
    );
    $this->add_control(
      'tj_career_link',
      [
        'label' => esc_html__('Link', 'tjcore'),
        'type' => Controls_Manager::URL,
        'dynamic'       => [
          'active' => true,
        ],
        'default' => [
          'url' => '#',
          'is_external' => false,
          'nofollow' => false,
        ],
      ]
    );
    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Form Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    $this->start_controls_section(
      'section_style_service',
      [
        'label' => esc_html__('Wrapper style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'wrapper_border',
        'selector' => '{{WRAPPER}} .tj-careers',
      ]
    );

    $this->start_controls_tabs('wrapper_style_tabs');
    $this->start_controls_tab(
      'wrapper_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_wrapper_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .tj-careers',
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'wrapper_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_wrapper_hbackground',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .tj-careers',
      ]
    );

    $this->add_control(
      'wrapper_border_hcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-careers:hover' => 'border-color: {{VALUE}}',
        ],
      ]
    );

    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'tj_wrapper_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-careers' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_wrapper_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-careers' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'section_social_style',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_responsive_control(
      'social_width',
      [
        'label' => esc_html__('Width', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-careers .tj-careers-icon' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'social_height',
      [
        'label' => esc_html__('Height', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-careers .tj-careers-icon' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'social_icon_size',
      [
        'label' => esc_html__('Icon Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-careers .tj-careers-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
        'separator' => 'before'
      ]
    );
    $this->start_controls_tabs(
      'socials_tabs'
    );

    $this->start_controls_tab(
      'style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-careers .tj-careers-icon i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'icon_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-careers .tj-careers-icon' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'icon_hover_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-careers:hover .tj-careers-icon i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'icon_bg_hover_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-careers:hover .tj-careers-icon ' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'icon_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-careers .tj-careers-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before'
      ]
    );
    $this->add_responsive_control(
      'icon_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-careers .tj-careers-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'icon_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-careers .tj-careers-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();


    // category
    $this->start_controls_section(
      '_style_category_btn',
      [
        'label' => esc_html__('Category', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_category_btn_typography',
        'selector' => '{{WRAPPER}} .tj-careers-tag span',
      ]
    );
    $this->start_controls_tabs('category_btn_style_tabs');
    $this->start_controls_tab(
      'category_btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_category_btn_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-careers-tag span' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_category_btn_bgcolor',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-careers-tag span' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_category_btn_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_category_btn_hcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-careers-tag span:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_category_btn_hbgcolor',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-careers-tag span:hover' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_category_btn_hborder_color',
      [
        'label'     => __('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-careers-tag span:hover' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'span_border',
        'selector' => '{{WRAPPER}} .tj-careers-tag span',
      ]
    );
    $this->end_controls_section();


    $this->start_controls_section(
      '_style_stitle',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_stitle_typography',
        'selector' => '{{WRAPPER}} .tj-careers .tj-careers-title',
      ]
    );
    $this->start_controls_tabs('stitle_style_tabs');
    $this->start_controls_tab(
      'stitle_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_stitle_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-careers .tj-careers-title a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_stitle_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_stitle_hcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-careers:hover .tj-careers-title a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'tj_stitle_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-careers .tj-careers-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_stitle_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-careers .tj-careers-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // content
    $this->start_controls_section(
      '_style_scontent',
      [
        'label' => esc_html__('Salary', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_scontent_typography',
        'selector' => '{{WRAPPER}} .tj-careers-salary',
      ]
    );
    $this->start_controls_tabs('sscontent_style_tabs');
    $this->start_controls_tab(
      'scontent_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_scontent_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-careers-salary' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_scontent_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_scontent_hcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-careers:hover .tj-careers-salary span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-careers:hover .tj-careers-salary' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'tj_scontent_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-careers-salary' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_scontent_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-careers-salary' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // button
    $this->start_controls_section(
      '_style_stext_btn',
      [
        'label' => esc_html__('Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_stext_btn_typography',
        'selector' => '{{WRAPPER}} .tj-careers:hover .tj-careers-btn',
      ]
    );
    $this->start_controls_tabs('stext_btn_style_tabs');
    $this->start_controls_tab(
      'stext_btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_stext_btn_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-careers .tj-careers-btn' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_stext_btn_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_stext_btn_hcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-careers:hover .tj-careers-btn' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();

    // location
    $this->start_controls_section(
      '_style_location',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_location_typography',
        'selector' => '{{WRAPPER}} .tj-careers .location',
      ]
    );
    $this->start_controls_tabs('location_style_tabs');
    $this->start_controls_tab(
      'location_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_location_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-careers .location' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_location_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_location_hcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-careers:hover .location' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/careers/style-' . $tj_design_style . '.php';
?>


<?php
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Careers());
