<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Coming Soon.
 */
class TJ_Coming_Soon extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-coming-soon';
  }

  // widget title.
  public function get_title() {
    return __('TJ Coming Soon', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-countdown tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'coming soon',
      'maintenance',
      'tj mode',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {
    $this->start_controls_section(
      'tj_content_section',
      [
        'label' => esc_html__('Content', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_title',
      [
        'label'       => esc_html__('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Coming Soon', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
      ]
    );
    $this->add_control(
      'tj_title_tag',
      [
        'label'   => esc_html__('Title Tags', 'tjcore'),
        'type'    => Controls_Manager::CHOOSE,
        'options' => [
          'h1' => [
            'title' => esc_html__('H1', 'tjcore'),
            'icon'  => 'eicon-editor-h1',
          ],
          'h2' => [
            'title' => esc_html__('H2', 'tjcore'),
            'icon'  => 'eicon-editor-h2',
          ],
          'h3' => [
            'title' => esc_html__('H3', 'tjcore'),
            'icon'  => 'eicon-editor-h3',
          ],
          'h4' => [
            'title' => esc_html__('H4', 'tjcore'),
            'icon'  => 'eicon-editor-h4',
          ],
          'h5' => [
            'title' => esc_html__('H5', 'tjcore'),
            'icon'  => 'eicon-editor-h5',
          ],
          'h6' => [
            'title' => esc_html__('H6', 'tjcore'),
            'icon'  => 'eicon-editor-h6',
          ],
        ],
        'default' => 'h1',
        'toggle'  => false,
      ]
    );
    $this->add_control(
      'tj_desc',
      [
        'label'   => esc_html__('Description', 'tjcore'),
        'type'    => Controls_Manager::TEXTAREA,
        'default' => tj_kses('Our new website is under development — smarter, faster, and more creative than ever.'),
        'dynamic' => [
          'active' => true,
        ],
      ]
    );
    $this->end_controls_section();

    // countdown
    $this->start_controls_section(
      '_tj_countdown_section',
      [
        'label' => esc_html__('Countdown Control', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'day_label',
      [
        'label'       => esc_html__('Day Label', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Days', 'tjcore'),
        'placeholder' => esc_html__('Day Label', 'tjcore'),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'hour_label',
      [
        'label'       => esc_html__('Hour Label', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Hours', 'tjcore'),
        'placeholder' => esc_html__('Hour Label', 'tjcore'),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'min_label',
      [
        'label'       => esc_html__('Minute Label', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Mins', 'tjcore'),
        'placeholder' => esc_html__('Minute Label', 'tjcore'),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'sec_label',
      [
        'label'       => esc_html__('Second Label', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Sec', 'tjcore'),
        'placeholder' => esc_html__('Second Label', 'tjcore'),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_date',
      [
        'label' => esc_html__('Date', 'tjcore'),
        'type'  => Controls_Manager::DATE_TIME,
      ]
    );
    $this->end_controls_section();

    // form
    $this->start_controls_section(
      '_tj_form_section',
      [
        'label' => esc_html__('Form Control', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'shortcode',
      [
        'label'       => esc_html__('Form Shortcode', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Paste shortcode here.', 'tjcore'),
        'rows'        => 2,
        'dynamic'     => [
          'active' => true,
        ],
      ]
    );
    $this->add_control(
      'form_note',
      [
        'label'   => esc_html__('Form Note', 'tjcore'),
        'type'    => Controls_Manager::TEXTAREA,
        'default' => esc_html__('* Join the launch list here.', 'tjcore'),
        'rows'    => 3,
        'dynamic' => [
          'active' => true,
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Section', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'section_width',
      [
        'label'      => esc_html__('Width', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj_coming_soon' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'section_height',
      [
        'label'      => esc_html__('Height', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj_coming_soon' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label' => esc_html__('Background', 'tjcore'),
          ],
        ],
        'name'           => 'background',
        'types'          => ['classic', 'gradient', 'video'],
        'selector'       => '{{WRAPPER}} .tj_coming_soon',
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label' => esc_html__('Background Overlay', 'tjcore'),
          ],
        ],
        'name'           => 'background_overlay',
        'types'          => ['classic', 'gradient'],
        'selector'       => '{{WRAPPER}} .tj_coming_soon::after',
        'separator'      => 'before',

      ]
    );
    $this->add_responsive_control(
      'background_overlay_opacity',
      [
        'type'      => Controls_Manager::SLIDER,
        'label'     => esc_html__('Opacity', 'tjcore'),
        'range'     => [
          'px' => [
            'min'  => 0,
            'max'  => 1,
            'step' => .1,
          ],
        ],
        'condition' => [
          'background_overlay_background!' => "",
        ],
        'selectors' => [
          '{{WRAPPER}} .tj_coming_soon::after' => 'opacity: {{SIZE}};',
        ],
      ]
    );
    $this->add_control(
      'section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj_coming_soon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->add_control(
      'section_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj_coming_soon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_tj_title_style',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'title_typography',
        'label'    => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .title',
      ]
    );
    $this->add_control(
      'title_color',
      [
        'label'     => esc_html__('Title Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // desc
    $this->start_controls_section(
      '_tj_desc_style',
      [
        'label' => esc_html__('Description', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'desc_typography',
        'label'    => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .desc',
      ]
    );
    $this->add_control(
      'desc_color',
      [
        'label'     => esc_html__('Desc Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .desc' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'desc_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'desc_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // countdown
    $this->start_controls_section(
      '_tj_countdown_style',
      [
        'label' => esc_html__('Countdown', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'countdown_option_value',
      [
        'label' => esc_html__('Value', 'tjcore'),
        'type'  => Controls_Manager::HEADING,
      ]
    );
    $this->add_control(
      'countdown_value_width',
      [
        'label'      => esc_html__('Value Width', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .countdown-value' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'countdown_value_height',
      [
        'label'      => esc_html__('Value Height', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .countdown-value' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label' => esc_html__('Background', 'tjcore'),
          ],
        ],
        'name'           => 'countdown_value_background',
        'types'          => ['classic', 'gradient'],
        'exclude'        => ['image'],
        'selector'       => '{{WRAPPER}} .countdown-value',
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'countdown_value_typography',
        'label'    => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .countdown-value',
      ]
    );
    $this->add_control(
      'countdown_value_color',
      [
        'label'     => esc_html__('Value Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .countdown-value' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'countdown_value_padding',
      [
        'label'      => esc_html__('Value Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .countdown-value' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    // label
    $this->add_control(
      'countdown_option_label',
      [
        'label'     => esc_html__('Label', 'tjcore'),
        'type'      => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'countdown_label_width',
      [
        'label'      => esc_html__('Label Width', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .countdown-heading' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'countdown_label_height',
      [
        'label'      => esc_html__('Label Height', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .countdown-heading' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label' => esc_html__('Background', 'tjcore'),
          ],
        ],
        'name'           => 'countdown_label_background',
        'types'          => ['classic', 'gradient'],
        'exclude'        => ['image'],
        'selector'       => '{{WRAPPER}} .countdown-heading',
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'countdown_label_typography',
        'label'    => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .countdown-heading',
      ]
    );
    $this->add_control(
      'countdown_label_color',
      [
        'label'     => esc_html__('Label Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .countdown-heading' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'countdown_label_padding',
      [
        'label'      => esc_html__('Label Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .countdown-heading' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    // divider
    $this->add_control(
      'countdown_option_divider',
      [
        'label'     => esc_html__('Divider', 'tjcore'),
        'type'      => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'countdown_divider_size',
      [
        'label'      => esc_html__('Divider Size', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .countdown .divider' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'countdown_divider_color',
      [
        'label'     => esc_html__('Divider Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .countdown .divider' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();

    // form field
    $this->start_controls_section(
      '_tj_form_field_style',
      [
        'label' => esc_html__('Form Field', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'cf_field_typo',
        'label'    => esc_html__('Field Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} input, {{WRAPPER}} .wpcf7-form-control',
      ]
    );
    $this->add_responsive_control(
      'cf_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} input'               => 'color: {{VALUE}}',
          '{{WRAPPER}} .wpcf7-form-control' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_placeholder_color',
      [
        'label'     => esc_html__('Placeholder Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} input::-moz-placeholder'                        => 'color: {{VALUE}}',
          '{{WRAPPER}} input::-ms-input-placeholder'                   => 'color: {{VALUE}}',
          '{{WRAPPER}} input::-webkit-input-placeholder'               => 'color: {{VALUE}}',
          '{{WRAPPER}} .wpcf7-form-control::-moz-placeholder'          => 'color: {{VALUE}}',
          '{{WRAPPER}} .wpcf7-form-control::-ms-input-placeholder'     => 'color: {{VALUE}}',
          '{{WRAPPER}} .wpcf7-form-control::-webkit-input-placeholder' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} input'               => 'background: {{VALUE}}',
          '{{WRAPPER}} .wpcf7-form-control' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Border::get_type(),
      [
        'name'     => 'cf_borders',
        'label'    => esc_html__('Field Border', 'tjcore'),
        'selector' => '{{WRAPPER}} input, {{WRAPPER}} .wpcf7-form-control',
      ]
    );
    $this->add_control(
      'cf_focus_border_color',
      [
        'label'     => esc_html__('Focus Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} input:focus'               => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .wpcf7-form-control:focus' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_field_padding',
      [
        'label'      => esc_html__('Field Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} input'               => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .wpcf7-form-control' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_field_margin',
      [
        'label'      => esc_html__('Field Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} input'               => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .wpcf7-form-control' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // form button
    $this->start_controls_section(
      '_tj_form_button_style',
      [
        'label' => esc_html__('Form Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_responsive_control(
      'Button Size',
      [
        'label' => esc_html__('Icon Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors' => [
          '{{WRAPPER}} input[type="submit"]' => 'font-size: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} button[type="submit"]' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->start_controls_tabs('btn_style_tabs');
    $this->start_controls_tab(
      'btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} input[type="submit"]' => 'color: {{VALUE}}',
          '{{WRAPPER}} button[type="submit"]' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_hcolor',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} input[type=submit]:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} button[type=submit]:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();

    // form note
    $this->start_controls_section(
      '_tj_form_note_style',
      [
        'label' => esc_html__('Form Note', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'form_note_typography',
        'label'    => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .form_note',
      ]
    );
    $this->add_control(
      'form_note_color',
      [
        'label'     => esc_html__('Note Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .form_note' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'form_note_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .form_note' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'form_note_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .form_note' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();

    $tjTitle         = $settings['tj_title'] ?? '';
    $tjTitleTag      = $settings['tj_title_tag'] ?? '';
    $tjDescription   = $settings['tj_desc'] ?? '';
    $tjDayLabel      = $settings['day_label'] ?? '';
    $tjHourLabel     = $settings['hour_label'] ?? '';
    $tjMinLabel      = $settings['min_label'] ?? '';
    $tjSecLabel      = $settings['sec_label'] ?? '';
    $tjDate          = $settings['tj_date'] ?? '';
    $tjFormShortcode = $settings['shortcode'] ?? '';
    $tjFormNote      = $settings['form_note'] ?? '';

    $formattedDate = "";
    if (!empty($tjDate)) {
      $dateTime      = new \DateTime($tjDate);
      $formattedDate = $dateTime->format('Y-m-d H:i:s'); // full datetime
    }
    $this->add_render_attribute('title_args', 'class', 'title');
?>

    <div class="tj_coming_soon">
      <div class="tj_coming_soon_wrap">
        <?php if (!empty($tjDescription) || !empty($tjTitle)): ?>
          <div class="tj_coming_soon_content">
            <?php if (!empty($tjTitle)):
              printf(
                '<%1$s %2$s>%3$s</%1$s>',
                tag_escape($tjTitleTag),
                $this->get_render_attribute_string('title_args'),
                tj_kses($tjTitle)
              );
            endif; ?>

            <?php if (!empty($tjDescription)): ?>
              <div class="desc"><?php echo tj_kses($tjDescription); ?></div>
            <?php endif; ?>
          </div>
        <?php endif; ?>


        <div class="countdown" data-date="<?php echo esc_attr($formattedDate); ?>" data-day_label="<?php echo esc_attr($tjDayLabel); ?>" data-min_label="<?php echo esc_attr($tjMinLabel); ?>" data-hour_label="<?php echo esc_attr($tjHourLabel); ?>" data-sec_label="<?php echo esc_attr($tjSecLabel); ?>">
          <div class="countdown-container days">
            <span class="countdown-value"><?php esc_html_e("00", "tjcore"); ?></span>
            <span class="countdown-heading"><?php echo esc_html__('Days', 'tjcore'); ?></span>
          </div>

          <span class="divider"><?php esc_html_e(':', 'tjcore'); ?></span>

          <div class="countdown-container hours">
            <span class="countdown-value"><?php esc_html_e("00", "tjcore"); ?></span>
            <span class="countdown-heading"><?php echo esc_html__('Hours', 'tjcore'); ?></span>
          </div>

          <span class="divider"><?php esc_html_e(':', 'tjcore'); ?></span>

          <div class="countdown-container minutes">
            <span class="countdown-value"><?php esc_html_e("00", "tjcore"); ?></span>
            <span class="countdown-heading"><?php echo esc_html__('Mins', 'tjcore'); ?></span>
          </div>

          <span class="divider"><?php esc_html_e(':', 'tjcore'); ?></span>

          <div class="countdown-container seconds">
            <span class="countdown-value"><?php esc_html_e("00", "tjcore"); ?></span>
            <span class="countdown-heading"><?php echo esc_html__('Sec', 'tjcore'); ?></span>
          </div>
        </div>

        <?php if (!empty($tjFormShortcode) || !empty($tjFormNote)): ?>
          <div class="query_form">
            <?php echo do_shortcode(wp_kses_post($tjFormShortcode)); ?>

            <?php if (!empty($tjFormNote)): ?>
              <span class="form_note">
                <?php echo tj_kses($tjFormNote); ?>
              </span>
            <?php endif; ?>
          </div>
        <?php endif; ?>
      </div>
    </div>

<?php }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Coming_Soon());
