<?php

namespace TJCore;

use Elementor\Widget_Base;
use \Elementor\Repeater;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) {
  exit;
}

/**
 * Elementor widget for Funfact.
 */
class Tj_Counter extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-counter';
  }

  // widget title.
  public function get_title()
  {
    return esc_html__('TJ Counter', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-counter tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'counter',
      'counter up',
      'tj counter',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {
    // tj counter tab
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Style', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Counter Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'section_tab_tj_counter',
      [
        'label' => esc_html__('Counter', 'tjcore'),
      ]
    );

    $repeater = new Repeater();
    $repeater->add_control(
      'tj_ff_title',
      [
        'label'       => esc_html__('Counter Title', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => tj_kses('Counter Item #01'),
        'rows'        => '3',
      ]
    );
    $repeater->add_control(
      'tj_ff_number',
      [
        'label'       => esc_html__('Counter Amount', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'default'     => esc_html__('95', 'tjcore'),
      ]
    );
    $repeater->add_control(
      'tj_ff_prefix',
      [
        'label'       => esc_html__('Number Prefix', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'description' => esc_html__('Insert prefix for fact.', 'tjcore'),
      ]
    );
    $repeater->add_control(
      'tj_ff_suffix',
      [
        'label'       => esc_html__('Number Suffix', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'description' => esc_html__('Insert suffix for fact.', 'tjcore'),
        'default'     => tj_kses('%'),
      ]
    );
    $this->add_control(
      'tj_counter_list',
      [
        'label'    => esc_html__('Counter Items', 'tjcore'),
        'type'     => Controls_Manager::REPEATER,
        'fields'   => $repeater->get_controls(),
        'default'  => [
          [
            'tj_ff_title' => tj_kses('Complete project'),
          ],
          [
            'tj_ff_title' => tj_kses('Reach worldwide'),
          ],
          [
            'tj_ff_title' => tj_kses('Faster growth'),
          ],
          [
            'tj_ff_title' => tj_kses('Awards archived'),
          ]
        ],
        'title_field' => '{{{ tj_ff_title }}}',
        'condition' => [
          'tj_design_style!' => ['3']
        ]
      ]
    );

    $repeater2 = new Repeater();
    $repeater2->add_control(
      'tj_ff_title_2',
      [
        'label'       => esc_html__('Counter Title', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => tj_kses('Counter Item #01'),
        'rows'        => '3',
      ]
    );
    $repeater2->add_control(
      'tj_ff_desc_2',
      [
        'label'       => esc_html__('Counter Desc', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => tj_kses('Our mission is our empower businesses off our all size too thrive in an businesse changing marketplaces. Our mission.'),
      ]
    );
    $repeater2->add_control(
      'tj_ff_number_2',
      [
        'label'       => esc_html__('Counter Amount', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'default'     => esc_html__('95', 'tjcore'),
      ]
    );
    $repeater2->add_control(
      'tj_ff_prefix_2',
      [
        'label'       => esc_html__('Number Prefix', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'description' => esc_html__('Insert prefix for fact.', 'tjcore'),
      ]
    );
    $repeater2->add_control(
      'tj_ff_suffix_2',
      [
        'label'       => esc_html__('Number Suffix', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'description' => esc_html__('Insert suffix for fact.', 'tjcore'),
        'default'     => tj_kses('%'),
      ]
    );
    $this->add_control(
      'tj_counter_list_2',
      [
        'label'    => esc_html__('Counter Items', 'tjcore'),
        'type'     => Controls_Manager::REPEATER,
        'fields'   => $repeater2->get_controls(),
        'default'  => [
          [
            'tj_ff_title_2' => tj_kses('Reach worldwide'),
            'tj_ff_desc_2' => tj_kses('Our mission is our empower businesses off our all size too thrive in an businesse changing marketplaces. Our mission.'),
          ],
          [
            'tj_ff_title_2' => tj_kses('Faster growth'),
            'tj_ff_desc_2' => tj_kses('Our mission is our empower businesses off our all size too thrive in an businesse changing marketplaces. Our mission.'),
          ],
          [
            'tj_ff_title_2' => tj_kses('Awards archived'),
            'tj_ff_desc_2' => tj_kses('Our mission is our empower businesses off our all size too thrive in an businesse changing marketplaces. Our mission.'),
          ],
        ],
        'title_field' => '{{{ tj_ff_title_2 }}}',
        'condition' => [
          'tj_design_style' => ['3']
        ]
      ]
    );

    // animation
    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Wrapper', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    // section background
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_background',
        'selector' => '{{WRAPPER}} .counter-wrapper, {{WRAPPER}} .about-funfact, {{WRAPPER}} .h6-about-funfact-item',
        'exclude' => ['image', 'video']
      ]
    );
    // section border color
    $this->add_control(
      'tj_border_color',
      [
        'label'     => __('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .counter-item' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .h6-about-funfact-item' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .h6-about-funfact-item .desc::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_dot_color',
      [
        'label'     => __('Dot Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .counter-item::before' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .counter-item::after' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    // section padding
    $this->add_responsive_control(
      'tj_section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .counter-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    // section margin
    $this->add_responsive_control(
      'tj_section_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .counter-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // counter
    $this->start_controls_section(
      '_counter_name',
      [
        'label' => esc_html__('Counter', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    // counter typography
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_counter_typography',
        'selector' => '{{WRAPPER}} .counter-item .number',
      ]
    );

    // counter color
    $this->add_control(
      'tj_counter_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .counter-item .number' => 'color: {{VALUE}}',
        ],
      ]
    );

    // counter margin
    $this->add_responsive_control(
      'tj_counter_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .counter-item .number' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    // counter padding
    $this->add_responsive_control(
      'tj_counter_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .counter-item .number' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // Label
    $this->start_controls_section(
      '_label_name',
      [
        'label' => esc_html__('Label', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    // label typography
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_label_typography',
        'selector' => '{{WRAPPER}} .counter-item .sub-title',
      ]
    );
    $this->add_control(
      'tj_label_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .counter-item .sub-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();

    // desc
    $this->start_controls_section(
      '_desc_name',
      [
        'label' => esc_html__('Description', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['1', '2', '4']
        ]
      ]
    );
    // label typography
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_desc_typography',
        'selector' => '{{WRAPPER}} .h6-about-funfact-item .desc',
      ]
    );
    $this->add_control(
      'tj_desc_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .h6-about-funfact-item .desc' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_desc_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .h6-about-funfact-item .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  protected function render()
  {
    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/counter/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {}
}

$widgets_manager->register(new Tj_Counter());
