<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Footer Subscription.
 */
class TJ_CTA_Three extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-cta-three';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ CTA 3', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-form-vertical tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'form',
      'cta',
      'tj cta',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  // Get Contact Form
  public function get_tj_contact_form()
  {
    if (!class_exists('WPCF7')) {
      return;
    }
    $tj_cfa     = array();
    $tj_cf_args = array('posts_per_page' => -1, 'post_type' => 'wpcf7_contact_form');
    $tj_forms   = get_posts($tj_cf_args);
    $tj_cfa     = ['0' => esc_html__('Select Form', 'tjcore')];
    if ($tj_forms) {
      foreach ($tj_forms as $tj_form) {
        $tj_cfa[$tj_form->ID] = $tj_form->post_title;
      }
    } else {
      $tj_cfa[esc_html__('No contact form found', 'tjcore')] = 0;
    }
    return $tj_cfa;
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {
    $this->start_controls_section(
      '_tj_cta_three_content',
      [
        'label' => esc_html__('Content', 'tjcore'),
      ]
    );

    $this->add_control(
      'tj_title',
      [
        'label'   => esc_html__('Title', 'tjcore'),
        'type'    => Controls_Manager::TEXTAREA,
        'default' => esc_html__('Subscribe to our newsletter', 'tjcore'),
        'rows' => 3,
      ]
    );

    $this->add_control(
      'tj_title_tag',
      [
        'label'   => esc_html__('Title HTML Tag', 'tjcore'),
        'type'    => Controls_Manager::CHOOSE,
        'options' => [
          'h1' => [
            'title' => esc_html__('H1', 'tjcore'),
            'icon'  => 'eicon-editor-h1',
          ],
          'h2' => [
            'title' => esc_html__('H2', 'tjcore'),
            'icon'  => 'eicon-editor-h2',
          ],
          'h3' => [
            'title' => esc_html__('H3', 'tjcore'),
            'icon'  => 'eicon-editor-h3',
          ],
          'h4' => [
            'title' => esc_html__('H4', 'tjcore'),
            'icon'  => 'eicon-editor-h4',
          ],
          'h5' => [
            'title' => esc_html__('H5', 'tjcore'),
            'icon'  => 'eicon-editor-h5',
          ],
          'h6' => [
            'title' => esc_html__('H6', 'tjcore'),
            'icon'  => 'eicon-editor-h6',
          ],
        ],
        'default' => 'h2',
        'toggle'  => false,
      ]
    );

    $this->add_control(
      'tj_gsap_animation',
      [
        'label'        => esc_html__('Enable Title Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator' => 'after',
      ]
    );


    // form style
    $this->add_control(
      'form_style',
      [
        'label'   => esc_html__('Form', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'default' => 'shortcode',
        'options' => [
          'shortcode' => esc_html__('Shortcode', 'tjcore'),
          'cf7-form'  => esc_html__('Contact Form 7', 'tjcore'),
        ],
      ]
    );
    // cf7
    $this->add_control(
      'tj_select_form',
      [
        'label'     => esc_html__('Select Form', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'separator' => 'before',
        'options'   => $this->get_tj_contact_form(),
        'condition' => [
          'form_style' => 'cf7-form',
        ],
      ]
    );
    // shortcode
    $this->add_control(
      'tj_shortcode',
      [
        'label'       => esc_html__('Shortcode', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'label_block' => true,
        'condition'   => [
          'form_style' => 'shortcode',
        ],
      ]
    );

    // title animation
    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );

    $this->end_controls_section();

    $this->start_controls_section(
      '_tj_cta_three_images',
      [
        'label' => esc_html__('Images', 'tjcore'),
      ]
    );

    $this->add_control(
      'tj_bgimage',
      [
        'label'   => esc_html__('Background Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
      ]
    );

    $this->add_control(
      'tj_bgshape',
      [
        'label'   => esc_html__('Shape Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
      ]
    );

    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Section', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .el-section',
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'sec_border',
        'selector' => '{{WRAPPER}} .el-section',
      ]
    );

    $this->add_responsive_control(
      'tj_section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .el-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_section_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .el-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
    // title
    $this->start_controls_section(
      '_style_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .tj-newsletter .title',
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-newsletter .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-newsletter .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-newsletter .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
    // From Style
    $this->start_controls_section(
      'section_tab_area',
      [
        'label' => esc_html__('Form Field Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'cf_field_typo',
        'label'    => esc_html__('Field Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-newsletter .newsletter-form .form-input input[type=email]',
      ]
    );
    $this->add_control(
      'cf_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-newsletter .newsletter-form .form-input input[type=email]' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'cf_placeholder_color',
      [
        'label'     => esc_html__('Placeholder Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-newsletter .newsletter-form .form-input input[type=email]::placeholder'               => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-newsletter .newsletter-form .form-input input[type=email]::-moz-placeholder'          => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-newsletter .newsletter-form .form-input input[type=email]::-ms-input-placeholder'     => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-newsletter .newsletter-form .form-input input[type=email]::-webkit-input-placeholder' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'cf_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-newsletter .newsletter-form .form-input input[type=email]' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Border::get_type(),
      [
        'name'     => 'cf_borders',
        'label'    => esc_html__('Field Border', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-newsletter .newsletter-form .form-input input[type=email]',
      ]
    );
    $this->add_responsive_control(
      'cf_field_radius',
      [
        'label'      => esc_html__('Field Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-newsletter .newsletter-form .form-input input[type=email]' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_field_padding',
      [
        'label'      => esc_html__('Field Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-newsletter .newsletter-form .form-input input[type=email]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // button
    $this->start_controls_section(
      'section_tab_button',
      [
        'label' => esc_html__('Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'btn_typo',
        'label'    => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-newsletter input[type=submit], {{WRAPPER}} .tj-newsletter .newsletter-form .form-input button',
      ]
    );
    $this->start_controls_tabs('style_tabs_1');
    $this->start_controls_tab(
      'btn_1_button_style_normal',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_1_label_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-newsletter .newsletter-form .form-input input[type=submit]'  => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-newsletter .newsletter-form .form-input button' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'btn_1_bg',
        'label'    => esc_html__('Background', 'tjcore'),
        'types'    => ['classic', 'gradient'],
        'exclude'  => ['image'],
        'selector' => '{{WRAPPER}} .tj-newsletter input[type=submit], {{WRAPPER}} .tj-newsletter .newsletter-form .form-input button',
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'btn_1_button_style_hover',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_label_hover_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-newsletter input[type=submit]:hover'    => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-newsletter .newsletter-form .form-input button:hover'   => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-newsletter input[type=submit]:hover i'  => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-newsletter .newsletter-form .form-input button:hover i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'btn_hover__bg',
        'label'    => esc_html__('Background', 'tjcore'),
        'types'    => ['classic', 'gradient'],
        'exclude'  => ['image'],
        'selector' => '{{WRAPPER}} .tj-newsletter input[type=submit]:hover, {{WRAPPER}} .tj-newsletter .newsletter-form .form-input button:hover',
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'tj_btn_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-newsletter input[type=submit]'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-newsletter .newsletter-form .form-input button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => "before"
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/cta-3/style-' . $tj_design_style . '.php';
?>


<?php
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_CTA_Three());
