<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for CTA.
 */
class TJ_CTA_Two extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-cta-two';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ CTA 2', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-call-to-action tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'cta',
      'call-to-action',
      'tj cta',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {
    // CTA Content
    $this->start_controls_section(
      'tj_cta_content',
      [
        'label' => esc_html__('Content', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_phone_icon',
      [
        'label'            => esc_html__('Phone Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'phone_icon',
        'default'          => [
          'value'   => 'tji-phone',
          'library' => 'tj',
        ],
        'skin'             => 'inline',
        'label_block'      => false,
      ]
    );
    $this->add_control(
      'tj_phone_number',
      [
        'label'         => esc_html__('Phone Number', 'tjcore'),
        'type'          => Controls_Manager::TEXT,
        'default'       => esc_html__('1-888-452-1505', 'tjcore'),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_email_icon',
      [
        'label'            => esc_html__('Email Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'email_icon',
        'default'          => [
          'value'   => 'tji-email',
          'library' => 'tj',
        ],
        'skin'             => 'inline',
        'label_block'      => false,
      ]
    );
    $this->add_control(
      'tj_email_address',
      [
        'label'         => esc_html__('Email Address', 'tjcore'),
        'type'          => Controls_Manager::TEXT,
        'default'       => esc_html__('support@solvior.com', 'tjcore'),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_time_icon',
      [
        'label'            => esc_html__('Time Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'time_icon',
        'default'          => [
          'value'   => 'tji-clock',
          'library' => 'tj',
        ],
        'skin'             => 'inline',
        'label_block'      => false,
      ]
    );
    $this->add_control(
      'tj_time',
      [
        'label'         => esc_html__('Time', 'tjcore'),
        'type'          => Controls_Manager::TEXT,
        'default'       => esc_html__('Mon - Friday from 9:00 - 18:00', 'tjcore'),
        'label_block' => true,
      ]
    );

    // title animation
    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Title Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();


    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Section', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .tj-cta-section-3',
      ]
    );

    $this->add_control(
      'tj_sbefore_color',
      [
        'label'     => __('Before BG Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-cta-section-3::before' => 'background: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'tj_s_after_color',
      [
        'label'     => __('After BG Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-cta-section-3::after' => 'background: {{VALUE}}',
        ],
      ]
    );

    $this->add_responsive_control(
      'tj_section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-cta-section-3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_section_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-cta-section-3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_title',
      [
        'label' => esc_html__('Text', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .tj-cta-list li a, .tj-cta-list li span',
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-cta-list li a, .tj-cta-list li span' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_title_icolor',
      [
        'label'     => __('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-cta-list li a i, .tj-cta-list li span i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();
    extract($settings);

    // animation
    $tjAnimation   = $settings['tj_animation'] ?? '';
    $tjAnimationName   = $settings['tj_animation_name'] ?? '';
    $tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

    if (!empty($tjAnimation)) {
      $formClass = "tj-cta-wrapper-3 wow $tjAnimationName";
      $this->add_render_attribute('tj_wrap_arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
    } else {
      $formClass = "tj-cta-wrapper-3";
    }
    $this->add_render_attribute('tj_wrap_arg', 'class', $formClass);
?>

    <div class="tj-cta-section-3">
      <div class="container">
        <div class="row align-items-center">
          <div class="col-lg-6 col-md-7">
            <div <?php echo $this->get_render_attribute_string('tj_wrap_arg'); ?>>
              <ul class="tj-cta-list">
                <?php if (!empty($settings['tj_phone_number'])) : ?>
                  <li>
                    <a href="tel:<?php echo esc_attr($settings['tj_phone_number']); ?>">
                      <?php tj_render_icon($settings, 'phone_icon', 'tj_phone_icon') ?>
                      <span class="line-hover"><?php echo esc_html($settings['tj_phone_number']); ?></span>
                    </a>
                  </li>
                <?php endif; ?>
                <?php if (!empty($settings['tj_email_address'])) : ?>
                  <li>
                    <a href="mailto:<?php echo esc_attr($settings['tj_email_address']); ?>">
                      <?php tj_render_icon($settings, 'email_icon', 'tj_email_icon') ?>
                      <span class="line-hover"><?php echo esc_html($settings['tj_email_address']); ?></span>
                    </a>
                  </li>
                <?php endif; ?>
              </ul>
            </div>
          </div>
          <?php if (!empty($settings['tj_time'])) : ?>
            <div class="col-lg-6 col-md-5">
              <div <?php echo $this->get_render_attribute_string('tj_wrap_arg'); ?>>
                <ul class="tj-cta-list style-2">
                  <li>
                    <span>
                      <?php tj_render_icon($settings, 'time_icon', 'tj_time_icon') ?>
                      <?php echo esc_html($settings['tj_time']); ?>
                    </span>
                  </li>
                </ul>
              </div>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
<?php
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_CTA_Two());
