<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Divider.
 */
class TJ_Divider extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-divider';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Divider', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-divider tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'divider',
      'partition',
      'tj divider',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {

    // tj_content_tab
    $this->start_controls_section(
      'tj_content_tab',
      [
        'label' => esc_html__('content', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_title',
      [
        'label'       => esc_html__('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'rows'        => 5,
        'default'     => esc_html__('Join the <span>1000+</span> companies benefiting from solvior', 'tjcore'),
        'show_label'  => false,
        'dynamic'     => [
          'active' => true,
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Divider', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'tj_divider_color',
      [
        'label' => esc_html__('Color', 'tjcore'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-brand-section-two .sec-heading::before, .tj-brand-section-two .sec-heading::after' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'divider_width',
      [
        'label' => esc_html__('Width', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-brand-section-two .sec-heading::before, .tj-brand-section-two .sec-heading::after' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // text
    $this->start_controls_section(
      '_section_style_text',
      [
        'label' => esc_html__('Text', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .tj-brand-section-two .sec-heading .sec-title',
        'separator' => "before"
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-brand-section-two .sec-heading .sec-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_title_bg_color',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-brand-section-two .sec-heading .sec-title' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-brand-section-two .sec-heading .sec-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tjTitle = $settings['tj_title'] ?? "";
?>
    <div class="tj-brand-section-two wow fadeInUp" data-wow-delay="0.1s">
      <?php if (!empty($tjTitle)): ?>
        <div class="sec-heading text-center">
          <h6 class="sec-title">
            <?php echo tj_kses($tjTitle); ?>
          </h6>
        </div>
      <?php endif; ?>
    </div>
<?php
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Divider());
