<?php

namespace TJCore;

use Elementor\Widget_Base;
use \Elementor\Utils;
use \Elementor\Repeater;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Text_Stroke;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Css_Filter;
use \Elementor\Group_Control_Background;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Elementor widget for About.
 */
class TJ_Feature extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-feature';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Feature', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-lightbox tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'feature',
      'tj feature',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {
    // tj feature tab
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Feature Style', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
          5 => esc_html__('Style 05', 'tjcore'),
          6 => esc_html__('Style 06', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'tj_feature_tab',
      [
        'label' => esc_html__('Feature Content', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_icon_type',
      [
        'label' => __('Icon Type', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'font',
        'options' => [
          'font'  => __('Font Icon', 'tjcore'),
          'svg'  => __('SVG Icon', 'tjcore'),
          'image' => __('Image Icon', 'tjcore'),
        ],
      ]
    );
    $this->add_control(
      'tj_feature_icon',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'default' => [
          'value' => 'tji-personalization',
          'library' => 'tj',
        ],
        'fa4compatibility' => 'feature_icon',
        'condition' => [
          'tj_icon_type' => 'font',
        ]
      ]
    );
    $this->add_control(
      'tj_image_icon',
      [
        'label'   => esc_html__('Upload Image Icon', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_icon_type' => 'image',
        ]
      ]
    );
    $this->add_control(
      'tj_svg_icon',
      [
        'label' => esc_html__('SVG Code', 'tjcore'),
        'type' => Controls_Manager::TEXTAREA,
        'rows' => 10,
        'condition' => [
          'tj_icon_type' => 'svg',
        ]
      ]
    );
    $this->add_control(
      'tj_feature_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'type' => Controls_Manager::TEXTAREA,
        'default' => esc_html__('Quick solutions', 'tjcore'),
        'placeholder' => esc_html__('Type your title here', 'tjcore'),
        'rows' => 3,
      ]
    );
    $this->add_control(
      'tj_title_link',
      [
        'label' => esc_html__('Link', 'tjcore'),
        'type' => Controls_Manager::URL,
        'dynamic'       => [
          'active' => true,
        ],
        'default' => [
          'url' => '#',
          'is_external' => false,
          'nofollow' => false,
        ]
      ]
    );
    $this->add_control(
      'tj_feature_desc',
      [
        'label' => esc_html__('Description', 'tjcore'),
        'type' => Controls_Manager::TEXTAREA,
        'rows' => 6,
        'default' => esc_html__('Our consultancy excels in providing quick solutions tailored to your business challenges', 'tjcore'),
        'placeholder' => esc_html__('Type your description here', 'tjcore'),
      ]
    );

    $this->add_control(
      'tj_feature_title_tag',
      [
        'label'   => esc_html__('Title HTML Tag', 'tjcore'),
        'type'    => Controls_Manager::CHOOSE,
        'options' => [
          'h1' => [
            'title' => esc_html__('H1', 'tjcore'),
            'icon'  => 'eicon-editor-h1',
          ],
          'h2' => [
            'title' => esc_html__('H2', 'tjcore'),
            'icon'  => 'eicon-editor-h2',
          ],
          'h3' => [
            'title' => esc_html__('H3', 'tjcore'),
            'icon'  => 'eicon-editor-h3',
          ],
          'h4' => [
            'title' => esc_html__('H4', 'tjcore'),
            'icon'  => 'eicon-editor-h4',
          ],
          'h5' => [
            'title' => esc_html__('H5', 'tjcore'),
            'icon'  => 'eicon-editor-h5',
          ],
          'h6' => [
            'title' => esc_html__('H6', 'tjcore'),
            'icon'  => 'eicon-editor-h6',
          ],
        ],
        'default' => 'h4',
        'toggle'  => false,
      ]
    );
    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * About_TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      'section_style_fcontent',
      [
        'label' => esc_html__('Wrapper style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'wrapper_border',
        'selector' => '{{WRAPPER}} .feature-el-item',
        'condition' => [
          'tj_design_style!' => ['5'],
        ],
      ]
    );

    $this->start_controls_tabs('wrap_style_tabs');
    $this->start_controls_tab(
      'wrap_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );

    $this->add_control(
      'tj_wrapper_background',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .feature-el-item' => 'background: {{VALUE}}; overflow: hidden;',
          '{{WRAPPER}} .feature-el-item::before' => 'background: {{VALUE}}',
        ],
      ]
    );

    $this->end_controls_tab();
    $this->start_controls_tab(
      'wrap_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );

    $this->add_control(
      'tj_wrap_hover_background',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .feature-el-item:hover' => 'background: {{VALUE}}',
          '{{WRAPPER}} .feature-el-item::before' => 'background: {{VALUE}}',
          '{{WRAPPER}} .h8-feature-item.style-4:hover' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_feature_border_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .feature-el-item:hover' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .h8-feature-item.style-4:hover' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'feature_border',
        'selector' => '{{WRAPPER}} .feature-el-item, {{WRAPPER}} .h8-feature-item.style-4',
      ]
    );

    $this->add_responsive_control(
      'tj_wrapper_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .feature-el-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_wrapper_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .feature-el-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // icon
    $this->start_controls_section(
      'section_style_ficon',
      [
        'label' => esc_html__('Icon style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_responsive_control(
      'ficon_font_size',
      [
        'label' => esc_html__('Icon Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .feature-el-item .el-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .feature-el-item .el-icon svg, {{WRAPPER}} .feature-el-item .el-icon img' => 'max-width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'ficon_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .feature-el-item .el-icon' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_ftitle',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .feature-el-item .el-title',
      ]
    );

    $this->start_controls_tabs('ftitle_style_tabs');
    $this->start_controls_tab(
      'ftitle_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .feature-el-item .el-title' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->end_controls_tab();
    $this->start_controls_tab(
      'ftitle_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_title_hover_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .feature-el-item .el-title:hover a' => 'color: {{VALUE}}',
          '{{WRAPPER}} .feature-el-item:hover .el-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .feature-el-item .el-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .feature-el-item .el-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // content
    $this->start_controls_section(
      '_style_fcontent',
      [
        'label'     => esc_html__('Content', 'tjcore'),
        'tab'       => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_content_typography',
        'selector' => '{{WRAPPER}} .feature-el-item .desc',
      ]
    );

    $this->start_controls_tabs('fcontent_style_tabs');
    $this->start_controls_tab(
      'fcontent_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_content_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .feature-el-item .desc' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->end_controls_tab();
    $this->start_controls_tab(
      'fcontent_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_content_hover_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .feature-el-item:hover .desc' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'tj_content_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .feature-el-item .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_content_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .feature-el-item .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/feature/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Feature());
