<?php

namespace TJCore;

use Elementor\Widget_Base;
use \Elementor\Utils;
use \Elementor\Repeater;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Text_Stroke;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Css_Filter;


if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Elementor widget for Footer Navigation.
 */
class TJ_Footer_Bottom extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-footer-bottom';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Footer Bottom', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-footer tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'footer bottom',
      'nav',
      'tj footer',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }


  /**
   * widget controls.
   */
  protected function register_controls()
  {

    $menus = wp_get_nav_menus();
    if (!empty($menus)) {
      foreach ($menus as $menu) {
        $menulist[$menu->term_id] = $menu->name;
      }
    }

    // layout Panel
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Copyright Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // tj_footer_content
    $this->start_controls_section(
      'tj_footer_content',
      [
        'label' => esc_html__('Content', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );
    // copyright text
    $this->add_control(
      'tj_copyright_text',
      [
        'label' => esc_html__('Copyright Text', 'tjcore'),
        'type' => Controls_Manager::WYSIWYG,
        'default' => tj_kses('Solarplus © 2025 All Rights Reserved.'),

      ]
    );

    $this->add_control(
      'tj_footer_extra_text',
      [
        'label' => esc_html__('Extra Text', 'tjcore'),
        'type' => Controls_Manager::WYSIWYG,
        'default' => tj_kses('Trusted partner in business excellence'),
        'condition' => [
          'tj_design_style' => ['2'],
        ],
      ]
    );

    // Navigation
    $this->add_control(
      'show_footer_navigation',
      [
        'label' => esc_html__('Show footer navigation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Show', 'tjcore'),
        'label_off' => esc_html__('Hide', 'tjcore'),
        'return_value' => 'yes',
        'default' => 'yes',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_navigation',
      [
        'label'     => esc_html__('Select Menu', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'options'   => $menulist,
        'condition' => [
          'show_footer_navigation' => 'yes',
        ]
      ]
    );

    // footer Socials
    $this->add_control(
      'is_footer_socials',
      [
        'label'        => esc_html__('Is footer socials?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'description'  => esc_html__('Do you want to show footer socials?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
        'separator'    => 'before',
      ]
    );
    $footerSocials = new Repeater();
    $footerSocials->add_control(
      'tj_footer_social_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'footer_social_icon',
      ]
    );
    $footerSocials->add_control(
      'footer_social_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'label_block' => true,
      ]
    );
    $this->add_control(
      'footer_socials_list',
      [
        'label'       => esc_html__('Socials List', 'tjcore'),
        'type'        => Controls_Manager::REPEATER,
        'fields'      => $footerSocials->get_controls(),
        'default'     => [
          [
            'tj_footer_social_icon' => [
              'value'   => 'fa-brands fa-facebook-f',
              'library' => 'fa-brands',
            ],
          ],
          [
            'tj_footer_social_icon' => [
              'value'   => 'fa-brands fa-instagram',
              'library' => 'fa-brands',
            ],
          ],
          [
            'tj_footer_social_icon' => [
              'value'   => 'fa-brands fa-x-twitter',
              'library' => 'fa-brands',
            ],
          ],
          [
            'tj_footer_social_icon' => [
              'value'   => 'fa-brands fa-linkedin-in',
              'library' => 'fa-brands',
            ],
          ],
        ],
        'title_field' => '{{{ elementor.helpers.renderIcon( this, tj_footer_social_icon, {}, "i", "panel" ) || \'<i class="{{ icon }}" aria-hidden="true"></i>\' }}}',
        'condition'   => [
          'is_footer_socials' => "yes",
        ],
      ]
    );

    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Section', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_background',
        'types' => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .copyright-content-area',
      ]
    );
    $this->add_responsive_control(
      'tj_section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .copyright-content-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_section_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .copyright-content-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();


    // copyright_text
    $this->start_controls_section(
      '_style_copyright_text',
      [
        'label' => esc_html__('Copyright Text', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_copyright_text_typography',
        'selector' => '{{WRAPPER}} .copyright-text p',
      ]
    );
    $this->add_control(
      'tj_copyright_text_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .copyright-text p' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_copyright_text_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .copyright-text p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_copyright_text_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .copyright-text p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // Navigation
    $this->start_controls_section(
      '_style_navigation',
      [
        'label' => esc_html__('Navigation', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'show_footer_navigation' => 'yes',
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'nav_menu_typography',
        'selector' => '{{WRAPPER}} .copyright-menu ul > li > a',
      ]
    );
    $this->start_controls_tabs('nav_style_tabs');
    $this->start_controls_tab(
      'nav_style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    // menu color
    $this->add_control(
      'nav_normal_solid_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .copyright-menu ul > li > a' => 'color: {{VALUE}} ',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'nav_style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    // menu hover color
    $this->add_control(
      'nav_hover_solid_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .copyright-menu ul > li > a:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'nav_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .copyright-menu ul > li > a'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before',
      ]
    );
    $this->add_responsive_control(
      'nav_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .copyright-menu ul > li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_ssocial',
      [
        'label' => esc_html__('Social', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_ssocial_typography',
        'selector' => '{{WRAPPER}} .copyright-socails ul li a',
      ]
    );
    $this->start_controls_tabs('ssocial_style_tabs');
    $this->start_controls_tab(
      'ssocial_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_ssocial_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .copyright-socails ul li a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_ssocial_bgcolor',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .copyright-socails ul li a' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_ssocial_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_ssocial_hcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .copyright-socails ul li a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_ssocial_hbgcolor',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .copyright-socails ul li a:hover' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'tj_icon_width',
      [
        'label'      => esc_html__('Width', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 2000,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => '%',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .copyright-socails ul li a' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_icon_height',
      [
        'label'      => esc_html__('Height', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 2000,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => '%',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .copyright-socails ul li a' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/footer-bottom/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Footer_Bottom());
