<?php

namespace TJCore;

use Elementor\Widget_Base;
use \Elementor\Utils;
use \Elementor\Repeater;
use Elementor\Controls_Manager;


if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Elementor widget for Socials.
 */
class TJ_Footer_Contact extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-footer-contact';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Footer Contact', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-tel-field tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'contacts',
      'contact',
      'tj contact',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }


  /**
   * widget controls.
   */
  protected function register_controls()
  {

    $this->start_controls_section(
      '_tj_contact_info',
      [
        'label' => esc_html__('Contact Content', 'tjcore'),
      ]
    );

    $this->add_control(
      'tj_title',
      [
        'label'         => esc_html__('Widget Title', 'tjcore'),
        'type'          => Controls_Manager::TEXT,
        'default'       => esc_html__('Our offices', 'tjcore'),
        'label_block' => true,
      ]
    );

    $repeater = new Repeater();

    $repeater->add_control(
      'tj_info_title',
      [
        'label'         => esc_html__('Contact Info', 'tjcore'),
        'type'          => Controls_Manager::TEXT,
        'default'       => esc_html__('Headquarters - USA', 'tjcore'),
        'label_block' => true,
      ]
    );

    $repeater->add_control(
      'tj_info_address',
      [
        'label'         => esc_html__('Address', 'tjcore'),
        'type'          => Controls_Manager::TEXTAREA,
        'default'       => esc_html__('993 Renner Burg, West Rond, MT 94251-030', 'tjcore'),
        'row'           => '3',
        'label_block' => true,
      ]
    );

    $repeater->add_control(
      'tj_info_phone',
      [
        'label'         => esc_html__('Contact Number', 'tjcore'),
        'type'          => Controls_Manager::TEXT,
        'default'       => esc_html__('+1 (009) 544-7818', 'tjcore'),
        'label_block' => true,
      ]
    );
    $repeater->add_control(
      'tj_info_link',
      [
        'label' => esc_html__('Link', 'tjcore'),
        'type' => Controls_Manager::URL,
        'dynamic'       => [
          'active' => true,
        ],
        'default' => [
          'url' => '#',
          'is_external' => false,
          'nofollow' => false,
        ]
      ]
    );

    $this->add_control(
      'tj_contact_list',
      [
        'label' => esc_html__('Contact Info List', 'tjcore'),
        'type' => Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'tj_info_title' => esc_html__('Headquarters - USA', 'tjcore'),
            'tj_info_address' => esc_html__('993 Renner Burg, West Rond, MT 94251-030', 'tjcore'),
          ],
          [
            'tj_info_title' => esc_html__('Operations - Canada', 'tjcore'),
            'tj_info_address' => esc_html__('Suite 452 8082 Boner Parge, Elviraton, CA 48998', 'tjcore'),
          ]
        ],
        'title_field' => '{{{ tj_info_title }}}',
      ]
    );

    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    // title
    $this->start_controls_section(
      '_style_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .footer-widget .title',
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .footer-widget .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .footer-widget .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .footer-widget .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      '_style_footer_contact',
      [
        'label' => esc_html__('Contact', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'heading_label',
      [
        'label'     => __('Address Label', 'tjcore'),
        'type'      => Controls_Manager::HEADING,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_label_typography',
        'selector' => '{{WRAPPER}} .footer-widget.footer-contact-infos .infos-item span',
      ]
    );
    $this->add_control(
      'tj_label_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .footer-widget.footer-contact-infos .infos-item span' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'heading_address',
      [
        'label'     => __('Address', 'tjcore'),
        'type'      => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_address_typography',
        'selector' => '{{WRAPPER}} .footer-widget.footer-contact-infos .infos-item p',
      ]
    );
    $this->add_control(
      'tj_address_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .footer-widget.footer-contact-infos .infos-item p' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'heading_phone',
      [
        'label'     => __('Phone', 'tjcore'),
        'type'      => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_phone_typography',
        'selector' => '{{WRAPPER}} .footer-widget.footer-contact-infos .infos-item a',
      ]
    );
    $this->add_control(
      'tj_phone_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .footer-widget.footer-contact-infos .infos-item a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_phone_lcolor',
      [
        'label'     => __('Line Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .footer-widget.footer-contact-infos .infos-item a::before' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_contact_list = !empty($settings['tj_contact_list']) ? $settings['tj_contact_list'] : "";

?>

    <div class="footer-widget footer-contact-infos">
      <?php if (!empty($settings['tj_title'])) : ?>
        <div class="footer-title">
          <h4 class="title"><?php echo esc_html($settings['tj_title']); ?></h4>
        </div>
      <?php endif; ?>
      <?php foreach ($tj_contact_list as $info):
        $infoTitle = !empty($info['tj_info_title']) ? $info['tj_info_title'] : "";
        $infoAddress = !empty($info['tj_info_address']) ? $info['tj_info_address'] : "";
        $infoPhone = !empty($info['tj_info_phone']) ? $info['tj_info_phone'] : "";
        $link = !empty($info['tj_info_link']['url']) ? $info['tj_info_link']['url'] : '';
        $href = 'href="' . esc_attr($link) . '"';
      ?>
        <div class="infos-item">
          <?php if (!empty($infoTitle)) : ?>
            <span><?php echo esc_html($infoTitle); ?></span>
          <?php endif; ?>
          <?php if (!empty($infoAddress)) : ?>
            <p><?php echo tj_kses($infoAddress); ?></p>
          <?php endif; ?>
          <?php if (!empty($infoPhone)): ?>
            <a <?php echo $href; ?>>
              <?php echo esc_html($infoPhone); ?>
            </a>
          <?php endif; ?>
        </div>
      <?php endforeach; ?>
    </div>

<?php
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Footer_Contact());
