<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Footer Subscription.
 */
class TJ_Footer_Subscription extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-footer-subscription';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Footer Subscription', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-form-vertical tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'subscription',
      'cta',
      'tj cta',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  // Get Contact Form
  public function get_tj_contact_form()
  {
    if (!class_exists('WPCF7')) {
      return;
    }
    $tj_cfa     = array();
    $tj_cf_args = array('posts_per_page' => -1, 'post_type' => 'wpcf7_contact_form');
    $tj_forms   = get_posts($tj_cf_args);
    $tj_cfa     = ['0' => esc_html__('Select Form', 'tjcore')];
    if ($tj_forms) {
      foreach ($tj_forms as $tj_form) {
        $tj_cfa[$tj_form->ID] = $tj_form->post_title;
      }
    } else {
      $tj_cfa[esc_html__('No contact form found', 'tjcore')] = 0;
    }
    return $tj_cfa;
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {
    $this->start_controls_section(
      '_tj_content',
      [
        'label' => esc_html__('Content', 'tjcore'),
      ]
    );
    // title
    $this->add_control(
      'tj_title',
      [
        'label'   => esc_html__('Title', 'tjcore'),
        'type'    => Controls_Manager::TEXTAREA,
        'default' => esc_html__('subscribe to our Newsletter for latest update', 'tjcore'),
        'rows'    => 3,
        'dynamic' => [
          'active' => true,
        ],
      ]
    );
    // form style
    $this->add_control(
      'form_style',
      [
        'label'   => esc_html__('Form', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'default' => 'shortcode',
        'options' => [
          'shortcode' => esc_html__('Shortcode', 'tjcore'),
          'cf7-form'  => esc_html__('Contact Form 7', 'tjcore'),
        ],
      ]
    );
    // cf7
    $this->add_control(
      'tj_select_form',
      [
        'label'     => esc_html__('Select Form', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '0',
        'separator' => 'before',
        'options'   => $this->get_tj_contact_form(),
        'condition' => [
          'form_style' => 'cf7-form',
        ],
      ]
    );
    // shortcode
    $this->add_control(
      'tj_shortcode',
      [
        'label'       => esc_html__('Shortcode', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'label_block' => true,
        'condition'   => [
          'form_style' => 'shortcode',
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    // title
    $this->start_controls_section(
      '_style_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .footer-widget .title',
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .footer-widget .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .footer-widget .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .footer-widget .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
    // From Style
    $this->start_controls_section(
      'section_tab_area',
      [
        'label' => esc_html__('Form Field Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'cf_field_typo',
        'label'    => esc_html__('Field Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .footer-widget .newsletter-form .form-input input[type=email]',
      ]
    );
    $this->add_control(
      'cf_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .footer-widget .newsletter-form .form-input input[type=email]' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'cf_placeholder_color',
      [
        'label'     => esc_html__('Placeholder Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .footer-widget .newsletter-form .form-input input[type=email]::placeholder'               => 'color: {{VALUE}}',
          '{{WRAPPER}} .footer-widget .newsletter-form .form-input input[type=email]::-moz-placeholder'          => 'color: {{VALUE}}',
          '{{WRAPPER}} .footer-widget .newsletter-form .form-input input[type=email]::-ms-input-placeholder'     => 'color: {{VALUE}}',
          '{{WRAPPER}} .footer-widget .newsletter-form .form-input input[type=email]::-webkit-input-placeholder' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'cf_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .footer-widget .newsletter-form .form-input input[type=email]' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Border::get_type(),
      [
        'name'     => 'cf_borders',
        'label'    => esc_html__('Field Border', 'tjcore'),
        'selector' => '{{WRAPPER}} .footer-widget .newsletter-form .form-input input[type=email]',
      ]
    );
    $this->add_responsive_control(
      'cf_field_radius',
      [
        'label'      => esc_html__('Field Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .footer-widget .newsletter-form .form-input input[type=email]' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_field_padding',
      [
        'label'      => esc_html__('Field Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .footer-widget .newsletter-form .form-input input[type=email]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // button
    $this->start_controls_section(
      'section_tab_button',
      [
        'label' => esc_html__('Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'btn_typo',
        'label'    => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .footer-widget input[type=submit], {{WRAPPER}} .footer-widget .newsletter-form .form-input button',
      ]
    );
    $this->start_controls_tabs('style_tabs_1');
    $this->start_controls_tab(
      'btn_1_button_style_normal',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_1_label_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .footer-widget input[type=submit]'  => 'color: {{VALUE}}',
          '{{WRAPPER}} .footer-widget .newsletter-form .form-input button' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'btn_1_bg',
        'label'    => esc_html__('Background', 'tjcore'),
        'types'    => ['classic', 'gradient'],
        'exclude'  => ['image'],
        'selector' => '{{WRAPPER}} .footer-widget input[type=submit], {{WRAPPER}} .footer-widget .newsletter-form .form-input button',
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'btn_1_button_style_hover',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_label_hover_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .footer-widget input[type=submit]:hover'    => 'color: {{VALUE}}',
          '{{WRAPPER}} .footer-widget .newsletter-form .form-input button:hover'   => 'color: {{VALUE}}',
          '{{WRAPPER}} .footer-widget input[type=submit]:hover i'  => 'color: {{VALUE}}',
          '{{WRAPPER}} .footer-widget .newsletter-form .form-input button:hover i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'btn_hover__bg',
        'label'    => esc_html__('Background', 'tjcore'),
        'types'    => ['classic', 'gradient'],
        'exclude'  => ['image'],
        'selector' => '{{WRAPPER}} .footer-widget input[type=submit]:hover, {{WRAPPER}} .footer-widget .newsletter-form .form-input button:hover',
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'tj_btn_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .footer-widget input[type=submit]'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .footer-widget .newsletter-form .form-input button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => "before"
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/footer-subscription/style-' . $tj_design_style . '.php';
?>


<?php
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Footer_Subscription());
