<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Repeater;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Form.
 */
class TJ_Form extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-form';
  }

  // widget title.
  public function get_title() {
    return __('TJ Form', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-form-horizontal tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'form',
      'form',
      'tj contact',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  // Get Contact Form
  public function get_tj_contact_form() {
    if (!class_exists('WPCF7')) {
      return;
    }
    $tj_cfa     = array();
    $tj_cf_args = array('posts_per_page' => -1, 'post_type' => 'wpcf7_contact_form');
    $tj_forms   = get_posts($tj_cf_args);
    $tj_cfa     = ['0' => esc_html__('Select Form', 'tjcore')];
    if ($tj_forms) {
      foreach ($tj_forms as $tj_form) {
        $tj_cfa[$tj_form->ID] = $tj_form->post_title;
      }
    } else {
      $tj_cfa[esc_html__('No contact form found', 'tjcore')] = 0;
    }
    return $tj_cfa;
  }

  /**
   * widget controls.
   */
  protected function register_controls() {

    // layout Panel
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Form Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // lists
    $this->start_controls_section(
      'section_contact_tab',
      [
        'label'         => esc_html__('Contact info', 'tjcore'),
        'condition' => [
          'tj_design_style!' => ['2', '3', '4']
        ]
      ]
    );
    $this->add_control(
      'tj_title',
      [
        'label'       => esc_html__('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Feel free to get in touch or visit our location.', 'tjcore'),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_hide_contact',
      [
        'label' => esc_html__('Show Contact Info?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => 'yes',
        'separator' => 'before'
      ]
    );
    $repeater = new Repeater();
    $repeater->add_control(
      'tj_contact_icon',
      [
        'label'         => esc_html__('Icon', 'tjcore'),
        'type'          => Controls_Manager::ICONS,
        'fa4compatibility' => 'menu_icon',
        'default'          => [
          'value' => 'fa-solid fa-envelope',
          'library' => 'fa-solid',
        ],
      ]
    );
    $repeater->add_control(
      'tj_contact_title',
      [
        'label'         => esc_html__('Contact info', 'tjcore'),
        'type'          => Controls_Manager::TEXT,
        'default'       => esc_html__('support@solvior.com', 'tjcore'),
      ]
    );
    $repeater->add_control(
      'tj_contact_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_contact_list',
      [
        'label'         => esc_html__('Contact Items', 'tjcore'),
        'type'          => Controls_Manager::REPEATER,
        'fields'        => $repeater->get_controls(),
        'default'       => [
          [
            'tj_contact_title'       => tj_kses('support@solvior.com'),
          ],
          [
            'tj_contact_title'       => tj_kses('Elviraton, CA 48998'),
          ]
        ],
        'title_field' => '{{{ tj_contact_title }}}',
        'condition' => [
          'tj_hide_contact' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();

    // form
    $this->start_controls_section(
      '_tj_form',
      [
        'label' => esc_html__('TJ Form', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_title2',
      [
        'label'       => esc_html__('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Feel free to get in touch or visit our location.', 'tjcore'),
        'label_block' => true,
        'condition' => [
          'tj_design_style!' => ['3', '1']
        ]
      ]
    );
    $this->add_control(
      'tj_select_form',
      [
        'label'     => esc_html__('Select Form', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'separator' => 'before',
        'options'   => $this->get_tj_contact_form(),
      ]
    );
    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Form Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    $this->start_controls_section(
      'section_style_fcontent',
      [
        'label' => esc_html__('Wrapper style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_wrapper_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .contact-form-one.tj-form, {{WRAPPER}} .h9-contact-form_wrap',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'wrapper_border',
        'selector' => '{{WRAPPER}} .contact-form-one.tj-form',
        'condition' => [
          'tj_design_style!' => ['4']
        ]
      ]
    );
    $this->add_responsive_control(
      'tj_wrapper_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .contact-form-one.tj-form' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h9-contact-form_wrap' => 'padding-top: {{TOP}}{{UNIT}};',
          '{{WRAPPER}} .h9-contact-form_wrap .form_title' => 'padding-left: {{LEFT}}{{UNIT}}; padding-right: {{RIGHT}}{{UNIT}};',
          '{{WRAPPER}} .h9-contact-form_wrap .form .row' => 'padding-left: {{LEFT}}{{UNIT}}; padding-right: {{RIGHT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_wrapper_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .contact-form-one.tj-form' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h9-contact-form_wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .contact-form-one.tj-form .title, {{WRAPPER}} .h9-contact-form_wrap .form_title',
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .contact-form-one.tj-form .title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h9-contact-form_wrap .form_title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .contact-form-one.tj-form .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition' => [
          'tj_design_style!' => ['4']
        ]
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .contact-form-one.tj-form .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h9-contact-form_wrap .form_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // contact
    $this->start_controls_section(
      'form_contact_info',
      [
        'label' => esc_html__('Contact style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['4']
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_contact_info_typography',
        'selector' => '{{WRAPPER}} .contact-form-one .contact-item .contact-text',
      ]
    );
    $this->add_control(
      'tj_contact_info_bg_color',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .contact-form-one .contact-item .contact-text' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_contact_info_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .contact-form-one .contact-item .contact-text a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_contact_info_icolor',
      [
        'label'     => __('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .contact-form-one .contact-item .contact-text i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_contact_info_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .contact-form-one .contact-item .contact-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // From Style
    $this->start_controls_section(
      'section_tab_area',
      [
        'label' => esc_html__('Form Field Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'cf_field_typo',
        'label'    => esc_html__('Field Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-form .form-input select, {{WRAPPER}} .tj-form .form-input .nice-select, {{WRAPPER}} .tj-form .form-input input:not([type="submit"]):not([type="radio"]):not([type="checkbox"]), {{WRAPPER}} .tj-form .form-input textarea, {{WRAPPER}} .wpcf7-list-item-label, {{WRAPPER}} .form-group input:not([type=submit]):not([type=radio]):not([type=checkbox]), {{WRAPPER}} .form-group textarea, {{WRAPPER}} .form-group .nice-select',
      ]
    );
    $this->add_responsive_control(
      'cf_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-form .form-input input:not([type="submit"]):not([type="radio"]):not([type="checkbox"])' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input select'                                                                => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input .nice-select'                                                          => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input textarea'                                                              => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input .wpcf7-list-item-label'                                                => 'color: {{VALUE}}',
          '{{WRAPPER}} .form-group input:not([type=submit]):not([type=radio]):not([type=checkbox])'                                                => 'color: {{VALUE}}',
          '{{WRAPPER}} .form-group textarea'                                                => 'color: {{VALUE}}',
          '{{WRAPPER}} .form-group .nice-select'                                                => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_placeholder_color',
      [
        'label'     => esc_html__('Placeholder Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-form .form-input textarea::-moz-placeholder'                                            => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input .nice-select::-moz-placeholder'                                        => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input input::-moz-placeholder'                                               => 'color: {{VALUE}}',

          '{{WRAPPER}} .tj-form .form-input textarea::-ms-input-placeholder'                                       => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input .nice-select::-ms-input-placeholder'                                   => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input input::-ms-input-placeholder'                                          => 'color: {{VALUE}}',

          '{{WRAPPER}} .tj-form .form-input textarea::-webkit-input-placeholder'                                   => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input .nice-select::-webkit-input-placeholder'                               => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input input::-webkit-input-placeholder'                                      => 'color: {{VALUE}}',

          '{{WRAPPER}} input:not([type=submit]):not([type=radio]):not([type=checkbox])::-moz-placeholder'                                               => 'color: {{VALUE}}',
          '{{WRAPPER}} input:not([type=submit]):not([type=radio]):not([type=checkbox])::-ms-input-placeholder'                                          => 'color: {{VALUE}}',
          '{{WRAPPER}} input:not([type=submit]):not([type=radio]):not([type=checkbox])::-webkit-input-placeholder'                                      => 'color: {{VALUE}}',

          '{{WRAPPER}} textarea::-moz-placeholder'                                               => 'color: {{VALUE}}',
          '{{WRAPPER}} textarea::-ms-input-placeholder'                                          => 'color: {{VALUE}}',
          '{{WRAPPER}} textarea::-webkit-input-placeholder'                                      => 'color: {{VALUE}}',

          '{{WRAPPER}} .nice-select::-moz-placeholder'                                               => 'color: {{VALUE}}',
          '{{WRAPPER}} .nice-select::-ms-input-placeholder'                                          => 'color: {{VALUE}}',
          '{{WRAPPER}} .nice-select::-webkit-input-placeholder'                                      => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-form .form-input select'                                                                => 'background: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input .nice-select'                                                          => 'background: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input .form-input input:not([type="submit"]):not([type="radio"]):not([type="checkbox"])' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input .form-input textarea'                                                              => 'background-color: {{VALUE}}',
          '{{WRAPPER}} input:not([type=submit]):not([type=radio]):not([type=checkbox])'                                                              => 'background-color: {{VALUE}}',
          '{{WRAPPER}} textarea'                                                              => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .nice-select'                                                              => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Border::get_type(),
      [
        'name'     => 'cf_borders',
        'label'    => esc_html__('Field Border', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-form .form-input select, {{WRAPPER}} .tj-form .form-input .nice-select, {{WRAPPER}} .tj-form .form-input input:not([type="submit"]):not([type="range"]):not([type="radio"]):not([type="checkbox"]), {{WRAPPER}} .tj-form .form-input textarea, {{WRAPPER}} input:not([type=submit]):not([type=radio]):not([type=checkbox]), {{WRAPPER}} textarea, {{WRAPPER}} .nice-select',
      ]
    );
    $this->add_control(
      'cf_focus_border_color',
      [
        'label'     => esc_html__('Focus Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-form .form-input select:focus' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input .nice-select:focus' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input input:not([type="submit"]):not([type="range"]):not([type="radio"]):not([type="checkbox"]):focus' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .tj-form .form-input textarea:focus' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} input:not([type=submit]):not([type=radio]):not([type=checkbox]):focus' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} textarea:focus' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .nice-select:focus' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_field_radius',
      [
        'label'      => esc_html__('Field Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-form .form-input select'   => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input .nice-select' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input input:not([type="submit"]):not([type="radio"]):not([type="checkbox"])' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input textarea' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} input:not([type=submit]):not([type=radio]):not([type=checkbox])' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} textarea' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .nice-select' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name'     => 'cf_field_shadow',
        'label'    => esc_html__('Field Shadow', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-form .form-input select, {{WRAPPER}} .tj-form .form-input .nice-select, {{WRAPPER}} .tj-form .form-input input:not([type="submit"]):not([type="radio"]):not([type="checkbox"]), {{WRAPPER}} .tj-form .form-input textarea, {{WRAPPER}} input:not([type=submit]):not([type=radio]):not([type=checkbox]), {{WRAPPER}} textarea, {{WRAPPER}} .nice-select',
      ]
    );
    $this->add_responsive_control(
      'cf_field_padding',
      [
        'label'      => esc_html__('Field Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-form .form-input select' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input .nice-select' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input input:not([type="submit"]):not([type="radio"]):not([type="checkbox"])' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} input:not([type="submit"]):not([type="radio"]):not([type="checkbox"])' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} textarea' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .nice-select' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_field_margin',
      [
        'label'      => esc_html__('Field Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-form .form-input select'   => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input .nice-select' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input input:not([type="submit"]):not([type="radio"]):not([type="checkbox"])' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .form-group' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_filed_height',
      [
        'label'      => esc_html__('Input/Select Height', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 8,
            'max'  => 100,
            'step' => 1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .tj-form .form-input input[type="text"]'   => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input input[type="email"]'  => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input input[type="url"]'    => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input input[type="tel"]'    => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input input[type="number"]' => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input input[type="date"]'   => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input select'               => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .tj-form .form-input .nice-select'         => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} input:not([type="submit"]):not([type="radio"]):not([type="checkbox"])'         => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .nice-select'         => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_message_height',
      [
        'label'      => esc_html__('Textarea Height', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 8,
            'max'  => 500,
            'step' => 1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .tj-form .form-input textarea' => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} textarea' => 'height: {{SIZE}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->add_responsive_control(
      'text_area_box_radius',
      [
        'label'      => esc_html__('Textarea Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-form .form-input textarea' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} textarea' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'cf_textarea_typo',
        'label'    => esc_html__('Textarea Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-form .form-input textarea, {{WRAPPER}} textarea',
      ]
    );
    $this->add_responsive_control(
      'cf_message_padding',
      [
        'label'      => esc_html__('Textarea Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-form .form-input textarea' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} textarea' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_message_margin',
      [
        'label'      => esc_html__('Textarea Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-form .form-input textarea' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .form-group textarea' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();


    //Button
    $this->start_controls_section(
      '_heading_hero_btn_style',
      [
        'label' => __('Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'btn_typography',
        'selector' => '{{WRAPPER}} .tj-primary-btn, {{WRAPPER}} button[type=submit], {{WRAPPER}} input[type=submit]',
      ]
    );
    $this->start_controls_tabs('btn_style_tabs');
    $this->start_controls_tab(
      'btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn .btn_text' => 'color: {{VALUE}}',
          '{{WRAPPER}} button[type=submit]' => 'color: {{VALUE}}',
          '{{WRAPPER}} input[type=submit]' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn .btn_icon' => 'color: {{VALUE}}',
          '{{WRAPPER}} button[type=submit] i' => 'color: {{VALUE}}',
          '{{WRAPPER}} input[type=submit] i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_bgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn .btn_inner::before' => 'background-color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style!' => ['4']
        ]
      ]
    );
    $this->add_control(
      'btn_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'background-color: {{VALUE}}',
          '{{WRAPPER}}  button[type=submit]' => 'background-color: {{VALUE}}',
          '{{WRAPPER}}  input[type=submit]' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_hcolor',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn:hover .btn_text' => 'color: {{VALUE}}',
          '{{WRAPPER}} input[type=submit]:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} button[type=submit]:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_hcolor',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover .btn_icon' => 'color: {{VALUE}}',
          '{{WRAPPER}} input[type=submit]:hover i' => 'color: {{VALUE}}',
          '{{WRAPPER}} button[type=submit]:hover i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_hbgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover .btn_inner::before' => 'background-color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style!' => ['4']
        ]
      ]
    );
    $this->add_control(
      'btn_bg_hcolor',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} button[type=submit]:hover' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} input[type=submit]:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/form/style-' . $tj_design_style . '.php';
?>


<?php
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Form());
