<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Testimonials.
 */
class TJ_Hero_Banner_Slider extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-hero-banner-slider';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Hero Banner Slider', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-banner tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script', 'swiper'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style', 'swiper'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'hero',
      'banner',
      'hero banner',
      'hero banner slider',
      'tj hero',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {

    // layout Panel
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Slider Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Slider Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // _tj_section_content
    $this->start_controls_section(
      '_tj_banner_content',
      [
        'label' => esc_html__('Banner Content', 'tjcore'),
      ]
    );
    $repeater = new Repeater();
    $repeater->add_control(
      'tj_slider_image',
      [
        'label'   => esc_html__('Slider Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $repeater->add_control(
      'tj_slider_subtitle',
      [
        'label'       => esc_html__('Subtitle', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Type your subtitle here', 'tjcore'),
        'rows' => 3,
      ]
    );
    $repeater->add_control(
      'tj_slider_title',
      [
        'label'       => esc_html__('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Type your title here', 'tjcore'),
        'rows' => 3,
      ]
    );
    $repeater->add_control(
      'tj_title_tag',
      [
        'label'     => esc_html__('Title Tag', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'options' => [
          'h1' => 'H1',
          'h2' => 'H2',
          'h3' => 'H3',
          'h4' => 'H4',
          'h5' => 'H5',
          'h6' => 'H6',
          'div' => 'div',
          'span' => 'span',
          'p' => 'p',
        ],
        'default'   => 'h1',
      ]
    );
    $repeater->add_control(
      'tj_show_awards',
      [
        'label' => esc_html__('Show Highlighter', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Show', 'tjcore'),
        'label_off' => esc_html__('Hide', 'tjcore'),
        'return_value' => 'yes',
        'default' => 'yes',
        'separator' => "before"
      ]
    );
    $repeater->add_control(
      'tj_slider_awards_images',
      [
        'label' => esc_html__('Highlighter Images', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_show_awards' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'tj_slider_awards_text',
      [
        'label' => esc_html__('Highlighter Text', 'tjcore'),
        'type' => Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Type your awards text here', 'tjcore'),
        'condition' => [
          'tj_show_awards' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'tj_button_show',
      [
        'label'        => esc_html__('Show button?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
        'separator' => "before"
      ]
    );
    $repeater->add_control(
      'tj_hero_banner_btn_text',
      [
        'label'     => esc_html__('Text', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__('Get Started Now', 'tjcore'),
        'dynamic'   => [
          'active' => true,
        ],
        'condition' => [
          'tj_button_show' => 'yes',
        ],
      ]
    );
    $repeater->add_control(
      'tj_btn_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'btn_icon',
        'default'          => [
          'value'   => 'tji-arrow-right',
          'library' => 'tji',
        ],
        'skin'             => 'inline',
        'label_block'      => false,
        'condition'        => [
          'tj_button_show' => 'yes',
        ],
      ]
    );
    $repeater->add_control(
      'tj_hero_banner_btn_link_type',
      [
        'label'     => esc_html__('Link Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'options'   => [
          '1' => esc_html__('Custom Link', 'tjcore'),
          '2' => esc_html__('Internal Page', 'tjcore'),
        ],
        'default'   => '1',
        'separator' => 'before',
        'condition' => [
          'tj_button_show' => 'yes',
        ],
      ]
    );
    $repeater->add_control(
      'tj_hero_banner_btn_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'condition'   => [
          'tj_button_show'               => 'yes',
          'tj_hero_banner_btn_link_type' => '1',
        ],
        'label_block' => true,
      ]
    );
    $repeater->add_control(
      'tj_hero_banner_btn_page_link',
      [
        'label'       => esc_html__('Select Page', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'tj_button_show'               => 'yes',
          'tj_hero_banner_btn_link_type' => '2',
        ],
      ]
    );
    $this->add_control(
      'tj_banner_contents',
      [
        'label'       => esc_html__('Slider Content', 'tjcore'),
        'type'        => Controls_Manager::REPEATER,
        'fields'      => $repeater->get_controls(),
        'default'     => [
          [
            'tj_slider_subtitle' => tj_kses('number #1 solver agency', 'tjcore'),
            'tj_slider_title' => esc_html__('Transform your business with expert consultation', 'tjcore'),
            'tj_slider_awards_text' => tj_kses('Transform your business growth with expert consultancy services our team of seasoned consultants unparalleled.', 'tjcore'),
          ],
          [
            'tj_slider_subtitle' => tj_kses('number #1 solver agency', 'tjcore'),
            'tj_slider_title' => esc_html__('Transform your business with expert consultation', 'tjcore'),
            'tj_slider_awards_text' => tj_kses('Transform your business growth with expert consultancy services our team of seasoned consultants unparalleled.', 'tjcore'),
          ],
          [
            'tj_slider_subtitle' => tj_kses('number #1 solver agency', 'tjcore'),
            'tj_slider_title' => esc_html__('Transform your business with expert consultation', 'tjcore'),
            'tj_slider_awards_text' => tj_kses('Transform your business growth with expert consultancy services our team of seasoned consultants unparalleled.', 'tjcore'),
          ],
        ],
        'title_field' => '{{{ tj_slider_title }}}',
        'condition' => [
          'tj_design_style!' => ['2']
        ]
      ]
    );
    // repeater end  

    // repeater 2
    $repeater2 = new Repeater();
    $repeater2->add_control(
      'tj_slider2_image',
      [
        'label'   => esc_html__('Slider Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $repeater2->add_control(
      'tj_slider2_subtitle',
      [
        'label'       => esc_html__('Subtitle', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'placeholder' => esc_html__('Type your subtitle here', 'tjcore'),
        'label_block' => true,
      ]
    );
    $repeater2->add_control(
      'tj_slider2_subtitle_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'subtitle_icon',
        'skin'             => 'inline',
        'label_block'      => false,
      ]
    );
    $repeater2->add_control(
      'tj_slider2_title',
      [
        'label'       => esc_html__('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Type your title here', 'tjcore'),
        'rows' => 3,
      ]
    );
    $repeater2->add_control(
      'tj_title_tag2',
      [
        'label'     => esc_html__('Title Tag', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'options' => [
          'h1' => 'H1',
          'h2' => 'H2',
          'h3' => 'H3',
          'h4' => 'H4',
          'h5' => 'H5',
          'h6' => 'H6',
          'div' => 'div',
          'span' => 'span',
          'p' => 'p',
        ],
        'default'   => 'h1',
      ]
    );
    $repeater2->add_control(
      'tj_slider2_desc',
      [
        'label'       => esc_html__('Description', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Type your description here', 'tjcore'),
      ]
    );
    $repeater2->add_control(
      'tj_button2_show',
      [
        'label'        => esc_html__('Show button?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
        'separator' => "before"
      ]
    );
    $repeater2->add_control(
      'tj_slider2_btn_text',
      [
        'label'     => esc_html__('Text', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__('Free consultation', 'tjcore'),
        'dynamic'   => [
          'active' => true,
        ],
        'condition' => [
          'tj_button2_show' => 'yes',
        ],
      ]
    );
    $repeater2->add_control(
      'tj_slider2_btn_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'slider2_btn_icon',
        'default'          => [
          'value'   => 'tji-arrow-right',
          'library' => 'tji',
        ],
        'skin'             => 'inline',
        'label_block'      => false,
        'condition'        => [
          'tj_button2_show' => 'yes',
        ],
      ]
    );
    $repeater2->add_control(
      'tj_slider2_btn_link_type',
      [
        'label'     => esc_html__('Link Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'options'   => [
          '1' => esc_html__('Custom Link', 'tjcore'),
          '2' => esc_html__('Internal Page', 'tjcore'),
        ],
        'default'   => '1',
        'separator' => 'before',
        'condition' => [
          'tj_button2_show' => 'yes',
        ],
      ]
    );
    $repeater2->add_control(
      'tj_slider2_btn_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'condition'   => [
          'tj_button2_show'               => 'yes',
          'tj_slider2_btn_link_type' => '1',
        ],
        'label_block' => true,
      ]
    );
    $repeater2->add_control(
      'tj_slider2_btn_page_link',
      [
        'label'       => esc_html__('Select Page', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'tj_button2_show'               => 'yes',
          'tj_slider2_btn_link_type' => '2',
        ],
      ]
    );

    $repeater2->add_control(
      'tj_contact_btn_show',
      [
        'label'        => esc_html__('Show button 02?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
        'separator' => "before"
      ]
    );
    $repeater2->add_control(
      'tj_contact_btn_text',
      [
        'label'     => esc_html__('Text', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__('1-888-452-1505', 'tjcore'),
        'dynamic'   => [
          'active' => true,
        ],
        'condition' => [
          'tj_contact_btn_show' => 'yes',
        ],
      ]
    );
    $repeater2->add_control(
      'tj_contact_btn_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'contact_btn_icon',
        'default'          => [
          'value'   => 'tji-phone',
          'library' => 'tji',
        ],
        'skin'             => 'inline',
        'label_block'      => false,
        'condition'        => [
          'tj_contact_btn_show' => 'yes',
        ],
      ]
    );
    $repeater2->add_control(
      'tj_contact_btn_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('tel:18884521505', 'tjcore'),
        'condition'   => [
          'tj_contact_btn_show'               => 'yes',
        ],
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_slider2_content',
      [
        'label'       => esc_html__('Slider Content', 'tjcore'),
        'type'        => Controls_Manager::REPEATER,
        'fields'      => $repeater2->get_controls(),
        'default'     => [
          [
            'tj_slider2_subtitle' => tj_kses('number #1 solver agency'),
            'tj_slider2_title' => esc_html__('Smartest solutions for agile companies', 'tjcore'),
            'tj_slider2_desc' => tj_kses('Transform your business with expert consultancy services our team of seasoned consultants unparalleled.'),
          ],
          [
            'tj_slider2_subtitle' => tj_kses('number #1 solver agency', 'tjcore'),
            'tj_slider2_title' => esc_html__('Cutting-Edge solution for businesses', 'tjcore'),
            'tj_slider2_desc' => tj_kses('Transform your business with expert consultancy services our team of seasoned consultants unparalleled.'),
          ],
          [
            'tj_slider2_subtitle' => tj_kses('number #1 solver agency', 'tjcore'),
            'tj_slider2_title' => esc_html__('Intelligent solutions for modern business', 'tjcore'),
            'tj_slider2_desc' => tj_kses('Transform your business with expert consultancy services our team of seasoned consultants unparalleled.'),
          ],
        ],
        'condition' => [
          'tj_design_style!' => ['1']
        ]
      ]
    );
    $this->end_controls_section();

    // slider settings
    $this->start_controls_section(
      '__tj_slider_settings',
      [
        'label' => esc_html__('Slider Settings', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'slide_loop',
      [
        'label'        => esc_html__('Is Loop?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to make this slider item loop?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );
    $this->add_control(
      'slide_nav',
      [
        'label'        => esc_html__('Is Navigation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to show slider navigation?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );
    $this->add_control(
      'slide_autoplay',
      [
        'label'        => esc_html__('Is Autoplay?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to make this slider auto play?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );
    $this->add_control(
      'slide_autoplay_Delay',
      [
        'label'       => esc_html__('Autoplay Delay', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'description' => esc_html__('Set slider autoplay delay.', 'tjcore'),
        'min'         => 1000,
        'max'         => 10000,
        'step'        => 100,
        'default'     => 5000,
        'condition'   => [
          'slide_autoplay' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();
    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Section', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .tj-hero-slider, {{WRAPPER}} .h7-hero-slider .tj-hero-shape',
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => __('Overlay', 'tjcore'),
          ],
        ],
        'name'     => 'tj_section_background_overlay',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .tj-slider-section::before',
      ]
    );
    $this->add_responsive_control(
      'tj_slide_height',
      [
        'label' => esc_html__('Height', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'responsive' => true,
        'size_units' => ['px', '%', 'em', 'rem', 'vw', 'custom'],
        'range' => [
          '%' => [
            'min' => 1,
            'max' => 100,
          ],
          'px' => [
            'min' => 1,
            'max' => 1000,
          ],
          'vw' => [
            'min' => 1,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-slider-section' => 'min-height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .slider-wrapper .slider-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_section_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-slider-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h7-hero-slider' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // subtitle
    $this->start_controls_section(
      '_style_subtitle',
      [
        'label' => esc_html__('Subtitle', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_subtitle_typography',
        'selector' => '{{WRAPPER}} .tj-hero-slider.style-1 .sub-title, {{WRAPPER}} .slider-content .sub-title',
      ]
    );
    $this->add_control(
      'tj_subtitle_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-hero-slider.style-1 .sub-title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .slider-content .sub-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_subtitle_dot_color',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-hero-slider.style-1 .sub-title' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .slider-content .sub-title' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_subtitle_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-hero-slider.style-1 .sub-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .slider-content .sub-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_subtitle_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-hero-slider.style-1 .sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .slider-content .sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .slider-wrapper .slider-content .slider-title, {{WRAPPER}} .slider-content .slider-title',
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-wrapper .slider-content .slider-title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .slider-content .slider-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .slider-wrapper .slider-content .slider-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .slider-content .slider-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .slider-wrapper .slider-content .slider-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .slider-content .slider-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // desc
    $this->start_controls_section(
      '_style_desc',
      [
        'label' => esc_html__('Description', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['1']
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_desc_typography',
        'selector' => '{{WRAPPER}} .slider-content .desc',
      ]
    );
    $this->add_control(
      'tj_desc_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-content .desc' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_desc_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .slider-content .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_desc_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .slider-content .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    //Button
    $this->start_controls_section(
      '_heading_hero_btn_style',
      [
        'label' => __('Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'btn_typography',
        'selector' => '{{WRAPPER}} .tj-primary-btn',
      ]
    );
    $this->start_controls_tabs('btn_style_tabs');
    $this->start_controls_tab(
      'btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn .btn_text' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn .btn_icon' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_bgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn .btn_inner::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_hcolor',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn:hover .btn_text' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_hcolor',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover .btn_icon' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_hbgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover .btn_inner::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_bg_hcolor',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();

    // button 02
    $this->start_controls_section(
      '_heading_hero_btn2_style',
      [
        'label' => __('Contact Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['1']
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'btn2_typography',
        'selector' => '{{WRAPPER}} .slider-content .hero-btn .text',
      ]
    );
    $this->start_controls_tabs('btn2_style_tabs');
    $this->start_controls_tab(
      'btn2_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn2_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-content .hero-btn .text' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn2_icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-content .hero-btn .icon' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn2_icon_bgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-content .hero-btn .icon' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style2_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn2_text_hcolor',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} ..slider-content .hero-btn:hover .text' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn2_icon_hcolor',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-content .hero-btn:hover .icon' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn2_icon_hbgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-content .hero-btn:hover .icon' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();

    // button box style
    $this->start_controls_section(
      'section_style_fcontent',
      [
        'label' => esc_html__('Bottom Box style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['2']
        ]
      ]
    );
    $this->add_control(
      'wrap_text_hcolor',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-feature-wrap .slider-feature-box .desc' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_wrapper_box_background',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-feature-wrap .slider-feature-box' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'wrapper_border',
        'selector' => '{{WRAPPER}} .slider-feature-wrap .slider-feature-box',
      ]
    );
    $this->add_responsive_control(
      'tj_wrapper_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .slider-feature-wrap .slider-feature-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_wrapper_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .slider-feature-wrap .slider-feature-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // pagination
    $this->start_controls_section(
      'section_style_pagination',
      [
        'label' => esc_html__('Slider Progress style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['2']
        ]
      ]
    );
    $this->add_control(
      'pagination_hcolor',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-hero-slider.style-1 .tj-sw-pagination, .tj-hero-slider.style-1 .tj-btn' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_pagination_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .tj-hero-slider.style-1 .tj-sw-pagination .dash .dash-inner',
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/hero-banner-slider/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Hero_Banner_Slider());
