<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Hero Banner.
 */
class TJ_Hero_Banner extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-hero-banner';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Hero Banner', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-banner tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'hero',
      'hero banner',
      'tj hero',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {
    // tj banner tab
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Style', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Banner Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
          5 => esc_html__('Style 05', 'tjcore'),
          6 => esc_html__('Style 06', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->add_control(
      'tj_hero_banner_parallax',
      [
        'label'        => esc_html__('Enable hero parallax?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator' => 'before',
        'condition' => [
          'tj_design_style' => ['1'],
        ]
      ]
    );
    $this->end_controls_section();

    // _tj_hero_banner_content
    $this->start_controls_section(
      '_tj_hero_banner_content',
      [
        'label' => esc_html__('Banner Content', 'tjcore'),
      ]
    );
    // subtitle
    $this->add_control(
      'tj_hero_banner_subtitle',
      [
        'label'     => esc_html__('Subtitle', 'tjcore'),
        'type'      => Controls_Manager::TEXTAREA,
        'default'   => tj_kses('NUMBER <span>#1</span> SOLVER AGENCY'),
        'rows'      => '2',
        'condition' => [
          'tj_design_style!' => ['1', '2', '4', '6'],
        ]
      ]
    );
    $this->add_control(
      'tj_subtitle_animation',
      [
        'label'        => esc_html__('Enable Subtitle Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'condition' => [
          'tj_design_style!' => ['1', '2', '4', '6'],
        ]
      ]
    );
    $this->add_control(
      'tj_subtitle_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition'  => [
          'tj_design_style!' => ['1', '2', '4', '6'],
          'tj_subtitle_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_subtitle_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_design_style!' => ['1', '2', '4', '6'],
          'tj_subtitle_animation' => 'yes',
        ],
      ]
    );

    // title
    $this->add_control(
      'tj_hero_banner_title',
      [
        'label'     => esc_html__('Title', 'tjcore'),
        'type'      => Controls_Manager::TEXTAREA,
        'default'   => tj_kses('Maximise growth qualified business <span class="active-color">consulting</span>', 'tjcore'),
        'rows'      => '5',
        'separator' => 'before',
      ]
    );
    // title animation
    $this->add_control(
      'tj_title_animation',
      [
        'label'        => esc_html__('Enable Title Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
      ]
    );

    // title tag
    $this->add_control(
      'tj_hero_banner_title_tag',
      [
        'label'     => esc_html__('Title HTML Tag', 'tjcore'),
        'type'      => Controls_Manager::CHOOSE,
        'options'   => [
          'h1' => [
            'title' => esc_html__('H1', 'tjcore'),
            'icon'  => 'eicon-editor-h1',
          ],
          'h2' => [
            'title' => esc_html__('H2', 'tjcore'),
            'icon'  => 'eicon-editor-h2',
          ],
          'h3' => [
            'title' => esc_html__('H3', 'tjcore'),
            'icon'  => 'eicon-editor-h3',
          ],
          'h4' => [
            'title' => esc_html__('H4', 'tjcore'),
            'icon'  => 'eicon-editor-h4',
          ],
          'h5' => [
            'title' => esc_html__('H5', 'tjcore'),
            'icon'  => 'eicon-editor-h5',
          ],
          'h6' => [
            'title' => esc_html__('H6', 'tjcore'),
            'icon'  => 'eicon-editor-h6',
          ],
        ],
        'default'   => 'h1',
        'toggle'    => false,
        'separator' => 'before',
      ]
    );

    // desc
    $this->add_control(
      'tj_hero_banner_description',
      [
        'label' => esc_html__('Description', 'tjcore'),
        'type' => Controls_Manager::TEXTAREA,
        'rows' => 6,
        'default' => esc_html__('Transform your business with expert consultancy services our team of seasoned consultants unparalleled.', 'tjcore'),
        'placeholder' => esc_html__('Type your description here', 'tjcore'),
      ]
    );
    // desc animation
    $this->add_control(
      'tj_description_animation',
      [
        'label'        => esc_html__('Enable Description Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
      ]
    );
    $this->add_control(
      'tj_description_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition'  => [
          'tj_description_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_description_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_description_animation' => 'yes',
        ],
      ]
    );

    // scroll down
    $this->add_control(
      'tj_scroll_down_show',
      [
        'label'        => esc_html__('Show scroll down?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
        'separator' => 'before',
        'condition'  => [
          'tj_design_style!' => ['2', '3', '4', '5', '6'],
        ],
      ]
    );
    $this->add_control(
      'tj_hero_banner_scroll_text',
      [
        'label'  => esc_html__('Scroll Text', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'default' => esc_html__('SCROLL', 'tjcore'),
        'condition' => [
          'tj_scroll_down_show' => 'yes',
          'tj_design_style!' => ['2', '3', '4', '5', '6'],
        ]
      ]
    );
    $this->add_control(
      'tj_banner_scroll_link',
      [
        'label' => esc_html__('Scroll Link', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'default' => esc_attr("#"),
        'label_block' => true,
        'condition' => [
          'tj_scroll_down_show' => 'yes',
          'tj_design_style!' => ['2', '3', '4', '5', '6'],
        ]
      ]
    );
    $this->end_controls_section();

    // button    
    $this->start_controls_section(
      'tj_hero_btn',
      [
        'label'     => esc_html__('Button', 'tjcore'),
        'condition' => [
          'tj_design_style!' => ['4']
        ],
      ]
    );
    $this->add_control(
      'tj_button_show',
      [
        'label'        => esc_html__('Show button?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );
    $this->add_control(
      'tj_btn_text',
      [
        'label'     => esc_html__('Text', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__('Free consultation', 'tjcore'),
        'dynamic'   => [
          'active' => true,
        ],
        'condition' => [
          'tj_button_show' => 'yes',
          'tj_design_style!' => ['2']
        ],
      ]
    );
    $this->add_control(
      'tj_btn_icon',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'default' => [
          'value' => 'tji-arrow-right',
          'library' => 'tji',
        ],
        'skin' => 'inline',
        'label_block' => false
      ]
    );
    $this->add_control(
      'tj_btn_link_type',
      [
        'label'     => esc_html__('Link Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'options'   => [
          '1' => esc_html__('Custom Link', 'tjcore'),
          '2' => esc_html__('Internal Page', 'tjcore'),
        ],
        'default'   => '1',
        'separator' => 'before',
        'condition' => [
          'tj_button_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_btn_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'condition'   => [
          'tj_button_show' => 'yes',
          'tj_btn_link_type' => '1',
        ],
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_btn_page_link',
      [
        'label'       => esc_html__('Select Page', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'tj_button_show'  => 'yes',
          'tj_btn_link_type' => '2',
        ],
      ]
    );
    // btn animation
    $this->add_control(
      'tj_button_animation',
      [
        'label'        => esc_html__('Enable Button Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
        'condition'    => [
          'tj_button_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_button_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_button_show'      => 'yes',
          'tj_button_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_button_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_button_show'      => 'yes',
          'tj_button_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    // button 2
    $this->start_controls_section(
      'tj_hero_text_btn_tab',
      [
        'label'     => esc_html__('Button 2', 'tjcore'),
        'condition'    => [
          'tj_design_style!'      => ['1', '2', '3', '4', '6'],
        ],
      ]
    );
    $this->add_control(
      'tj_hero_text_btn',
      [
        'label'     => esc_html__('Text', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__('Join us now', 'tjcore'),
        'dynamic'   => [
          'active' => true,
        ],
      ]
    );
    $this->add_control(
      'tj_hero_text_btn_link',
      [
        'label' => esc_html__('Link', 'tjcore'),
        'type' => Controls_Manager::URL,
        'dynamic' => [
          'active' => true,
        ],
        'default' => [
          'url' => '',
        ],
      ]
    );

    $this->add_control(
      'tj_hero_text_btn_icon',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'default' => [
          'value' => 'tji-angle-right',
          'library' => 'tj',
        ],
        'skin' => 'inline',
        'label_block' => false
      ]
    );

    $this->end_controls_section();
    // thumbnails
    $this->start_controls_section(
      'tj_hero_thumbnails',
      [
        'label'     => esc_html__('Thumbnails', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_hero_banner_image',
      [
        'label' => esc_html__('Banner Image', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition'    => [
          'tj_design_style!'      => ['6'],
        ],
      ]
    );
    $this->add_control(
      'tj_hero_bg_image',
      [
        'label' => esc_html__('Background Image', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition'    => [
          'tj_design_style!'      => ['1', '2', '3'],
        ],
      ]
    );
    // image animation
    $this->add_control(
      'tj_image_animation',
      [
        'label'        => esc_html__('Enable Image Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
        'condition'    => [
          'tj_design_style!'      => ['6'],
        ],
      ]
    );
    $this->add_control(
      'tj_image_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_image_animation' => 'yes',
          'tj_design_style!'      => ['6'],
        ],
      ]
    );
    $this->add_control(
      'tj_image_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_image_animation' => 'yes',
          'tj_design_style!'      => ['6'],
        ],
      ]
    );

    $this->add_control(
      'tj_shape_show',
      [
        'label'        => esc_html__('Enable shape image?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '1',
        'separator'    => 'before',
        'condition'  => [
          'tj_design_style!'      => ['3', '4', '5', '6'],
        ],
      ]
    );

    $this->add_control(
      'tj_small_shape',
      [
        'label' => esc_html__('Small Shape Image', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
        'default'     => [
          'url' => esc_url(SOLVIOR_ASSETS_IMAGES_URL . '/icons/h3-shape-1.svg'),
        ],
        'condition'  => [
          'tj_design_style!'      => ['1', '3', '4', '5', '6'],
          'tj_shape_show' => 'yes',
        ],
      ]
    );

    $this->add_control(
      'tj_large_shape',
      [
        'label' => esc_html__('Large Shape Image', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
        'default'     => [
          'url' => esc_url(SOLVIOR_ASSETS_IMAGES_URL . '/shapes/h2-hero-shapes.png'),
        ],
        'condition'  => [
          'tj_design_style!'      => ['1', '3', '4', '5', '6'],
          'tj_shape_show' => 'yes',
        ],
      ]
    );

    // shape 1
    $this->add_control(
      'tj_shape_1_show',
      [
        'label'        => esc_html__('Enable shape 01 image?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '1',
        'separator'    => 'before',
        'condition'  => [
          'tj_design_style!'      => ['1', '2', '4'],
        ],
      ]
    );
    $this->add_control(
      'tj_shape_1_image',
      [
        'label' => esc_html__('Shape 1 Image', 'tjcore'),
        'type' => Controls_Manager::MEDIA,

        'condition'  => [
          'tj_design_style!'      => ['1', '2', '4'],
          'tj_shape_1_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_shape_1_animation',
      [
        'label'        => esc_html__('Enable Shape 1 Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'condition'    => [
          'tj_design_style!'      => ['1', '2', '4'],
          'tj_shape_1_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_shape_1_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_design_style!'      => ['1', '2', '4'],
          'tj_shape_1_show' => 'yes',
          'tj_shape_1_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_shape_1_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_design_style!'      => ['1', '2', '4'],
          'tj_shape_1_show' => 'yes',
          'tj_shape_1_animation' => 'yes',
        ],
      ]
    );

    // shape 2
    $this->add_control(
      'tj_shape_2_show',
      [
        'label'        => esc_html__('Enable shape 02 image?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '1',
        'separator'    => 'before',
        'condition'  => [
          'tj_design_style!'      => ['1', '2', '4', '5', '6'],
        ],
      ]
    );
    $this->add_control(
      'tj_shape_2_image',
      [
        'label' => esc_html__('Shape 2 Image', 'tjcore'),
        'type' => Controls_Manager::MEDIA,

        'condition'  => [
          'tj_design_style!'      => ['1', '2', '4', '5', '6'],
          'tj_shape_2_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_shape_2_animation',
      [
        'label'        => esc_html__('Enable Shape 2 Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'condition'    => [
          'tj_design_style!'      => ['1', '2', '4', '5', '6'],
          'tj_shape_2_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_shape_2_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_design_style!'      => ['1', '2', '4', '5', '6'],
          'tj_shape_2_show' => 'yes',
          'tj_shape_2_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_shape_2_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_design_style!'      => ['1', '2', '4', '5', '6'],
          'tj_shape_2_show' => 'yes',
          'tj_shape_2_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    // video popup
    $this->start_controls_section(
      'tj_video_tab',
      [
        'label' => esc_html__('Video Button', 'tjcore'),
        'condition' => [
          'tj_design_style!' => ['2', '4', '5', '6'],
        ]
      ]
    );
    $this->add_control(
      'tj_video_icon',
      [
        'label' => esc_html__('Video Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'default' => [
          'value' => 'tji-play',
          'library' => 'tji',
        ],
        'fa4compatibility' => 'video_icon',
      ]
    );
    $this->add_control(
      'tj_video_image',
      [
        'label' => esc_html__('Circle Image', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_design_style!' => ['3']
        ]
      ]
    );
    $this->add_control(
      'tj_video_link',
      [
        'label' => esc_html__('Video Link', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'default' => esc_html__('https://www.youtube.com/watch?v=MLpWrANjFbI', 'tjcore'),
        'placeholder' => esc_html__('Type your video link here', 'tjcore'),
        'label_block' => true
      ]
    );
    $this->add_control(
      'tj_video_text',
      [
        'label' => esc_html__('Video Text', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'default' => esc_html__('Play our reels', 'tjcore'),
        'condition' => [
          'tj_design_style!' => ['1', '2']
        ]
      ]
    );
    $this->end_controls_section();

    // highlight
    $this->start_controls_section(
      'tj_highlight_tab',
      [
        'label' => esc_html__('Highlight', 'tjcore'),
        'condition' => [
          'tj_design_style!' => ['1', '2', '5', '6'],
        ]
      ]
    );
    $this->add_control(
      'tj_highlight_show',
      [
        'label'        => esc_html__('Enable banner highlight?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '1',
      ]
    );
    $this->add_control(
      'tj_highlight_content',
      [
        'label' => esc_html__('Content', 'tjcore'),
        'type' => Controls_Manager::WYSIWYG,
        'default' => tj_kses('<ul class="images-thumb">
            <li><img src="assets/images/about/thumb-1.png" alt="Images"></li>
            <li><img src="assets/images/about/thumb-2.png" alt="Images"></li>
            <li><img src="assets/images/about/thumb-3.png" alt="Images"></li>
            <li class="plus"><i class="fa-sharp fa-solid fa-plus"></i></li>
          </ul>'),
        'condition' => [
          'tj_highlight_show' => 'yes',
          'tj_design_style!' => ['4'],
        ]
      ]
    );
    $this->add_control(
      'tj_highlight_content2',
      [
        'label' => esc_html__('Content', 'tjcore'),
        'type' => Controls_Manager::WYSIWYG,
        'default' => tj_kses('<div class="circle-wrap">
            <img class="rotate-image" src="assets/images/shapes/h5-about-circle.png" alt="image">
            <span class="logo-icon"><img src="assets/images/icons/logo-icon.svg" alt=""></span>
          </div>'),
        'condition' => [
          'tj_highlight_show' => 'yes',
          'tj_design_style!' => ['3'],
        ]
      ]
    );
    $this->add_control(
      'tj_highlight_title',
      [
        'label' => esc_html__('Text', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'default' => tj_kses("<span>39K+</span> Happy clients all over world."),
        'label_block' =>  true,
        'condition' => [
          'tj_highlight_show' => 'yes',
          'tj_design_style!' => ['4'],
        ]
      ]
    );
    $this->end_controls_section();

    // tj_marquee_tab
    $this->start_controls_section(
      'tj_marquee_tab',
      [
        'label' => esc_html__('Marquee', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
        'condition' => [
          'tj_design_style!' => ['1', '2', '3', '4', '6'],
        ]
      ]
    );
    $this->add_control(
      'tj_marquee_show',
      [
        'label'        => esc_html__('Enable Marquee?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '1',
      ]
    );
    $repeater = new Repeater();
    $repeater->add_control(
      'tj_marquee_icon',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'fa4compatibility' => 'marquee_icon',
        'default' => [
          'value' => 'tji-single-cube',
          'library' => 'tj',
        ]
      ]
    );
    $repeater->add_control(
      'tj_marquee_title',
      [
        'label'         => esc_html__('Title', 'tjcore'),
        'type'          => Controls_Manager::TEXT,
        'default'       => esc_html__('List Content', 'tjcore'),
        'label_block'   => true,
      ]
    );

    $this->add_control(
      'tj_marquee_list',
      [
        'label'         => esc_html__('List Marquees', 'tjcore'),
        'type'          => Controls_Manager::REPEATER,
        'fields'        => $repeater->get_controls(),
        'default'       => [
          [
            'tj_marquee_title'       => esc_html__('Expertise', 'tjcore'),
          ],
          [
            'tj_marquee_title'       => esc_html__('Consulting', 'tjcore'),
          ],
          [
            'tj_marquee_title'       => esc_html__('Business', 'tjcore'),
          ],
          [
            'tj_marquee_title'       => esc_html__('Growth', 'tjcore'),
          ],
        ],
        'title_field' => '{{{ tj_marquee_title }}}',
      ]
    );

    $this->add_control(
      'marquee_slide',
      [
        'label' => esc_html__('Slide Direction', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => 'right-to-left',
        'options' => [
          'left-to-right' => esc_html__('Left to Right', 'tjcore'),
          'right-to-left'  => esc_html__('Right to Left', 'tjcore'),
        ],
        'separator' => 'before',
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'tj_counter_tab',
      [
        'label' => esc_html__('Counter', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
        'condition' => [
          'tj_design_style!' => ['1', '2', '3', '4', '5'],
        ]
      ]
    );
    $this->add_control(
      'tj_chart_title',
      [
        'label'         => esc_html__('Chart Title', 'tjcore'),
        'type'          => Controls_Manager::TEXT,
        'default'       => esc_html__('Statics', 'tjcore'),
        'label_block'   => true,
      ]
    );
    $this->add_control(
      'ending_number',
      [
        'label'         => esc_html__('Number', 'tjcore'),
        'type'          => Controls_Manager::NUMBER,
        'default'       => esc_html__('810', 'tjcore'),
      ]
    );
    $this->add_control(
      'Suffix',
      [
        'label'         => esc_html__('Suffix', 'tjcore'),
        'type'          => Controls_Manager::TEXT,
        'default'       => esc_html__('+', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_counter_desc',
      [
        'label'         => esc_html__('Description', 'tjcore'),
        'type'          => Controls_Manager::TEXTAREA,
        'default'       => esc_html__('Helping ambitious our brand turn into a success', 'tjcore'),
        'row' => 3,
        'label_block'   => true,
      ]
    );

    $this->add_control(
      'chart_bg_color',
      [
        'label'     => __('Chart BG Color 1', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
      ]
    );

    $this->add_control(
      'chart_bg_color2',
      [
        'label'     => __('Chart BG Color 2', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
      ]
    );

    $this->add_control(
      'chart_bg_color3',
      [
        'label'     => __('Chart BG Color 3', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
      ]
    );

    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Section', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_background',
        'types' => ['classic', 'gradient'],
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .tj-hero-section, 
        {{WRAPPER}} .tj-hero-section-two::before, 
        {{WRAPPER}} .tj-hero-section-four,
        {{WRAPPER}} .h9-hero::before, .h9-hero::after,
        {{WRAPPER}} .h9-hero,
        {{WRAPPER}} .h8-hero-inner, {{WRAPPER}} .h10-hero-inner',
      ]
    );
    $this->add_control(
      'heading_overlay_options',
      [
        'label' => esc_html__('Image Overly', 'tjcore'),
        'type' => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
        'condition' => [
          'tj_design_style!' => ['1', '2', '4', '3', '6']
        ]
      ]
    );

    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_image_overlay_background',
        'types' => ['classic', 'gradient'],
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .h9-hero-wrapper::after',
        'condition' => [
          'tj_design_style!' => ['1', '2', '4', '3', '6']
        ]
      ]
    );

    $this->add_responsive_control(
      'tj_section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-hero-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-hero-section-two' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-hero-section-four' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h8-hero-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h9-hero' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h10-hero-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_section_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-hero-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-hero-section-two' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-hero-section-four' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h8-hero-inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h9-hero' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h10-hero-inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // subtitle
    $this->start_controls_section(
      '_style_subtitle',
      [
        'label' => esc_html__('Subtitle', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['1', '2', '4', '6']
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_subtitle_typography',
        'selector' => '{{WRAPPER}} .hero-subtitle, {{WRAPPER}} .hero-sub-title',
      ]
    );
    $this->add_control(
      'tj_subtitle_bg_color',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hero-subtitle' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .hero-sub-title' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_subtitle_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hero-subtitle' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-sub-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_subtitle_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .hero-subtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .hero-sub-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_subtitle_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .hero-subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .hero-sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .tj-hero-content .hero-title, {{WRAPPER}} .hero-content-four .hero-title, {{WRAPPER}} .slider-content .h8-hero-title, {{WRAPPER}} .h9-hero-content .hero-title, {{WRAPPER}} .h10-hero-content .hero-title',
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-hero-content .hero-title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-content-four .hero-title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .slider-content .h8-hero-title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h9-hero-content .hero-title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h10-hero-content .hero-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_title_highlighter_color',
      [
        'label'     => __('Text Hightlight Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-hero-content .hero-title span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-content-four .hero-title span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .slider-content .h8-hero-title span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h9-hero-content .hero-title span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h10-hero-content .hero-title span' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-hero-content .hero-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .hero-content-four .hero-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .slider-content .h8-hero-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h9-hero-content .hero-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h10-hero-content .hero-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-hero-content .hero-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .hero-content-four .hero-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .slider-content .h8-hero-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h9-hero-content .hero-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h10-hero-content .hero-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();


    // content
    $this->start_controls_section(
      '_style_content',
      [
        'label'     => esc_html__('Content', 'tjcore'),
        'tab'       => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_content_typography',
        'selector' => '{{WRAPPER}} .tj-hero-content .desc, {{WRAPPER}} .hero-content-four .desc, {{WRAPPER}} .slider-content .desc, {{WRAPPER}} .h9-hero-content .desc, {{WRAPPER}} .h10-hero-content .desc',
      ]
    );
    $this->add_control(
      'tj_content_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-hero-content .desc' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-content-four .desc' => 'color: {{VALUE}}',
          '{{WRAPPER}} .slider-content .desc' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h9-hero-content .desc' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h10-hero-content .desc' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_content_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-hero-content .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .hero-content-four .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .slider-content .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h9-hero-content .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h10-hero-content .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_content_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-hero-content .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .hero-content-four .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .slider-content .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h9-hero-content .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h10-hero-content .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    //Button
    $this->start_controls_section(
      '_heading_hero_btn_style',
      [
        'label' => __('Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['2', '4'],
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'btn_typography',
        'selector' => '{{WRAPPER}} .tj-primary-btn',
      ]
    );
    $this->start_controls_tabs('btn_style_tabs');
    $this->start_controls_tab(
      'btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn .btn_text' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn .btn_icon' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_bgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn .btn_inner::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_hcolor',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn:hover .btn_text' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_hcolor',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover .btn_icon' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_hbgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover .btn_inner::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_bg_hcolor',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();

    // Circle button
    $this->start_controls_section(
      '_circle_btn_style',
      [
        'label' => __('Circle Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['3', '4', '5', '6']
        ]
      ]
    );
    $this->add_control(
      'circle_btn_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .el-circle .circle' => 'color: {{VALUE}}',
          '{{WRAPPER}} .el-circle .hero-btn span.blue' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'circle_btn_bgcolor',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .el-circle .circle' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .el-circle .hero-btn span.blue' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'circle_mask_bgcolor',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hero-circle' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .hero-images-box-two.style-2 .hero-button .hero-btn::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();

    // video_btn_style
    $this->start_controls_section(
      '_video_btn_style',
      [
        'label' => __('Video Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['1', '2', '4', '5', '6']
        ]
      ]
    );
    $this->add_control(
      'video_wrap_bgcolor',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hero-video-btn .video-btn' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'video_wrap_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .hero-video-btn .video-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'video_btn_bgcolor',
      [
        'label'     => esc_html__('Btn Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hero-video-btn .video-btn .play-btn' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'video_btn_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hero-video-btn .video-btn .play-btn' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'video_btn_typography',
        'selector' => '{{WRAPPER}} .hero-video-btn .video-btn .video-text',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'video_text_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hero-video-btn .video-btn .video-text' => 'color: {{VALUE}}',
          '{{WRAPPER}} .hero-video-btn .video-btn .video-text::after' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();

    // _highlight_style
    $this->start_controls_section(
      '_highlight_style',
      [
        'label' => __('Highlight', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['1', '2', '5', '6']
        ]
      ]
    );
    $this->add_control(
      'highlight_wrap_bgcolor',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hero-wrapper-four .client-experience' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .h8-hero-circle .circle-wrap' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'highlight_wrap_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .hero-wrapper-four .client-experience, {{WRAPPER}} .h8-hero-circle .circle-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'highlight_text_typography',
        'selector' => '{{WRAPPER}} .hero-wrapper-four .client-experience .sub-title',
        'separator' => 'before',
        'condition' => [
          'tj_design_style!' => ['4']
        ]
      ]
    );
    $this->add_control(
      'highlight_text_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hero-wrapper-four .client-experience .sub-title' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style!' => ['4']
        ]
      ]
    );
    $this->end_controls_section();

    // Button 02
    $this->start_controls_section(
      '_tj_hero_text_btn_style',
      [
        'label' => __('Button 02', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['1', '2', '3', '4', '6']
        ]
      ]
    );

    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_hero_text_btn_typography',
        'selector' => '{{WRAPPER}} .h9-hero-action .text-btn',
      ]
    );
    $this->add_control(
      'tj_hero_text_btn_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .h9-hero-action .text-btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h9-hero-action .text-btn::before' => 'background: {{VALUE}}',
        ],
      ]
    );

    $this->end_controls_section();

    $this->start_controls_section(
      '_tj_hero_marquee_style',
      [
        'label' => __('Marquee', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['1', '2', '3', '4', '6']
        ]
      ]
    );

    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_marquee_title_typography',
        'selector' => '{{WRAPPER}} .marquee-item .marquee-title .text',
      ]
    );
    $this->add_control(
      'tj_marquee_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .marquee-item .marquee-title .text' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'marquee_color',
      [
        'label'     => __('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .marquee-item .marquee-icons i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .marquee-item .marquee-icons svg' => 'fill: {{VALUE}}',
        ],
      ]
    );

    $this->end_controls_section();

    $this->start_controls_section(
      '_tj_hero_counter_style',
      [
        'label' => __('Counter', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['1', '2', '3', '4', '5']
        ]
      ]
    );

    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_counter_title_typography',
        'selector' => '{{WRAPPER}} .h10-hero-stat-chart-text,  {{WRAPPER}} .h10-hero-counter-item .sub-title',
      ]
    );

    $this->add_control(
      'counter_text_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .h10-hero-stat-chart-text' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h10-hero-counter-item .sub-title' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'counter_hr',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );

    $this->add_control(
      'counter_number_color',
      [
        'label'     => __('Number Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .h10-hero-stat .h10-hero-counter-item .number' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_counter_number_typography',
        'selector' => '{{WRAPPER}} .h10-hero-stat .h10-hero-counter-item .number',
      ]
    );

    $this->end_controls_section();
  }


  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();
    extract($settings);
    $tj_banner_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/hero-banner/style-' . $tj_banner_style . '.php';
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Hero_Banner());
