<?php

namespace TJCore;

use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Image.
 */
class TJ_Image_Slider extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-image-slider';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Image Slider', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-carousel-loop tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script', 'swiper'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style', 'swiper'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'image',
      'media',
      'tj image',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {

    // _tj_image_content
    $this->start_controls_section(
      'tj_image_slider_tab',
      [
        'label' => esc_html__('Image Slider', 'tjcore'),
      ]
    );
    $repeater = new Repeater();
    $repeater->add_control(
      'tj_slider_image',
      [
        'label'   => esc_html__('Choose Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
      ]
    );

    $this->add_control(
      'tj_image_list',
      [
        'type'          => Controls_Manager::REPEATER,
        'fields'        => $repeater->get_controls(),
        'default'       => [
          [
            'tj_slider_image' => [
              'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
          ],
          [
            'tj_slider_image' => [
              'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
          ],
          [
            'tj_slider_image' => [
              'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
          ],
          [
            'tj_slider_image' => [
              'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
          ],
          [
            'tj_slider_image' => [
              'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
          ]
        ],
        'title_field' => '<# print("Carousel Item"); #>',
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    // carousel tab
    $this->start_controls_section(
      '__tj_carousel_settings',
      [
        'label' => esc_html__('Slider Settings', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'slide_loop',
      [
        'label'             => esc_html__('Is Loop?', 'tjcore'),
        'type'              => Controls_Manager::SWITCHER,
        'label_on'          => esc_html__('Yes', 'tjcore'),
        'label_off'         => esc_html__('No', 'tjcore'),
        'description'       => esc_html__('Do you want to make this slider item loop?', 'tjcore'),
        'return_value'      => 'yes',
        'default'           => 'no',
      ]
    );
    $this->add_control(
      'slide_autoplay',
      [
        'label'             => esc_html__('Is Autoplay?', 'tjcore'),
        'type'              => Controls_Manager::SWITCHER,
        'label_on'          => esc_html__('Yes', 'tjcore'),
        'label_off'         => esc_html__('No', 'tjcore'),
        'description'       => esc_html__('Do you want to make this slider auto play?', 'tjcore'),
        'return_value'      => 'yes',
        'default'           => 'no',
      ]
    );
    $this->add_control(
      'slide_autoplay_Delay',
      [
        'label' => esc_html__('Autoplay Delay', 'tjcore'),
        'type' => Controls_Manager::NUMBER,
        'description'       => esc_html__('Set slider autoplay delay.', 'tjcore'),
        'min' => 1,
        'max' => 10000,
        'step' => 100,
        'default' => 1,
        'condition' => [
          'slide_autoplay' => 'yes',
        ]
      ]
    );
    $this->end_controls_section();


    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_image',
      [
        'label' => esc_html__('Image', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_responsive_control(
      'tj_image_width',
      [
        'label'      => esc_html__('Width', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 2000,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => '%',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .slider-img img' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_image_max_width',
      [
        'label'      => esc_html__('Max Width', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 2000,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => '%',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .slider-img img' => 'max-width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_image_height',
      [
        'label'      => esc_html__('Height', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 2000,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => '%',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .slider-img img' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $this->add_control(
      'tj_image_border_style',
      [
        'label'     => esc_html__('Border Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''       => esc_html__('Default', 'tjcore'),
          'none'   => esc_html__('None', 'tjcore'),
          'solid'  => esc_html__('Solid', 'tjcore'),
          'dashed' => esc_html__('Dashed', 'tjcore'),
          'dotted' => esc_html__('Dotted', 'tjcore'),
          'double' => esc_html__('Double', 'tjcore'),
        ],
        'selectors' => [
          '{{WRAPPER}} .slider-img  img' => 'border-style: {{VALUE}};',
        ],
        'separator' => 'before',
      ]
    );
    $this->add_responsive_control(
      'tj_image_border_width',
      [
        'label'      => esc_html__('Border Width', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .slider-img  img' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition'  => [
          'tj_image_border_style!' => ['', 'none'],
        ],
      ]
    );
    $this->add_control(
      'tj_image_border_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-img img' => 'border-color: {{VALUE}}',
        ],
        'condition' => [
          'tj_image_border_style!' => ['', 'none'],
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_image_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .slider-img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/image-slider/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Image_Slider());
