<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Image.
 */
class TJ_Image extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-image';
  }

  // widget title.
  public function get_title() {
    return __('TJ Image', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-image tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'image',
      'media',
      'tj image',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {
    // layout Panel
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Image Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Image Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
          5 => esc_html__('Style 05', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // _tj_image_content
    $this->start_controls_section(
      '_tj_image_content',
      [
        'label' => esc_html__('Image', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_image',
      [
        'label'   => esc_html__('Choose Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $this->add_control(
      'tj_circle_image',
      [
        'label'   => esc_html__('Award Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_design_style' => ['2', '3']
        ]
      ]
    );
    $this->add_control(
      'tj_image_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'image_icon',
        'skin'             => 'inline',
        'label_block'      => false,
        'condition' => [
          'tj_design_style' => ['2', '3']
        ]
      ]
    );
    $this->add_control(
      'tj_image_overlay',
      [
        'label'     => esc_html__('Overlay', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'default'   => '',
        'selectors' => [
          '{{WRAPPER}} .tj_image::after' => 'background: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style!' => ['2', '3', '5']
        ]
      ]
    );
    $this->add_control(
      'tj_image_title',
      [
        'label'     => esc_html__('Title', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__("Expert business advices", 'tjcore'),
        'ai'        => false,
        'dynamic'   => [
          'active' => true,
        ],
        'condition' => [
          'tj_design_style!' => ['2', '3', '1', '5']
        ]
      ]
    );
    $this->add_responsive_control(
      'tj_image_alignment',
      [
        'label'        => esc_html__('Alignment', 'tjcore'),
        'type'         => Controls_Manager::CHOOSE,
        'options'      => [
          'left'   => [
            'title' => esc_html__('Left', 'tjcore'),
            'icon'  => 'eicon-text-align-left',
          ],
          'center' => [
            'title' => esc_html__('Center', 'tjcore'),
            'icon'  => 'eicon-text-align-center',
          ],
          'right'  => [
            'title' => esc_html__('Right', 'tjcore'),
            'icon'  => 'eicon-text-align-right',
          ],
        ],
        'prefix_class' => 'tj_image_align elementor%s-align-',
        'separator'    => 'before',
        'condition' => [
          'tj_design_style!' => ['4', '5']
        ]
      ]
    );
    $this->add_control(
      'is_image_link',
      [
        'label'   => esc_html__('Link', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'default' => 'none',
        'options' => [
          'none'        => esc_html__('None', 'tjcore'),
          'custom-link' => esc_html__('Custom URL', 'tjcore'),
        ],
        'condition' => [
          'tj_design_style!' => ['2', '3', '4', '5']
        ]
      ]
    );
    $this->add_control(
      'tj_image_link',
      [
        'label'         => esc_html__('Image link', 'tjcore'),
        'type'          => Controls_Manager::URL,
        'dynamic'       => [
          'active' => true,
        ],
        'placeholder'   => esc_html__('Paste URL or type', 'tjcore'),
        'show_external' => false,
        'default'       => [
          'url'         => '#',
          'is_external' => false,
          'nofollow'    => false,
        ],
        'condition'     => [
          'is_image_link' => 'custom-link',
        ],
        'show_label'    => false,
        'condition' => [
          'tj_design_style!' => ['2', '3', '4', '5']
        ]
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_image',
      [
        'label' => esc_html__('Image', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_responsive_control(
      'tj_image_width',
      [
        'label'      => esc_html__('Width', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 2000,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => '%',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .tj-image img' => 'width: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .h7-process-banner' => 'width: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .h9-about-statistics' => 'width: {{SIZE}}{{UNIT}};',
        ],
        'condition' => [
          'tj_design_style!' => ['5']
        ]
      ]
    );
    $this->add_responsive_control(
      'tj_image_max_width',
      [
        'label'      => esc_html__('Max Width', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 2000,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => '%',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .tj-image img' => 'max-width: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .h7-process-banner' => 'max-width: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .h9-about-statistics' => 'max-width: {{SIZE}}{{UNIT}};',
        ],
        'condition' => [
          'tj_design_style!' => ['5']
        ]
      ]
    );
    $this->add_responsive_control(
      'tj_image_height',
      [
        'label'      => esc_html__('Height', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 2000,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => '%',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} img' => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .h4-progress-section' => 'min-height: {{SIZE}}{{UNIT}};',
        ],
        'condition'  => [
          'tj_design_style!' => ['2', '3'],
        ],
      ]
    );

    $this->add_responsive_control(
      'object-fit',
      [
        'label' => esc_html__('Object Fit', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'condition' => [
          'tj_image_height[size]!' => '',
          'tj_design_style!' => ['2', '3'],
        ],
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'fill' => esc_html__('Fill', 'tjcore'),
          'cover' => esc_html__('Cover', 'tjcore'),
          'contain' => esc_html__('Contain', 'tjcore'),
          'scale-down' => esc_html__('Scale Down', 'tjcore'),
        ],
        'default' => '',
        'selectors' => [
          '{{WRAPPER}} img' => 'object-fit: {{VALUE}};',
        ],
        'condition' => [
          'tj_design_style!' => ['5']
        ]
      ]
    );

    $this->add_responsive_control(
      'object-position',
      [
        'label' => esc_html__('Object Position', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'options' => [
          'center center' => esc_html__('Center Center', 'tjcore'),
          'center left' => esc_html__('Center Left', 'tjcore'),
          'center right' => esc_html__('Center Right', 'tjcore'),
          'top center' => esc_html__('Top Center', 'tjcore'),
          'top left' => esc_html__('Top Left', 'tjcore'),
          'top right' => esc_html__('Top Right', 'tjcore'),
          'bottom center' => esc_html__('Bottom Center', 'tjcore'),
          'bottom left' => esc_html__('Bottom Left', 'tjcore'),
          'bottom right' => esc_html__('Bottom Right', 'tjcore'),
        ],
        'default' => 'center center',
        'selectors' => [
          '{{WRAPPER}} img' => 'object-position: {{VALUE}};',
        ],
        'condition' => [
          'tj_image_height[size]!' => '',
          'object-fit' => ['cover', 'contain', 'scale-down'],
          'tj_design_style!' => ['2', '3', '5'],
        ],
      ]
    );

    $this->add_control(
      'tj_image_background_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-image' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .h7-process-banner-bg::before' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .h9-about-statistics' => 'background-color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style!' => ['5']
        ]
      ]
    );
    $this->add_control(
      'tj_image_primary_bg_color',
      [
        'label'     => esc_html__('Primary Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .h7-process-banner-bg' => 'background-color: {{VALUE}}',
        ],
        'condition'  => [
          'tj_design_style!' => ['1', '3', '4', '5'],
        ],
      ]
    );
    $this->add_control(
      'tj_image_secondary_bg_color',
      [
        'label'     => esc_html__('Secondary Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .h7-process-banner-bg::after' => 'background-color: {{VALUE}}',
        ],
        'condition'  => [
          'tj_design_style!' => ['1', '3', '4', '5'],
        ],
      ]
    );

    $this->add_control(
      'tj_image_border_style',
      [
        'label'     => esc_html__('Border Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''       => esc_html__('Default', 'tjcore'),
          'none'   => esc_html__('None', 'tjcore'),
          'solid'  => esc_html__('Solid', 'tjcore'),
          'dashed' => esc_html__('Dashed', 'tjcore'),
          'dotted' => esc_html__('Dotted', 'tjcore'),
          'double' => esc_html__('Double', 'tjcore'),
        ],
        'selectors' => [
          '{{WRAPPER}}  img' => 'border-style: {{VALUE}};',
        ],
        'separator' => 'before',
        'condition'  => [
          'tj_design_style!' => ['2', '3', '5'],
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_image_border_width',
      [
        'label'      => esc_html__('Border Width', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}}  img' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition'  => [
          'tj_image_border_style!' => ['', 'none'],
          'tj_design_style!' => ['2', '3', '5'],
        ],
      ]
    );
    $this->add_control(
      'tj_image_border_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} img' => 'border-color: {{VALUE}}',
        ],
        'condition' => [
          'tj_image_border_style!' => ['', 'none'],
          'tj_design_style!' => ['2', '3', '5'],
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_image_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition'  => [
          'tj_design_style!' => ['2', '3', '5'],
        ],
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'section_style_img_title',
      [
        'label' => esc_html__('Title style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition'  => [
          'tj_design_style!' => ['2', '3', '1', '5'],
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_imgtitle_typography',
        'selector' => '{{WRAPPER}} .h10-feature-img-item .feature-content .title',
      ]
    );
    $this->add_control(
      'tj_imgtitle_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .h10-feature-img-item .feature-content .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
        'name'     => 'tj_img_title_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .h10-feature-img-item .feature-content',
      ]
    );

    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();

    // animation
    $tjAnimation      = $settings['tj_animation'] ?? '';
    $tjAnimationName  = $settings['tj_animation_name'] ?? '';
    $tjAnimationDelay = $settings['tj_animation_delay'] ?? '';

    $link   = !empty($settings['tj_image_link']['url']) ? $settings['tj_image_link']['url'] : '';
    $target = !empty($settings['tj_image_link']['is_external']) ? '_blank' : '';
    $rel    = !empty($settings['tj_image_link']['nofollow']) ? 'nofollow' : '';

    // style 05
    if ("5" == $settings['tj_design_style']):

      $imageClass = "h4-progress-section tjParallaxSection";
      if (!empty($tjAnimation)) {
        $imageClass .= " wow $tjAnimationName";
        $this->add_render_attribute('tj-image-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
      }
      $this->add_render_attribute('tj-image-arg', 'class', $imageClass);
?>
      <div <?php echo $this->get_render_attribute_string('tj-image-arg'); ?>>
        <?php if (!empty($settings['tj_image']['url'])): ?>
          <div class="h4-progress-bg tjParallaxImage" data-bg-image="<?php echo esc_url($settings['tj_image']['url']); ?>"></div>
        <?php endif; ?>

        <div class="container">
          <div class="row">
            <div class="col"></div>
          </div>
        </div>
      </div>

    <?php
    // style 04
    elseif ("4" == $settings['tj_design_style']):

      $imageClass = "h10-feature-img-item";
      if (!empty($tjAnimation)) {
        $imageClass .= " wow $tjAnimationName";
        $this->add_render_attribute('tj-image-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
      }
      $this->add_render_attribute('tj-image-arg', 'class', $imageClass);
    ?>

      <div <?php echo $this->get_render_attribute_string('tj-image-arg'); ?>>
        <?php if (!empty($settings['tj_image']['url'])): ?>
          <div class="feature-img tj-image  hover:shine">
            <img src="<?php echo esc_url($settings['tj_image']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_image']['id'], '_wp_attachment_image_alt', true)); ?>">
          </div>
        <?php endif; ?>
        <?php if (!empty($settings['tj_image_title'])): ?>
          <div class="feature-content">
            <h5 class="title"><?php echo tj_kses($settings['tj_image_title']); ?></h5>
          </div>
        <?php endif; ?>
      </div>

    <?php elseif ("3" == $settings['tj_design_style']):

      $imageClass = "about-statistics h9-about-statistics";
      if (!empty($tjAnimation)) {
        $imageClass .= " wow $tjAnimationName";
        $this->add_render_attribute('tj-image-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
      }
      $this->add_render_attribute('tj-image-arg', 'class', $imageClass);
    ?>
      <!-- banner img -->
      <div <?php echo $this->get_render_attribute_string('tj-image-arg'); ?>>

        <?php if (!empty($settings['tj_image']['url'])): ?>
          <img src="<?php echo esc_url($settings['tj_image']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_image']['id'], '_wp_attachment_image_alt', true)); ?>">
        <?php endif; ?>
        <?php if (!empty($settings['tj_circle_image']['url']) || !empty($settings['tj_image_icon']['value'])): ?>
          <div class="about-circle h7-process-circle h9-about-circle">
            <div class="circle-wrap">
              <?php if (!empty($settings['tj_circle_image']['url'])): ?>
                <img class="rotate-image" src="<?php echo esc_url($settings['tj_circle_image']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_circle_image']['id'], '_wp_attachment_image_alt', true)); ?>">
              <?php endif; ?>
              <?php if (!empty($settings['tj_image_icon']['value'])): ?>
                <span class="logo-icon"><?php tj_render_icon($settings, "image_icon", "tj_image_icon"); ?></span>
              <?php endif; ?>
            </div>
          </div>
        <?php endif; ?>
      </div>

    <?php elseif ("2" == $settings['tj_design_style']):

      $imageClass = "h7-process-banner";
      if (!empty($tjAnimation)) {
        $imageClass .= " wow $tjAnimationName";
        $this->add_render_attribute('tj-image-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
      }
      $this->add_render_attribute('tj-image-arg', 'class', $imageClass);
    ?>
      <!-- banner img -->
      <div <?php echo $this->get_render_attribute_string('tj-image-arg'); ?>>
        <div class="h7-process-banner-bg"></div>
        <?php if (!empty($settings['tj_image']['url'])): ?>
          <img src="<?php echo esc_url($settings['tj_image']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_image']['id'], '_wp_attachment_image_alt', true)); ?>">
        <?php endif; ?>
        <?php if (!empty($settings['tj_circle_image']['url']) || !empty($settings['tj_image_icon']['value'])): ?>
          <div class="about-circle h7-process-circle">
            <div class="circle-wrap">
              <?php if (!empty($settings['tj_circle_image']['url'])): ?>
                <img class="rotate-image" src="<?php echo esc_url($settings['tj_circle_image']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_circle_image']['id'], '_wp_attachment_image_alt', true)); ?>">
              <?php endif; ?>
              <?php if (!empty($settings['tj_image_icon']['value'])): ?>
                <span class="logo-icon"><?php tj_render_icon($settings, "image_icon", "tj_image_icon"); ?></span>
              <?php endif; ?>
            </div>
          </div>
        <?php endif; ?>
      </div>

      <?php else:

      if (!empty($tjAnimation)) {
        $imageClass = "tj-image hover:shine wow $tjAnimationName";
        $this->add_render_attribute('tj-image-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
      } else {
        $imageClass = "tj-image hover:shine";
      }
      $this->add_render_attribute('tj-image-arg', 'class', $imageClass);

      if (!empty($link)):
        $this->add_render_attribute('tj-image-link-arg', 'href', $link);
        $this->add_render_attribute('tj-image-link-arg', 'target', $target);
        $this->add_render_attribute('tj-image-link-arg', 'rel', $rel);
      ?>
        <div <?php echo $this->get_render_attribute_string('tj-image-arg'); ?>>
          <a class="tj_image" <?php echo $this->get_render_attribute_string('tj-image-link-arg'); ?>>
            <?php if (!empty($settings['tj_image']['url'])): ?>
              <img src="<?php echo esc_url($settings['tj_image']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_image']['id'], '_wp_attachment_image_alt', true)); ?>">
            <?php endif; ?>
          </a>
        </div>
      <?php else: ?>
        <div <?php echo $this->get_render_attribute_string('tj-image-arg'); ?>>
          <?php if (!empty($settings['tj_image']['url'])): ?>
            <img src="<?php echo esc_url($settings['tj_image']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_image']['id'], '_wp_attachment_image_alt', true)); ?>">
          <?php endif; ?>
        </div>
<?php
      endif;
    endif;
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Image());
