<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) {
  exit;
}

class TJ_Language extends Widget_Base
{

  public function get_name()
  {
    return 'tj-language';
  }

  public function get_title()
  {
    return __('TJ Language', 'tjcore');
  }

  public function get_icon()
  {
    return 'eicon-globe tj-icon';
  }

  public function get_categories()
  {
    return ['tjcore'];
  }

  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  public function get_keywords()
  {
    return [
      'language',
      'switcher',
      'wpml',
      'tj',
      'tjcore',
    ];
  }

  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  protected function register_controls()
  {
    $this->start_controls_section(
      'tj_content_tab',
      [
        'label' => esc_html__('Content', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_title',
      [
        'label'       => esc_html__('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'rows'        => 2,
        'default'     => esc_html__('Choose Language', 'tjcore'),
        'show_label'  => false,
        'dynamic'     => [
          'active' => true,
        ],
      ]
    );

    $this->end_controls_section();
  }

  // Helper to render language list
  protected function render_language_list()
  {
    $languages = apply_filters('wpml_active_languages', NULL, 'orderby=id&order=desc');

    if (!empty($languages)) {
      echo '<ul class="wpml-lang">';
      foreach ($languages as $lan) {
        $lan_name = !empty($lan['translated_name']) ? $lan['translated_name'] : $lan['native_name'];
        $active   = $lan['active'] == 1 ? 'active' : '';
        echo '<li class="' . esc_attr($active) . '"><a href="' . esc_url($lan['url']) . '">' . esc_html($lan_name) . '</a></li>';
      }
      echo '</ul>';
    } else {
      echo '<ul>';
      echo '<li><a href="#">' . __('English', 'tjcore') . '</a></li>';
      echo '<li><a href="#">' . __('Spanish', 'tjcore') . '</a></li>';
      echo '<li><a href="#">' . __('Hindi', 'tjcore') . '</a></li>';
      echo '</ul>';
    }
  }

  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $tjTitle  = $settings['tj_title'] ?? '';

    echo '<div class="tj-language-widget">';
    echo '<ul class="language-switcher"><li>';

    $languages = apply_filters('wpml_active_languages', NULL, 'orderby=id&order=desc');

    if (!empty($languages)) {
      foreach ($languages as $lan) {
        $name_lang = !empty($lan['language_code']) ? ucfirst($lan['language_code']) : __('En', 'tjcore');
        if ($lan['active'] == 1) {
          echo '<a href="#0" class="lang__btn">' . esc_html($name_lang) . ' <i class="ti-arrow-down"></i></a>';
          break;
        }
      }
    } else {
      echo '<a href="#0" class="lang__btn">' . __('English', 'tjcore') . ' <i class="ti-arrow-down"></i></a>';
    }

    $this->render_language_list();

    echo '</li></ul>';
    echo '</div>';
  }

  protected function content_template()
  {
    // Optional: live preview in editor
  }
}

// Register widget
$widgets_manager->register(new TJ_Language());
