<?php

namespace TJCore;

use Elementor\Widget_Base;
use \Elementor\Utils;
use \Elementor\Repeater;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Text_Stroke;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Css_Filter;


if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Elementor widget for Tj List.
 */
class Tj_List_Widgets extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-lists';
  }

  // widget title
  public function get_title()
  {
    return esc_html__('TJ List Items', 'tjcore');
  }

  // widget icon
  public function get_icon()
  {
    return 'eicon-editor-list-ul tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'list',
      'lists',
      'tj list',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }


  /**
   * widget controls.
   */
  protected function register_controls()
  {
    // tj feature tab
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('List Style', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select List Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // lists
    $this->start_controls_section(
      'section_tab',
      [
        'label'         => esc_html__('List Items', 'tjcore'),
      ]
    );
    $repeater = new Repeater();
    $repeater->add_control(
      'tj_item_icon',
      [
        'label'         => esc_html__('Icon', 'tjcore'),
        'type'          => Controls_Manager::ICONS,
        'fa4compatibility' => 'tj_icon',
        'default'          => [
          'value' => 'tji-double-check',
          'library' => 'tji',
        ],
      ]
    );
    $repeater->add_control(
      'tj_item_content',
      [
        'label'         => esc_html__('Item Content', 'tjcore'),
        'type'          => Controls_Manager::TEXTAREA,
        'default'       => esc_html__('List Content', 'tjcore'),
        'rows' => 3,
      ]
    );
    $this->add_control(
      'tj_list',
      [
        'label'         => esc_html__('List Items', 'tjcore'),
        'type'          => Controls_Manager::REPEATER,
        'fields'        => $repeater->get_controls(),
        'default'       => [
          [
            'tj_item_content'       => tj_kses('Expertise and experience'),
          ],
          [
            'tj_item_content'       => tj_kses('Client centric approach'),
          ],
          [
            'tj_item_content'       => tj_kses('Commitment excellences'),
          ]
        ],
        'title_field' => '{{{ tj_item_content }}}',
      ]
    );

    // animation
    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ]
      ]
    );
    $this->end_controls_section();
    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    $this->start_controls_section(
      'section_style_list',
      [
        'label' => esc_html__('List style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_responsive_control(
      'ficon_font_size',
      [
        'label' => esc_html__('Icon Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-el-list ul li i' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $this->add_control(
      'ficon_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-el-list ul li i' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_list_typography',
        'selector' => '{{WRAPPER}} .tj-el-list ul li, .tj-el-list ul li span',
      ]
    );
    $this->add_control(
      'tj_list_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-el-list ul li' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-el-list ul li span' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_responsive_control(
      'tj_list_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-el-list ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_control(
      'tj_list_border_color',
      [
        'label'     => __('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-el-list ul li' => 'border-color: {{VALUE}}',
        ],
      ]
    );

    $this->end_controls_section();
  }

  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/list/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {}
}
$widgets_manager->register(new Tj_List_Widgets());
