<?php

namespace TJCore;

use Elementor\Widget_Base;
use \Elementor\Utils;
use \Elementor\Repeater;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Text_Stroke;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Css_Filter;


if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Elementor widget for Marquee.
 */
class TJ_Marquee extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-marquee';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Marquee', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-divider-shape tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'marquee',
      'marquees',
      'tj marquee',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }


  /**
   * widget controls.
   */
  protected function register_controls()
  {

    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Marquee Style', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // tj_marquee_tab
    $this->start_controls_section(
      'tj_marquee_tab',
      [
        'label' => esc_html__('Marquee', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );
    $repeater = new Repeater();
    $repeater->add_control(
      'tj_marquee_icon',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'fa4compatibility' => 'marquee_icon',
        'default' => [
          'value' => 'tji-single-cube',
          'library' => 'tj',
        ]
      ]
    );
    $repeater->add_control(
      'tj_marquee_title',
      [
        'label'         => esc_html__('Title', 'tjcore'),
        'type'          => Controls_Manager::TEXT,
        'default'       => esc_html__('List Content', 'tjcore'),
        'label_block'   => true,
      ]
    );

    $this->add_control(
      'tj_list',
      [
        'label'         => esc_html__('List Marquees', 'tjcore'),
        'type'          => Controls_Manager::REPEATER,
        'fields'        => $repeater->get_controls(),
        'default'       => [
          [
            'tj_marquee_title'       => esc_html__('Passion and progress', 'tjcore'),
          ],
          [
            'tj_marquee_title'       => esc_html__('Founders and vision', 'tjcore'),
          ],
          [
            'tj_marquee_title'       => esc_html__('Growth and impact', 'tjcore'),
          ],
          [
            'tj_marquee_title'       => esc_html__('Team and values', 'tjcore'),
          ],
          [
            'tj_marquee_title'       => esc_html__('Innovation and future', 'tjcore'),
          ],
          [
            'tj_marquee_title'       => esc_html__('Success and impact', 'tjcore'),
          ],
        ],
        'title_field' => '{{{ tj_marquee_title }}}',
      ]
    );

    $this->add_control(
      'marquee_slide',
      [
        'label' => esc_html__('Slide Direction', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => 'right-to-left',
        'options' => [
          'left-to-right' => esc_html__('Left to Right', 'tjcore'),
          'right-to-left'  => esc_html__('Right to Left', 'tjcore'),
        ],
        'separator' => 'before',
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Section', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .tj-marquee-section, {{WRAPPER}} .h6-marquee-slider, {{WRAPPER}} .h8-marquee-section',
      ]
    );
    $this->add_responsive_control(
      'tj_section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-marquee-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h6-marquee-slider' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h8-marquee-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_section_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-marquee-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h6-marquee-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h8-marquee-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();


    // title
    $this->start_controls_section(
      '_style_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .marquee-item .marquee-title .text, {{WRAPPER}} .h6-marquee-slider .marquee_item',
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .marquee-item .marquee-title .text' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h6-marquee-slider .marquee_item' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .marquee-item .marquee-title .text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h6-marquee-slider .marquee_item .marquee-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .marquee-item .marquee-title .text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h6-marquee-slider .marquee_item .marquee-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // icon
    $this->start_controls_section(
      'section_style_ficon',
      [
        'label' => esc_html__('Icon style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_responsive_control(
      'ficon_font_size',
      [
        'label' => esc_html__('Icon Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .marquee-item .marquee-icons' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $this->add_control(
      'ficon_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .marquee-item .marquee-icons' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/marquee/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Marquee());
