<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Pricing Box.
 */
class TJ_Pricing_Box extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-pricing-box';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Pricing Box', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-price-table tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'pricing',
      'pricing table',
      'tj price',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {


    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Pricing Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();




    // Header
    $this->start_controls_section(
      '_section_header',
      [
        'label' => __('Box Header', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'price_title',
      [
        'label'       => __('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'label_block' => true,
        'default'     => esc_html__('Premium', 'tjcore'),
        'dynamic'     => [
          'active' => true,
        ],
      ]
    );
    $this->add_control(
      'price_description',
      [
        'label' => esc_html__('Description', 'tjcore'),
        'type' => Controls_Manager::TEXTAREA,
        'rows' => 3,
        'default' => esc_html__('Save 20% offer of consulting 93K clients.', 'tjcore'),
        'placeholder' => esc_html__('Type your description here', 'tjcore'),
      ]
    );
    $this->add_control(
      'is_price_box_recommend',
      [
        'label'        => __('Is this recommended?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Yes', 'tjcore'),
        'label_off'    => __('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'price_subtitle',
      [
        'label'       => __('Badge', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'label_block' => true,
        'default'     => esc_html__('Recommended', 'tjcore'),
        'dynamic'     => [
          'active' => true,
        ],
        'condition' => [
          'is_price_box_recommend' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      '_section_pricing',
      [
        'label' => __('Pricing', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_price_currency',
      [
        'label'       => __('Currency', 'tjcore'),
        'type'        => Controls_Manager::SELECT,
        'label_block' => false,
        'options'     => [
          ''             => __('None', 'tjcore'),
          'baht'         => '&#3647; ' . _x('Baht', 'Currency Symbol', 'tjcore'),
          'bdt'          => '&#2547; ' . _x('BD Taka', 'Currency Symbol', 'tjcore'),
          'dollar'       => '&#36; ' . _x('Dollar', 'Currency Symbol', 'tjcore'),
          'euro'         => '&#128; ' . _x('Euro', 'Currency Symbol', 'tjcore'),
          'franc'        => '&#8355; ' . _x('Franc', 'Currency Symbol', 'tjcore'),
          'guilder'      => '&fnof; ' . _x('Guilder', 'Currency Symbol', 'tjcore'),
          'krona'        => 'kr ' . _x('Krona', 'Currency Symbol', 'tjcore'),
          'lira'         => '&#8356; ' . _x('Lira', 'Currency Symbol', 'tjcore'),
          'peseta'       => '&#8359 ' . _x('Peseta', 'Currency Symbol', 'tjcore'),
          'peso'         => '&#8369; ' . _x('Peso', 'Currency Symbol', 'tjcore'),
          'pound'        => '&#163; ' . _x('Pound Sterling', 'Currency Symbol', 'tjcore'),
          'real'         => 'R$ ' . _x('Real', 'Currency Symbol', 'tjcore'),
          'ruble'        => '&#8381; ' . _x('Ruble', 'Currency Symbol', 'tjcore'),
          'rupee'        => '&#8360; ' . _x('Rupee', 'Currency Symbol', 'tjcore'),
          'indian_rupee' => '&#8377; ' . _x('Rupee (Indian)', 'Currency Symbol', 'tjcore'),
          'shekel'       => '&#8362; ' . _x('Shekel', 'Currency Symbol', 'tjcore'),
          'won'          => '&#8361; ' . _x('Won', 'Currency Symbol', 'tjcore'),
          'yen'          => '&#165; ' . _x('Yen/Yuan', 'Currency Symbol', 'tjcore'),
          'custom'       => __('Custom', 'tjcore'),
        ],
        'default'     => 'dollar',
      ]
    );
    $this->add_control(
      'tj_currency_custom',
      [
        'label'     => __('Custom Symbol', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'condition' => [
          'price_currency' => 'custom',
        ],
        'dynamic'   => [
          'active' => true,
        ],
      ]
    );

    $this->start_controls_tabs('pricing_price_tabs');
    $this->start_controls_tab(
      'pricing_year_tab',
      [
        'label' => esc_html__('Yearly', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_yearly_price',
      [
        'label'   => __('Yearly Price', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('9.99', 'tjcore'),
        'dynamic' => [
          'active' => true,
        ],
      ]
    );
    $this->add_control(
      'tj_year_price_period',
      [
        'label'   => __('Period', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('/year', 'tjcore'),
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'pricing_month_tab',
      [
        'label' => esc_html__('Monthly', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_monthly_price',
      [
        'label'   => __('Monthly Price', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('4.99', 'tjcore'),
        'dynamic' => [
          'active' => true,
        ],
      ]
    );
    $this->add_control(
      'tj_month_price_period',
      [
        'label'   => __('Period', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('/month', 'tjcore'),
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->end_controls_section();

    $this->start_controls_section(
      '_section_features',
      [
        'label' => __('Features', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_feature_title',
      [
        'label'   => __('Title', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('Includes', 'tjcore'),
        'condition' => [
          'tj_design_style' => ['2'],
        ],
      ]
    );
    $repeater = new Repeater();
    $repeater->add_control(
      'tj_feature_available',
      [
        'label'        => __('Feature Hide ?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Yes', 'tjcore'),
        'label_off'    => __('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
      ]
    );
    $repeater->add_control(
      'tj_feature_icon',
      [
        'show_label'  => true,
        'type'        => Controls_Manager::ICONS,
        'label_block' => true,
        'fa4compatibility' => "feature_icon",
        'default'     => [
          'value'   => 'tji-double-check',
          'library' => 'tj',
        ],
      ]
    );
    $repeater->add_control(
      'tj_feature_text',
      [
        'label'   => esc_html__('Text', 'tjcore'),
        'type'    => Controls_Manager::TEXTAREA,
        'default' => esc_html__('In-Depth consultation', 'tjcore'),
        'dynamic' => [
          'active' => true,
        ],
      ]
    );
    $this->add_control(
      'tj_feature_list',
      [
        'type'        => Controls_Manager::REPEATER,
        'fields'      => $repeater->get_controls(),
        'show_label'  => false,
        'default'     => [
          [
            'tj_feature_text' => esc_html__('In-Depth consultation'),
          ],
          [
            'tj_feature_text' => esc_html__('Standard business'),
          ],
          [
            'tj_feature_text' => esc_html__('Quick email support'),
          ],
          [
            'tj_feature_text' => esc_html__('Monthly check-In'),
          ],
          [
            'tj_feature_text' => esc_html__('Progress reviews'),
          ],
          [
            'tj_feature_text' => esc_html__('Flexible support'),
          ],
          [
            'tj_feature_text' => esc_html__('24/7 support'),
          ],
        ],
        'title_field' => '{{{ tj_feature_text }}}',
      ]
    );
    $this->end_controls_section();

    // tj_btn_button_group
    $this->start_controls_section(
      'tj_btn_button_group',
      [
        'label' => esc_html__('Button', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_btn_text',
      [
        'label'       => esc_html__('Button Text', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Chose package', 'tjcore'),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_btn_link_type',
      [
        'label'       => esc_html__('Button Link Type', 'tjcore'),
        'type'        => Controls_Manager::SELECT,
        'options'     => [
          '1' => 'Custom Link',
          '2' => 'Internal Page',
        ],
        'default'     => '1',
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_btn_link',
      [
        'label'         => esc_html__('Button link', 'tjcore'),
        'type'          => Controls_Manager::URL,
        'dynamic'       => [
          'active' => true,
        ],
        'placeholder'   => esc_html__('https://your-link.com', 'tjcore'),
        'show_external' => false,
        'default'       => [
          'url'               => '#',
          'is_external'       => true,
          'nofollow'          => true,
          'custom_attributes' => '',
        ],
        'condition'     => [
          'tj_btn_link_type' => '1',
        ],
        'label_block'   => true,
      ]
    );
    $this->add_control(
      'tj_btn_page_link',
      [
        'label'       => esc_html__('Select Page Link', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'tj_btn_link_type' => '2',
        ],
      ]
    );
    $this->add_control(
      'tj_btn_icon',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'default' => [
          'value' => 'tji-angle-right',
          'library' => 'tj',
        ],
        'fa4compatibility' => 'btn_icon',
        'skin' => 'inline',
        'label_block' => false
      ]
    );
    $this->end_controls_section();

    // animation
    $this->start_controls_section(
      'tj_animation_group',
      [
        'label' => esc_html__('Animation', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',

      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();
    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Section', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_background',
        'selector' => '{{WRAPPER}} .price-el-box',
        'exclude' => ['image', 'video']
      ]
    );
    $this->add_control(
      'tj_border_color',
      [
        'label'     => __('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .price-el-box' => 'border-color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'heading_pricing_active',
      [
        'label'     => __('Active', 'tjcore'),
        'type'      => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_active_background',
        'selector' => '{{WRAPPER}} .price-el-box.active',
        'exclude' => ['image', 'video']
      ]
    );
    $this->add_control(
      'tj_border_active_color',
      [
        'label'     => __('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .price-el-box.active' => 'border-color: {{VALUE}}',
        ],
      ]
    );

    $this->add_responsive_control(
      'tj_section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .price-el-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // price header
    $this->start_controls_section(
      '_style_price_header',
      [
        'label' => esc_html__('Price Header', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'tj_header_border_color',
      [
        'label'     => __('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .price-el-header' => 'border-bottom-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_header_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .price-el-header' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_header_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .price-el-header' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    // header title
    $this->add_control(
      'price_header_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .el-title',
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .el-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_title_acolor',
      [
        'label'     => __('Active Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .price-el-box.active .el-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .el-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_control(
      'price_header_subtitle',
      [
        'label' => esc_html__('Subtitle', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_subtitle_typography',
        'selector' => '{{WRAPPER}} .el-desc p',
      ]
    );
    $this->add_control(
      'tj_subtitle_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .el-desc p' => 'color: {{VALUE}}',
          '{{WRAPPER}} .el-desc p span' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_subtitle_acolor',
      [
        'label'     => __('Active Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .price-el-box.active .el-desc p' => 'color: {{VALUE}}',
          '{{WRAPPER}} .price-el-box.active .el-desc p span' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_subtitle_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .el-desc p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // price Price
    $this->start_controls_section(
      '_style_price_price',
      [
        'label' => esc_html__('Price', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      '_style_price_currency',
      [
        'label' => esc_html__('Currency', 'tjcore'),
        'type' => Controls_Manager::HEADING,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_price_currency_typography',
        'selector' => '{{WRAPPER}} .el-currency',
      ]
    );
    $this->add_control(
      'tj_price_currency_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .el-currency' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_price_currency_acolor',
      [
        'label'     => __('Active Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .price-el-box.active .el-currency' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      '_style_price',
      [
        'label' => esc_html__('Price', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_price_price_typography',
        'selector' => '{{WRAPPER}} .el-price',
      ]
    );
    $this->add_control(
      'tj_price_price_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .el-price' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_price_price_acolor',
      [
        'label'     => __('Active Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .price-el-box.active .el-price' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      '_style_price_period',
      [
        'label' => esc_html__('Period', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_price_period_typography',
        'selector' => '{{WRAPPER}} .el-period',
      ]
    );
    $this->add_control(
      'tj_price_period_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .el-period' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_price_period_acolor',
      [
        'label'     => __('Active Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .price-el-box.active .el-period' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();

    // feature
    $this->start_controls_section(
      '_style_feature',
      [
        'label' => esc_html__('Feature', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_feature_title_typography',
        'selector' => '{{WRAPPER}} .el-feature h4',
        'condition' => [
          'tj_design_style' => ['2'],
        ],
      ]
    );
    $this->add_control(
      'tj_feature_title_color',
      [
        'label'     => __('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .el-feature h4' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => ['2'],
        ],
      ]
    );

    $this->add_control(
      'heading_feature_options',
      [
        'label' => esc_html__('Feature List', 'textdomain'),
        'type' => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
        'condition' => [
          'tj_design_style' => ['2'],
        ],
      ]
    );

    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_feature_typography',
        'selector' => '{{WRAPPER}} .el-feature ul li',
      ]
    );
    $this->add_control(
      'tj_feature_icon_color',
      [
        'label'     => __('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .el-feature ul li i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_feature_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .el-feature ul li' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'heading_feature_active',
      [
        'label'     => __('Active', 'tjcore'),
        'type'      => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );

    $this->add_control(
      'tj_feature_icon_acolor',
      [
        'label'     => __('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .price-el-box.active .el-feature ul li.active i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_feature_acolor',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .price-el-box.active .el-feature ul li.active' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_responsive_control(
      'tj_feature_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .el-feature ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_feature_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .el-feature ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // button
    $this->start_controls_section(
      '_heading_price_btn',
      [
        'label' => __('Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['2'],
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'pbtn_typography',
        'selector' => '{{WRAPPER}} .el-button a',
      ]
    );
    $this->start_controls_tabs('pbtn_tabs');
    $this->start_controls_tab(
      'pbtn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'pbtn_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .el-button a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'pbtn_background_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .el-button a' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'pstyle_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'pbtn_text_hover_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .el-button a:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'pbtn_background_hover_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .el-button a:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_control(
      'pheading_btn_active',
      [
        'label'     => __('Active', 'tjcore'),
        'type'      => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'pbtn_text_acolor',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .el-button.active a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'pbtn_background_acolor',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .el-button.active a:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );

    $this->add_responsive_control(
      'pbtn_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .el-button a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => "before"
      ]
    );
    $this->add_responsive_control(
      'pbtn_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .el-button a'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->add_responsive_control(
      'pbtn_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .el-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    //Button
    $this->start_controls_section(
      '_heading_hero_btn_style',
      [
        'label' => __('Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style' => ['2'],
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'btn_typography',
        'selector' => '{{WRAPPER}} .tj-primary-btn',
      ]
    );
    $this->start_controls_tabs('btn_style_tabs');
    $this->start_controls_tab(
      'btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn .btn_text' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn .btn_icon' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_bgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn .btn_inner::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_hcolor',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn:hover .btn_text' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_hcolor',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover .btn_icon' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_hbgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover .btn_inner::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_bg_hcolor',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();
  }

  private static function get_currency_symbol($symbol_name)
  {
    $symbols = [
      'baht'         => '&#3647;',
      'bdt'          => '&#2547;',
      'dollar'       => '&#36;',
      'euro'         => '&#128;',
      'franc'        => '&#8355;',
      'guilder'      => '&fnof;',
      'indian_rupee' => '&#8377;',
      'pound'        => '&#163;',
      'peso'         => '&#8369;',
      'peseta'       => '&#8359',
      'lira'         => '&#8356;',
      'ruble'        => '&#8381;',
      'shekel'       => '&#8362;',
      'rupee'        => '&#8360;',
      'real'         => 'R$',
      'krona'        => 'kr',
      'won'          => '&#8361;',
      'yen'          => '&#165;',
    ];

    return isset($symbols[$symbol_name]) ? $symbols[$symbol_name] : '';
  }

  /**
   * Render the widget output on the frontend.
   *
   */
  protected function render()
  {
    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/pricing-box/style-' . $tj_design_style . '.php';
?>

<?php
  }
}

$widgets_manager->register(new TJ_Pricing_Box());
