<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Pricing Box.
 */
class TJ_Pricing_Tab extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-pricing-tab';
  }

  // widget title.
  public function get_title() {
    return __('TJ Pricing Tab', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-price-table tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'pricing',
      'pricing tab',
      'tj price',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {
    // _section_content
    $this->start_controls_section(
      '_section_content',
      [
        'label' => __('Content', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );

    $repeater = new Repeater();
    $repeater->add_control(
      'is_price_box_recommend',
      [
        'label'        => __('Is this recommended?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Yes', 'tjcore'),
        'label_off'    => __('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $repeater->add_control(
      'recommend_text',
      [
        'label'       => __('Recommended Text', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Recommended', 'tjcore'),
        'condition' => [
          'is_price_box_recommend' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'price_title',
      [
        'label'       => __('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'label_block' => true,
        'default'     => esc_html__('Basic', 'tjcore'),
        'dynamic'     => [
          'active' => true,
        ],
      ]
    );
    $repeater->add_control(
      'price_save',
      [
        'label'       => __('Save Text', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Save 20%', 'tjcore'),
      ]
    );
    $repeater->add_control(
      'price_desc',
      [
        'label' => esc_html__('Description', 'tjcore'),
        'type' => Controls_Manager::TEXTAREA,
        'rows' => 3,
        'default' => esc_html__('Perfect for a small teams', 'tjcore'),
      ]
    );


    $repeater->add_control(
      'price_heading_01',
      [
        'label' => esc_html__('Price', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $repeater->add_control(
      'tj_price_currency',
      [
        'label'       => __('Currency', 'tjcore'),
        'type'        => Controls_Manager::SELECT,
        'label_block' => false,
        'options'     => [
          ''             => __('None', 'tjcore'),
          'baht'         => '&#3647; ' . _x('Baht', 'Currency Symbol', 'tjcore'),
          'bdt'          => '&#2547; ' . _x('BD Taka', 'Currency Symbol', 'tjcore'),
          'dollar'       => '&#36; ' . _x('Dollar', 'Currency Symbol', 'tjcore'),
          'euro'         => '&#128; ' . _x('Euro', 'Currency Symbol', 'tjcore'),
          'franc'        => '&#8355; ' . _x('Franc', 'Currency Symbol', 'tjcore'),
          'guilder'      => '&fnof; ' . _x('Guilder', 'Currency Symbol', 'tjcore'),
          'krona'        => 'kr ' . _x('Krona', 'Currency Symbol', 'tjcore'),
          'lira'         => '&#8356; ' . _x('Lira', 'Currency Symbol', 'tjcore'),
          'peseta'       => '&#8359 ' . _x('Peseta', 'Currency Symbol', 'tjcore'),
          'peso'         => '&#8369; ' . _x('Peso', 'Currency Symbol', 'tjcore'),
          'pound'        => '&#163; ' . _x('Pound Sterling', 'Currency Symbol', 'tjcore'),
          'real'         => 'R$ ' . _x('Real', 'Currency Symbol', 'tjcore'),
          'ruble'        => '&#8381; ' . _x('Ruble', 'Currency Symbol', 'tjcore'),
          'rupee'        => '&#8360; ' . _x('Rupee', 'Currency Symbol', 'tjcore'),
          'indian_rupee' => '&#8377; ' . _x('Rupee (Indian)', 'Currency Symbol', 'tjcore'),
          'shekel'       => '&#8362; ' . _x('Shekel', 'Currency Symbol', 'tjcore'),
          'won'          => '&#8361; ' . _x('Won', 'Currency Symbol', 'tjcore'),
          'yen'          => '&#165; ' . _x('Yen/Yuan', 'Currency Symbol', 'tjcore'),
          'custom'       => __('Custom', 'tjcore'),
        ],
        'default'     => 'dollar',
      ]
    );
    $repeater->add_control(
      'tj_currency_custom',
      [
        'label'     => __('Custom Symbol', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'condition' => [
          'price_currency' => 'custom',
        ],
        'dynamic'   => [
          'active' => true,
        ],
      ]
    );
    $repeater->start_controls_tabs('pricing_price_tabs');
    $repeater->start_controls_tab(
      'pricing_year_tab',
      [
        'label' => esc_html__('Yearly', 'tjcore'),
      ]
    );
    $repeater->add_control(
      'tj_yearly_price',
      [
        'label'   => __('Yearly Price', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('9.99', 'tjcore'),
        'dynamic' => [
          'active' => true,
        ],
      ]
    );
    $repeater->add_control(
      'tj_year_price_period',
      [
        'label'   => __('Period', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('/year', 'tjcore'),
      ]
    );
    $repeater->end_controls_tab();
    $repeater->start_controls_tab(
      'pricing_month_tab',
      [
        'label' => esc_html__('Monthly', 'tjcore'),
      ]
    );
    $repeater->add_control(
      'tj_monthly_price',
      [
        'label'   => __('Monthly Price', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('4.99', 'tjcore'),
        'dynamic' => [
          'active' => true,
        ],
      ]
    );
    $repeater->add_control(
      'tj_month_price_period',
      [
        'label'   => __('Period', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('/month', 'tjcore'),
      ]
    );
    $repeater->end_controls_tab();
    $repeater->end_controls_tabs();

    $repeater->add_control(
      'price_heading_02',
      [
        'label' => esc_html__('Features', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $repeater->add_control(
      'tj_price_features',
      [
        'label'   => __('Features Content', 'tjcore'),
        'type'    => Controls_Manager::TEXTAREA,
        'default' => tj_kses('<ul>
          <li class="active"><i class="tji-double-check"></i> Our in-depth consultation is more than just a
            conversation</li>
          <li class="active"><i class="tji-double-check"></i> Standard business performance package</li>
          <li class="active"><i class="tji-double-check"></i> Quick email support with priority access to
            our
            consulting</li>
          <li class="active"><i class="tji-double-check"></i> Monthly strategic check-In & progress review
          </li>
          <li class="active"><i class="tji-double-check"></i> Progress reviews & performance optimization
          </li>
          <li class="active"><i class="tji-double-check"></i> Quick email support with priority access to
            our
            consulting</li>
          <li><i class="tji-double-check"></i> 24/7 dedicated business support</li>
        </ul>')
      ]
    );

    $repeater->add_control(
      'price_heading_03',
      [
        'label' => esc_html__('Buttons', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $repeater->start_controls_tabs('price_button_tabs');
    $repeater->start_controls_tab(
      'button_01_tab',
      [
        'label' => esc_html__('Button 01', 'tjcore'),
      ]
    );
    $repeater->add_control(
      'tj_btn1_icon',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'default' => [
          'value' => 'tji-arrow-right',
          'library' => 'tj',
        ],
        'fa4compatibility' => 'btn1_icon',
        'skin' => 'inline',
        'label_block' => false
      ]
    );
    $repeater->add_control(
      'tj_btn1_text',
      [
        'label'       => esc_html__('Button Text', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Choose package', 'tjcore'),
      ]
    );
    $repeater->add_control(
      'tj_btn1_link_type',
      [
        'label'       => esc_html__('Button Link Type', 'tjcore'),
        'type'        => Controls_Manager::SELECT,
        'options'     => [
          '1' => 'Custom Link',
          '2' => 'Internal Page',
        ],
        'default'     => '1',
        'label_block' => true,
      ]
    );
    $repeater->add_control(
      'tj_btn1_link',
      [
        'label'         => esc_html__('Button link', 'tjcore'),
        'type'          => Controls_Manager::URL,
        'dynamic'       => [
          'active' => true,
        ],
        'placeholder'   => esc_html__('https://your-link.com', 'tjcore'),
        'condition'     => [
          'tj_btn1_link_type' => '1',
        ],
        'label_block'   => true,
      ]
    );
    $repeater->add_control(
      'tj_btn1_page_link',
      [
        'label'       => esc_html__('Select Page Link', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'tj_btn1_link_type' => '2',
        ],
      ]
    );
    $repeater->end_controls_tab();

    $repeater->start_controls_tab(
      'button_02_tab',
      [
        'label' => esc_html__('Button 02', 'tjcore'),
      ]
    );
    $repeater->add_control(
      'tj_btn2_icon',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'default' => [
          'value' => 'tji-angle-right',
          'library' => 'tj',
        ],
        'fa4compatibility' => 'btn2_icon',
        'skin' => 'inline',
        'label_block' => false
      ]
    );
    $repeater->add_control(
      'tj_btn2_text',
      [
        'label'       => esc_html__('Button Text', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Price comparison', 'tjcore'),
      ]
    );
    $repeater->add_control(
      'tj_btn2_link_type',
      [
        'label'       => esc_html__('Button Link Type', 'tjcore'),
        'type'        => Controls_Manager::SELECT,
        'options'     => [
          '1' => 'Custom Link',
          '2' => 'Internal Page',
        ],
        'default'     => '1',
        'label_block' => true,
      ]
    );
    $repeater->add_control(
      'tj_btn2_link',
      [
        'label'         => esc_html__('Button link', 'tjcore'),
        'type'          => Controls_Manager::URL,
        'dynamic'       => [
          'active' => true,
        ],
        'placeholder'   => esc_html__('https://your-link.com', 'tjcore'),
        'condition'     => [
          'tj_btn2_link_type' => '1',
        ],
        'label_block'   => true,
      ]
    );
    $repeater->add_control(
      'tj_btn2_page_link',
      [
        'label'       => esc_html__('Select Page Link', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'tj_btn2_link_type' => '2',
        ],
      ]
    );
    $repeater->end_controls_tab();
    $repeater->end_controls_tabs();

    $this->add_control(
      'tj_pricing_content',
      [
        'type'        => Controls_Manager::REPEATER,
        'fields'      => $repeater->get_controls(),
        'show_label'  => false,
        'default'     => [
          [
            'price_title' => esc_html__('Basic', 'tjcore'),
            'price_desc' => esc_html__('Perfect for a small teams', 'tjcore'),
            'tj_yearly_price' => esc_html__('80', 'tjcore'),
            'tj_monthly_price' => esc_html__('20', 'tjcore'),
          ],
          [
            'price_title' => esc_html__('Business', 'tjcore'),
            'price_desc' => esc_html__('Perfect for a medium teams', 'tjcore'),
            'tj_yearly_price' => esc_html__('100', 'tjcore'),
            'tj_monthly_price' => esc_html__('40', 'tjcore'),
          ],
          [
            'price_title' => esc_html__('Enterprise', 'tjcore'),
            'price_desc' => esc_html__('Perfect for a large teams', 'tjcore'),
            'tj_yearly_price' => esc_html__('120', 'tjcore'),
            'tj_monthly_price' => esc_html__('80', 'tjcore'),
          ],
        ],
        'title_field' => '{{{ price_title }}}',
      ]
    );
    $this->end_controls_section();


    // animation
    $this->start_controls_section(
      'tj_animation_group',
      [
        'label' => esc_html__('Animation', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',

      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();
    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Section', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->start_controls_tabs('price_section_tabs');
    $this->start_controls_tab(
      'section_style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_background',
        'selector' => '{{WRAPPER}} .tab_item',
        'exclude' => ['image', 'video']
      ]
    );
    $this->add_control(
      'tj_border_color',
      [
        'label'     => __('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tab_item' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'section_style_active_tab',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_active_background',
        'selector' => '{{WRAPPER}} .tab_item.active, {{WRAPPER}} .tab_item.active::after, {{WRAPPER}} .tab_item:not(.collapsed)',
        'exclude' => ['image', 'video']
      ]
    );
    $this->add_control(
      'tj_active_border_color',
      [
        'label'     => __('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tab_item.active' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .tab_item:not(.collapsed)' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'tj_section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tab_item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_control(
      'price_style_options-01',
      [
        'label' => esc_html__('Content', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => __('Content Background Color', 'tjcore'),
          ],
        ],
        'name'     => 'tj_section_content_background',
        'selector' => '{{WRAPPER}} .tab_content',
        'exclude' => ['image', 'video']
      ]
    );
    $this->add_responsive_control(
      'tj_section_content_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tab_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // Title
    $this->start_controls_section(
      '_style_price_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .tab_item .title',
      ]
    );
    $this->start_controls_tabs('title_style_tabs');
    $this->start_controls_tab(
      'title_style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tab_item .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'title_style_active_tab',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_title_active_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tab_item.active .title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tab_item:not(.collapsed) .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tab_item .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // Save Text
    $this->start_controls_section(
      '_style_price_save_text',
      [
        'label' => esc_html__('Save Text', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_save_text_typography',
        'selector' => '{{WRAPPER}} .tab_item .title span',
      ]
    );
    $this->start_controls_tabs('save_text_style_tabs');
    $this->start_controls_tab(
      'save_text_style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_save_text_bg_color',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tab_item .title span' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_save_text_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tab_item .title span' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'save_text_style_active_tab',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_save_text_active_bg_color',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tab_item.active .title span' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .tab_item:not(.collapsed) .title span' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_save_text_active_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tab_item.active .title span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tab_item:not(.collapsed) .title span' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'tj_save_text_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tab_item .title span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // Desc
    $this->start_controls_section(
      '_style_desc_text',
      [
        'label' => esc_html__('Description', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_desc_typography',
        'selector' => '{{WRAPPER}} .tab_item .desc',
      ]
    );
    $this->start_controls_tabs('desc_style_tabs');
    $this->start_controls_tab(
      '_desc_style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_desc_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tab_item .desc' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      '_desc_style_active_tab',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_desc_active_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tab_item.active .desc' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tab_item:not(.collapsed) .desc' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'tj_desc_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tab_item .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // price Price
    $this->start_controls_section(
      '_style_price_price',
      [
        'label' => esc_html__('Price', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_control(
      '_style_price_currency',
      [
        'label' => esc_html__('Currency', 'tjcore'),
        'type' => Controls_Manager::HEADING,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_price_currency_typography',
        'selector' => '{{WRAPPER}} .tab_item .price .dollar',
      ]
    );
    $this->start_controls_tabs('currency_style_tabs');
    $this->start_controls_tab(
      '_currency_style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_price_currency_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tab_item .price .dollar' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      '_currency_style_active_tab',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_price_currency_a_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tab_item.active .price .dollar' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tab_item:not(.collapsed) .price .dollar' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();


    $this->add_control(
      '_style_price',
      [
        'label' => esc_html__('Price', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_price_price_typography',
        'selector' => '{{WRAPPER}} .tab_item .price .price-number',
      ]
    );
    $this->start_controls_tabs('price_price_style_tabs');
    $this->start_controls_tab(
      '_price_price_style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_price_price_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tab_item .price .price-number' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      '_price_price_style_active_tab',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_price_price_active_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tab_item.active .price .price-number' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tab_item:not(.collapsed) .price .price-number' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();


    $this->add_control(
      '_style_price_period',
      [
        'label' => esc_html__('Period', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_price_period_typography',
        'selector' => '{{WRAPPER}} .tab_item .price .period',
      ]
    );
    $this->start_controls_tabs('price_period_style_tabs');
    $this->start_controls_tab(
      '_price_period_style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_price_period_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tab_item .price .period' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      '_price_period_style_active_tab',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_price_period_a_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tab_item.active .price .period' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tab_item:not(.collapsed) .price .period' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();

    // Badge Text
    $this->start_controls_section(
      '_style_badge_text',
      [
        'label' => esc_html__('Recommend Text', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_badge_typography',
        'selector' => '{{WRAPPER}} .tab_content .pricing-badge',
      ]
    );
    $this->add_control(
      'tj_badge_bg_color',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tab_content .pricing-badge' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_badge_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tab_content .pricing-badge' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_badge_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tab_content .pricing-badge' => 'Padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // feature
    $this->start_controls_section(
      '_style_feature',
      [
        'label' => esc_html__('Feature', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_feature_typography',
        'selector' => '{{WRAPPER}} .tab_content .features li',
      ]
    );
    $this->start_controls_tabs('price_feature_style_tabs');
    $this->start_controls_tab(
      '_price_feature_style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_feature_icon_color',
      [
        'label'     => __('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tab_content .features li i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_feature_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tab_content .features li' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      '_price_feature_style_active_tab',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_feature_icon_acolor',
      [
        'label'     => __('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tab_content .features li.active i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_feature_acolor',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tab_content .features li.active' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'tj_feature_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tab_content .features li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    //Button 01
    $this->start_controls_section(
      '_heading_hero_btn_style',
      [
        'label' => __('Button 01', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'btn_typography',
        'selector' => '{{WRAPPER}} .tj-primary-btn',
      ]
    );
    $this->start_controls_tabs('btn_style_tabs');
    $this->start_controls_tab(
      'btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn .btn_text' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn .btn_icon' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_bgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn .btn_inner::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_hcolor',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn:hover .btn_text' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_hcolor',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover .btn_icon' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_hbgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover .btn_inner::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_bg_hcolor',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();

    // button
    $this->start_controls_section(
      '_heading_price_btn',
      [
        'label' => __('Button 02', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'pbtn_typography',
        'selector' => '{{WRAPPER}} .text-btn',
      ]
    );
    $this->start_controls_tabs('pbtn_tabs');
    $this->start_controls_tab(
      'pbtn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'pbtn_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .text-btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .text-btn i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'pstyle_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'pbtn_text_hover_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .text-btn:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .text-btn:hover i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .text-btn:before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'pbtn_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .text-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  private static function get_currency_symbol($symbol_name) {
    $symbols = [
      'baht'         => '&#3647;',
      'bdt'          => '&#2547;',
      'dollar'       => '&#36;',
      'euro'         => '&#128;',
      'franc'        => '&#8355;',
      'guilder'      => '&fnof;',
      'indian_rupee' => '&#8377;',
      'pound'        => '&#163;',
      'peso'         => '&#8369;',
      'peseta'       => '&#8359',
      'lira'         => '&#8356;',
      'ruble'        => '&#8381;',
      'shekel'       => '&#8362;',
      'rupee'        => '&#8360;',
      'real'         => 'R$',
      'krona'        => 'kr',
      'won'          => '&#8361;',
      'yen'          => '&#165;',
    ];

    return isset($symbols[$symbol_name]) ? $symbols[$symbol_name] : '';
  }

  /**
   * Render the widget output on the frontend.
   *
   */
  protected function render() {
    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/pricing-tab/style-' . $tj_design_style . '.php';
?>

<?php
  }
}

$widgets_manager->register(new TJ_Pricing_Tab());
