<?php

namespace TJCore;

use Elementor\Widget_Base;
use \Elementor\Utils;
use Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Text_Stroke;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Css_Filter;
use Elementor\Group_Control_Background;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Elementor widget for Process.
 */
class TJ_Process extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-process';
  }

  // widget title.
  public function get_title() {
    return __('TJ Process', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-navigation-horizontal tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'process',
      'tj process',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {
    // layout Panel
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Process Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Process Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      '_tj_content_tab',
      [
        'label' => esc_html__('Content', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );
    $repeater = new Repeater();
    $repeater->add_control(
      'content_style',
      [
        'label' => esc_html__('Content Style', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => 1,
        'options' => [
          1 => esc_html__('Style 1', 'tjcore'),
          2 => esc_html__('Style 2', 'tjcore'),
          3 => esc_html__('Style 3', 'tjcore'),
        ],
        'separator' => 'after'
      ]
    );
    $repeater->add_control(
      'tj_image',
      [
        'label' => esc_html__('Choose Image', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'content_style!' => ['1', '2']
        ]
      ]
    );
    $repeater->add_control(
      'tj_no',
      [
        'label' => esc_html__('Number', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'default' => esc_html__('01.', 'tjcore'),
      ]
    );
    $repeater->add_control(
      'tj_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'default' => esc_html__('Understand business', 'tjcore'),
        'label_block' => true
      ]
    );
    $repeater->add_control(
      'tj_content',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'type' => Controls_Manager::TEXTAREA,
        'default' => tj_kses("Our consultancy excels in providing quick solutions tailored to your business challenges"),
      ]
    );
    $repeater->add_control(
      'tj_step_text',
      [
        'label' => esc_html__('Step Text', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'default' => esc_html__('STEPS.', 'tjcore'),
        'condition' => [
          'content_style!' => ['1', '2']
        ]
      ]
    );
    $repeater->add_control(
      'tj_btn_text',
      [
        'label' => esc_html__('Button Text', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'default' => esc_html__('Book discovery call', 'tjcore'),
        'condition' => [
          'content_style!' => ['1', '3']
        ]
      ]
    );
    $repeater->add_control(
      'tj_btn_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'btn_icon',
        'default'          => [
          'value'   => 'tji-angle-right',
          'library' => 'tji',
        ],
        'skin'             => 'inline',
        'label_block'      => false,
        'condition' => [
          'content_style!' => ['1', '3']
        ]
      ]
    );
    $repeater->add_control(
      'tj_btn_link',
      [
        'label' => esc_html__('Button Link', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'default' => esc_attr("#"),
        'label_block' => true,
        'condition' => [
          'content_style!' => ['1', '3']
        ]
      ]
    );

    // animation
    $repeater->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $repeater->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $repeater->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ]
      ]
    );

    $this->add_control(
      'process_steps',
      [
        'label' => esc_html__('Process Steps', 'tjcore'),
        'type' => Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'tj_no' => esc_html__('01.', 'tjcore'),
            'tj_title' => esc_html__('Understand business', 'tjcore'),
            'tj_content' => esc_html__('Our consultancy excels in providing quick solutions tailored to your business challenges', 'tjcore'),
          ],
          [
            'tj_no' => esc_html__('02.', 'tjcore'),
            'tj_title' => esc_html__('Custom strategy', 'tjcore'),
            'tj_content' => esc_html__('Our consultancy excels in providing quick solutions tailored to your business challenges', 'tjcore'),
          ],
          [
            'tj_no' => esc_html__('03.', 'tjcore'),
            'tj_title' => esc_html__('Execute & optimize', 'tjcore'),
            'tj_content' => esc_html__('Our consultancy excels in providing quick solutions tailored to your business challenges', 'tjcore'),
          ],
        ],
        'title_field' => '{{{ tj_title }}}',
      ]
    );
    $this->add_control(
      'tj_title_tag',
      [
        'label'   => esc_html__('Title HTML Tag', 'tjcore'),
        'type'    => Controls_Manager::CHOOSE,
        'options' => [
          'h1' => [
            'title' => esc_html__('H1', 'tjcore'),
            'icon'  => 'eicon-editor-h1',
          ],
          'h2' => [
            'title' => esc_html__('H2', 'tjcore'),
            'icon'  => 'eicon-editor-h2',
          ],
          'h3' => [
            'title' => esc_html__('H3', 'tjcore'),
            'icon'  => 'eicon-editor-h3',
          ],
          'h4' => [
            'title' => esc_html__('H4', 'tjcore'),
            'icon'  => 'eicon-editor-h4',
          ],
          'h5' => [
            'title' => esc_html__('H5', 'tjcore'),
            'icon'  => 'eicon-editor-h5',
          ],
          'h6' => [
            'title' => esc_html__('H6', 'tjcore'),
            'icon'  => 'eicon-editor-h6',
          ],
        ],
        'default' => 'h5',
        'toggle'  => false,
        'separator' => 'before'
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * About_TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      'section_style_wrapper',
      [
        'label' => esc_html__('Wrapper style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_wrapper_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .h5-process_wrap, {{WRAPPER}} .h7-process-item.style-4 .process-content, {{WRAPPER}} .h7-process-item.style-4 .process-index, {{WRAPPER}} .process-item.style-4 .process-index, {{WRAPPER}} .h7-process-item.style-4 .process-content, {{WRAPPER}} .h9-process-item',
      ]
    );
    $this->add_control(
      'tj_wrapper_shaped_color',
      [
        'label'     => __('Shaped Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .h9-process-item .process-img' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .h9-process-item .process-content .step' => 'border-color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style!' => ['1', '2', '3']
        ]
      ]
    );
    $this->add_responsive_control(
      'tj_wrapper_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .h5-process_wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h7-process-item.style-4 .process-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .process-item.style-4 .process-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h9-process-item .process-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_wrapper_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .h5-process_wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h7-process-item.style-4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .process-item.style-4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h9-process-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // no
    $this->start_controls_section(
      '_style_no',
      [
        'label' => esc_html__('Number', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_no_typography',
        'selector' => '{{WRAPPER}} .h5-process_item .step, {{WRAPPER}} .h7-process-item.style-4 .process-index span, {{WRAPPER}} .process-item.style-4 .process-index span, {{WRAPPER}} .h9-process-item .process-content .step',
      ]
    );
    $this->start_controls_tabs('style_tabs');
    $this->start_controls_tab(
      'style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_no_text_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .h5-process_item .step' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h7-process-item.style-4 .process-index span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h7-process-item.style-4 .process-index span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h9-process-item .process-content .step' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_no_bg_color',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .h5-process_item .step' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .h5-process_item .line::after' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .h7-process-item.style-4 .process-index span' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .process-item.style-4 .process-index span' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .h9-process-item .process-content .step' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'style_active_tab',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_no_text_active_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .h5-process_item.active .step' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h7-process-item.active .process-index span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .process-item.active .process-index span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h9-process-item.active .process-content .step' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_no_bg_active_color',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .h5-process_item.active .step' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .h5-process_item.active .line::after' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .h7-process-item.active .process-index span' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .process-item.active .process-index span' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .h9-process-item.active .process-content .step' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_control(
      'tj_line_color',
      [
        'label'     => __('Line Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .h5-process_item .line::before' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .h7-process-item.active .process-index span' => 'background-color: {{VALUE}}',
        ],
        'separator' => 'before',
        'condition' => [
          'tj_design_style!' => ['4']
        ]
      ]
    );
    $this->add_responsive_control(
      'tj_no_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .h5-process_item .step' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition' => [
          'tj_design_style!' => ['2', '3', '4']
        ]
      ]
    );
    $this->end_controls_section();


    // title
    $this->start_controls_section(
      '_style_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .h5-process_item .title, {{WRAPPER}} .h7-process-item.style-4 .process-content .title, {{WRAPPER}} .process-item.style-4 .process-content .title, {{WRAPPER}} .h9-process-item .process-content .title',
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .h5-process_item .title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h7-process-item.style-4 .process-content .title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .process-item.style-4 .process-content .title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h9-process-item .process-content .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .h5-process_item .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h7-process-item.style-4 .process-content .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .process-item.style-4 .process-content .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h9-process-item .process-content .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .h5-process_item .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h7-process-item.style-4 .process-content .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .process-item.style-4 .process-content .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h9-process-item .process-content .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // content
    $this->start_controls_section(
      '_style_content',
      [
        'label'     => esc_html__('Content', 'tjcore'),
        'tab'       => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_content_typography',
        'selector' => '{{WRAPPER}} .h5-process_item .desc, {{WRAPPER}} .h7-process-item.style-4 .process-content .desc, {{WRAPPER}} .process-item.style-4 .process-content .desc, {{WRAPPER}} .h9-process-item .process-content .desc',
      ]
    );
    $this->add_control(
      'tj_content_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .h5-process_item .desc' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h7-process-item.style-4 .process-content .desc' => 'color: {{VALUE}}',
          '{{WRAPPER}} .process-item.style-4 .process-content .desc' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h9-process-item .process-content .desc' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_content_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .h5-process_item .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h7-process-item.style-4 .process-content .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .process-item.style-4 .process-content .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h9-process-item .process-content .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_content_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .h5-process_item .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h7-process-item.style-4 .process-content .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .process-item.style-4 .process-content .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h9-process-item .process-content .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // _style_step_text
    $this->start_controls_section(
      '_style_step_text',
      [
        'label' => esc_html__('Step Text', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['1', '2', '3']
        ]
      ]
    );
    $this->add_control(
      'tj_step_text_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .h9-process-item .step-text' => '-webkit-text-stroke-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();

    // button
    $this->start_controls_section(
      '_style_button',
      [
        'label'     => esc_html__('Button', 'tjcore'),
        'tab'       => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['1', '4']
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_button_typography',
        'selector' => '{{WRAPPER}} .h7-process-item .text-btn, {{WRAPPER}} .process-item .text-btn',
      ]
    );
    $this->add_control(
      'tj_button_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .h7-process-item .text-btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h7-process-item .text-btn::before' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .process-item .text-btn' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .process-item .text-btn::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_button_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .h7-process-item .text-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .process-item .text-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/process/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Process());
