<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Projects Carousel.
 */
class TJ_Projects_2 extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-project-list-2';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Projects List 2', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-apps tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'project',
      'projects',
      'tj project',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {

    // layout Panel
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Project Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
        ],
        'default' => 1,
      ]
    );

    $this->end_controls_section();

    // Project List
    $this->start_controls_section(
      'tj_project_tab_list',
      [
        'label' => esc_html__('Project List', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $repeater = new Repeater();
    $repeater->add_control(
      'field_condition',
      [
        'label' => __('Field condition', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          1 => __('Style 01', 'tjcore'),
          2 => __('Style 02', 'tjcore'),
          3 => __('Style 03', 'tjcore'),
        ],
        'default' => '1',
        'frontend_available' => true,
        'style_transfer' => true,
      ]
    );
    $repeater->add_control(
      'tj_project_image',
      [
        'label'   => esc_html__('Project Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],

      ]
    );
    $repeater->add_control(
      'tj_project_title',
      [
        'label'       => esc_html__('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => esc_html__('Solvior project title', 'tjcore'),
        'rows' => 3,
      ]
    );
    $repeater->add_control(
      'tj_project_link',
      [
        'label' => esc_html__('Link', 'tjcore'),
        'type' => Controls_Manager::URL,
        'dynamic'       => [
          'active' => true,
        ],
        'default' => [
          'url' => '#',
          'is_external' => false,
          'nofollow' => false,
        ]
      ]
    );
    $repeater->add_control(
      'tj_project_cat',
      [
        'label'       => esc_html__('Category 1', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Branding', 'tjcore'),
        'label_block' => true,
        'condition' => [
          'field_condition!' => ['2'],
        ],
      ]
    );
    $repeater->add_control(
      'tj_cat_link',
      [
        'label' => esc_html__('Category Link', 'tjcore'),
        'type' => Controls_Manager::URL,
        'dynamic'       => [
          'active' => true,
        ],
        'default' => [
          'url' => '#',
          'is_external' => false,
          'nofollow' => false,
        ],
        'condition' => [
          'field_condition!' => ['2'],
        ],
      ]
    );
    $repeater->add_control(
      'tj_project_cat2',
      [
        'label'       => esc_html__('Category 2', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Design', 'tjcore'),
        'label_block' => true,
        'condition' => [
          'field_condition!' => ['2'],
        ],
      ]
    );
    $repeater->add_control(
      'tj_cat_link2',
      [
        'label' => esc_html__('Category 2 Link', 'tjcore'),
        'type' => Controls_Manager::URL,
        'dynamic'       => [
          'active' => true,
        ],
        'default' => [
          'url' => '#',
          'is_external' => false,
          'nofollow' => false,
        ],
        'condition' => [
          'field_condition!' => ['2'],
        ],
      ]
    );
    $repeater->add_control(
      'tj_project_desc',
      [
        'label'       => esc_html__('Description', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => esc_html__('Our consultant specialize in delivering rapid, actionable solutions that address your most pressing business on challenges. Whether you are facing.', 'tjcore'),
        'label_block' => true,
        'rows' => 3,
      ]
    );
    $repeater->add_control(
      'tj_project_btn',
      [
        'label'       => esc_html__('Button Text', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Learn more', 'tjcore'),
        'label_block' => true,
        'condition' => [
          'field_condition!' => ['2'],
        ],
      ]
    );
    $repeater->add_control(
      'tj_pbtn_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'pbtn_icon',
        'default'          => [
          'value'   => 'tji-arrow-right',
          'library' => 'tj',
        ],
        'skin'             => 'inline',
        'label_block'      => false,
      ]
    );
    $repeater->add_control(
      'tj_project_show',
      [
        'label'        => esc_html__('Expand Project?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'condition' => [
          'field_condition!' => ['2', '3'],
        ],
      ]
    );
    $repeater->add_control(
      'tj_project_stack',
      [
        'label'        => esc_html__('Enable Stack?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'condition' => [
          'field_condition!' => ['1'],
        ],
      ]
    );
    $repeater->add_control(
      'tj_project_number',
      [
        'label'        => esc_html__('Show Number?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'condition' => [
          'field_condition!' => ['1', '3'],
        ],
      ]
    );

    $this->add_control(
      'tj_project_list',
      [
        'label' => esc_html__('Project List', 'tjcore'),
        'type' => Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'tj_project_title' => esc_html('Innovate consultancy'),
          ],
          [
            'tj_project_title' => esc_html('Prime strategy partners'),
          ],
          [
            'tj_project_title' => esc_html('Elevate enterprise'),
          ],
          [
            'tj_project_title' => esc_html('Strat edge solutions'),
          ],
        ],
        'title_field' => '{{{ tj_project_title }}}',
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();


    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      'section_style_title_button',
      [
        'label' => esc_html__('Title Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition'  => [
          'tj_design_style!' => ['2', '3'],
        ],
      ]
    );
    $this->add_control(
      'tj_thumb_color',
      [
        'label'     => __('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .project-style-3 .project-thumb' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'heading_title',
      [
        'label'     => __('Title', 'tjcore'),
        'type'      => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .project-style-3 .project-thumb .project-default-content .title',
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .project-style-3 .project-thumb .project-default-content .title' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'heading_button',
      [
        'label'     => __('Circle Button', 'tjcore'),
        'type'      => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );

    $this->add_responsive_control(
      'ficon_font_size',
      [
        'label' => esc_html__('Icon Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .project-style-3 .project-thumb .project-default-content span' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $this->add_control(
      'ficon_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .project-style-3 .project-thumb .project-default-content span' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'ficon_bgcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .project-style-3 .project-thumb .project-default-content span' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();

    // box
    $this->start_controls_section(
      'section_style_fcontent',
      [
        'label' => esc_html__('Content Box style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_wrapper_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .project-style-3 .project-content-box, {{WRAPPER}} .h6-project-item, {{WRAPPER}} .h10-projects_item .project_content',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'wrapper_border',
        'selector' => '{{WRAPPER}} .project-style-3 .project-content-box, {{WRAPPER}} .h6-project-item, {{WRAPPER}} .h10-projects_item .project_content',
      ]
    );
    $this->add_responsive_control(
      'tj_wrapper_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .project-style-3 .project-content-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h6-project-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h10-projects_item .project_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // category
    $this->start_controls_section(
      '_style_category_btn',
      [
        'label' => esc_html__('Category', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition'  => [
          'tj_design_style!' => ['2'],
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_category_btn_typography',
        'selector' => '{{WRAPPER}} .project-style-3 .project-content-box .project-tags ul li a, {{WRAPPER}} .h10-projects_item .project_content .category li a',
      ]
    );
    $this->start_controls_tabs('category_btn_style_tabs');
    $this->start_controls_tab(
      'category_btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_category_btn_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .project-style-3 .project-content-box .project-tags ul li a' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h10-projects_item .project_content .category li a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_category_btn_bgcolor',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .project-style-3 .project-content-box .project-tags ul li a' => 'background: {{VALUE}}',
          '{{WRAPPER}} .h10-projects_item .project_content .category li a' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_category_btn_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_category_btn_hcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .project-style-3 .project-content-box .project-tags ul li a:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h10-projects_item .project_content .category li a:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_category_btn_hbgcolor',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .project-style-3 .project-content-box .project-tags ul li a:hover' => 'background: {{VALUE}}',
          '{{WRAPPER}} .h10-projects_item .project_content .category li a:hover' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_snumber',
      [
        'label' => esc_html__('Number', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition'  => [
          'tj_design_style' => ['2'],
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_snumber_typography',
        'selector' => '{{WRAPPER}} .h6-project-item .no',
      ]
    );
    $this->add_control(
      'tj_snumber_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .h6-project-item .no' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_snumber_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .h6-project-item .no' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
    // title
    $this->start_controls_section(
      '_style_stitle',
      [
        'label' => esc_html__('Box Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_stitle_typography',
        'selector' => '{{WRAPPER}} .project-style-3 .project-content-box .project-text .title, {{WRAPPER}} .h6-project-item .title, {{WRAPPER}} .h10-projects_item .project_content .project_title',
      ]
    );
    $this->start_controls_tabs('stitle_style_tabs');
    $this->start_controls_tab(
      'stitle_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_stitle_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .project-style-3 .project-content-box .project-text .title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h6-project-item .title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h10-projects_item .project_content .project_title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_stitle_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_stitle_hcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .project-style-3 .project-content-box .project-text .title:hover a' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h6-project-item .title:hover a' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h10-projects_item .project_content .project_title:hover a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'tj_stitle_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .project-style-3 .project-content-box .project-text .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h6-project-item .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h10-projects_item .project_content .project_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_stitle_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .project-style-3 .project-content-box .project-text .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h6-project-item .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h10-projects_item .project_content .project_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // content
    $this->start_controls_section(
      '_style_fcontent',
      [
        'label'     => esc_html__('Box Content', 'tjcore'),
        'tab'       => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_content_typography',
        'selector' => '{{WRAPPER}} .project-style-3 .project-content-box .project-text .desc, {{WRAPPER}} .h6-project-item .desc, {{WRAPPER}} .h10-projects_item .project_content .desc',
      ]
    );
    $this->add_control(
      'tj_content_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .project-style-3 .project-content-box .project-text .desc' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h6-project-item .desc' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h10-projects_item .project_content .desc' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_content_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .project-style-3 .project-content-box .project-text .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h6-project-item .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h10-projects_item .project_content .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_content_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .project-style-3 .project-content-box .project-text .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h6-project-item .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h10-projects_item .project_content .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // Text button
    $this->start_controls_section(
      '_style_stext_btn',
      [
        'label' => esc_html__('Box Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition'  => [
          'tj_design_style!' => ['2', '3'],
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_stext_btn_typography',
        'selector' => '{{WRAPPER}} .project-style-3 .project-content-box .project-text .project-button .project-btn',
      ]
    );
    $this->start_controls_tabs('stext_btn_style_tabs');
    $this->start_controls_tab(
      'stext_btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_stext_btn_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .project-style-3 .project-content-box .project-text .project-button .project-btn' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_stext_btn_bgcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .project-style-3 .project-content-box .project-text .project-button .project-btn' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_stext_btn_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_stext_btn_hcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .project-style-3 .project-content-box .project-text .project-button .project-btn:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .project-style-3 .project-content-box .project-text .project-button .project-btn:hover::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_stext_btn_hbgcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .project-style-3 .project-content-box .project-text .project-button .project-btn:hover' => 'background: {{VALUE}}',
          '{{WRAPPER}} .project-style-3 .project-content-box .project-text .project-button .project-btn:hover::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'tj_stext_btn_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .project-style-3 .project-content-box .project-text .project-button .project-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // icon btn
    $this->start_controls_section(
      'section_style_icon_btn',
      [
        'label' => esc_html__('Icon Button', 'tjcore'),
        'tab' => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['1', '3'],
        ],
      ]
    );

    $this->start_controls_tabs('icon_btn_colors');

    $this->start_controls_tab(
      'icon_btn_colors_normal',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );

    $this->add_control(
      'icon_btn_color',
      [
        'label' => esc_html__('Color', 'tjcore'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .el-icon' => 'background-color: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'icon_btn_bgcolor',
      [
        'label' => esc_html__('Background Color', 'tjcore'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .el-icon' => 'background-color: {{VALUE}};',
        ],
      ]
    );

    $this->end_controls_tab();

    $this->start_controls_tab(
      'iconbtn_colors_hover',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );

    $this->add_control(
      'hover_icon_btn_color',
      [
        'label' => esc_html__('Color', 'tjcore'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .el-icon:hover' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'hover_icon_btn_bgcolor',
      [
        'label' => esc_html__('Background Color', 'tjcore'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .el-icon:hover' => 'background-color: {{VALUE}};',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->end_controls_tabs();

    $this->add_responsive_control(
      'icon_btn_size',
      [
        'label' => esc_html__('Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'vw', 'custom'],
        'range' => [
          'px' => [
            'min' => 6,
            'max' => 300,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .el-icon' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
        'separator' => 'before',
      ]
    );

    $this->add_control(
      'icon_btn_width',
      [
        'label' => esc_html__('Width', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors' => [
          '{{WRAPPER}} .el-icon' => 'width: {{SIZE}}{{UNIT}};',
        ],
        'range' => [
          'px' => [
            'max' => 100,
          ],
          'em' => [
            'min' => 0,
            'max' => 5,
          ],
          'rem' => [
            'min' => 0,
            'max' => 5,
          ],
        ],
      ]
    );

    $this->add_control(
      'icon_btn_height',
      [
        'label' => esc_html__('Height', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors' => [
          '{{WRAPPER}} .el-icon' => 'height: {{SIZE}}{{UNIT}};',
        ],
        'range' => [
          'px' => [
            'max' => 100,
          ],
          'em' => [
            'min' => 0,
            'max' => 5,
          ],
          'rem' => [
            'min' => 0,
            'max' => 5,
          ],
        ],
      ]
    );

    $this->end_controls_section();


    //Button
    $this->start_controls_section(
      '_heading_hero_btn_style',
      [
        'label' => __('Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['1', '2'],
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'btn_typography',
        'selector' => '{{WRAPPER}} .tj-primary-btn',
      ]
    );
    $this->start_controls_tabs('btn_style_tabs');
    $this->start_controls_tab(
      'btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn .btn_text' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn .btn_icon' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_bgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn .btn_inner::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_hcolor',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn:hover .btn_text' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_hcolor',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover .btn_icon' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_hbgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover .btn_inner::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_bg_hcolor',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/project-2/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Projects_2());
