<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Projects Carousel.
 */
class TJ_Projects_Grid extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-project-grid';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Projects Grid', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-apps tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'project',
      'projects',
      'tj project',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {
    // layout Panel
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Project Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
        ],
        'default' => 1,
      ]
    );

    $this->add_control(
      'tj_query_style',
      [
        'label'   => esc_html__('Data From', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Custom', 'tjcore'),
          2 => esc_html__('Query', 'tjcore'),
        ],
        'default' => 1,
        'separator' => 'before',
      ]
    );
    $this->end_controls_section();

    // Project Query
    $this->start_controls_section(
      'tj_project_query',
      [
        'label' => esc_html__('Project Query', 'tjcore'),
        'condition' => [
          'tj_query_style' => '2',
        ]
      ]
    );

    $post_type = 'projects';
    $taxonomy = 'projects-cat';

    $this->add_control(
      'posts_per_page',
      [
        'label' => esc_html__('Projects Per Page', 'tjcore'),
        'description' => esc_html__('Leave blank or enter -1 for all.', 'tjcore'),
        'type' => Controls_Manager::NUMBER,
        'default' => '6',
      ]
    );
    $this->add_control(
      'category',
      [
        'label' => esc_html__('Include Categories', 'tjcore'),
        'description' => esc_html__('Select a category to include or leave blank for all.', 'tjcore'),
        'type' => Controls_Manager::SELECT2,
        'multiple' => true,
        'options' => tj_get_categories($taxonomy),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'exclude_category',
      [
        'label' => esc_html__('Exclude Categories', 'tjcore'),
        'description' => esc_html__('Select a category to exclude', 'tjcore'),
        'type' => Controls_Manager::SELECT2,
        'multiple' => true,
        'options' => tj_get_categories($taxonomy),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'post__in',
      [
        'label' => esc_html__('Include Project', 'tjcore'),
        'type' => Controls_Manager::SELECT2,
        'options' => tj_get_all_types_post($post_type),
        'multiple' => true,
        'label_block' => true,
      ]
    );
    $this->add_control(
      'post__not_in',
      [
        'label' => esc_html__('Exclude Project', 'tjcore'),
        'type' => Controls_Manager::SELECT2,
        'options' => tj_get_all_types_post($post_type),
        'multiple' => true,
        'label_block' => true,
      ]
    );
    $this->add_control(
      'offset',
      [
        'label' => esc_html__('Offset', 'tjcore'),
        'type' => Controls_Manager::NUMBER,
        'default' => '0',
      ]
    );
    $this->add_control(
      'orderby',
      [
        'label' => esc_html__('Order By', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'options' => array(
          'ID' => 'Post ID',
          'author' => 'Post Author',
          'title' => 'Title',
          'date' => 'Date',
          'modified' => 'Last Modified Date',
          'parent' => 'Parent Id',
          'rand' => 'Random',
          'comment_count' => 'Comment Count',
          'menu_order' => 'Menu Order',
        ),
        'default' => 'date',
      ]
    );
    $this->add_control(
      'order',
      [
        'label' => esc_html__('Order', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'options' => [
          'asc' => esc_html__('Ascending', 'tjcore'),
          'desc' => esc_html__('Descending', 'tjcore'),
        ],
        'default' => 'desc',

      ]
    );

    $this->add_control(
      'tj_post_title_word',
      [
        'label'       => esc_html__('Title Word Limit', 'tjcore'),
        'description' => esc_html__('Set how many word you want to display!', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '6',
      ]
    );

    $this->add_control(
      'tj_pagination',
      [
        'label' => esc_html__('Enable Pagination?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before',
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before',
      ]
    );

    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );

    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();

    // Project Query
    $this->start_controls_section(
      'tj_project_custom',
      [
        'label' => esc_html__('Custom Query', 'tjcore'),
        'condition' => [
          'tj_query_style' => "1",
        ]
      ]
    );
    $repeater = new Repeater();
    $repeater->add_control(
      'tj_project_image',
      [
        'label'   => esc_html__('Project Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],

      ]
    );
    $repeater->add_control(
      'tj_project_title',
      [
        'label'       => esc_html__('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => esc_html__('Business Card', 'tjcore'),
        'rows' => 3,
      ]
    );
    $repeater->add_control(
      'tj_project_link',
      [
        'label' => esc_html__('Link', 'tjcore'),
        'type' => Controls_Manager::URL,
        'dynamic'       => [
          'active' => true,
        ],
        'default' => [
          'url' => '#',
          'is_external' => false,
          'nofollow' => false,
        ]
      ]
    );
    $repeater->add_control(
      'tj_project_cat',
      [
        'label'       => esc_html__('Category 1', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Branding', 'tjcore'),
        'label_block' => true,
      ]
    );
    $repeater->add_control(
      'tj_cat_link',
      [
        'label' => esc_html__('Category Link', 'tjcore'),
        'type' => Controls_Manager::URL,
        'dynamic'       => [
          'active' => true,
        ],
        'default' => [
          'url' => '#',
          'is_external' => false,
          'nofollow' => false,
        ]
      ]
    );
    $repeater->add_control(
      'tj_project_cat2',
      [
        'label'       => esc_html__('Category 2', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Design', 'tjcore'),
        'label_block' => true,
      ]
    );
    $repeater->add_control(
      'tj_cat_link2',
      [
        'label' => esc_html__('Category 2 Link', 'tjcore'),
        'type' => Controls_Manager::URL,
        'dynamic'       => [
          'active' => true,
        ],
        'default' => [
          'url' => '#',
          'is_external' => false,
          'nofollow' => false,
        ]
      ]
    );
    $this->add_control(
      'tj_project_list',
      [
        'label' => esc_html__('Project List', 'tjcore'),
        'type' => Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'tj_project_title' => esc_html('Business Card'),
          ],
          [
            'tj_project_title' => esc_html('Watch Mockup'),
          ],
          [
            'tj_project_title' => esc_html('Minimal Headphone'),
          ],
        ],
        'title_field' => '{{{ tj_project_title }}}',
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'section_column_settings',
      [
        'label' => esc_html__('Column Settings', 'tjcore'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'desktop_column',
      [
        'label' => esc_html__('Columns for Desktop', 'tjcore'),
        'description' => esc_html__('Screen width equal to or greater than 1200px', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          12 => esc_html__('1 Columns', 'tjcore'),
          6 => esc_html__('2 Columns', 'tjcore'),
          4 => esc_html__('3 Columns', 'tjcore'),
          3 => esc_html__('4 Columns', 'tjcore'),
          2 => esc_html__('6 Columns', 'tjcore'),
        ],
        'separator' => 'before',
        'default' => '6',
        'style_transfer' => true,
      ]
    );

    $this->add_control(
      'laptop_column',
      [
        'label' => esc_html__('Columns for Laptop', 'tjcore'),
        'description' => esc_html__('Screen width equal to or greater than 992px', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          12 => esc_html__('1 Columns', 'tjcore'),
          6 => esc_html__('2 Columns', 'tjcore'),
          4 => esc_html__('3 Columns', 'tjcore'),
          3 => esc_html__('4 Columns', 'tjcore'),
          2 => esc_html__('6 Columns', 'tjcore'),
        ],
        'separator' => 'before',
        'default' => '6',
        'style_transfer' => true,
      ]
    );

    $this->add_control(
      'tablet_column',
      [
        'label' => esc_html__('Columns for Tablet', 'tjcore'),
        'description' => esc_html__('Screen width equal to or greater than 768px', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          12 => esc_html__('1 Columns', 'tjcore'),
          6 => esc_html__('2 Columns', 'tjcore'),
          4 => esc_html__('3 Columns', 'tjcore'),
          3 => esc_html__('4 Columns', 'tjcore'),
          2 => esc_html__('6 Columns', 'tjcore'),
        ],
        'separator' => 'before',
        'default' => '6',
        'style_transfer' => true,
      ]
    );
    $this->add_control(
      'mobile_column',
      [
        'label' => esc_html__('Columns for Mobile', 'tjcore'),
        'description' => esc_html__('Screen width less than 768px', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          12 => esc_html__('1 Columns', 'tjcore'),
          6 => esc_html__('2 Columns', 'tjcore'),
          4 => esc_html__('3 Columns', 'tjcore'),
          3 => esc_html__('4 Columns', 'tjcore'),
          2 => esc_html__('6 Columns', 'tjcore'),
        ],
        'separator' => 'before',
        'default' => '12',
        'style_transfer' => true,
      ]
    );

    $this->end_controls_section();


    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      'section_style_service',
      [
        'label' => esc_html__('Wrapper style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_wrapper_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .project-item',
      ]
    );

    $this->add_control(
      'wrapper_overlay_color',
      [
        'label'     => __('Overlay Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .project-item::before' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'wrapper_overlay_opacity',
      [
        'label'     => __('Opacity', 'tjcore'),
        'type'      => Controls_Manager::NUMBER,
        'selectors' => [
          '{{WRAPPER}} .project-item::before' => 'opacity: {{VALUE}}',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'wrapper_border',
        'selector' => '{{WRAPPER}} .project-item',
      ]
    );
    $this->add_responsive_control(
      'tj_wrapper_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .project-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_wrapper_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .project-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_stitle',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_stitle_typography',
        'selector' => '{{WRAPPER}} .project-item .title',
      ]
    );
    $this->start_controls_tabs('stitle_style_tabs');
    $this->start_controls_tab(
      'stitle_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_stitle_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .project-item .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_stitle_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_stitle_hcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .project-item .title:hover a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'tj_stitle_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .project-item .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_stitle_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .project-item .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      '_style_stext_category',
      [
        'label' => esc_html__('Category', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_stext_btn_typography',
        'selectors' => '{{WRAPPER}} .project-item .project-content .tag-list a, {{WRAPPER}} .h8-case-study-item .h8-case-study-category ul li a',
      ]
    );
    $this->start_controls_tabs('stext_btn_style_tabs');
    $this->start_controls_tab(
      'stext_cat_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_stext_cat_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .project-item .project-content .tag-list a' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h8-case-study-item .h8-case-study-category ul li a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_stext_cat_bgcolor',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .project-item .project-content .tag-list a' => 'background: {{VALUE}}',
          '{{WRAPPER}} .h8-case-study-item .h8-case-study-category ul li a' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_stext_cat_border_color',
      [
        'label'     => __('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .project-item .project-content .tag-list a' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .h8-case-study-item .h8-case-study-category ul li a' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_stext_cat_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_stext_cat_hcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .project-item .project-content .tag-list a:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h8-case-study-item .h8-case-study-category ul li a:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_stext_cat_hbgcolor',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .project-item .project-content .tag-list a:hover' => 'background: {{VALUE}}',
          '{{WRAPPER}} .h8-case-study-item .h8-case-study-category ul li a:hover' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_stext_cat_border_hover_color',
      [
        'label'     => __('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .project-item .project-content .tag-list a:hover' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .h8-case-study-item .h8-case-study-category ul li a:hover' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();
    extract($settings);
    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/projects-grid/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Projects_Grid());
