<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

class Tj_Rating_Widget extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-rating';
  }

  // widget title.
  public function get_title()
  {
    return esc_html__('TJ Rating', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-rating tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'rating',
      'tj rating',
      'tj text',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {
    $this->start_controls_section(
      'tj_section_content',
      [
        'label' => esc_html__('Rating', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_rating',
      [
        'label'      => esc_html__('Rating', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['%'],
        'range'      => [
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => '%',
          'size' => 80,
        ],
      ]
    );
    $this->add_control(
      'tj_rating_text',
      [
        'label'      => esc_html__('Description', 'tjcore'),
        'default'    => esc_html__('Customers review (4.8/5.0)', 'tjcore'),
        'type'       => Controls_Manager::TEXT,
        'label_block' => true,
        'dynamic'    => [
          'active' => true,
        ],
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      'section_rating_style',
      [
        'label' => esc_html__('Rating Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'rating_typography',
        'label'    => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .star-ratings > *',
      ]
    );
    $this->add_control(
      'ricon_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .star-ratings > *' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'rtext_bgcolor',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .service-rating .star-fill' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'text_rating_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .service-rating .star-fill' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'rtext_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .service-rating .review' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
  }

  protected function render()
  {
    $settings = $this->get_settings_for_display();
    extract($settings);
    // animation
    $tjAnimation      = $settings['tj_animation'] ?? '';
    $tjAnimationName  = $settings['tj_animation_name'] ?? '';
    $tjAnimationDelay = $settings['tj_animation_delay'] ?? '';

    if (!empty($tjAnimation)) {
      $editorClass = "service-rating wow $tjAnimationName";
      $this->add_render_attribute('tj-editor-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
    } else {
      $editorClass = "service-rating";
    }
    $this->add_render_attribute('tj-editor-arg', 'class', $editorClass);

    if (!empty($tj_rating)): ?>

      <div <?php echo $this->get_render_attribute_string('tj-editor-arg'); ?>>
        <div class="star-fill">
          <div class="star-ratings">
            <div class="fill-ratings" style="width: <?php echo esc_attr($settings['tj_rating']['size']);
                                                    echo esc_attr($settings['tj_rating']['unit']) ?>">
              <span><?php esc_html_e('★★★★★', 'tjcore'); ?></span>
            </div>
            <div class="empty-ratings">
              <span><?php esc_html_e('★★★★★', 'tjcore'); ?></span>
            </div>
          </div>
        </div>
        <?php if (!empty($tj_rating_text)) : ?>
          <div class="review"><?php echo tj_kses($tj_rating_text); ?></div>
        <?php endif; ?>
      </div>
<?php endif;
  }
}
$widgets_manager->register(new Tj_Rating_Widget());
