<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

class TJ_Search_Form extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-search-form';
  }

  // widget title.
  public function get_title()
  {
    return esc_html__('TJ Search Form', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-search tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'search',
      'form',
      'tj search',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {
    $this->start_controls_section(
      'tj_section_content',
      [
        'label' => esc_html__('Search Form', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_placeholder',
      [
        'label'      => esc_html__('Placeholder', 'tjcore'),
        'default'    => esc_html__('Ask a question', 'tjcore'),
        'type'       => Controls_Manager::TEXT,
        'dynamic'    => [
          'active' => true,
        ],
      ]
    );

    $this->add_control(
      'tj_btn_text',
      [
        'label'      => esc_html__('Button Text', 'tjcore'),
        'default'    => esc_html__('Search', 'tjcore'),
        'type'       => Controls_Manager::TEXT,
        'dynamic'    => [
          'active' => true,
        ],
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    // fields
    $this->start_controls_section(
      '_style_field',
      [
        'label' => esc_html__('Input Field', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'cf_field_typo',
        'label'    => esc_html__('Field Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .faq-search-form .faq-search input:not([type=submit]):not([type=radio]):not([type=checkbox])',
      ]
    );
    $this->add_control(
      'cf_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .faq-search-form .faq-search input:not([type=submit]):not([type=radio]):not([type=checkbox])' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'cf_placeholder_color',
      [
        'label'     => esc_html__('Placeholder Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .faq-search-form .faq-search input:not([type=submit]):not([type=radio]):not([type=checkbox])::-moz-placeholder' => 'color: {{VALUE}}',

          '{{WRAPPER}} .faq-search-form .faq-search input:not([type=submit]):not([type=radio]):not([type=checkbox])::-ms-input-placeholder' => 'color: {{VALUE}}',

          '{{WRAPPER}} .faq-search-form .faq-search input:not([type=submit]):not([type=radio]):not([type=checkbox])::-webkit-input-placeholder' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'cf_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .faq-search-form .faq-search input:not([type=submit]):not([type=radio]):not([type=checkbox])' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'cf_border_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .faq-search-form .faq-search input:not([type=submit]):not([type=radio]):not([type=checkbox])' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'cf_field_padding',
      [
        'label'      => esc_html__('Field Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .faq-search-form .faq-search input:not([type=submit]):not([type=radio]):not([type=checkbox])' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before'
      ]
    );
    $this->end_controls_section();

    // button
    $this->start_controls_section(
      'section_tab_button',
      [
        'label' => esc_html__('Button Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'btn_typography',
        'selector' => '{{WRAPPER}} .faq-search-form .faq-search button .btn-text',
      ]
    );
    $this->start_controls_tabs('btn_tabs');
    $this->start_controls_tab(
      'btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .faq-search-form .faq-search button .btn-text' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_background_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .faq-search-form .faq-search button' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_hover_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .faq-search-form .faq-search button:hover .btn-text' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_background_hover_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .faq-search-form .faq-search button:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'btn_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .faq-search-form .faq-search button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->end_controls_section();
  }

  protected function render()
  {
    $settings = $this->get_settings_for_display();

    // animation
    $tjAnimation      = $settings['tj_animation'] ?? '';
    $tjAnimationName  = $settings['tj_animation_name'] ?? '';
    $tjAnimationDelay = $settings['tj_animation_delay'] ?? '';

    if (!empty($tjAnimation)) {
      $wrapperClass = "faq-search-form wow $tjAnimationName";
      $this->add_render_attribute('tj-wrap-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
    } else {
      $wrapperClass = "faq-search-form";
    }
    $this->add_render_attribute('tj-wrap-arg', 'class', $wrapperClass);

    $tj_placeholder = $settings['tj_placeholder'] ?? "";
    $tj_btn_text = $settings['tj_btn_text'] ?? "";

?>

    <div <?php echo $this->get_render_attribute_string('tj-wrap-arg'); ?>>
      <form method="get" action="<?php echo esc_url(home_url('/')); ?>">
        <div class="faq-search">
          <input type="text" value="<?php echo esc_attr(get_search_query()); ?>" placeholder="<?php echo esc_attr($tj_placeholder); ?>">
          <label><i class="tji-search"></i></label>
          <button type="submit"><span class="btn-text"><span><?php echo esc_attr($tj_btn_text); ?></span></span></button>
        </div>
      </form>
    </div>

<?php
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Search_Form());
