<?php

namespace TJCore;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Typography;


if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Services.
 */
class TJ_Service_List extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-service-title';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Services Title', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'tj-icon eicon-editor-list-ul';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'service-list',
      'services-list',
      'ts service list',
      'ts',
      'ts addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {

    $post_type = 'services';
    $taxonomy = 'services-cat';

    // Service group
    $this->start_controls_section(
      '_tj_services',
      [
        'label' => esc_html__('Services List', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'service_title',
      [
        'label'             => esc_html__('Title', 'tjcore'),
        'type'              => Controls_Manager::TEXT,
        'default'           => esc_html__('Services List', 'tjcore'),
        'label_block'       => TRUE,
      ]
    );
    $this->add_control(
      'posts_per_page',
      [
        'label' => esc_html__('Posts Per Page', 'tjcore'),
        'description' => esc_html__('Leave blank or enter -1 for all.', 'tjcore'),
        'type' => Controls_Manager::NUMBER,
        'default' => '6',
      ]
    );
    $this->add_control(
      'orderby',
      [
        'label' => esc_html__('Order By', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'options' => array(
          'ID' => 'Post ID',
          'author' => 'Post Author',
          'title' => 'Title',
          'date' => 'Date',
          'modified' => 'Last Modified Date',
          'parent' => 'Parent Id',
          'rand' => 'Random',
          'comment_count' => 'Comment Count',
          'menu_order' => 'Menu Order',
        ),
        'default' => 'date',
      ]
    );
    $this->add_control(
      'order',
      [
        'label' => esc_html__('Order', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'options' => [
          'asc'     => esc_html__('Ascending', 'tjcore'),
          'desc'     => esc_html__('Descending', 'tjcore')
        ],
        'default' => 'desc',

      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();


    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Wrapper Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .tj-sidebar-widget',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'wrapper_border',
        'selector' => '{{WRAPPER}} .tj-sidebar-widget',
      ]
    );

    $this->add_responsive_control(
      'tj_section_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sidebar-widget' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'tj_section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sidebar-widget' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'tj_section_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sidebar-widget' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_title',
      [
        'label' => esc_html__('Widget Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .tj-sidebar-widget-title',
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-sidebar-widget-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_title_linecolor',
      [
        'label'     => __('Line Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-sidebar-widget-title::before, .tj-sidebar-widget-title::after' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sidebar-widget-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before'
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sidebar-widget-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // item
    $this->start_controls_section(
      '_section_style_service_item',
      [
        'label' => esc_html__('Service Item', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->start_controls_tabs('service_style_tabs');
    $this->start_controls_tab(
      'service_style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_service_background',
        'exclude' => ['image'],
        'selector' => '{{WRAPPER}} ul li a',
      ]
    );
    $this->add_control(
      'tj_service_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} ul li a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'service_style_hover_tab',
      [
        'label' => esc_html__('Hover/Active', 'tjcore'),
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_service_hover_background',
        'exclude' => ['image'],
        'selector' => '{{WRAPPER}} ul li a.active, {{WRAPPER}} ul li a:hover',
      ]
    );
    $this->add_control(
      'tj_service_hover_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} ul li a.active' => 'color: {{VALUE}}',
          '{{WRAPPER}} ul li a:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'tj_service_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} ul li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_service_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   *
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $serviceTitle = !empty($settings['service_title']) ? $settings['service_title'] : "";
    $posts_per_page = (!empty($settings['posts_per_page'])) ? $settings['posts_per_page'] : '-1';
    $orderby = (!empty($settings['orderby'])) ? $settings['orderby'] : 'post_date';
    $order = (!empty($settings['order'])) ? $settings['order'] : 'desc';

    $args = array(
      'post_type' => 'services',
      'post_status' => 'publish',
      'posts_per_page' => $posts_per_page,
      'orderby' => $orderby,
      'order' => $order,
    );

    // The Query
    $query = new \WP_Query($args);

    // animation
    $tsAnimation   = $settings['tj_animation'] ?? '';
    $tsAnimationName   = $settings['tj_animation_name'] ?? '';
    $tsAnimationDelay   = $settings['tj_animation_delay'] ?? '';

    if (!empty($tsAnimation)) {
      $widgetClass = "tj-sidebar-widget mb-0 wow $tsAnimationName";
      $this->add_render_attribute('tj-widget-arg', 'data-wow-delay', $tsAnimationDelay['size'] . "s");
    } else {
      $widgetClass = "tj-sidebar-widget mb-0";
    }
    $this->add_render_attribute('tj-widget-arg', 'class', $widgetClass);

?>
    <!-- service widget -->
    <div <?php echo $this->get_render_attribute_string('tj-widget-arg'); ?>>
      <?php if (!empty($serviceTitle)) : ?>
        <h5 class="tj-sidebar-widget-title"><?php echo esc_html($serviceTitle); ?></h5>
      <?php endif; ?>
      <?php if ($query->have_posts()) : ?>
        <div class="service-category">
          <ul>
            <?php while ($query->have_posts()): $query->the_post(); ?>
              <li>
                <a class="<?php echo (get_queried_object_id() == get_the_ID()) ? 'active' : ''; ?>" href="<?php the_permalink(); ?>">
                  <?php the_title(); ?>
                  <i class="tji-angle-right"></i>
                </a>
              </li>
            <?php endwhile;
            wp_reset_query(); ?>
          </ul>
        </div>
      <?php else:
        printf("%s", esc_html__("No Services Available", 'tjcore'));
      endif; ?>
    </div>
<?php
  }
}
$widgets_manager->register(new TJ_Service_List());
