<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Services Carousel.
 */
class TJ_ServiceList extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-service-list';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Services List', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-apps tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'service',
      'services',
      'tj service',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {


    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Service List Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
          5 => esc_html__('Style 05', 'tjcore'),
        ],
        'default' => 1,
      ]
    );

    $this->end_controls_section();

    $this->start_controls_section(
      'tj_service_tab_list',
      [
        'label' => esc_html__('Service List', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $repeater = new Repeater();

    $repeater->add_control(
      'field_condition',
      [
        'label' => __('Field condition', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'options' => [
          1 => __('Style 01', 'tjcore'),
          2 => __('Style 02', 'tjcore'),
          3 => __('Style 03', 'tjcore'),
          4 => __('Style 04', 'tjcore'),
          5 => __('Style 05', 'tjcore'),
        ],
        'default' => '1',
        'frontend_available' => true,
        'style_transfer' => true,
      ]
    );

    $repeater->add_control(
      'tj_service_image',
      [
        'label'   => esc_html__('Service Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'field_condition!' => ['2', '3', '4', '5'],
        ],
      ]
    );
    $repeater->add_control(
      'tj_service_icon',
      [
        'label' => __('Icon', 'tjcore'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'label_block' => true,
        'fa4compatibility' => 'service_icon',
        'default' => [
          'value' => 'tji-strategic',
          'library' => 'tj',
        ],
        'condition' => [
          'field_condition!' => ['1', '4'],
        ],
      ]
    );
    $repeater->add_control(
      'tj_service_title',
      [
        'label'       => esc_html__('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => esc_html__('Service Title', 'tjcore'),
        'rows' => 3,
      ]
    );
    $repeater->add_control(
      'tj_service_link',
      [
        'label' => esc_html__('Link', 'tjcore'),
        'type' => Controls_Manager::URL,
        'dynamic'       => [
          'active' => true,
        ],
        'default' => [
          'url' => '#',
          'is_external' => false,
          'nofollow' => false,
        ]
      ]
    );
    $repeater->add_control(
      'tj_service_desc',
      [
        'label'       => esc_html__('Description', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => esc_html__('In todays dynamic business environment, the key to success lies strategic our planning and operational business.', 'tjcore'),
        'rows' => 3,
      ]
    );
    $repeater->add_control(
      'tj_service_btn',
      [
        'label'       => esc_html__('Button', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Learn more', 'tjcore'),
        'condition' => [
          'field_condition!' => ['3', '4'],
        ],
      ]
    );

    $repeater->add_control(
      'service_icon_btn',
      [
        'label' => __('Button Icon', 'tjcore'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'label_block' => true,
        'fa4compatibility' => 'btn_icon',
        'default' => [
          'value' => 'tji-angle-right',
          'library' => 'tj',
        ],
      ]
    );
    $repeater->add_control(
      'tj_active',
      [
        'label'        => esc_html__('Is Expand?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'condition' => [
          'field_condition!' => ['1', '3', '4', '5'],
        ],
      ]
    );
    $this->add_control(
      'tj_service_list',
      [
        'label' => esc_html__('Service List', 'tjcore'),
        'type' => Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'tj_service_title' => esc_html('Business process optimization'),
          ],
          [
            'tj_service_title' => esc_html('Strategic planning & execution'),
          ],
          [
            'tj_service_title' => esc_html('Leadership executive coaching'),
          ],
        ],
        'title_field' => '{{{ tj_service_title }}}',
      ]
    );

    $this->add_control(
      'tj_number',
      [
        'label'        => esc_html__('Enable Number?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
        'condition' => [
          'tj_design_style!' => ['2', '3'],
        ],
      ]
    );

    $this->end_controls_section();

    // animation
    $this->start_controls_section(
      'tj_animation_group',
      [
        'label' => esc_html__('Animation', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',

      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();


    // slider settings
    $this->start_controls_section(
      '__tj_slider_settings',
      [
        'label' => esc_html__('Slider Settings', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
        'condition' => [
          'tj_design_style!' => ['1', '2', '3', '4']
        ]
      ]
    );

    $this->add_control(
      'slide_loop',
      [
        'label'        => esc_html__('Is Loop?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to make this slider item loop?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );
    $this->add_control(
      'slide_dot',
      [
        'label'        => esc_html__('Is Dots?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to show slider dots?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );

    $this->add_control(
      'slide_autoplay',
      [
        'label'        => esc_html__('Is Autoplay?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to make this slider auto play?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );
    $this->add_control(
      'slide_autoplay_Delay',
      [
        'label'       => esc_html__('Autoplay Delay', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'description' => esc_html__('Set slider autoplay delay.', 'tjcore'),
        'min'         => 1000,
        'max'         => 10000,
        'step'        => 100,
        'default'     => 5000,
        'condition'   => [
          'slide_autoplay' => 'yes',
        ],
      ]
    );

    $this->end_controls_section();

    $this->start_controls_section(
      'gsap_swipe_animation_content',
      [
        'label' => esc_html__('Swipe Animation', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
        'condition' => [
          'tj_design_style' => ['5']
        ]
      ]
    );
    $this->add_control(
      'gsap_swipe_direction',
      [
        'label'   => esc_html__('Select Direction', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'right-swipe' => esc_html__('Right Swipe', 'tjcore'),
          'left-swipe' => esc_html__('Left Swipe', 'tjcore'),
        ],
        'default' => '',
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    $this->start_controls_section(
      'section_style_service',
      [
        'label' => esc_html__('Wrapper style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_wrapper_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .service-style-3, {{WRAPPER}} .service-style-5, {{WRAPPER}} .h8-services-list, {{WRAPPER}} .h9-services-item-inner',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'wrapper_border',
        'selector' => '{{WRAPPER}} .service-style-3, {{WRAPPER}} .service-style-5, {{WRAPPER}} .h8-services-list, {{WRAPPER}} .h9-services-item-inner',
      ]
    );
    $this->add_responsive_control(
      'tj_wrapper_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .service-style-3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .service-style-5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h8-services-list' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h9-services-item-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_wrapper_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .service-style-3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .service-style-5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h8-services-list' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h9-services-item-inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // Number
    $this->start_controls_section(
      'section_style_service_number',
      [
        'label' => esc_html__('Number style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['2', '3'],
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_number_typography',
        'selector' => '{{WRAPPER}} .service-style-3 .service-title .title span, {{WRAPPER}} .h8-services-list .service_item .no, {{WRAPPER}} .h9-services-item-inner .number',
      ]
    );
    $this->add_control(
      'tj_number_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .service-style-3 .service-title .title span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h8-services-list .service_item .no' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h9-services-item-inner .number' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_number_hcolor',
      [
        'label'     => __('Hover Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .service-style-3:hover .service-title .title span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h8-services-list .service_item:hover .no' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style!' => ['5'],
        ],
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_stitle',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_stitle_typography',
        'selector' => '{{WRAPPER}} .service-style-3 .service-title .title, {{WRAPPER}} .service-style-5 .h5-service-content .title, {{WRAPPER}} .h8-services-list .service_item .content .title, {{WRAPPER}} .h9-services-item-inner .service-content .title',
      ]
    );
    $this->start_controls_tabs('stitle_style_tabs');
    $this->start_controls_tab(
      'stitle_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_stitle_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .service-style-3 .service-title .title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .service-style-5 .h5-service-content .title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h8-services-list .service_item .content .title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h9-services-item-inner .service-content .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_stitle_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_stitle_hcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .service-style-3:hover .service-title .title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .service-style-5 .h5-service-content .title a:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h8-services-list .service_item .content .title a:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h9-services-item-inner .service-content .title a:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'tj_stitle_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .service-style-3 .service-title .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .service-style-5 .h5-service-content .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h8-services-list .service_item .content .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h9-services-item-inner .service-content .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_stitle_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .service-style-3 .service-title .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .service-style-5 .h5-service-content .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h8-services-list .service_item .content .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h9-services-item-inner .service-content .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // content
    $this->start_controls_section(
      '_style_scontent',
      [
        'label' => esc_html__('Content', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_scontent_typography',
        'selector' => '{{WRAPPER}} .service-style-3 .desc p, {{WRAPPER}} .service-style-3 .desc, {{WRAPPER}} .service-style-5 .h5-service-content, {{WRAPPER}} .h8-services-list .service_item .content .desc, {{WRAPPER}} .check-list-one ul li, {{WRAPPER}} .check-list-one',
      ]
    );
    $this->start_controls_tabs('sscontent_style_tabs');
    $this->start_controls_tab(
      'scontent_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_scontent_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .service-style-3 .desc p' => 'color: {{VALUE}}',
          '{{WRAPPER}} .service-style-3 .desc' => 'color: {{VALUE}}',
          '{{WRAPPER}} .service-style-5 .h5-service-content .desc' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h8-services-list .service_item .content .desc' => 'color: {{VALUE}}',
          '{{WRAPPER}} .check-list-one ul li' => 'color: {{VALUE}}',
          '{{WRAPPER}} .check-list-one' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_scontent_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_scontent_hcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .service-style-3:hover .desc p' => 'color: {{VALUE}}',
          '{{WRAPPER}} .service-style-3:hover .desc' => 'color: {{VALUE}}',
          '{{WRAPPER}} .service-style-5:hover .h5-service-content .desc' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h8-services-list .service_item:hover .content .desc' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'tj_scontent_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .service-style-3 .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .service-style-5 .h5-service-content .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h8-services-list .service_item .content .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .check-list-one' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_scontent_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .service-style-3 .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .service-style-5 .h5-service-content .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h8-services-list .service_item .content .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .check-list-one' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // button
    $this->start_controls_section(
      '_style_stext_btn',
      [
        'label' => esc_html__('Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['3', '4'],
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_stext_btn_typography',
        'selector' => '{{WRAPPER}} .service-style-3 .service-button a, {{WRAPPER}} .service-style-5 .blog-btn-2, {{WRAPPER}} .h9-services-item .service-btn .text-btn',
      ]
    );
    $this->start_controls_tabs('stext_btn_style_tabs');
    $this->start_controls_tab(
      'stext_btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_stext_btn_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .service-style-3 .service-button a' => 'color: {{VALUE}}',
          '{{WRAPPER}} .service-style-5 .blog-btn-2' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h9-services-item .service-btn .text-btn' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_stext_btn_bgcolor',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .h9-services-item .service-btn' => 'background: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style!' => ['1', '2', '3', '4'],
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_stext_btn_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_stext_btn_hcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .service-style-3:hover .service-button a' => 'color: {{VALUE}}',
          '{{WRAPPER}} .service-style-5 .blog-btn-2:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .service-style-3:hover .service-button a::before' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .h9-services-item:hover .service-btn .text-btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h9-services-item .service-btn .text-btn::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_stext_btn_hbgcolor',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .h9-services-item:hover .service-btn' => 'background: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style!' => ['1', '2', '3', '4'],
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();

    // icon button
    $this->start_controls_section(
      'style_icon_btn_project',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style' => ['2', '3', '4', '5'],
        ],
      ]
    );
    $this->add_responsive_control(
      'iconbtn_font_size',
      [
        'label' => esc_html__('Icon Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .blog-btn-2 .btn-icon' => 'font-size: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .service_btn.icon-btn' => 'font-size: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .h9-services-item-inner .service-icon' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->start_controls_tabs('icon_btn_style_tabs');
    $this->start_controls_tab(
      'iconbtn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'iconbtn_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-btn-2 .btn-icon' => 'color: {{VALUE}}',
          '{{WRAPPER}} .blog-btn-2 .btn-icon i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .service_btn.icon-btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .service_btn.icon-btn i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h9-services-item-inner .service-icon' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'iconbtn_bgcolor',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-btn-2 .btn-icon' => 'background: {{VALUE}}',
          '{{WRAPPER}} .service-button' => 'background: {{VALUE}}',
          '{{WRAPPER}} .service_btn.icon-btn' => 'background: {{VALUE}}',
          '{{WRAPPER}} .h9-services-item-inner .service-icon' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'iconbtn_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'iconbtn_hcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-btn-2:hover .btn-icon' => 'color: {{VALUE}}',
          '{{WRAPPER}} .blog-btn-2:hover .btn-icon i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .service-style-3:hover .blog-btn-2 .btn-icon i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .service_btn.icon-btn:hover i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h9-services-item:hover .h9-services-item-inner .service-icon' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'iconbtn_hbgcolor',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-btn-2:hover .btn-icon' => 'background: {{VALUE}}',
          '{{WRAPPER}} .service-style-3:hover .service-button' => 'background: {{VALUE}}',
          '{{WRAPPER}} .service_item:hover .service_btn.icon-btn' => 'background: {{VALUE}}',
          '{{WRAPPER}} .h9-services-item:hover .h9-services-item-inner .service-icon' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();
    extract($settings);
    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/services-list/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_ServiceList());
