<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Services.
 */
class TJ_Services_Layout extends Widget_Base
{
  // widget name
  public function get_name()
  {
    return 'tj-services';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Services', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-posts-ticker tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script', 'swiper'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style', 'swiper'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'service',
      'services',
      'tj service',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {
    // layout Panel
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Services Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
          5 => esc_html__('Style 05', 'tjcore'),
          6 => esc_html__('Style 06', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->add_control(
      'tj_query_style',
      [
        'label'   => esc_html__('Data From', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Custom', 'tjcore'),
          2 => esc_html__('Query', 'tjcore'),
        ],
        'default' => 1,
        'separator' => 'before',
      ]
    );
    $this->end_controls_section();

    // Service Query
    $this->start_controls_section(
      'tj_services_query',
      [
        'label' => esc_html__('Service Query', 'tjcore'),
        'condition' => [
          'tj_query_style' => '2',
        ]
      ]
    );
    $post_type = 'services';
    $this->add_control(
      'posts_per_page',
      [
        'label'       => esc_html__('Services Per Page', 'tjcore'),
        'description' => esc_html__('Leave blank or enter -1 for all.', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '4',
      ]
    );
    $this->add_control(
      'post__in',
      [
        'label'       => esc_html__('Include Services', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'options'     => tj_get_all_types_post($post_type),
        'multiple'    => true,
        'label_block' => true,
      ]
    );
    $this->add_control(
      'post__not_in',
      [
        'label'       => esc_html__('Exclude Services', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'options'     => tj_get_all_types_post($post_type),
        'multiple'    => true,
        'label_block' => true,
      ]
    );
    $this->add_control(
      'offset',
      [
        'label'   => esc_html__('Offset', 'tjcore'),
        'type'    => Controls_Manager::NUMBER,
        'default' => '0',
      ]
    );
    $this->add_control(
      'orderby',
      [
        'label'   => esc_html__('Order By', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => array(
          'ID'            => 'Post ID',
          'author'        => 'Post Author',
          'title'         => 'Title',
          'date'          => 'Date',
          'modified'      => 'Last Modified Date',
          'parent'        => 'Parent Id',
          'rand'          => 'Random',
          'comment_count' => 'Comment Count',
          'menu_order'    => 'Menu Order',
        ),
        'default' => 'date',
      ]
    );
    $this->add_control(
      'order',
      [
        'label'   => esc_html__('Order', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          'asc'  => esc_html__('Ascending', 'tjcore'),
          'desc' => esc_html__('Descending', 'tjcore'),
        ],
        'default' => 'desc',

      ]
    );
    $this->add_control(
      'tj_post_title_word',
      [
        'label'       => esc_html__('Title Word Limit', 'tjcore'),
        'description' => esc_html__('Set how many word you want to display!', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '6',
      ]
    );
    $this->add_control(
      'tj_post_content',
      [
        'label'        => __('Show Content?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Show', 'tjcore'),
        'label_off'    => __('Hide', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );
    $this->add_control(
      'tj_post_content_limit',
      [
        'label'       => __('Content Limit', 'tjcore'),
        'description' => esc_html__('Set how many word you want to display!', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '25',
        'condition'   => [
          'tj_post_content'  => 'yes',
        ],
      ]
    );

    $this->add_control(
      'tj_show_link',
      [
        'label'        => __('Show image link?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Show', 'tjcore'),
        'label_off'    => __('Hide', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '',
      ]
    );

    $this->add_control(
      'tj_service_btn',
      [
        'label'        => __('Show service btn?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Show', 'tjcore'),
        'label_off'    => __('Hide', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );

    $this->add_control(
      'tj_service_btn_text',
      [
        'label'       => esc_html__('Button Text', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Get started', 'tjcore'),
        'label_block' => true,
        'condition'   => [
          'tj_service_btn'  => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_service_btn_icon',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'default' => [
          'value' => 'tji-arrow-right',
          'library' => 'tji',
        ],
        'fa4compatibility' => 'btn_icon',
        'condition'   => [
          'tj_service_btn'  => 'yes',
        ],
      ]
    );

    $this->add_control(
      'tj_pagination',
      [
        'label' => esc_html__('Enable Pagination?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before',
      ]
    );
    // animation
    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Service Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ]
      ]
    );
    $this->end_controls_section();

    // Service Query
    $this->start_controls_section(
      'tj_service_custom',
      [
        'label' => esc_html__('Custom Query', 'tjcore'),
        'condition' => [
          'tj_query_style' => "1",
        ]
      ]
    );
    $repeater = new Repeater();
    $repeater->add_control(
      'field_condition',
      [
        'label' => __('Field condition', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          1 => __('Style 01', 'tjcore'),
          2 => __('Style 02', 'tjcore'),
          3 => __('Style 03', 'tjcore'),
          4 => __('Style 04', 'tjcore'),
          5 => __('Style 05', 'tjcore'),
        ],
        'default' => '1',
        'frontend_available' => true,
        'style_transfer' => true,
      ]
    );
    $repeater->add_control(
      'tj_service_icon',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'default' => [
          'value' => 'tji-optimization',
          'library' => 'tji',
        ],
        'fa4compatibility' => 'service_icon',
      ]
    );
    $repeater->add_control(
      'tj_service_image',
      [
        'label'   => esc_html__('Service Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $repeater->add_control(
      'tj_show_link_2',
      [
        'label'        => __('Show image link?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Show', 'tjcore'),
        'label_off'    => __('Hide', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '',
        'condition' => [
          'tj_service_image[url]!' => '',
          'field_condition!' => ['5'],
        ],
      ]
    );
    $repeater->add_control(
      'tj_service_number',
      [
        'label'       => esc_html__('Number', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('1', 'tjcore'),
        'label_block' => true,
        'condition' => [
          'field_condition!' => ['4', '5'],
        ],
      ]
    );
    $repeater->add_control(
      'tj_service_number2',
      [
        'label'       => esc_html__('Number 2', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('/3', 'tjcore'),
        'label_block' => true,
        'condition' => [
          'field_condition!' => ['4', '5', '2', '3'],
        ],
      ]
    );
    $repeater->add_control(
      'tj_service_title',
      [
        'label'       => esc_html__('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => esc_html__('Business Card', 'tjcore'),
        'rows' => 2,
      ]
    );
    $repeater->add_control(
      'tj_service_desc',
      [
        'label'       => esc_html__('Description', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => esc_html__('In todays dynamic business environment, to know to success lies strategic planning and operationals business success execution', 'tjcore'),
        'rows' => 3,
        'condition' => [
          'field_condition!' => ['5'],
        ],
      ]
    );
    $repeater->add_control(
      'tj_btn_text',
      [
        'label'       => esc_html__('Button Text', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Get started', 'tjcore'),
        'label_block' => true,
        'condition' => [
          'field_condition!' => ['4'],
        ],
      ]
    );
    $repeater->add_control(
      'tj_btn_icon',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'default' => [
          'value' => 'tji-arrow-right',
          'library' => 'tji',
        ],
        'fa4compatibility' => 'btn_icon',
      ]
    );
    $repeater->add_control(
      'tj_service_link',
      [
        'label' => esc_html__('Link', 'tjcore'),
        'type' => Controls_Manager::URL,
        'dynamic'       => [
          'active' => true,
        ],
        'default' => [
          'url' => '#',
          'is_external' => false,
          'nofollow' => false,
        ]
      ]
    );
    $repeater->add_control(
      'tj_gsap_stack',
      [
        'label'        => esc_html__('Enable GSAP Stack?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
        'condition' => [
          'field_condition!' => ['4', '5', '2', '3', '6'],
        ],
      ]
    );
    $this->add_control(
      'tj_service_list',
      [
        'label' => esc_html__('Service List', 'tjcore'),
        'type' => Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'tj_service_title' => esc_html('Strategic planning execution'),
          ],
          [
            'tj_service_title' => esc_html('Leadership executive coaching'),
          ],
          [
            'tj_service_title' => esc_html('Empowered leadership journey'),
          ],
        ],
        'title_field' => '{{{ tj_service_title }}}',
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'gsap_swipe_animation_content',
      [
        'label' => esc_html__('Swipe Animation', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
        'condition' => [
          'tj_design_style' => ['2', '3', '4', '5']
        ]
      ]
    );
    $this->add_control(
      'gsap_swipe_direction',
      [
        'label'   => esc_html__('Select Direction', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'right-swipe' => esc_html__('Right Swipe', 'tjcore'),
          'left-swipe' => esc_html__('Left Swipe', 'tjcore'),
        ],
        'default' => '',
      ]
    );
    $this->end_controls_section();

    // carousel settings
    $this->start_controls_section(
      '__tj_carousel_settings',
      [
        'label' => esc_html__('Carousel Settings', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
        'condition' => [
          'tj_design_style' => ['2', '4', '5'],
        ]
      ]
    );
    $this->add_control(
      'slide_loop',
      [
        'label'        => esc_html__('Is Loop?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to make this slider item loop?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );
    $this->add_control(
      'slide_dot',
      [
        'label'        => esc_html__('Is Dots?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to show slider dots?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );
    $this->add_control(
      'slide_autoplay',
      [
        'label'        => esc_html__('Is Autoplay?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to make this slider auto play?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );
    $this->add_control(
      'slide_autoplay_delay',
      [
        'label'       => esc_html__('Autoplay Delay', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'description' => esc_html__('Set slider autoplay delay.', 'tjcore'),
        'min'         => 1000,
        'max'         => 10000,
        'step'        => 100,
        'default'     => 5000,
        'condition'   => [
          'slide_autoplay' => 'yes',
        ],
      ]
    );

    $this->add_control(
      'tj_device_options',
      [
        'label' => esc_html__('Breakpoint Options below:', 'tjcore'),
        'type' => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );

    $bootstrap_breakpoints = [
      'xs'  => 'Mobile (<576px)',
      'sm'  => 'Large Moblie (≥576px)',
      'md'  => 'Tablet (≥768px)',
      'lg'  => 'Large (≥992px)',
      'xl'  => 'Laptop (≥1200px)',
      'xxl' => 'Desktop  (≥1400px)',
    ];

    foreach ($bootstrap_breakpoints as $key => $label) {

      $this->add_control(
        'tj_' . $key . '_preview',
        [
          'label'       => sprintf(esc_html__('%s Device', 'tjcore'), $label),
          'type'        => \Elementor\Controls_Manager::NUMBER,
          'default'     => '',
          'separator' => 'before',
        ]
      );

      $this->add_control(
        'tj_' . $key . '_space',
        [
          'label'       => __('Space Between', 'tjcore'),
          'type'        => \Elementor\Controls_Manager::NUMBER,
          'default'     => '',
        ]
      );
    }

    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      'section_style_service',
      [
        'label' => esc_html__('Wrapper style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_wrapper_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .service-el-item',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'wrapper_border',
        'selector' => '{{WRAPPER}} .service-el-item',
      ]
    );
    $this->add_responsive_control(
      'tj_wrapper_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .service-el-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_wrapper_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .service-el-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
    // Number
    $this->start_controls_section(
      'section_style_service_number',
      [
        'label' => esc_html__('Number style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['4', '5', '6'],
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_number_typography',
        'selector' => '{{WRAPPER}} .service-el-item .el-number',
      ]
    );
    $this->add_control(
      'tj_number_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .service-el-item .el-number' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();

    // Icon
    $this->start_controls_section(
      'section_style_sicon',
      [
        'label' => esc_html__('Icon style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_responsive_control(
      'sicon_font_size',
      [
        'label' => esc_html__('Icon Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .service-el-item .el-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'tj_icon_width',
      [
        'label'      => esc_html__('Width', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 2000,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => '%',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .service-el-item .el-icon' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'tj_icon_height',
      [
        'label'      => esc_html__('Height', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 2000,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => '%',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .service-el-item .el-icon' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->start_controls_tabs('sicon_style_tabs');
    $this->start_controls_tab(
      'sicon_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'sicon_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .service-el-item .el-icon i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'sicon_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .service-el-item .el-icon' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_icon_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'sicon_hcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .service-el-item:hover .el-icon i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'sicon_bg_hcolor',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .service-el-item:hover .el-icon' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_stitle',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_stitle_typography',
        'selector' => '{{WRAPPER}} .service-el-item .title',
      ]
    );
    $this->start_controls_tabs('stitle_style_tabs');
    $this->start_controls_tab(
      'stitle_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_stitle_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .service-el-item .title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .service-el-item .title a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_stitle_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_stitle_hcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .service-el-item:hover .title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .service-el-item:hover .title a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'tj_stitle_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .service-el-item .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_stitle_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .service-el-item .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // content
    $this->start_controls_section(
      '_style_scontent',
      [
        'label' => esc_html__('Content', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_scontent_typography',
        'selector' => '{{WRAPPER}} .service-el-item .desc',
      ]
    );
    $this->start_controls_tabs('sscontent_style_tabs');
    $this->start_controls_tab(
      'scontent_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_scontent_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .service-el-item .service-content .desc' => 'color: {{VALUE}}',
          '{{WRAPPER}} .service-el-item .desc' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_scontent_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_scontent_hcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .service-el-item:hover .desc' => 'color: {{VALUE}}',
          '{{WRAPPER}} .service-el-item:hover .service-content .desc' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'tj_scontent_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .service-el-item .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_scontent_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .service-el-item .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    //Button
    $this->start_controls_section(
      '_heading_hero_btn_style',
      [
        'label' => __('Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['2', '3', '4', '5'],
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'btn_typography',
        'selector' => '{{WRAPPER}} .tj-primary-btn, {{WRAPPER}} .text-btn-2',
      ]
    );
    $this->start_controls_tabs('btn_style_tabs');
    $this->start_controls_tab(
      'btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn .btn_text' => 'color: {{VALUE}}',
          '{{WRAPPER}} .text-btn-2' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn .btn_icon' => 'color: {{VALUE}}',
          '{{WRAPPER}} .text-btn-2 .icon' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_bgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn .btn_inner::before' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .text-btn-2 .icon' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .text-btn-2' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_hcolor',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn:hover .btn_text' => 'color: {{VALUE}}',
          '{{WRAPPER}} .text-btn-2:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_hcolor',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover .btn_icon' => 'color: {{VALUE}}',
          '{{WRAPPER}} .text-btn-2 > *:nth-child(1)' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_hbgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover .btn_inner::before' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .text-btn-2 > *:nth-child(1)' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_bg_hcolor',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .text-btn-2:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();

    // Text button
    $this->start_controls_section(
      '_style_stext_btn',
      [
        'label' => esc_html__('Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['6', '1'],
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_stext_btn_typography',
        'selector' => '{{WRAPPER}} .service-el-item .service-button, .service-el-item .service_btn',
      ]
    );
    $this->start_controls_tabs('stext_btn_style_tabs');
    $this->start_controls_tab(
      'stext_btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_stext_btn_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .service-el-item .text-btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .service-el-item .service_btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .service-el-item .service-button' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_stext_btn_bg_color',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .service-el-item .text-btn' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .service-el-item .service_btn' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .service-el-item .service-button' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_stext_btn_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_stext_btn_hcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .service-el-item:hover .text-btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .service-el-item:hover .service_btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .service-el-item:hover .service-button' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_stext_btn_hbg_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .service-el-item:hover .text-btn' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .service-el-item:hover .service_btn' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .service-el-item:hover .service-button' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .service-el-item:hover .service-button.text-btn::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'tj_stext_btn_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .service-el-item .text-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .service-el-item .service_btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .service-el-item .service-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      '_style_test_pagination',
      [
        'label' => esc_html__('Pagination Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['1', '3', '4', '6'],
        ]
      ]
    );
    $this->add_control(
      'tj_test_paginaton_color',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .swiper_pagination .swiper-pagination-bullet::after' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_test_paginaton_border_color',
      [
        'label'     => __('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} ..swiper_pagination .swiper-pagination-bullet::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();
    extract($settings);
    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/services/style-' . $tj_design_style . '.php';
?>

<?php
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Services_Layout());
