<?php

namespace TJCore;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Typography;


if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Sidebar CTA.
 */
class TJ_Sidebar_Cta extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-sidebar-cta';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Sidebar CTA', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'tj-icon eicon-ehp-cta';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'sidebar-cta',
      'cta',
      'ts sidebar cta',
      'ts',
      'ts addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {

    // Sidebar group
    $this->start_controls_section(
      '_tj_content',
      [
        'label' => esc_html__('Content', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_image',
      [
        'label'   => esc_html__('Choose Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
      ]
    );

    $this->add_control(
      'tj_icon_type',
      [
        'label' => __('Icon Type', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'font',
        'options' => [
          'font'  => __('Font Icon', 'tjcore'),
          'image' => __('Image Icon', 'tjcore'),
        ],
      ]
    );
    $this->add_control(
      'tj_feature_icon',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'default' => [
          'value' => 'tji-precision',
          'library' => 'tj',
        ],
        'fa4compatibility' => 'feature_icon',
        'condition' => [
          'tj_icon_type' => 'font',
        ]
      ]
    );
    $this->add_control(
      'tj_image_icon',
      [
        'label'   => esc_html__('Upload Image Icon', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_icon_type' => 'image',
        ]
      ]
    );

    $this->add_control(
      'cta_title',
      [
        'label'      => esc_html__('Title', 'tjcore'),
        'type'       => Controls_Manager::TEXTAREA,
        'default'    => esc_html__('Need help? <br> Feel free contact us', 'tjcore'),
        'rows'       => 3,
      ]
    );

    $this->add_control(
      'cta_desc',
      [
        'label'      => esc_html__('Shor Description', 'tjcore'),
        'type'       => Controls_Manager::TEXTAREA,
        'default'    => esc_html__('Our mission is to empowers businesses off all size  in an businesses.', 'tjcore'),
        'rows'       => 3,
      ]
    );

    $this->add_control(
      'tj_button_show',
      [
        'label'        => esc_html__('Show button?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_btn_text',
      [
        'label'     => esc_html__('Button Text', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__('Get in touch', 'tjcore'),
        'dynamic'   => [
          'active' => true,
        ],
        'condition' => [
          'tj_button_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_btn_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'btn_icon',
        'default'          => [
          'value'   => 'tji-arrow-right',
          'library' => 'tj',
        ],
        'skin'             => 'inline',
        'label_block'      => false,
        'condition'        => [
          'tj_button_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_btn_link_type',
      [
        'label'     => esc_html__('Link Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'options'   => [
          '1' => esc_html__('Custom Link', 'tjcore'),
          '2' => esc_html__('Internal Page', 'tjcore'),
        ],
        'default'   => '1',
        'separator' => 'before',
        'condition' => [
          'tj_button_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_btn_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'condition'   => [
          'tj_button_show'               => 'yes',
          'tj_btn_link_type' => '1',
        ],
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_btn_page_link',
      [
        'label'       => esc_html__('Select Page', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'tj_button_show'               => 'yes',
          'tj_btn_link_type' => '2',
        ],
      ]
    );

    $this->add_control(
      'tj_shape',
      [
        'label' => esc_html__('Enable Shape?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => 'yes',
        'separator' => 'before'
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();


    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Wrapper Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .tj-sidebar-widget',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'wrapper_border',
        'selector' => '{{WRAPPER}} .tj-sidebar-widget',
      ]
    );

    $this->add_responsive_control(
      'tj_section_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sidebar-widget' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'tj_section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sidebar-widget' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'tj_section_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sidebar-widget' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // icon
    $this->start_controls_section(
      'section_style_ficon',
      [
        'label' => esc_html__('Icon style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_responsive_control(
      'ficon_font_size',
      [
        'label' => esc_html__('Icon Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-sidebar-cta .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $this->add_control(
      'ficon_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-sidebar-cta .icon i' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->end_controls_section();


    // title
    $this->start_controls_section(
      '_style_ftitle',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .tj-sidebar-widget .title',
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-sidebar-widget .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sidebar-widget .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sidebar-widget .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    //Button
    $this->start_controls_section(
      '_heading_hero_btn_style',
      [
        'label' => __('Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'btn_typography',
        'selector' => '{{WRAPPER}} .tj-primary-btn',
      ]
    );
    $this->start_controls_tabs('btn_style_tabs');
    $this->start_controls_tab(
      'btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn .btn_text' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn .btn_icon' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_bgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn .btn_inner::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_hcolor',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-primary-btn:hover .btn_text' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_hcolor',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover .btn_icon' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_hbgcolor',
      [
        'label'     => esc_html__('Icon Bg Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover .btn_inner::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_bg_hcolor',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-primary-btn:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   *
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $ctaImage = !empty($settings['tj_image']) ? $settings["tj_image"] : "";
    $ctaTitle = !empty($settings['cta_title']) ? $settings["cta_title"] : "";
    $cta_desc = !empty($settings['cta_desc']) ? $settings["cta_desc"] : "";


    // Button
    $tjButtonShow = !empty($settings['tj_button_show']) ? "yes" : 'no';
    $tjBtnText = $settings['tj_btn_text'] ?? '';
    $tjBtnLinkType = $settings['tj_btn_link_type'] ?? '';
    $tjBtnLink = $settings['tj_btn_link'] ?? '';
    $tjBtnPageLink = $settings['tj_btn_page_link'] ?? '';

    if ('2' == $tjBtnLinkType) {
      $this->add_render_attribute('tj_button_arg', 'href', get_permalink($tjBtnPageLink));
      $this->add_render_attribute('tj_button_arg', 'target', '_self');
      $this->add_render_attribute('tj_button_arg', 'rel', 'nofollow');
      $this->add_render_attribute('tj_button_arg', 'class', "tj-primary-btn white-btn");
    } else {
      if (!empty($tjBtnLink['url'])) {
        $this->add_link_attributes('tj_button_arg', $tjBtnLink);
        $this->add_render_attribute('tj_button_arg', 'class', "tj-primary-btn white-btn");
      }
    }

    // animation
    $tj_shape   = $settings['tj_shape'] ?? '';
    $tsAnimation   = $settings['tj_animation'] ?? '';
    $tsAnimationName   = $settings['tj_animation_name'] ?? '';
    $tsAnimationDelay   = $settings['tj_animation_delay'] ?? '';

    if (!empty($tsAnimation)) {
      $widgetClass = "tj-sidebar-widget mb-0 wow $tsAnimationName";
      $this->add_render_attribute('tj-widget-arg', 'data-wow-delay', $tsAnimationDelay['size'] . "s");
    } else {
      $widgetClass = "tj-sidebar-widget mb-0";
    }
    $this->add_render_attribute('tj-widget-arg', 'class', $widgetClass);

?>

    <div <?php echo $this->get_render_attribute_string('tj-widget-arg'); ?>>
      <div class="tj-sidebar-cta" <?php if (!empty($ctaImage['url'])) { ?> data-bg-image="<?php echo esc_url($ctaImage['url']); ?>" <?php } ?>>
        <div class="content">
          <?php if (!empty($settings['tj_feature_icon']['value']) || !empty($settings['tj_image_icon']['url'])) : ?>
            <?php if ($settings['tj_icon_type'] == 'font') { ?>
              <div class="icon">
                <?php tj_render_icon($settings, 'feature_icon', 'tj_feature_icon'); ?>
              </div>
            <?php } ?>
            <?php if ($settings['tj_icon_type'] == 'image') { ?>
              <div class="icon">
                <img src="<?php echo esc_url($settings['tj_image_icon']['url']); ?>" alt="<?php echo esc_attr(get_post_meta($settings['tj_image_icon']['id'], '_wp_attachment_image_alt', true)); ?>" />
              </div>
            <?php } ?>
          <?php endif; ?>
          <?php if (!empty($ctaTitle)) : ?>
            <h3 class="title"><?php echo tj_kses($ctaTitle); ?></h3>
          <?php endif; ?>
          <?php if (!empty($cta_desc)) : ?>
            <p>
              <?php echo tj_kses($cta_desc); ?>
            </p>
          <?php endif; ?>
        </div>
        <?php if ($tjButtonShow === 'yes'): ?>
          <div class="cta-btn">
            <a <?php echo $this->get_render_attribute_string('tj_button_arg'); ?>>
              <div class="btn_inner">
                <?php if (!empty($settings['tj_btn_icon']['value'])) : ?>
                  <div class="btn_icon">
                    <span>
                      <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
                      <?php tj_render_icon($settings, 'btn_icon', 'tj_btn_icon') ?>
                    </span>
                  </div>
                <?php endif; ?>
                <div class="btn_text"><span><?php echo esc_html__($tjBtnText, 'tjcore'); ?></span></div>
              </div>
            </a>
            <?php if (!empty($tj_shape)) : ?>
              <img class="shapes move-anim-2" src="<?php echo get_template_directory_uri(); ?>/assets/images/shapes/carrow.png" alt="shape">
            <?php endif; ?>
          </div>
        <?php endif; ?>
      </div>
    </div>

<?php
  }
}
$widgets_manager->register(new TJ_Sidebar_Cta());
