<?php

namespace TJCore;

use Elementor\Widget_Base;
use \Elementor\Utils;
use \Elementor\Repeater;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Text_Stroke;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Css_Filter;


if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Elementor widget for Tj Pricing Button.
 */
class TJ_Swiper_Navigation extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-swiper-navigation';
  }

  // widget title
  public function get_title()
  {
    return esc_html__('TJ Swiper Navigation Button', 'tjcore');
  }

  // widget icon
  public function get_icon()
  {
    return 'eicon-dual-button tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'testimonial',
      'testimonial navigation',
      'tj testimonial navigation button',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {
    $this->start_controls_section(
      'section_tab',
      [
        'label'         => esc_html__('Content', 'tjcore'),
      ]
    );
    $this->add_responsive_control(
      'tj_alignment',
      [
        'label'        => esc_html__('Alignment', 'tjcore'),
        'type'         => Controls_Manager::CHOOSE,
        'options'      => [
          'left'   => [
            'title' => esc_html__('Left', 'tjcore'),
            'icon'  => 'eicon-text-align-left',
          ],
          'center' => [
            'title' => esc_html__('Center', 'tjcore'),
            'icon'  => 'eicon-text-align-center',
          ],
          'right'  => [
            'title' => esc_html__('Right', 'tjcore'),
            'icon'  => 'eicon-text-align-right',
          ],
        ],
        'default'      => 'left',
        'prefix_class' => 'tj_navigation_align elementor%s-align-',
        'separator'    => 'before',
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();


    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    $this->start_controls_section(
      'section_nav_style',
      [
        'label' => esc_html__('Navigation', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->start_controls_tabs('navs_tabs');
    $this->start_controls_tab(
      'nav_style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .navigation i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'icon_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-next' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .slider-prev' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'icon_border_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-next' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .slider-prev' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'nav_style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'icon_hover_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .navigation:hover i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'icon_bg_hover_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-next:hover' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .slider-prev:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'icon_border_hcolor',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .slider-next:hover' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .slider-prev:hover' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();
  }

  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/swiper-navigation/style-' . $tj_design_style . '.php';
  }
  protected function content_template() {}
}
$widgets_manager->register(new TJ_Swiper_Navigation());
