<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Teams.
 */
class TJ_Team extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-team';
  }

  // widget title.
  public function get_title() {
    return __('TJ Team', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-person tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script', 'swiper'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style', 'swiper'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'teams',
      'team',
      'ts team',
      'ts',
      'ts addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {
    // team style
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Section Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Section Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
          5 => esc_html__('Style 05', 'tjcore'),
          6 => esc_html__('Style 06', 'tjcore'),
          7 => esc_html__('Style 07', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // Team Members
    $this->start_controls_section(
      'tj_team_members',
      [
        'label' => esc_html__('Members', 'tjcore'),
        'condition' => [
          'tj_design_style!' => ['6']
        ]
      ]
    );

    // repeater 
    $repeater = new Repeater();
    $repeater->start_controls_tabs('members_tabs');
    $repeater->start_controls_tab(
      'member_info_tab',
      [
        'label' => esc_html__('Information', 'tjcore'),
      ]
    );
    $repeater->add_control(
      'field_condition',
      [
        'label' => __('Field condition', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'options' => [
          1 => __('Style 01', 'tjcore'),
          2 => __('Style 02', 'tjcore'),
          3 => __('Style 03', 'tjcore'),
        ],
        'default' => '1',
        'frontend_available' => true,
        'style_transfer' => true,
      ]
    );
    $repeater->add_control(
      'tj_member_image',
      [
        'type' => Controls_Manager::MEDIA,
        'label' => esc_html__('Image', 'tjcore'),
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'dynamic' => [
          'active' => true,
        ]
      ]
    );
    $repeater->add_control(
      'tj_media_link',
      [
        'label'        => esc_html__('Enable media link?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'condition' => [
          'member_url[url]!' => "",
        ],
      ]
    );
    $repeater->add_control(
      'tj_member_name',
      [
        'type' => Controls_Manager::TEXT,
        'label' => esc_html__('Name', 'tjcore'),
        'label_block' => true,
        'dynamic' => [
          'active' => true,
        ]
      ]
    );
    $repeater->add_control(
      'tj_name_link',
      [
        'label'        => esc_html__('Enable name link?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => 'yes',
        'condition' => [
          'member_url[url]!' => "",
        ],
      ]
    );
    $repeater->add_control(
      'tj_member_designation',
      [
        'type' => Controls_Manager::TEXT,
        'label_block' => true,
        'label' => esc_html__('Designation', 'tjcore'),
        'dynamic' => [
          'active' => true,
        ]
      ]
    );
    $repeater->add_control(
      'tj_member_desc',
      [
        'type' => Controls_Manager::TEXTAREA,
        'label_block' => true,
        'label' => esc_html__('Description', 'tjcore'),
        'dynamic' => [
          'active' => true,
        ],
        'condition' => [
          'field_condition!' => ['1'],
        ],
      ]
    );
    $repeater->add_control(
      'member_url',
      [
        'label' => esc_html__('Link', 'tjcore'),
        'type' => Controls_Manager::URL,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default' => [
          'url' => '#',
          'is_external' => false,
          'nofollow' => false,
        ],
        'dynamic'     => [
          'active' => true,
        ],
        'label_block' => true,
      ]
    );
    $repeater->add_control(
      'tj_show_button',
      [
        'label'        => esc_html__('Show member button?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'separator'    => 'before',
        'condition' => [
          'member_url[url]!' => "",
        ],
      ]
    );
    $repeater->add_control(
      'tj_button_text',
      [
        'type' => Controls_Manager::TEXT,
        'label' => esc_html__('Button Text', 'tjcore'),
        'default' => esc_html__('Read More', 'tjcore'),
        'dynamic' => [
          'active' => true,
        ],
        'condition' => [
          'member_url[url]!' => "",
          'tj_show_button' => 'yes',
        ],
      ]
    );
    $repeater->add_control(
      'tj_btn_icon',
      [
        'label'            => esc_html__('Button Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'btn_icon',
        'default'          => [
          'value'   => 'tji-arrow-right',
          'library' => 'tji',
        ],
        'skin'             => 'inline',
        'label_block'      => false,
        'condition' => [
          'member_url[url]!' => "",
          'tj_show_button' => 'yes',
        ],
      ]
    );

    $repeater->add_control(
      'tj_active',
      [
        'label'        => esc_html__('Enable Expand?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
        'condition' => [
          'field_condition!' => ['1', '2'],
        ],
      ]
    );

    // animation
    $repeater->add_control(
      'tj_scroll_animation',
      [
        'label'        => esc_html__('Enable scroll animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
        'separator'    => 'before',
        'condition' => [
          'field_condition!' => ['3'],
        ],
      ]
    );
    $repeater->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $repeater->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeftBig'  => esc_html__('Fade In Left Big', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $repeater->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ]
      ]
    );
    $repeater->end_controls_tab();

    $repeater->start_controls_tab(
      'member_socials_tab',
      [
        'label' => esc_html__('Socials', 'tjcore'),
      ]
    );
    $repeater->add_control(
      'tj_social_title',
      [
        'type' => Controls_Manager::TEXT,
        'label_block' => true,
        'label' => esc_html__('Follow me:', 'tjcore'),
        'dynamic' => [
          'active' => true,
        ],
        'condition' => [
          'field_condition!' => ['1', '2'],
        ]
      ]
    );
    $repeater->add_control(
      'show_member_socials',
      [
        'label' => __('Show socials option?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => __('Yes', 'tjcore'),
        'label_off' => __('No', 'tjcore'),
        'return_value' => 'yes',
      ]
    );
    $repeater->add_control(
      'website_link',
      [
        'label' => esc_html__('Website', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'email_link',
      [
        'label' => esc_html__('Email', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'phone_link',
      [
        'label' => esc_html__('Phone', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'facebook_link',
      [
        'label' => esc_html__('Facebook', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default' => esc_attr('#'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'twitter_link',
      [
        'label' => esc_html__('Twitter', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default' => esc_attr('#'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'instagram_link',
      [
        'label' => esc_html__('Instagram', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default' => esc_attr('#'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'linkedin_link',
      [
        'label' => esc_html__('Linkedin', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default' => esc_attr('#'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'pinterest_link',
      [
        'label' => esc_html__('Pinterest', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'youtube_link',
      [
        'label' => esc_html__('YouTube', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'vimeo_link',
      [
        'label' => esc_html__('Vimeo', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'github_link',
      [
        'label' => esc_html__('Github', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'flickr_link',
      [
        'label' => esc_html__('Flickr', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'behance_link',
      [
        'label' => esc_html__('Behance', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'dribbble_link',
      [
        'label' => esc_html__('Dribbble', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->end_controls_tab();
    $repeater->end_controls_tabs();

    // REPEATER
    $this->add_control(
      'team_member_list',
      [
        'show_label' => false,
        'type' => Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'tj_member_name' => esc_html__('Mike Hardson', 'tjcore'),
            'tj_member_designation' => esc_html__('Manager', 'tjcore'),
          ],
          [
            'tj_member_name' => esc_html__('David Cooper', 'tjcore'),
            'tj_member_designation' => esc_html__('Co Founder', 'tjcore'),
          ],
          [
            'tj_member_name' => esc_html__('Lucas Damian', 'tjcore'),
            'tj_member_designation' => esc_html__('Architect', 'tjcore'),
          ],
        ],
        'title_field' => '{{{ tj_member_name }}}',
      ]
    );
    $this->end_controls_section();

    // Team Members
    $this->start_controls_section(
      'tj_team_member',
      [
        'label' => esc_html__('Member', 'tjcore'),
        'condition' => [
          'tj_design_style' => ['6']
        ]
      ]
    );
    $this->start_controls_tabs('tj_members_tabs');
    $this->start_controls_tab(
      'tj_member_info_tab',
      [
        'label' => esc_html__('Information', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_image',
      [
        'type' => Controls_Manager::MEDIA,
        'label' => esc_html__('Image', 'tjcore'),
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'dynamic' => [
          'active' => true,
        ]
      ]
    );
    $this->add_control(
      'tj_media_link_6',
      [
        'label'        => esc_html__('Enable media link?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'condition' => [
          'tj_url[url]!' => "",
        ],
      ]
    );
    $this->add_control(
      'tj_name',
      [
        'type' => Controls_Manager::TEXT,
        'label' => esc_html__('Name', 'tjcore'),
        'default' => esc_html__('Savannah Nguyen', 'tjcore'),
        'label_block' => true,
        'dynamic' => [
          'active' => true,
        ]
      ]
    );
    $this->add_control(
      'tj_name_link_6',
      [
        'label'        => esc_html__('Enable name link?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => 'yes',
        'condition' => [
          'tj_url[url]!' => "",
        ],
      ]
    );
    $this->add_control(
      'tj_designation',
      [
        'label' => esc_html__('Designation', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'default' => esc_html__('Co. Founder', 'tjcore'),
        'label_block' => true,
        'dynamic' => [
          'active' => true,
        ]
      ]
    );

    $this->add_control(
      'tj_url',
      [
        'label' => esc_html__('Link', 'tjcore'),
        'type' => Controls_Manager::URL,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default' => [
          'url' => '#',
          'is_external' => false,
          'nofollow' => false,
        ],
        'dynamic'     => [
          'active' => true,
        ],
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_show_button_6',
      [
        'label'        => esc_html__('Show member button?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'separator'    => 'before',
        'condition' => [
          'tj_url[url]!' => "",
        ],
      ]
    );
    $this->add_control(
      'tj_button_text_6',
      [
        'type' => Controls_Manager::TEXT,
        'label' => esc_html__('Button Text', 'tjcore'),
        'default' => esc_html__('Read More', 'tjcore'),
        'dynamic' => [
          'active' => true,
        ],
        'condition' => [
          'tj_url[url]!' => "",
          'tj_show_button_6' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_btn_icon_6',
      [
        'label'            => esc_html__('Button Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'btn_icon',
        'default'          => [
          'value'   => 'tji-arrow-right',
          'library' => 'tji',
        ],
        'skin'             => 'inline',
        'label_block'      => false,
        'condition' => [
          'tj_url[url]!' => "",
          'tj_show_button_6' => 'yes',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'tj_member_socials_tab',
      [
        'label' => esc_html__('Socials', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_show_member_socials',
      [
        'label' => __('Show socials option?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => __('Yes', 'tjcore'),
        'label_off' => __('No', 'tjcore'),
        'return_value' => 'yes',
      ]
    );
    $this->add_control(
      'tj_website_link',
      [
        'label' => esc_html__('Website', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_email_link',
      [
        'label' => esc_html__('Email', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_phone_link',
      [
        'label' => esc_html__('Phone', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_facebook_link',
      [
        'label' => esc_html__('Facebook', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default' => esc_attr('#'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_twitter_link',
      [
        'label' => esc_html__('Twitter', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default' => esc_attr('#'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_instagram_link',
      [
        'label' => esc_html__('Instagram', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default' => esc_attr('#'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_linkedin_link',
      [
        'label' => esc_html__('Linkedin', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default' => esc_attr('#'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_pinterest_link',
      [
        'label' => esc_html__('Pinterest', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_youtube_link',
      [
        'label' => esc_html__('YouTube', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_vimeo_link',
      [
        'label' => esc_html__('Vimeo', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_github_link',
      [
        'label' => esc_html__('Github', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_flickr_link',
      [
        'label' => esc_html__('Flickr', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_behance_link',
      [
        'label' => esc_html__('Behance', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_dribbble_link',
      [
        'label' => esc_html__('Dribbble', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    // animation
    $this->add_control(
      'tj_i_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_i_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_i_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_i_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_i_animation' => 'yes',
        ]
      ]
    );
    $this->end_controls_section();

    // slider settings
    $this->start_controls_section(
      '__tj_slider_settings',
      [
        'label' => esc_html__('Slider Settings', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
        'condition'  => [
          'tj_design_style' => ['2'],
        ],
      ]
    );
    $this->add_control(
      'slide_loop',
      [
        'label'        => esc_html__('Is Loop?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to make this slider item loop?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );
    $this->add_control(
      'slide_dot',
      [
        'label'        => esc_html__('Is Dots?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to show slider dots?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );
    $this->add_control(
      'slide_autoplay',
      [
        'label'        => esc_html__('Is Autoplay?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to make this slider auto play?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );
    $this->add_control(
      'slide_autoplay_Delay',
      [
        'label'       => esc_html__('Autoplay Delay', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'description' => esc_html__('Set slider autoplay delay.', 'tjcore'),
        'min'         => 1000,
        'max'         => 10000,
        'step'        => 100,
        'default'     => 5000,
        'condition'   => [
          'slide_autoplay' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_device_options',
      [
        'label' => esc_html__('Breakpoint Options below:', 'tjcore'),
        'type' => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $bootstrap_breakpoints = [
      'xs'  => 'Mobile (<576px)',
      'sm'  => 'Large Moblie (≥576px)',
      'md'  => 'Tablet (≥768px)',
      'lg'  => 'Large (≥992px)',
      'xl'  => 'Laptop (≥1200px)',
      'xxl' => 'Desktop  (≥1400px)',
    ];
    foreach ($bootstrap_breakpoints as $key => $label) {
      $this->add_control(
        'tj_' . $key . '_preview',
        [
          'label'       => sprintf(esc_html__('%s Device Item', 'tjcore'), $label),
          'type'        => \Elementor\Controls_Manager::NUMBER,
          'default'     => '',
          'separator' => 'before',
        ]
      );
      $this->add_control(
        'tj_' . $key . '_space',
        [
          'label'       => __('Space Between', 'tjcore'),
          'type'        => \Elementor\Controls_Manager::NUMBER,
          'default'     => '',
        ]
      );
    }
    $this->end_controls_section();

    $this->start_controls_section(
      'section_column_settings',
      [
        'label' => esc_html__('Column Settings', 'tjcore'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition'  => [
          'tj_design_style!' => ['2', '6', '7'],
        ],
      ]
    );

    $this->add_control(
      'desktop_column',
      [
        'label' => esc_html__('Desktop', 'tjcore'),
        'description' => esc_html__('Screen width equal to or greater than 1200px', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          12 => esc_html__('1 Columns', 'tjcore'),
          6 => esc_html__('2 Columns', 'tjcore'),
          4 => esc_html__('3 Columns', 'tjcore'),
          3 => esc_html__('4 Columns', 'tjcore'),
          2 => esc_html__('6 Columns', 'tjcore'),
        ],
        'separator' => 'before',
        'default' => '3',
        'style_transfer' => true,
      ]
    );

    $this->add_control(
      'laptop_column',
      [
        'label' => esc_html__('Laptop', 'tjcore'),
        'description' => esc_html__('Screen width equal to or greater than 992px', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          12 => esc_html__('1 Columns', 'tjcore'),
          6 => esc_html__('2 Columns', 'tjcore'),
          4 => esc_html__('3 Columns', 'tjcore'),
          3 => esc_html__('4 Columns', 'tjcore'),
          2 => esc_html__('6 Columns', 'tjcore'),
        ],
        'separator' => 'before',
        'default' => '6',
        'style_transfer' => true,
      ]
    );

    $this->add_control(
      'tablet_column',
      [
        'label' => esc_html__('Tablet', 'tjcore'),
        'description' => esc_html__('Screen width equal to or greater than 768px', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          12 => esc_html__('1 Columns', 'tjcore'),
          6 => esc_html__('2 Columns', 'tjcore'),
          4 => esc_html__('3 Columns', 'tjcore'),
          3 => esc_html__('4 Columns', 'tjcore'),
          2 => esc_html__('6 Columns', 'tjcore'),
        ],
        'separator' => 'before',
        'default' => '6',
        'style_transfer' => true,
      ]
    );
    $this->add_control(
      'mobile_column',
      [
        'label' => esc_html__('Mobile', 'tjcore'),
        'description' => esc_html__('Screen width less than 768px', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          12 => esc_html__('1 Columns', 'tjcore'),
          6 => esc_html__('2 Columns', 'tjcore'),
          4 => esc_html__('3 Columns', 'tjcore'),
          3 => esc_html__('4 Columns', 'tjcore'),
          2 => esc_html__('6 Columns', 'tjcore'),
        ],
        'separator' => 'before',
        'default' => '6',
        'style_transfer' => true,
      ]
    );
    $this->add_control(
      'ex_mobile_column',
      [
        'label' => esc_html__('Small Mobile', 'tjcore'),
        'description' => esc_html__('Screen width less than 576px', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          12 => esc_html__('1 Columns', 'tjcore'),
          6 => esc_html__('2 Columns', 'tjcore'),
          4 => esc_html__('3 Columns', 'tjcore'),
          3 => esc_html__('4 Columns', 'tjcore'),
          2 => esc_html__('6 Columns', 'tjcore'),
        ],
        'separator' => 'before',
        'default' => '12',
        'style_transfer' => true,
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    $this->start_controls_section(
      'section_style_fcontent',
      [
        'label' => esc_html__('Wrapper style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_responsive_control(
      'tj_wrapper_height',
      [
        'label'      => esc_html__('Height', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 5000,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .team-item' => 'min-height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_wrapper_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .team-item .team-content, {{WRAPPER}} .h5-team-item-inner, {{WRAPPER}} .h9-team-item, {{WRAPPER}} .h10-team-item',
      ]
    );
    $this->add_control(
      'toverlay_color',
      [
        'label'     => __('Overlay Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .team-item::before' => 'background: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style!' => ['4', '6', '7']
        ]
      ]
    );
    $this->add_control(
      'toverlay_opacity',
      [
        'label'     => __('Overlay Opacity', 'tjcore'),
        'type'      => Controls_Manager::NUMBER,
        'selectors' => [
          '{{WRAPPER}} .team-item::before' => 'opacity: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style!' => ['4', '6', '7']
        ]
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'wrapper_border',
        'selector' => '{{WRAPPER}} .team-item, {{WRAPPER}} .h5-team-item-inner, {{WRAPPER}} .h10-team-item',
        'condition' => [
          'tj_design_style!' => ['6']
        ]
      ]
    );
    $this->add_responsive_control(
      'tj_wrapper_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .team-item .team-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h5-team-item-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h9-team-item .team_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h10-team-item .team_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_stitle',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_stitle_typography',
        'selector' => '{{WRAPPER}} .team-item .team-content .team-text .title, {{WRAPPER}} .h5-team-item-inner .team-content .title, {{WRAPPER}} .h9-team-item .team_content .name, {{WRAPPER}} .h10-team-item .team_content .title',
      ]
    );
    $this->start_controls_tabs('stitle_style_tabs');
    $this->start_controls_tab(
      'stitle_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_stitle_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .team-item .team-content .team-text .title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h5-team-item-inner .team-content .title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h9-team-item .team_content .name' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h10-team-item .team_content .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_stitle_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_stitle_hcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .team-item .team-content .team-text .title:hover a' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h5-team-item-inner .team-content .title a:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h9-team-item .team_content .name a:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h10-team-item .team_content .title a:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'tj_stitle_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .team-item .team-content .team-text .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h5-team-item-inner .team-content .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h9-team-item .team_content .name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h10-team-item .team_content .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // subtitle
    $this->start_controls_section(
      '_style_subtitle',
      [
        'label' => esc_html__('Designation', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_subtitle_typography',
        'selector' => '{{WRAPPER}} .team-item .team-content .team-text .sub-title, {{WRAPPER}} .h5-team-item-inner .team-content .designation, {{WRAPPER}} .h9-team-item .team_content .designation, {{WRAPPER}} .h9-team-item .team_content .sub-title',
      ]
    );
    $this->add_control(
      'tj_subtitle_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .team-item .team-content .team-text .sub-title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h5-team-item-inner .team-content .designation' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h9-team-item .team_content .designation' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h10-team-item .team_content .sub-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_subtitle_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .team-item .team-content .team-text .sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h5-team-item-inner .team-content .designation' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h9-team-item .team_content .designation' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h10-team-item .team_content .sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'section_editor_style',
      [
        'label' => esc_html__('Content', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_query_style!' => ['1', '2', '3', '4', '6'],
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'text_typography',
        'label'    => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .team-item .desc, {{WRAPPER}} .h10-team-item .desc',
      ]
    );
    $this->add_control(
      'text_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .team-item .desc' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h10-team-item .desc' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'text_editor_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .team-item .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h10-team-item .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'text_editor_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .team-item .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .h10-team-item .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // Social
    $this->start_controls_section(
      '_style_ssocial',
      [
        'label' => esc_html__('Social', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'tj_ssocial_typography',
      [
        'label' => esc_html__('Icon Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .team-share ul li a' => 'font-size: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .h5-team-item-inner .team-socials li a' => 'font-size: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .socials li a' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->start_controls_tabs('ssocial_style_tabs');
    $this->start_controls_tab(
      'ssocial_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_ssocial_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .team-share ul li a' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h5-team-item-inner .team-socials li a' => 'color: {{VALUE}}',
          '{{WRAPPER}} .socials li a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_ssocial_bgcolor',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .team-share ul li a' => 'background: {{VALUE}}',
          '{{WRAPPER}} .h5-team-item-inner .team-socials li a' => 'background: {{VALUE}}',
          '{{WRAPPER}} .socials li a' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_ssocial_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_ssocial_hcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}}  .team-share ul li a:hover i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .h5-team-item-inner .team-socials li a:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .socials li a:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_ssocial_hbgcolor',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}}  .team-share ul li a:hover' => 'background: {{VALUE}}',
          '{{WRAPPER}} .h5-team-item-inner .team-socials li a:hover' => 'background: {{VALUE}}',
          '{{WRAPPER}} .socials li a:hover' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'tj_icon_width',
      [
        'label'      => esc_html__('Width', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 2000,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => '%',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}}  .team-share ul li a' => 'width: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .h5-team-item-inner .team-socials li a' => 'width: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .socials li a' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_icon_height',
      [
        'label'      => esc_html__('Height', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 2000,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => '%',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}}  .team-share ul li a' => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .h5-team-item-inner .team-socials li a' => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .socials li a' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'tj_social_wrapp_bgcolor',
      [
        'label'     => __('Wrapper BG Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .team-item .team-share' => 'background-color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => ['3'],
        ],
      ]
    );
    $this->end_controls_section();

    // Icon Button
    $this->start_controls_section(
      'tj_team_icon_btn',
      [
        'label' => esc_html__('Icon Button', 'tjcore'),
        'tab' => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style' => ['3'],
        ],
      ]
    );
    $this->start_controls_tabs('icon_btn_colors');
    $this->start_controls_tab(
      'icon_btn_colors_normal',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'icon_btn_color',
      [
        'label' => esc_html__('Color', 'tjcore'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .el-icon' => 'color: {{VALUE}};',
        ],
      ]
    );
    $this->add_control(
      'icon_btn_bgcolor',
      [
        'label' => esc_html__('Background Color', 'tjcore'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .el-icon' => 'background-color: {{VALUE}};',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'iconbtn_colors_hover',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'hover_icon_btn_color',
      [
        'label' => esc_html__('Color', 'tjcore'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .el-icon:hover' => 'color: {{VALUE}};',
        ],
      ]
    );
    $this->add_control(
      'hover_icon_btn_bgcolor',
      [
        'label' => esc_html__('Background Color', 'tjcore'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .el-icon:hover' => 'background-color: {{VALUE}};',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'icon_btn_size',
      [
        'label' => esc_html__('Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'vw', 'custom'],
        'range' => [
          'px' => [
            'min' => 6,
            'max' => 300,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .el-icon' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'icon_btn_width',
      [
        'label' => esc_html__('Width', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors' => [
          '{{WRAPPER}} .el-icon' => 'width: {{SIZE}}{{UNIT}};',
        ],
        'range' => [
          'px' => [
            'max' => 100,
          ],
          'em' => [
            'min' => 0,
            'max' => 5,
          ],
          'rem' => [
            'min' => 0,
            'max' => 5,
          ],
        ],
      ]
    );
    $this->add_control(
      'icon_btn_height',
      [
        'label' => esc_html__('Height', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors' => [
          '{{WRAPPER}} .el-icon' => 'height: {{SIZE}}{{UNIT}};',
        ],
        'range' => [
          'px' => [
            'max' => 100,
          ],
          'em' => [
            'min' => 0,
            'max' => 5,
          ],
          'rem' => [
            'min' => 0,
            'max' => 5,
          ],
        ],
      ]
    );
    $this->end_controls_section();

    //Button
    $this->start_controls_section(
      '_team_btn_style',
      [
        'label' => __('Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['3'],
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'btn_typography',
        'selector' => '{{WRAPPER}} .team_btn',
      ]
    );
    $this->start_controls_tabs('btn_style_tabs');
    $this->start_controls_tab(
      'btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}}  .team_btn' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}}  .team_btn i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_hcolor',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .team_btn:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .team_btn::before' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_icon_hcolor',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .team_btn:hover i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'tj_button_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .team_btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // pagination
    $this->start_controls_section(
      '_style_test_pagination',
      [
        'label' => esc_html__('Pagination Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style' => ['2'],
        ],
      ]
    );
    $this->add_control(
      'tj_test_paginaton_color',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .swiper_pagination .swiper-pagination-bullet::after' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_test_paginaton_border_color',
      [
        'label'     => __('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .swiper_pagination .swiper-pagination-bullet.swiper-pagination-bullet-active' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();
    extract($settings);
    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/team/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Team());
